/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data.metadatafile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.clarin.CmdiComponentLinkReader;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.clarin.profiles.CmdiTemplate;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilVocabularies;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.MessageDialogHandler;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataReader {
    private static BugCatcher bugCatcher;
    private static SessionStorage sessionStorage;
    private static MetadataReader singleInstance;
    private static MessageDialogHandler messageDialogHandler;
    private static DataNodeLoader dataNodeLoader;
    private static ApplicationVersionManager versionManager;
    public static final String imdiPathSeparator = ".";
    public boolean copyNewResourcesToCache = sessionStorage.loadBoolean("copyNewResources", false);

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static synchronized MetadataReader getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new MetadataReader();
        }
        return singleInstance;
    }

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public static void setVersionManager(ApplicationVersionManager versionManagerInstance) {
        versionManager = versionManagerInstance;
    }

    private MetadataReader() {
    }

    public boolean nodeCanExistInNode(ArbilDataNode targetDataNode, ArbilDataNode childDataNode) {
        String targetImdiPath = MetadataReader.getNodePath(targetDataNode);
        String childPath = MetadataReader.getNodePath(childDataNode);
        targetImdiPath = targetImdiPath.replaceAll("\\(\\d*?\\)", "\\(x\\)");
        childPath = childPath.replaceAll("\\(\\d*?\\)", "\\(x\\)");
        int targetBranchCount = targetImdiPath.replaceAll("[^(]*", "").length();
        int childBranchCount = childPath.replaceAll("[^(]*", "").length();
        boolean hasCorrectSubNodeCount = childBranchCount - targetBranchCount < 2;
        return hasCorrectSubNodeCount && !childPath.equals(targetImdiPath) && childPath.startsWith(targetImdiPath);
    }

    public static String getNodePath(ArbilDataNode targetDataNode) {
        String xpath = targetDataNode.isSession() ? ".METATRANSCRIPT.Session" : (targetDataNode.isCatalogue() ? ".METATRANSCRIPT.Catalogue" : ".METATRANSCRIPT.Corpus");
        String[] nodePathArray = targetDataNode.getUrlString().split("#");
        if (nodePathArray.length > 1) {
            String nodePath;
            xpath = nodePath = nodePathArray[1].toString();
        }
        return xpath;
    }

    private URL constructTemplateUrl(String templateType) {
        URL templateUrl = null;
        if (CmdiProfileReader.pathIsProfile(templateType)) {
            try {
                return new URL(templateType);
            }
            catch (MalformedURLException ex) {
                bugCatcher.logError(ex);
                templateUrl = null;
            }
        } else {
            templateUrl = MetadataReader.class.getResource("/nl/mpi/arbil/resources/templates/" + templateType.substring(1) + ".xml");
        }
        if (templateUrl == null) {
            try {
                templateUrl = ArbilTemplateManager.getSingleInstance().getDefaultComponentOfTemplate(templateType).toURI().toURL();
            }
            catch (MalformedURLException exception) {
                bugCatcher.logError(exception);
                return null;
            }
        }
        return templateUrl;
    }

    public URI addFromTemplate(File destinationFile, String templateType) {
        System.out.println("addFromJarTemplateFile: " + templateType + " : " + destinationFile);
        URL templateUrl = this.constructTemplateUrl(templateType);
        if (templateUrl == null) {
            return null;
        }
        URI addedPathUri = this.copyToDisk(templateUrl, destinationFile);
        try {
            Document addedDocument = ArbilComponentBuilder.getDocument(addedPathUri);
            if (addedDocument == null) {
                messageDialogHandler.addMessageDialogToQueue("Error inserting create date", "Add from Template");
            } else {
                Node linkNode = XPathAPI.selectSingleNode((Node)addedDocument, (String)"/:METATRANSCRIPT");
                NamedNodeMap metatranscriptAttributes = linkNode.getAttributes();
                ApplicationVersion currentVersion = versionManager.getApplicationVersion();
                String arbilVersionString = "Arbil." + currentVersion.currentMajor + imdiPathSeparator + currentVersion.currentMinor + imdiPathSeparator + currentVersion.currentRevision;
                arbilVersionString = arbilVersionString + ":" + metatranscriptAttributes.getNamedItem("Originator").getNodeValue();
                metatranscriptAttributes.getNamedItem("Originator").setNodeValue(arbilVersionString);
                metatranscriptAttributes.getNamedItem("Date").setNodeValue(new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime()));
                ArbilComponentBuilder.savePrettyFormatting(addedDocument, new File(addedPathUri));
            }
        }
        catch (Exception ex) {
            bugCatcher.logError(ex);
        }
        return addedPathUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI copyToDisk(URL sourceURL, File targetFile) {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = sourceURL.openStream();
            out = new FileOutputStream(targetFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            in = null;
            out.flush();
            ((OutputStream)out).close();
            out = null;
            URI uRI = targetFile.toURI();
            return uRI;
        }
        catch (Exception ex) {
            System.out.println("copyToDisk: " + ex);
            bugCatcher.logError(ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    bugCatcher.logError(ioe);
                }
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ioe2) {
                    bugCatcher.logError(ioe2);
                }
            }
        }
        return null;
    }

    public String getNodeTypeFromMimeType(String mimeType) {
        System.out.println("getNodeTypeFromMimeType: " + mimeType);
        for (String[] formatType : new String[][]{{"http://www.mpi.nl/IMDI/Schema/WrittenResource-Format.xml", ".METATRANSCRIPT.Session.Resources.WrittenResource", "Manual/WrittenResource"}, {"http://www.mpi.nl/IMDI/Schema/MediaFile-Format.xml", ".METATRANSCRIPT.Session.Resources.MediaFile", "Manual/MediaFile"}}) {
            if (formatType[2].equals(mimeType)) {
                System.out.println("UsingOverrideNodeType: " + formatType[1]);
                return formatType[1];
            }
            if (!ArbilVocabularies.getSingleInstance().vocabularyContains(formatType[0], mimeType)) continue;
            System.out.println("NodeType: " + formatType[1]);
            return formatType[1];
        }
        return null;
    }

    private String getNamedAttributeValue(NamedNodeMap namedNodeMap, String attributeName) {
        Node nameNode = namedNodeMap.getNamedItem(attributeName);
        if (nameNode != null) {
            return nameNode.getNodeValue();
        }
        return null;
    }

    public boolean canInsertFromTemplate(ArbilTemplate currentTemplate, String elementName, String targetXmlPath, Document targetImdiDom) throws ArbilMetadataException {
        int maxOccurs = currentTemplate.getMaxOccursForTemplate(elementName);
        if (maxOccurs < 0) {
            return true;
        }
        Object addedPathURI = null;
        try {
            Node insertableNode;
            Document insertableSectionDoc;
            String templateFileString = MetadataReader.templateFileStringFromElementName(elementName);
            URL templateUrl = MetadataReader.urlForTemplateFile(currentTemplate, templateFileString);
            String targetRef = MetadataReader.xPathFromXmlPath(targetXmlPath, elementName);
            String targetXpath = MetadataReader.xPathFromTargetRef(targetRef);
            if (templateUrl != null && (insertableSectionDoc = ArbilComponentBuilder.getDocument(templateUrl.toURI())) != null && (insertableNode = XPathAPI.selectSingleNode((Node)insertableSectionDoc, (String)"/:InsertableSection/:*")) != null) {
                Node addableNode = targetImdiDom.importNode(insertableNode, true);
                Node destinationNode = XPathAPI.selectSingleNode((Node)targetImdiDom, (String)targetXpath);
                return ArbilComponentBuilder.canInsertNode(destinationNode, addableNode, maxOccurs);
            }
        }
        catch (URISyntaxException ex) {
            bugCatcher.logError(ex);
        }
        catch (MalformedURLException ex) {
            bugCatcher.logError(ex);
        }
        catch (DOMException exception) {
            bugCatcher.logError(exception);
        }
        catch (IOException exception) {
            bugCatcher.logError(exception);
        }
        catch (ParserConfigurationException exception) {
            bugCatcher.logError(exception);
        }
        catch (SAXException exception) {
            bugCatcher.logError(exception);
        }
        catch (TransformerException exception) {
            bugCatcher.logError(exception);
        }
        System.out.println("addedPathString: " + addedPathURI);
        return false;
    }

    public URI insertFromTemplate(ArbilTemplate currentTemplate, URI targetMetadataUri, File resourceDestinationDirectory, String elementName, String targetXmlPath, Document targetImdiDom, URI resourceUrl, String mimeType) throws ArbilMetadataException {
        URI addedPathURI;
        block13: {
            System.out.println("insertFromTemplate: " + elementName + " : " + resourceUrl);
            System.out.println("targetXpath: " + targetXmlPath);
            String insertBefore = currentTemplate.getInsertBeforeOfTemplate(elementName);
            System.out.println("insertBefore: " + insertBefore);
            int maxOccurs = currentTemplate.getMaxOccursForTemplate(elementName);
            System.out.println("maxOccurs: " + maxOccurs);
            addedPathURI = null;
            try {
                Node insertableNode;
                String templateFileString = MetadataReader.templateFileStringFromElementName(elementName);
                URL templateUrl = MetadataReader.urlForTemplateFile(currentTemplate, templateFileString);
                String targetRef = MetadataReader.xPathFromXmlPath(targetXmlPath, elementName);
                String targetXpath = MetadataReader.xPathFromTargetRef(targetRef);
                System.out.println("targetXpath: " + targetXpath);
                System.out.println("templateUrl: " + templateUrl);
                if (templateUrl == null) {
                    messageDialogHandler.addMessageDialogToQueue("No template found for: " + elementName.substring(1), "Load Template");
                    bugCatcher.logError(new Exception("No template found for: " + elementName.substring(1)));
                    break block13;
                }
                Document insertableSectionDoc = ArbilComponentBuilder.getDocument(templateUrl.toURI());
                if (insertableSectionDoc == null) {
                    messageDialogHandler.addMessageDialogToQueue("Error reading template", "Insert from Template");
                    break block13;
                }
                if (resourceUrl != null) {
                    this.insertValuesForAddingFromTemplate(insertableSectionDoc, resourceUrl, resourceDestinationDirectory, targetMetadataUri);
                }
                if (mimeType != null) {
                    this.insertMimeTypeForAddingFromTemplate(insertableSectionDoc, mimeType);
                }
                if ((insertableNode = XPathAPI.selectSingleNode((Node)insertableSectionDoc, (String)"/:InsertableSection/:*")) == null) {
                    bugCatcher.logError(new Exception("InsertableSection not found in the template"));
                }
                return this.importNodesAddedFromTemplate(targetImdiDom, targetMetadataUri, targetXpath, targetRef, insertableNode, insertBefore, maxOccurs);
            }
            catch (URISyntaxException ex) {
                bugCatcher.logError(ex);
            }
            catch (MalformedURLException ex) {
                bugCatcher.logError(ex);
            }
            catch (DOMException exception) {
                bugCatcher.logError(exception);
                return null;
            }
            catch (IOException exception) {
                bugCatcher.logError(exception);
                return null;
            }
            catch (ParserConfigurationException exception) {
                bugCatcher.logError(exception);
                return null;
            }
            catch (SAXException exception) {
                bugCatcher.logError(exception);
                return null;
            }
            catch (TransformerException exception) {
                bugCatcher.logError(exception);
                return null;
            }
        }
        System.out.println("addedPathString: " + addedPathURI);
        return addedPathURI;
    }

    private URI importNodesAddedFromTemplate(Document targetImdiDom, URI targetMetadataUri, String targetXpath, String targetRef, Node insertableNode, String insertBefore, int maxOccurs) throws URISyntaxException, DOMException, ArbilMetadataException, TransformerException {
        Node addableNode = targetImdiDom.importNode(insertableNode, true);
        Node destinationNode = XPathAPI.selectSingleNode((Node)targetImdiDom, (String)targetXpath);
        Node addedNode = ArbilComponentBuilder.insertNodeInOrder(destinationNode, addableNode, insertBefore, maxOccurs);
        String nodeFragment = ArbilComponentBuilder.convertNodeToNodePath(targetImdiDom, addedNode, targetRef);
        System.out.println("nodeFragment: " + nodeFragment);
        return new URI(targetMetadataUri.toString().split("#")[0] + "#" + nodeFragment);
    }

    private void insertMimeTypeForAddingFromTemplate(Document insertableSectionDoc, String mimeType) throws DOMException, TransformerException {
        if (mimeType.equals("image/jpeg")) {
            // empty if block
        }
        Node linkNode = XPathAPI.selectSingleNode((Node)insertableSectionDoc, (String)"/:InsertableSection/:*/:Format");
        linkNode.setTextContent(mimeType);
    }

    private void insertValuesForAddingFromTemplate(Document insertableSectionDoc, URI resourceUrl, File resourceDestinationDirectory, URI targetMetadataUri) throws UnsupportedEncodingException, DOMException, TransformerException {
        URI finalResourceUrl = resourceUrl;
        try {
            if (this.copyNewResourcesToCache) {
                File originalFile = new File(resourceUrl);
                int suffixIndex = originalFile.getName().lastIndexOf(imdiPathSeparator);
                String targetFilename = originalFile.getName().substring(0, suffixIndex);
                String targetSuffix = originalFile.getName().substring(suffixIndex);
                System.out.println("targetFilename: " + targetFilename + " targetSuffix: " + targetSuffix);
                File destinationFileCopy = new File(resourceDestinationDirectory, targetFilename + targetSuffix);
                int fileCounter = 0;
                while (destinationFileCopy.exists()) {
                    destinationFileCopy = new File(resourceDestinationDirectory, targetFilename + "(" + ++fileCounter + ")" + targetSuffix);
                }
                URI fullURI = destinationFileCopy.toURI();
                finalResourceUrl = targetMetadataUri.relativize(fullURI);
                this.copyToDisk(resourceUrl.toURL(), destinationFileCopy);
                System.out.println("destinationFileCopy: " + destinationFileCopy.toString());
            }
        }
        catch (Exception ex) {
            bugCatcher.logError(ex);
        }
        Node linkNode = XPathAPI.selectSingleNode((Node)insertableSectionDoc, (String)"/:InsertableSection/:*/:ResourceLink");
        String decodeUrlString = URLDecoder.decode(finalResourceUrl.toString(), "UTF-8");
        linkNode.setTextContent(decodeUrlString);
    }

    private static String xPathFromTargetRef(String targetRef) {
        String targetXpath = targetRef;
        targetXpath = targetXpath.replace(imdiPathSeparator, "/:");
        targetXpath = targetXpath.replace(")", "]");
        targetXpath = targetXpath.replace("(", "[");
        return targetXpath;
    }

    private static String xPathFromXmlPath(String targetXmlPath, String elementName) {
        String targetXpath = targetXmlPath;
        if (targetXpath == null) {
            targetXpath = elementName;
        } else {
            String[] targetXpathArray = targetXpath.split("\\)");
            String[] elementNameArray = elementName.split("\\)");
            StringBuilder targetXpathSB = new StringBuilder();
            for (int partCounter = 0; partCounter < elementNameArray.length; ++partCounter) {
                if (targetXpathArray.length > partCounter) {
                    targetXpathSB.append(targetXpathArray[partCounter]);
                } else {
                    targetXpathSB.append(elementNameArray[partCounter]);
                }
                targetXpathSB.append(')');
            }
            targetXpath = targetXpathSB.toString().replaceAll("\\)$", "");
        }
        targetXpath = targetXpath.substring(0, targetXpath.lastIndexOf(imdiPathSeparator));
        return targetXpath;
    }

    private static URL urlForTemplateFile(ArbilTemplate currentTemplate, String templateFileString) throws MalformedURLException {
        File templateFile = new File(currentTemplate.getTemplateComponentDirectory(), templateFileString + ".xml");
        System.out.println("templateFile: " + templateFile.getAbsolutePath());
        URL templateUrl = templateFile.exists() ? templateFile.toURI().toURL() : MetadataReader.class.getResource("/nl/mpi/arbil/resources/templates/" + templateFileString + ".xml");
        return templateUrl;
    }

    private static String templateFileStringFromElementName(String elementName) {
        String templateFileString = elementName.substring(1);
        System.out.println("templateFileString: " + templateFileString);
        templateFileString = templateFileString.replaceAll("\\(\\d*?\\)", "(x)");
        System.out.println("templateFileString(x): " + templateFileString);
        templateFileString = templateFileString.replaceAll("\\(x\\)$", "");
        return templateFileString;
    }

    public URI correctLinkPath(URI parentPath, String linkString) {
        URI linkURI = null;
        try {
            linkURI = !linkString.toLowerCase().startsWith("http:") && !linkString.toLowerCase().startsWith("file:") ? parentPath.resolve(new URI(null, linkString, null)) : (linkString.toLowerCase().startsWith("&root;") ? parentPath.resolve(new URI(null, linkString.substring(6), null)) : parentPath.resolve(linkString));
        }
        catch (URISyntaxException exception) {
            bugCatcher.logError(parentPath.toString() + " : " + linkString, exception);
        }
        if (linkURI != null) {
            linkURI = ArbilDataNode.normaliseURI(linkURI);
        }
        return linkURI;
    }

    private void showDomIdFoundMessage() {
        if (!dataNodeLoader.nodesNeedSave()) {
            messageDialogHandler.addMessageDialogToQueue("A dom id attribute has been found in one or more files, these files will need to be saved to correct this.", "Load IMDI Files");
        }
    }

    public int iterateChildNodes(ArbilDataNode parentNode, Vector<String[]> childLinks, Node startNode, String nodePath, String fullNodePath, Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree, Hashtable<String, Integer> siblingNodePathCounter, int nodeOrderCounter) {
        if (!parentChildTree.containsKey(parentNode)) {
            parentChildTree.put(parentNode, new HashSet());
        }
        for (Node childNode = startNode; childNode != null; childNode = childNode.getNextSibling()) {
            ArbilDataNode destinationNode;
            String localName = childNode.getLocalName();
            NamedNodeMap childNodeAttributes = childNode.getAttributes();
            if (localName == null || (nodePath + imdiPathSeparator + localName).equals(".CMD.Header") || (nodePath + imdiPathSeparator + localName).equals(".CMD.Resources") || (nodePath + imdiPathSeparator + localName).equals(".Kinnate.Entity")) continue;
            if (childNodeAttributes != null) {
                this.removeImdiNodeIds(childNodeAttributes, parentNode);
            }
            if (fullNodePath.length() == 0) {
                this.getClarinTemplate(childNode, parentNode, childNodeAttributes);
            }
            if (childNode.getLocalName().equals("Corpus")) {
                this.getImdiCatalogue(childNodeAttributes, parentNode, childLinks, parentChildTree);
            }
            String siblingNodePath = nodePath + imdiPathSeparator + localName;
            String fullSubNodePath = fullNodePath + imdiPathSeparator + localName;
            String parentNodePath = this.determineParentPath(parentNode);
            String childsMetaNode = parentNode.getParentDomNode().getNodeTemplate().pathIsChildNode(parentNodePath + siblingNodePath);
            int maxOccurs = parentNode.getParentDomNode().getNodeTemplate().getMaxOccursForTemplate(parentNodePath + siblingNodePath);
            if (localName != null && childsMetaNode != null) {
                try {
                    ArbilDataNode metaNode = null;
                    String pathUrlXpathSeparator = "";
                    if (!parentNode.getUrlString().contains("#")) {
                        pathUrlXpathSeparator = "#";
                    }
                    String siblingSpacer = "";
                    boolean isSingleton = false;
                    if (maxOccurs > 1 || maxOccurs == -1 || !(parentNode.getParentDomNode().nodeTemplate instanceof CmdiTemplate)) {
                        isSingleton = maxOccurs == 1;
                        metaNode = dataNodeLoader.getArbilDataNodeWithoutLoading(new URI(parentNode.getURI().toString() + pathUrlXpathSeparator + siblingNodePath));
                        metaNode.setNodeText(childsMetaNode);
                        if (!parentChildTree.containsKey(metaNode)) {
                            parentChildTree.put(metaNode, new HashSet());
                        }
                        if (!isSingleton) {
                            parentChildTree.get(parentNode).add(metaNode);
                        }
                        siblingSpacer = "(" + (parentChildTree.get(metaNode).size() + 1) + ")";
                    } else {
                        int siblingCount = this.countSiblings(parentChildTree, parentNode, localName);
                        siblingSpacer = "(" + siblingCount + ")";
                    }
                    fullSubNodePath = fullSubNodePath + siblingSpacer;
                    ArbilDataNode subNode = dataNodeLoader.getArbilDataNodeWithoutLoading(new URI(parentNode.getURI().toString() + pathUrlXpathSeparator + siblingNodePath + siblingSpacer));
                    if (metaNode != null && !isSingleton) {
                        parentChildTree.get(metaNode).add(subNode);
                        metaNode.setContainerNode(true);
                    } else {
                        parentChildTree.get(parentNode).add(subNode);
                        subNode.setSingletonMetadataNode(isSingleton);
                    }
                    if (!parentChildTree.containsKey(subNode)) {
                        parentChildTree.put(subNode, new HashSet());
                    }
                    destinationNode = subNode;
                }
                catch (URISyntaxException ex) {
                    destinationNode = parentNode;
                    bugCatcher.logError(ex);
                }
                siblingNodePath = "";
            } else {
                destinationNode = parentNode;
            }
            nodeOrderCounter = this.enterChildNodesRecursion(parentNode, childLinks, childNode, childNodeAttributes, destinationNode, localName, parentNodePath, siblingNodePath, fullSubNodePath, parentChildTree, siblingNodePathCounter, nodeOrderCounter);
        }
        return nodeOrderCounter;
    }

    private int enterChildNodesRecursion(ArbilDataNode parentNode, Vector<String[]> childLinks, Node childNode, NamedNodeMap childNodeAttributes, ArbilDataNode destinationNode, String localName, String parentNodePath, String siblingNodePath, String fullSubNodePath, Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree, Hashtable<String, Integer> siblingNodePathCounter, int nodeOrderCounter) throws DOMException {
        boolean shouldAddCurrent;
        NodeList childNodes = childNode.getChildNodes();
        boolean bl = shouldAddCurrent = childNodes.getLength() == 0 && localName != null || childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3;
        if (!siblingNodePathCounter.containsKey(fullSubNodePath)) {
            siblingNodePathCounter.put(fullSubNodePath, 0);
        } else {
            siblingNodePathCounter.put(fullSubNodePath, siblingNodePathCounter.get(fullSubNodePath) + 1);
        }
        if (parentNode.getParentDomNode().getNodeTemplate().pathIsEditableField(parentNodePath + siblingNodePath)) {
            String fieldValue = childNodes.getLength() == 1 ? childNodes.item(0).getTextContent() : "";
            nodeOrderCounter = this.addEditableField(nodeOrderCounter, destinationNode, siblingNodePath, fieldValue, siblingNodePathCounter, fullSubNodePath, parentNode, childLinks, parentChildTree, childNodeAttributes, shouldAddCurrent);
        } else {
            this.addReferencedResources(parentNode, parentChildTree, childNodeAttributes, childLinks, destinationNode);
            if (childNodeAttributes != null && parentNode.isCmdiMetaDataNode()) {
                for (int i = 0; i < childNodeAttributes.getLength(); ++i) {
                    Node attrNode = childNodeAttributes.item(i);
                    String attrName = CmdiTemplate.getAttributePathSection(attrNode.getNamespaceURI(), attrNode.getLocalName());
                    String attrPath = siblingNodePath + ".@" + attrName;
                    String fullAttrPath = fullSubNodePath + ".@" + attrName;
                    if (!siblingNodePathCounter.containsKey(fullAttrPath)) {
                        siblingNodePathCounter.put(fullAttrPath, 0);
                    }
                    if (!parentNode.getNodeTemplate().pathIsEditableField(fullAttrPath.replaceAll("\\(\\d*?\\)", ""))) continue;
                    nodeOrderCounter = this.addEditableField(nodeOrderCounter, destinationNode, attrPath, attrNode.getNodeValue(), siblingNodePathCounter, fullAttrPath, parentNode, childLinks, parentChildTree, null, true);
                }
            }
        }
        nodeOrderCounter = this.iterateChildNodes(destinationNode, childLinks, childNode.getFirstChild(), siblingNodePath, fullSubNodePath, parentChildTree, siblingNodePathCounter, nodeOrderCounter);
        return nodeOrderCounter;
    }

    private int countSiblings(Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree, ArbilDataNode parentNode, String localName) {
        int siblingCount = 1;
        for (ArbilDataNode siblingNode : parentChildTree.get(parentNode)) {
            String siblingPath = siblingNode.getURI().getFragment();
            if (siblingPath == null) continue;
            siblingPath = siblingPath.substring(siblingPath.lastIndexOf(imdiPathSeparator) + 1);
            if (!localName.equals(siblingPath = siblingPath.replaceAll("\\(\\d+\\)", ""))) continue;
            ++siblingCount;
        }
        return siblingCount;
    }

    private void removeImdiNodeIds(NamedNodeMap attributesMap, ArbilDataNode parentNode) {
        if (attributesMap.getNamedItem("id") != null && !parentNode.hasDomIdAttribute && !parentNode.isCmdiMetaDataNode()) {
            parentNode.hasDomIdAttribute = true;
            this.showDomIdFoundMessage();
            parentNode.setDataNodeNeedsSaveToDisk(null, false);
        }
    }

    private int addEditableField(int nodeOrderCounter, ArbilDataNode destinationNode, String siblingNodePath, String fieldValue, Hashtable<String, Integer> siblingNodePathCounter, String fullSubNodePath, ArbilDataNode parentNode, Vector<String[]> childLinks, Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree, NamedNodeMap childNodeAttributes, boolean shouldAddCurrent) {
        String cvType = null;
        String cvUrlString = null;
        String keyName = null;
        String languageId = null;
        if (childNodeAttributes != null) {
            cvType = this.getNamedAttributeValue(childNodeAttributes, "Type");
            cvUrlString = this.getNamedAttributeValue(childNodeAttributes, "Link");
            languageId = this.getNamedAttributeValue(childNodeAttributes, "LanguageId");
            if (languageId == null) {
                languageId = this.getNamedAttributeValue(childNodeAttributes, "xml:lang");
            }
            keyName = this.getNamedAttributeValue(childNodeAttributes, "Name");
        }
        List<String[]> attributePaths = null;
        HashMap<String, Object> attributesValueMap = null;
        boolean allowsLanguageId = false;
        if (destinationNode.isCmdiMetaDataNode()) {
            String nodePath = fullSubNodePath.replaceAll("\\(\\d+\\)", "");
            CmdiTemplate template = (CmdiTemplate)destinationNode.getNodeTemplate();
            attributePaths = template.getEditableAttributesForPath(nodePath);
            attributesValueMap = new HashMap<String, Object>();
            if (childNodeAttributes != null) {
                for (int i = 0; i < childNodeAttributes.getLength(); ++i) {
                    Node attrNode = childNodeAttributes.item(i);
                    String path = nodePath + ".@" + CmdiTemplate.getAttributePathSection(attrNode.getNamespaceURI(), attrNode.getLocalName());
                    attributesValueMap.put(path, attrNode.getNodeValue());
                }
            }
            allowsLanguageId = template.pathAllowsLanguageId(nodePath);
        } else {
            allowsLanguageId = languageId != null;
        }
        ArbilField fieldToAdd = new ArbilField(nodeOrderCounter++, destinationNode, siblingNodePath, fieldValue, siblingNodePathCounter.get(fullSubNodePath), allowsLanguageId, attributePaths, attributesValueMap);
        if (childNodeAttributes != null) {
            fieldToAdd.setFieldAttribute(cvType, cvUrlString, languageId, keyName);
            if (fieldToAdd.xmlPath.endsWith("Description") && cvUrlString != null && cvUrlString.length() > 0) {
                URI correcteLink = this.correctLinkPath(parentNode.getURI(), cvUrlString);
                childLinks.add(new String[]{correcteLink.toString(), "Info Link"});
                ArbilDataNode descriptionLinkNode = dataNodeLoader.getArbilDataNodeWithoutLoading(correcteLink);
                descriptionLinkNode.isInfoLink = true;
                descriptionLinkNode.setDataLoaded(true);
                parentChildTree.get(parentNode).add(descriptionLinkNode);
                descriptionLinkNode.addField(fieldToAdd);
            }
            this.addReferencedResources(parentNode, parentChildTree, childNodeAttributes, childLinks, destinationNode);
        }
        if (shouldAddCurrent && fieldToAdd.isDisplayable()) {
            destinationNode.addField(fieldToAdd);
        } else if (shouldAddCurrent && fieldToAdd.xmlPath.contains("CorpusLink") && fieldValue.length() > 0) {
            try {
                URI linkPath = this.correctLinkPath(parentNode.getURI(), fieldToAdd.getFieldValue());
                childLinks.add(new String[]{linkPath.toString(), "IMDI Link"});
                ArbilDataNode linkedNode = dataNodeLoader.getArbilDataNodeWithoutLoading(linkPath);
                linkedNode.setNodeText(fieldToAdd.getKeyName());
                parentChildTree.get(parentNode).add(linkedNode);
            }
            catch (Exception ex) {
                bugCatcher.logError(ex);
                System.out.println("Exception CorpusLink: " + ex.getMessage());
            }
        }
        fieldToAdd.finishLoading();
        return nodeOrderCounter;
    }

    private void addReferencedResources(ArbilDataNode parentNode, Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree, NamedNodeMap childNodeAttributes, Vector<String[]> childLinks, ArbilDataNode destinationNode) {
        String clarinRefIds = this.getNamedAttributeValue(childNodeAttributes, "ref");
        if (clarinRefIds != null && clarinRefIds.length() > 0) {
            System.out.println("clarinRefIds: " + clarinRefIds);
            CmdiComponentLinkReader cmdiComponentLinkReader = parentNode.getCmdiComponentLinkReader();
            if (cmdiComponentLinkReader != null) {
                for (String refId : clarinRefIds.split(" ")) {
                    if ((refId = refId.trim()).length() <= 0) continue;
                    CmdiComponentLinkReader.CmdiResourceLink clarinLink = cmdiComponentLinkReader.getResourceLink(refId);
                    this.addResourceLinkNode(parentNode, destinationNode, parentChildTree, clarinLink, childLinks);
                }
            }
        }
    }

    public void addUnreferencedResources(ArbilDataNode parentNode, Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree, Vector<String[]> childLinks) {
        CmdiComponentLinkReader cmdiComponentLinkReader = parentNode.getCmdiComponentLinkReader();
        if (cmdiComponentLinkReader != null) {
            for (CmdiComponentLinkReader.CmdiResourceLink link : cmdiComponentLinkReader.cmdiResourceLinkArray) {
                if (link.getReferencingNodesCount() != 0) continue;
                this.addResourceLinkNode(parentNode, parentNode, parentChildTree, link, childLinks);
            }
        }
    }

    private void addResourceLinkNode(ArbilDataNode parentNode, ArbilDataNode destinationNode, Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree, CmdiComponentLinkReader.CmdiResourceLink clarinLink, Vector<String[]> childLinks) {
        if (clarinLink != null) {
            try {
                URI linkURI = clarinLink.getLinkUri();
                if (linkURI != null) {
                    linkURI = parentNode.getURI().resolve(linkURI);
                    childLinks.add(new String[]{clarinLink.toString(), clarinLink.resourceProxyId});
                    parentChildTree.get(destinationNode).add(dataNodeLoader.getArbilDataNodeWithoutLoading(linkURI));
                    clarinLink.addReferencingNode();
                }
            }
            catch (URISyntaxException ex) {
                bugCatcher.logError("Error while reading resource link. Link not added: " + clarinLink.resourceRef, ex);
            }
        }
    }

    private String determineParentPath(ArbilDataNode parentNode) {
        String parentNodePath = parentNode.getURI().getFragment();
        parentNodePath = parentNodePath == null ? "" : parentNodePath.replaceAll("\\(\\d+\\)", "");
        return parentNodePath;
    }

    private void getClarinTemplate(Node childNode, ArbilDataNode parentNode, NamedNodeMap attributesMap) throws DOMException {
        if (!childNode.getLocalName().equals("METATRANSCRIPT")) {
            try {
                String schemaLocationString = null;
                Node schemaLocationNode = childNode.getAttributes().getNamedItem("xsi:noNamespaceSchemaLocation");
                if (schemaLocationNode == null) {
                    schemaLocationNode = childNode.getAttributes().getNamedItem("xsi:schemaLocation");
                }
                if (schemaLocationNode == null) {
                    throw new Exception("Could not find the schema url: " + childNode.toString());
                }
                schemaLocationString = schemaLocationNode.getNodeValue();
                String[] schemaLocation = schemaLocationString.split("\\s");
                schemaLocationString = schemaLocation[schemaLocation.length - 1];
                schemaLocationString = parentNode.getURI().resolve(schemaLocationString).toString();
                parentNode.nodeTemplate = ArbilTemplateManager.getSingleInstance().getCmdiTemplate(schemaLocationString);
            }
            catch (Exception exception) {
                bugCatcher.logError(exception);
                messageDialogHandler.addMessageDialogToQueue("Could not find the schema url, some nodes will not display correctly.", "CMDI Schema Location");
            }
        }
        if (attributesMap != null && childNode.getLocalName().equals("METATRANSCRIPT")) {
            Node archiveHandleAtt = attributesMap.getNamedItem("ArchiveHandle");
            parentNode.archiveHandle = archiveHandleAtt != null ? archiveHandleAtt.getNodeValue() : null;
            Node templateOriginatorAtt = attributesMap.getNamedItem("Originator");
            if (templateOriginatorAtt != null) {
                String templateOriginator = templateOriginatorAtt.getNodeValue();
                int separatorIndex = templateOriginator.indexOf(":");
                if (separatorIndex > -1) {
                    parentNode.nodeTemplate = ArbilTemplateManager.getSingleInstance().getTemplate(templateOriginator.substring(separatorIndex + 1));
                } else {
                    Node templateTypeAtt = attributesMap.getNamedItem("Type");
                    if (templateTypeAtt != null) {
                        String templateType = templateTypeAtt.getNodeValue();
                        parentNode.nodeTemplate = ArbilTemplateManager.getSingleInstance().getTemplate(templateType);
                    }
                }
            }
        }
    }

    private void getImdiCatalogue(NamedNodeMap attributesMap, ArbilDataNode parentNode, Vector<String[]> childLinks, Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree) throws DOMException {
        String catalogueLink;
        Node catalogueLinkAtt = attributesMap.getNamedItem("CatalogueLink");
        if (catalogueLinkAtt != null && (catalogueLink = catalogueLinkAtt.getNodeValue()).length() > 0) {
            URI correcteLink = this.correctLinkPath(parentNode.getURI(), catalogueLink);
            childLinks.add(new String[]{correcteLink.toString(), "CatalogueLink"});
            parentChildTree.get(parentNode).add(dataNodeLoader.getArbilDataNodeWithoutLoading(correcteLink));
        }
    }

    static {
        singleInstance = null;
    }
}

