/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.fieldeditors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.fieldeditors.ControlledVocabularyComboBox;
import nl.mpi.arbil.ui.fieldeditors.ControlledVocabularyComboBoxEditor;
import nl.mpi.arbil.ui.fieldeditors.LanguageIdBox;

public class ArbilLongFieldEditor
extends JPanel
implements ArbilDataNodeContainer {
    ArbilTable parentTable = null;
    ArbilDataNode parentArbilDataNode;
    ArbilField[] arbilFields;
    String fieldName = "unknown";
    JTabbedPane tabPane;
    int selectedField = -1;
    JTextField[] keyEditorFields = null;
    JComponent[] fieldEditors = null;
    JComboBox[] fieldLanguageBoxs = null;
    JInternalFrame editorFrame = null;
    private FieldAttributesTableModel[] attributeTables;
    private JPanel contentPanel;
    private List<ArbilField[]> parentFieldList;
    private JButton prevButton;
    private JButton nextButton;
    private Action nextAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            ArbilLongFieldEditor.this.moveAdjacent(1);
        }
    };
    private Action previousAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            ArbilLongFieldEditor.this.moveAdjacent(-1);
        }
    };
    private FocusListener editorFocusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            ArbilLongFieldEditor.this.storeChanges();
        }
    };
    private static final int ATTR_NAME_COLUMN = 0;
    private static final int ATTR_VALUE_COLUMN = 1;
    private static final String[] ATTR_COLUMN_NAMES = new String[]{"Attribute", "Value"};
    private static final Class[] ATTR_COLUMN_TYPES = new Class[]{String.class, Object.class};

    public ArbilLongFieldEditor() {
        this((ArbilTable)null);
    }

    public ArbilLongFieldEditor(ArbilTable parentTableLocal) {
        this.parentTable = parentTableLocal;
        this.setInputMap(1, new lfeInputMap(this.getInputMap()));
        this.setActionMap(new lfeActionMap(this.getActionMap()));
        this.contentPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.add((Component)this.contentPanel, "Center");
        this.add((Component)this.createPreviousNextPanel(), "Last");
    }

    public void showEditor(ArbilField[] cellValueLocal, String currentEditorText, int selectedFieldLocal) {
        this.selectedField = selectedFieldLocal;
        this.arbilFields = cellValueLocal;
        this.parentArbilDataNode = this.arbilFields[0].getParentDataNode();
        this.parentArbilDataNode.registerContainer(this);
        this.fieldName = this.arbilFields[0].getTranslateFieldName();
        this.setParentFieldList();
        this.contentPanel.removeAll();
        JLabel parentLabel = new JLabel(this.parentArbilDataNode.toString(), ArbilIcons.getSingleInstance().getIconForNode(this.parentArbilDataNode), 10);
        parentLabel.setBorder(BorderFactory.createEmptyBorder(5, 2, 0, 0));
        this.contentPanel.add((Component)parentLabel, "North");
        this.tabPane = new JTabbedPane();
        JComponent focusedTabTextArea = this.populateTabbedPane(currentEditorText);
        this.contentPanel.add((Component)this.tabPane, "Center");
        this.editorFrame = ArbilWindowManager.getSingleInstance().createWindow(this.getWindowTitle(), this);
        this.editorFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent e) {
                ArbilLongFieldEditor.this.parentArbilDataNode.removeContainer(ArbilLongFieldEditor.this);
                super.internalFrameClosed(e);
                if (ArbilLongFieldEditor.this.parentTable != null) {
                    ArbilLongFieldEditor.this.parentTable.requestFocusInWindow();
                }
            }
        });
        if (this.selectedField != -1) {
            this.tabPane.setSelectedIndex(this.selectedField);
        } else {
            this.tabPane.setSelectedIndex(0);
        }
        this.setNavigationEnabled();
        this.requestFocusFor(focusedTabTextArea);
    }

    private JPanel createLanguageBox(int cellFieldIndex) {
        this.fieldLanguageBoxs[cellFieldIndex] = new LanguageIdBox(this.arbilFields[cellFieldIndex], null);
        JPanel languagePanel = new JPanel(new BorderLayout());
        languagePanel.add((Component)new JLabel("Language:"), "Before");
        if (this.parentArbilDataNode.getParentDomNode().isEditable()) {
            languagePanel.add((Component)this.fieldLanguageBoxs[cellFieldIndex], "Center");
        } else {
            languagePanel.add((Component)new JLabel(this.fieldLanguageBoxs[cellFieldIndex].getSelectedItem().toString()), "Center");
        }
        return languagePanel;
    }

    private JComponent populateTabbedPane(String currentEditorText) {
        JComponent focusComponent = null;
        this.fieldEditors = new JComponent[this.arbilFields.length];
        this.keyEditorFields = new JTextField[this.arbilFields.length];
        this.fieldLanguageBoxs = new JComboBox[this.arbilFields.length];
        this.attributeTables = new FieldAttributesTableModel[this.arbilFields.length];
        for (int cellFieldIndex = 0; cellFieldIndex < this.arbilFields.length; ++cellFieldIndex) {
            this.fieldEditors[cellFieldIndex] = this.arbilFields[cellFieldIndex].hasVocabulary() ? new ControlledVocabularyComboBox(this.arbilFields[cellFieldIndex]) : new JTextArea();
            if (focusComponent == null || this.selectedField == cellFieldIndex) {
                focusComponent = this.fieldEditors[cellFieldIndex];
            }
            if (this.arbilFields[cellFieldIndex].hasEditableFieldAttributes()) {
                this.attributeTables[cellFieldIndex] = new FieldAttributesTableModel(cellFieldIndex);
            }
            JPanel tabPanel = this.createTabPanel(cellFieldIndex, currentEditorText, this.createFieldDescription(cellFieldIndex));
            this.tabPane.add(this.fieldName + (this.arbilFields.length <= 1 ? "" : " " + (cellFieldIndex + 1)), tabPanel);
        }
        if (this.arbilFields[this.selectedField].isAllowsLanguageId() && (this.arbilFields[this.selectedField].getLanguageId() == null || this.arbilFields[this.selectedField].getLanguageId().length() == 0)) {
            return this.fieldLanguageBoxs[this.selectedField];
        }
        return focusComponent;
    }

    private JPanel createTabPanel(int cellFieldIndex, String currentEditorText, JComponent fieldDescription) {
        JPanel tabPanel = new JPanel();
        JPanel tabTitlePanel = new JPanel();
        tabPanel.setLayout(new BorderLayout());
        tabTitlePanel.setLayout(new BoxLayout(tabTitlePanel, 3));
        tabTitlePanel.add(fieldDescription);
        this.initFieldEditor(cellFieldIndex, currentEditorText);
        if (this.arbilFields[cellFieldIndex].isAllowsLanguageId()) {
            tabTitlePanel.add(this.createLanguageBox(cellFieldIndex));
        }
        if (this.arbilFields[cellFieldIndex].getKeyName() != null) {
            tabTitlePanel.add(new KeyPanel(cellFieldIndex));
        }
        tabPanel.add((Component)tabTitlePanel, "First");
        JPanel editorPanel = new JPanel(new BorderLayout());
        if (this.fieldEditors[cellFieldIndex] instanceof JTextArea) {
            editorPanel.add((Component)new JScrollPane(this.fieldEditors[cellFieldIndex]), "Center");
        } else if (this.fieldEditors[cellFieldIndex] instanceof ControlledVocabularyComboBox) {
            editorPanel.add((Component)this.fieldEditors[cellFieldIndex], "First");
        }
        tabPanel.add((Component)editorPanel, "Center");
        if (this.arbilFields[cellFieldIndex].hasEditableFieldAttributes()) {
            JScrollPane tablePane = new JScrollPane(new JTable(this.attributeTables[cellFieldIndex]));
            tablePane.setPreferredSize(new Dimension(this.getWidth(), 100));
            tabPanel.add((Component)tablePane, "South");
        }
        return tabPanel;
    }

    private JComponent createFieldDescription(int cellFieldIndex) {
        final JTextArea fieldDescription = new JTextArea();
        fieldDescription.setLineWrap(true);
        fieldDescription.setEditable(false);
        fieldDescription.setOpaque(false);
        final String fullXmlPath = this.arbilFields[cellFieldIndex].getFullXmlPath();
        new Thread(){

            public void run() {
                final String helpString = ArbilLongFieldEditor.this.parentArbilDataNode.getNodeTemplate().getHelpStringForField(fullXmlPath);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        fieldDescription.setText(helpString);
                    }
                });
            }
        }.start();
        JComponent component = fieldDescription;
        Icon icon = ArbilIcons.getSingleInstance().getIconForField(this.arbilFields[cellFieldIndex]);
        if (icon != null) {
            JPanel panel = new JPanel(new BorderLayout());
            JLabel iconLabel = new JLabel(icon);
            iconLabel.setVerticalAlignment(1);
            panel.add((Component)fieldDescription, "Center");
            panel.add((Component)iconLabel, "After");
            component = panel;
        }
        component.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        return component;
    }

    private void initFieldEditor(int cellFieldIndex, String currentEditorText) {
        String text = currentEditorText;
        if (currentEditorText == null || this.selectedField != cellFieldIndex && (this.selectedField != -1 || cellFieldIndex != 0)) {
            text = this.arbilFields[cellFieldIndex].getFieldValue();
        }
        if (this.fieldEditors[cellFieldIndex] instanceof JTextArea) {
            JTextArea fieldEditor = (JTextArea)this.fieldEditors[cellFieldIndex];
            fieldEditor.setEditable(this.parentArbilDataNode.getParentDomNode().isEditable());
            fieldEditor.setText(text);
            fieldEditor.setLineWrap(true);
            fieldEditor.setWrapStyleWord(true);
        } else {
            ControlledVocabularyComboBox fieldEditor = (ControlledVocabularyComboBox)this.fieldEditors[cellFieldIndex];
            ControlledVocabularyComboBoxEditor cvcbEditor = new ControlledVocabularyComboBoxEditor(text, text, this.arbilFields[cellFieldIndex], (JComboBox)fieldEditor);
            fieldEditor.setEditor(cvcbEditor);
            cvcbEditor.getEditorComponent().addFocusListener(this.editorFocusListener);
            cvcbEditor.getTextField().setInputMap(0, new lfeInputMap(cvcbEditor.getTextField().getInputMap()));
            cvcbEditor.getTextField().setActionMap(new lfeActionMap(cvcbEditor.getTextField().getActionMap()));
            fieldEditor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }
        this.fieldEditors[cellFieldIndex].addFocusListener(this.editorFocusListener);
        this.fieldEditors[cellFieldIndex].setInputMap(0, new lfeInputMap(this.fieldEditors[cellFieldIndex].getInputMap()));
        this.fieldEditors[cellFieldIndex].setActionMap(new lfeActionMap(this.fieldEditors[cellFieldIndex].getActionMap()));
    }

    private String getWindowTitle() {
        return this.fieldName + " in " + String.valueOf(this.parentArbilDataNode);
    }

    private JPanel createPreviousNextPanel() {
        this.prevButton = new JButton(this.previousAction);
        this.prevButton.setText("Previous");
        this.prevButton.setMnemonic('p');
        this.nextButton = new JButton(this.nextAction);
        this.nextButton.setText("Next");
        this.nextButton.setMnemonic('n');
        JPanel buttonsPanel = new JPanel(new FlowLayout(4));
        buttonsPanel.add(this.prevButton);
        buttonsPanel.add(this.nextButton);
        return buttonsPanel;
    }

    private void setParentFieldList() {
        this.parentFieldList = this.parentArbilDataNode.getFieldsSorted();
    }

    private void setNavigationEnabled(boolean enabled) {
        this.nextButton.setEnabled(enabled);
        this.prevButton.setEnabled(enabled);
    }

    private void setNavigationEnabled() {
        int index = this.parentFieldList.indexOf(this.arbilFields);
        this.nextButton.setEnabled(index < this.parentFieldList.size() - 1);
        this.prevButton.setEnabled(index > 0);
    }

    private void requestFocusFor(final JComponent component) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                component.requestFocusInWindow();
            }
        });
    }

    public void updateEditor() {
        this.arbilFields = this.parentArbilDataNode.getFields().get(this.fieldName);
        this.selectedField = Math.max(0, Math.min(this.tabPane.getTabCount(), this.tabPane.getSelectedIndex()));
        this.tabPane.removeAll();
        if (this.arbilFields != null && this.arbilFields.length > 0) {
            this.editorFrame.setTitle(this.getWindowTitle());
            JComponent focusedTabTextArea = this.populateTabbedPane(null);
            this.requestFocusFor(focusedTabTextArea);
            if (this.selectedField < this.tabPane.getTabCount()) {
                this.tabPane.setSelectedIndex(this.selectedField);
            }
        }
    }

    public void closeWindow() {
        this.editorFrame.doDefaultCloseAction();
    }

    public synchronized void storeChanges() {
        if (this.arbilFields != null) {
            for (int cellFieldCounter = 0; cellFieldCounter < this.arbilFields.length; ++cellFieldCounter) {
                this.checkSaveCellField(cellFieldCounter);
            }
        }
    }

    private void checkSaveCellField(int cellFieldIndex) {
        ArbilField cellField = this.arbilFields[cellFieldIndex];
        if (cellField.getParentDataNode().getParentDomNode().isEditable()) {
            if (this.fieldEditors[cellFieldIndex] instanceof JTextArea) {
                cellField.setFieldValue(((JTextArea)this.fieldEditors[cellFieldIndex]).getText(), true, false);
            } else if (this.fieldEditors[cellFieldIndex] instanceof ControlledVocabularyComboBox) {
                cellField.setFieldValue(((ControlledVocabularyComboBox)this.fieldEditors[cellFieldIndex]).getCurrentValue(), true, false);
            }
        }
    }

    private boolean checkSaveKeyEditorField(int cellFieldIndex) {
        ArbilField cellField = this.arbilFields[cellFieldIndex];
        if (!this.keyEditorFields[cellFieldIndex].getText().equals(this.arbilFields[cellFieldIndex].getKeyName())) {
            if (ArbilWindowManager.getSingleInstance().askUserToSaveChanges(this.arbilFields[cellFieldIndex].getParentDataNode().getParentDomNode().toString())) {
                int index = this.parentFieldList.indexOf(this.arbilFields);
                if (cellField.setKeyName(this.keyEditorFields[cellFieldIndex].getText(), true, false)) {
                    this.setParentFieldList();
                    this.moveTo(index);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public void dataNodeRemoved(ArbilNode dataNode) {
        this.closeWindow();
    }

    public void dataNodeIconCleared(ArbilNode dataNode) {
        this.updateEditor();
        this.setParentFieldList();
        this.setNavigationEnabled();
    }

    public void dataNodeChildAdded(ArbilNode destination, ArbilNode newNode) {
    }

    private synchronized void changeTab(int d) {
        int index = d > 0 ? Math.min(this.tabPane.getSelectedIndex() + 1, this.tabPane.getTabCount() - 1) : Math.max(this.tabPane.getSelectedIndex() - 1, 0);
        this.tabPane.setSelectedIndex(index);
        this.requestFocusFor(this.fieldEditors[index]);
    }

    private synchronized void moveAdjacent(int d) {
        int index = this.parentFieldList.indexOf(this.arbilFields);
        if ((index += d) < this.parentFieldList.size() && index >= 0) {
            this.storeChanges();
            this.moveTo(index);
        }
    }

    private synchronized void moveTo(int index) {
        this.fieldName = this.parentFieldList.get(index)[0].getTranslateFieldName();
        this.updateEditor();
        this.setNavigationEnabled();
    }

    private class KeyPanel
    extends JPanel {
        private final int cellFieldIndex;
        private JButton changeKeyNameButton;
        private JPanel changeActionButtonsPanel;
        private JTextField keyEditorField;
        private JLabel keyNameLabel;
        private Action keyNameSaveAction;
        private Action keyNameCancelAction;

        public KeyPanel(int cellFieldIndex) {
            super(new BorderLayout());
            this.keyNameSaveAction = new AbstractAction("KeyNameOk"){

                public void actionPerformed(ActionEvent e) {
                    if (ArbilLongFieldEditor.this.checkSaveKeyEditorField(KeyPanel.this.cellFieldIndex)) {
                        KeyPanel.this.disableEditMode();
                    }
                }
            };
            this.keyNameCancelAction = new AbstractAction("KeyNameCancel"){

                public void actionPerformed(ActionEvent e) {
                    KeyPanel.this.disableEditMode();
                }
            };
            this.cellFieldIndex = cellFieldIndex;
            this.initComponents();
            this.addComponents();
        }

        private void initComponents() {
            this.keyNameLabel = new JLabel(ArbilLongFieldEditor.this.arbilFields[this.cellFieldIndex].getKeyName());
            this.initKeyEditorField(this.cellFieldIndex);
            this.initChangeKeyNameButton();
            this.initActionButtonsPanel();
        }

        private void addComponents() {
            this.add((Component)new JLabel("Key Name: "), "Before");
            this.add((Component)this.keyNameLabel, "Center");
            this.add((Component)this.changeKeyNameButton, "After");
        }

        private void initActionButtonsPanel() {
            JButton saveFieldNameButton = new JButton(this.keyNameSaveAction);
            saveFieldNameButton.setText("Apply");
            JButton cancelFieldNameButton = new JButton(this.keyNameCancelAction);
            cancelFieldNameButton.setText("Cancel");
            this.changeActionButtonsPanel = new JPanel(new BorderLayout());
            this.changeActionButtonsPanel.add((Component)saveFieldNameButton, "Before");
            this.changeActionButtonsPanel.add((Component)cancelFieldNameButton, "After");
        }

        private void initChangeKeyNameButton() {
            this.changeKeyNameButton = new JButton(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    KeyPanel.this.enableEditMode();
                }
            });
            this.changeKeyNameButton.setText("Change key name");
            this.changeKeyNameButton.setMnemonic('c');
        }

        private void initKeyEditorField(int cellFieldIndex) {
            this.keyEditorField = new JTextField(ArbilLongFieldEditor.this.arbilFields[cellFieldIndex].getKeyName());
            this.keyEditorField.setEditable(ArbilLongFieldEditor.this.parentArbilDataNode.getParentDomNode().isEditable());
            this.keyEditorField.getActionMap().put("KeyNameOk", this.keyNameSaveAction);
            this.keyEditorField.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "KeyNameOk");
            this.keyEditorField.getActionMap().put("KeyNameCancel", this.keyNameCancelAction);
            this.keyEditorField.getInputMap().put(KeyStroke.getKeyStroke(27, 0, true), "KeyNameCancel");
            ArbilLongFieldEditor.this.keyEditorFields[cellFieldIndex] = this.keyEditorField;
        }

        private void enableEditMode() {
            this.keyNameLabel.setVisible(false);
            this.remove(this.keyNameLabel);
            this.changeKeyNameButton.setVisible(false);
            this.remove(this.changeKeyNameButton);
            this.keyEditorField.setText(ArbilLongFieldEditor.this.arbilFields[this.cellFieldIndex].getKeyName());
            this.add((Component)this.keyEditorField, "Center");
            this.keyEditorField.setVisible(true);
            this.add((Component)this.changeActionButtonsPanel, "After");
            this.changeActionButtonsPanel.setVisible(true);
            this.validate();
            this.keyEditorField.requestFocusInWindow();
            ArbilLongFieldEditor.this.setNavigationEnabled(false);
        }

        private void disableEditMode() {
            this.keyEditorField.setVisible(false);
            this.remove(this.keyEditorField);
            this.changeActionButtonsPanel.setVisible(false);
            this.remove(this.changeActionButtonsPanel);
            this.keyNameLabel.setText(ArbilLongFieldEditor.this.arbilFields[this.cellFieldIndex].getKeyName());
            this.add((Component)this.keyNameLabel, "Center");
            this.keyNameLabel.setVisible(true);
            this.add((Component)this.changeKeyNameButton, "After");
            this.changeKeyNameButton.setVisible(true);
            this.validate();
            ArbilLongFieldEditor.this.setNavigationEnabled(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FieldAttributesTableModel
    implements TableModel {
        private List<String[]> attributePaths;
        private int cellFieldIndex;

        public FieldAttributesTableModel(int cellFieldIndex) {
            this.cellFieldIndex = cellFieldIndex;
            this.attributePaths = ArbilLongFieldEditor.this.arbilFields[cellFieldIndex].getAttributePaths();
        }

        @Override
        public int getRowCount() {
            return this.attributePaths.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return ATTR_COLUMN_NAMES[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return ATTR_COLUMN_TYPES[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String[] path = this.attributePaths.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return path[1];
                }
                case 1: {
                    return ArbilLongFieldEditor.this.arbilFields[this.cellFieldIndex].getAttributeValue(path[0]);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                String[] path = this.attributePaths.get(rowIndex);
                ArbilLongFieldEditor.this.arbilFields[this.cellFieldIndex].setAttributeValue(path[0], aValue, true);
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }

    private static class lfeInputMap
    extends InputMap {
        public lfeInputMap(InputMap parent) {
            if (parent != null) {
                this.setParent(parent);
            }
            this.put(KeyStroke.getKeyStroke(40, 256), "nextField");
            this.put(KeyStroke.getKeyStroke(34, 256), "nextField");
            this.put(KeyStroke.getKeyStroke(40, 128), "nextField");
            this.put(KeyStroke.getKeyStroke(34, 128), "nextField");
            this.put(KeyStroke.getKeyStroke(38, 256), "previousField");
            this.put(KeyStroke.getKeyStroke(33, 256), "previousField");
            this.put(KeyStroke.getKeyStroke(38, 128), "previousField");
            this.put(KeyStroke.getKeyStroke(33, 128), "previousField");
            this.put(KeyStroke.getKeyStroke(39, 256), "nextTab");
            this.put(KeyStroke.getKeyStroke(39, 128), "nextTab");
            this.put(KeyStroke.getKeyStroke(37, 256), "previousTab");
            this.put(KeyStroke.getKeyStroke(37, 128), "previousTab");
        }
    }

    private class lfeActionMap
    extends ActionMap {
        public lfeActionMap(ActionMap parent) {
            if (parent != null) {
                this.setParent(parent);
            }
            this.put("nextField", ArbilLongFieldEditor.this.nextAction);
            this.put("previousField", ArbilLongFieldEditor.this.previousAction);
            this.put("nextTab", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    ArbilLongFieldEditor.this.changeTab(1);
                }
            });
            this.put("previousTab", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    ArbilLongFieldEditor.this.changeTab(-1);
                }
            });
        }
    }
}

