/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.wizard.setup;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.arbil.ui.wizard.setup.ArbilSetupWizard;
import nl.mpi.arbil.ui.wizard.setup.ArbilSetupWizardModel;
import nl.mpi.arbil.ui.wizard.setup.TextInstructionWizardContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteLocationsContent
extends TextInstructionWizardContent {
    private ArbilSetupWizardModel model;
    private JTextArea locationsTextArea;
    public static final String imdiDefaultsResource = "/defaults/imdiLocations";
    public static final String cmdiDefaultsResource = "/defaults/cmdiLocations";

    public RemoteLocationsContent(ArbilSetupWizardModel model) {
        super("/nl/mpi/arbil/resources/html/wizard/RemoteLocations.html");
        this.model = model;
        this.locationsTextArea = new JTextArea();
        this.locationsTextArea.setEditable(true);
        this.locationsTextArea.setRows(6);
        JScrollPane locationsScrollPane = new JScrollPane(this.locationsTextArea);
        locationsScrollPane.setVerticalScrollBarPolicy(22);
        locationsScrollPane.setHorizontalScrollBarPolicy(30);
        this.add((Component)locationsScrollPane, "Center");
    }

    @Override
    public void beforeShow() {
        if (this.model.getRemoteLocations() == null) {
            this.model.setRemoteLocations(this.loadRemoteLocations());
        }
    }

    @Override
    public void refresh() {
        this.locationsTextArea.setText(this.model.getRemoteLocations());
        this.locationsTextArea.requestFocusInWindow();
    }

    @Override
    public boolean beforeNext() {
        this.model.setRemoteLocations(this.locationsTextArea.getText());
        if (this.model.getRemoteLocations().trim().length() > 0) {
            return true;
        }
        return 0 == JOptionPane.showConfirmDialog(this, "You have not yet specified any remote locations. Are you sure you want to continue?", "No locations specified", 2, 2);
    }

    @Override
    public boolean beforePrevious() {
        if (0 == JOptionPane.showConfirmDialog(this, "Doing this will reset the list of remote locations. Do you want to go back a step in the wizard?", "Discard changes", 2, 2)) {
            this.model.setRemoteLocations(null);
            return true;
        }
        return false;
    }

    @Override
    public Object getNext() {
        return ArbilSetupWizard.CONFIRMATION;
    }

    @Override
    public Object getPrevious() {
        if (this.model.isCmdiSelected()) {
            return ArbilSetupWizard.CMDI_PROFILE_SELECT;
        }
        return ArbilSetupWizard.METADATA_FORMAT_SELECT;
    }

    private String loadRemoteLocations() {
        String newLine = System.getProperty("line.separator");
        LinkedList<String> locationsList = new LinkedList<String>();
        for (ArbilDataNode remoteNode : ArbilTreeHelper.getSingleInstance().getRemoteCorpusNodes()) {
            locationsList.add(remoteNode.getUrlString());
        }
        if (this.model.isImdiSelected()) {
            try {
                this.addLocationsFromResource(imdiDefaultsResource, locationsList);
            }
            catch (IOException ex) {
                GuiHelper.linorgBugCatcher.logError("Error while reading default IMDI locations", ex);
            }
        }
        if (this.model.isCmdiSelected()) {
            try {
                this.addLocationsFromResource(cmdiDefaultsResource, locationsList);
            }
            catch (IOException ex) {
                GuiHelper.linorgBugCatcher.logError("Error while reading default CMDI locations", ex);
            }
        }
        StringBuilder locations = new StringBuilder();
        for (String location : locationsList) {
            locations.append(location).append(newLine);
        }
        return locations.toString();
    }

    private void addLocationsFromResource(String resourceLocation, List<String> locations) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(resourceLocation);
        if (is == null) {
            throw new IOException("Resource not found: " + resourceLocation);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String location = reader.readLine();
        while (location != null) {
            if ((location = location.trim()).length() > 0 && !locations.contains(location)) {
                locations.add(location);
            }
            location = reader.readLine();
        }
    }
}

