/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.util;

import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.WindowManager;

public class ArbilBugCatcher
implements BugCatcher {
    private static WindowManager windowManager;
    private static ApplicationVersionManager versionManager;
    private static SessionStorage sessionStorage;
    private int captureCount = 0;

    public static void setWindowManager(WindowManager windowManagerInstance) {
        windowManager = windowManagerInstance;
    }

    public static void setVersionManager(ApplicationVersionManager versionManagerInstance) {
        versionManager = versionManagerInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public ArbilBugCatcher() {
        File errorLogFile = new File(sessionStorage.getStorageDirectory(), "linorgerror.log");
        if (errorLogFile.exists()) {
            errorLogFile.delete();
        }
        ApplicationVersion appVersion = versionManager.getApplicationVersion();
        String currentApplicationVersionMatch = "error-" + appVersion.currentMajor + "-" + appVersion.currentMinor + "-";
        String currentLogFileMatch = "error-" + appVersion.currentMajor + "-" + appVersion.currentMinor + "-" + appVersion.currentRevision + ".log";
        for (String currentFile : sessionStorage.getStorageDirectory().list()) {
            if (!currentFile.startsWith(currentApplicationVersionMatch)) continue;
            if (currentFile.startsWith(currentLogFileMatch)) {
                System.out.println("currentLogFileMatch: " + currentFile);
                continue;
            }
            System.out.println("deleting old log file: " + currentFile);
            if (new File(sessionStorage.getStorageDirectory(), currentFile).delete()) continue;
            System.out.println("Did not delete old log file: " + currentFile);
        }
    }

    public File getLogFile() {
        ApplicationVersion appVersion = versionManager.getApplicationVersion();
        File file = new File(sessionStorage.getStorageDirectory(), "error-" + appVersion.currentMajor + "-" + appVersion.currentMinor + "-" + appVersion.currentRevision + ".log");
        if (!file.exists()) {
            ArbilBugCatcher.startNewLogFile(file);
        }
        return file;
    }

    private static void startNewLogFile(File file) {
        ApplicationVersion appVersion = versionManager.getApplicationVersion();
        try {
            FileWriter errorLogFile = new FileWriter(file, false);
            errorLogFile.append(appVersion.applicationTitle + " error log" + System.getProperty("line.separator") + "Version: " + appVersion.currentMajor + "." + appVersion.currentMinor + "." + appVersion.currentRevision + System.getProperty("line.separator") + appVersion.lastCommitDate + System.getProperty("line.separator") + "Compile Date: " + appVersion.compileDate + System.getProperty("line.separator") + "Operating System: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version") + System.getProperty("line.separator") + "Java version: " + System.getProperty("java.version") + " by " + System.getProperty("java.vendor") + System.getProperty("line.separator") + "User: " + System.getProperty("user.name") + System.getProperty("line.separator") + "Log started: " + new Date().toString() + System.getProperty("line.separator"));
            errorLogFile.append("======================================================================" + System.getProperty("line.separator"));
            errorLogFile.close();
        }
        catch (IOException ex) {
            System.err.println("failed to write to the error log: " + ex.getMessage());
        }
    }

    public void grabApplicationShot() {
        try {
            Robot robot = new Robot();
            BufferedImage screenShot = robot.createScreenCapture(windowManager.getMainFrame().getBounds());
            DecimalFormat myFormat = new DecimalFormat("000");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            String formattedDate = formatter.format(new Date());
            String formattedCount = myFormat.format((Object)this.captureCount);
            ImageIO.write((RenderedImage)screenShot, "JPG", new File(sessionStorage.getStorageDirectory(), "screenshots" + File.separatorChar + formattedDate + "-" + formattedCount + ".jpg"));
            ++this.captureCount;
        }
        catch (Exception e) {
            System.err.println("Exception when creating screenshot: " + e);
        }
    }

    public void logError(Exception exception) {
        this.logError("", exception);
    }

    public void logError(String messageString, Exception exception) {
        try {
            System.err.println(messageString);
            if (exception != null) {
                System.err.println("exception: " + exception.getMessage());
                exception.printStackTrace(System.err);
            }
            FileWriter errorLogFile = new FileWriter(this.getLogFile(), true);
            errorLogFile.append(messageString + System.getProperty("line.separator"));
            errorLogFile.append("Error Date: " + new Date().toString() + System.getProperty("line.separator"));
            this.appendVersionInformation(errorLogFile);
            if (exception != null) {
                StackTraceElement[] stackTraceElements;
                errorLogFile.append("Exception Message: " + exception.getMessage() + System.getProperty("line.separator"));
                for (StackTraceElement element : stackTraceElements = exception.getStackTrace()) {
                    errorLogFile.append(element.toString() + System.getProperty("line.separator"));
                }
            }
            errorLogFile.append("======================================================================" + System.getProperty("line.separator"));
            errorLogFile.close();
        }
        catch (Exception ex) {
            System.err.println("failed to write to the error log: " + ex.getMessage());
        }
    }

    protected void appendVersionInformation(FileWriter errorLogFile) throws IOException {
        ApplicationVersion appVersion = versionManager.getApplicationVersion();
        errorLogFile.append("Compile Date: " + appVersion.compileDate + System.getProperty("line.separator"));
        errorLogFile.append("Current Revision: " + appVersion.currentMajor + "-" + appVersion.currentMinor + "-" + appVersion.currentRevision + System.getProperty("line.separator"));
    }
}

