/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.Add;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.xml.sax.InputSource;

public final class Replace
extends ACreate {
    public Replace(String source, String input) {
        super(514, source, input);
    }

    @Override
    protected boolean run() {
        IO io = IO.get(this.args[1]);
        if (!io.exists()) {
            return this.error(Text.FILEWHICH, io);
        }
        try {
            return this.info(Replace.replace(this.args[0], io.inputSource(), this.context, false), this.perf);
        }
        catch (Exception ex) {
            return this.error(ex.getMessage(), new Object[0]);
        }
    }

    public static String replace(String p, InputSource input, Context ctx, boolean lock) throws BaseXException {
        String target;
        Data data = ctx.data;
        String path = Replace.path(p);
        if (path.isEmpty()) {
            return Util.info(Text.DIRERR, path);
        }
        byte[] src = Token.token(path);
        IntList docs = data.doc(p);
        if (docs.size() == 0) {
            return Util.info(Text.FILEWHICH, path);
        }
        IntList il = data.doc();
        int i = 0;
        int is = il.size();
        while (i < is) {
            if (!Token.eq(data.text(il.get(i), true), src)) {
                return Util.info(Text.DIRERR, path);
            }
            ++i;
        }
        int i2 = path.lastIndexOf(47);
        if (i2 != -1) {
            target = path.substring(0, i2);
            path = path.substring(i2 + 1);
        } else {
            target = "";
        }
        try {
            if (lock) {
                ctx.register(true);
            }
            int d = docs.size() - 1;
            while (d >= 0) {
                data.delete(docs.get(d));
                --d;
            }
            Add.add(path, target, input, ctx, null, false);
        }
        finally {
            if (lock) {
                ctx.unregister(true);
            }
        }
        return Util.info(Text.PATHREPLACED, docs.size());
    }
}

