/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.basex.core.Progress;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.list.ByteList;

public final class Zip
extends Progress {
    private final IO archive;
    private int total;
    private int curr;

    public Zip(IO file) {
        this.archive = file;
    }

    public int size() throws IOException {
        int c = 0;
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(this.archive.buffer());
            while (in.getNextEntry() != null) {
                ++c;
            }
            int n = c;
            return n;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public byte[] read(String path) throws IOException {
        block18: {
            byte[] byArray;
            ZipEntry ze;
            ZipInputStream in = null;
            in = new ZipInputStream(this.archive.buffer());
            while ((ze = in.getNextEntry()) != null) {
                int c;
                if (!path.equals(ze.getName())) continue;
                int s = (int)ze.getSize();
                if (s >= 0) {
                    int c2;
                    byte[] data = new byte[s];
                    int o = 0;
                    while (s - o != 0 && (c2 = in.read(data, o, s - o)) != -1) {
                        o += c2;
                    }
                    byte[] byArray2 = data;
                    return byArray2;
                }
                byte[] data = new byte[4096];
                ByteList bl = new ByteList();
                while ((c = in.read(data)) != -1) {
                    bl.add(data, 0, c);
                }
                byArray = bl.toArray();
            }
            break block18;
            {
                return byArray;
                break;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new FileNotFoundException(path);
    }

    public void unzip(IOFile target) throws IOException {
        byte[] data = new byte[4096];
        ZipInputStream in = null;
        this.total = this.size();
        this.curr = 0;
        try {
            ZipEntry ze;
            in = new ZipInputStream(this.archive.buffer());
            while ((ze = in.getNextEntry()) != null) {
                ++this.curr;
                IOFile trg = new IOFile(target, ze.getName());
                if (ze.isDirectory()) {
                    trg.md();
                    continue;
                }
                new IOFile(trg.dir()).md();
                FileOutputStream out = null;
                try {
                    int c;
                    out = new FileOutputStream(trg.path());
                    while ((c = in.read(data)) != -1) {
                        ((OutputStream)out).write(data, 0, c);
                    }
                }
                finally {
                    if (out != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void zip(File source) throws IOException {
        if (!(this.archive instanceof IOFile)) {
            throw new FileNotFoundException(this.archive.path());
        }
        byte[] data = new byte[4096];
        ZipOutputStream out = null;
        this.curr = 0;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(((IOFile)this.archive).path())));
            out.setLevel(1);
            out.putNextEntry(new ZipEntry(String.valueOf(source.getName()) + '/'));
            out.closeEntry();
            IOFile[] files = new IOFile(source).children();
            this.total = files.length;
            IOFile[] iOFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IOFile io = iOFileArray[n2];
                ++this.curr;
                FileInputStream in = null;
                try {
                    int c;
                    in = new FileInputStream(io.path());
                    out.putNextEntry(new ZipEntry(String.valueOf(source.getName()) + '/' + io.name()));
                    while ((c = in.read(data)) != -1) {
                        out.write(data, 0, c);
                    }
                    out.closeEntry();
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                ++n2;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected double prog() {
        return (double)this.curr / (double)this.total;
    }
}

