/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.net.URI;
import java.net.URISyntaxException;
import org.basex.query.QueryText;
import org.basex.query.item.AtomType;
import org.basex.query.item.Str;
import org.basex.util.Token;

public final class Uri
extends Str {
    public static final Uri EMPTY = new Uri(Token.EMPTY);
    public static final Uri COLL = Uri.uri(QueryText.URLCOLL);

    Uri(byte[] v) {
        super(v, AtomType.URI);
    }

    public static Uri uri(byte[] v) {
        return v.length == 0 ? EMPTY : new Uri(Token.norm(v));
    }

    public boolean eq(Uri uri) {
        return this.val == uri.val || Token.eq(this.val, uri.val);
    }

    public Uri resolve(Uri add) {
        if (add.val.length == 0) {
            return this;
        }
        try {
            URI base = new URI(Token.string(this.val));
            URI uri = base.resolve(Token.string(Token.uri(add.val, true)));
            return Uri.uri(Token.token(uri.toString()));
        }
        catch (Exception ex) {
            return this;
        }
    }

    public boolean absolute() {
        return Token.contains(this.val, 58);
    }

    public boolean valid() {
        try {
            new URI(Token.string(Token.uri(this.val, true)));
            return true;
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }
}

