/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import nl.mpi.corpusstructure.AccessCheck;
import org.apache.log4j.Logger;

public class AccessInfo {
    protected static Logger logger = Logger.getLogger(AccessInfo.class);
    protected static final String GROUPS = "accessgroups";
    public static final String EVERYBODY = "everybody";
    public static final String NOBODY = "nobody";
    public static final String CLEARED = "cleared";
    public static final String ALL_AUTH = "anyAuthenticatedUser";
    public static final String IGNORE = "ignore";
    private static Pattern validUserPattern = null;
    private String creator;
    private String owner;
    private String readRights;
    private String writeRights;

    protected AccessInfo(String creator, String owner, String readRights, String writeRights) {
        if (creator != null) {
            logger.warn((Object)("AccessInfo creator ignored: " + creator));
        }
        if (owner != null) {
            logger.warn((Object)("AccessInfo owner ignored: " + owner));
        }
        this.readRights = readRights == null ? NOBODY : readRights;
        this.writeRights = writeRights == null ? NOBODY : writeRights;
    }

    public AccessInfo(String readRights, String writeRights) {
        this.setReadRule(readRights);
        this.setWriteRule(writeRights);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("accessInfo:");
        result.append(" readRights: ").append(this.getReadRights());
        result.append(" writeRights: ").append(this.getWriteRights());
        return result.toString();
    }

    public boolean hasReadAccess(String username) {
        return AccessCheck.checkRights(username, this.readRights);
    }

    public boolean hasWriteAccess(String username) {
        return AccessCheck.checkRights(username, this.writeRights);
    }

    public boolean equals(AccessInfo otherAI) {
        if (otherAI == null) {
            return false;
        }
        return this.toString().equals(otherAI.toString());
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getReadRights() {
        return this.readRights;
    }

    public void setReadRights(String privs) {
        logger.warn((Object)("Deprecated: setReadRights: " + privs));
        this.readRights = privs;
    }

    public void setReadRule(String privs) {
        if (privs == null || privs.trim().length() < 1) {
            logger.warn((Object)"Readrights must not be empty - assuming NOBODY");
            privs = NOBODY;
        }
        if (!(EVERYBODY.equals(privs) || NOBODY.equals(privs) || ALL_AUTH.equals(privs) || CLEARED.equals(privs))) {
            throw new IllegalArgumentException("Readrights must be a valid AccessInfo constant or a List");
        }
        this.readRights = privs;
    }

    public void setReadUsers(List users) {
        if (users == null || users.size() < 1) {
            throw new IllegalArgumentException("Readrights user list must not be empty");
        }
        Iterator iter = users.iterator();
        StringBuffer sb = new StringBuffer(users.size() * 31 + 1);
        sb.append(" ");
        if (validUserPattern == null) {
            validUserPattern = Pattern.compile("^[a-zA-Z0-9_.,;:-][a-zA-Z0-9_@.,;:-]*$");
        }
        while (iter.hasNext()) {
            String user = (String)iter.next();
            if (!validUserPattern.matcher(user).matches()) {
                throw new IllegalArgumentException("Readrights user contains illegal chars: " + user);
            }
            sb.append(user).append(" ");
        }
        this.readRights = sb.toString();
    }

    public String getWriteRights() {
        return this.writeRights;
    }

    public void setWriteRights(String privs) {
        logger.warn((Object)("Deprecated: setWriteRights: " + privs));
        this.writeRights = privs;
    }

    public void setWriteRule(String privs) {
        if (privs == null || privs.trim().length() < 1) {
            logger.warn((Object)"Writerights must not be empty - assuming NOBODY");
            privs = NOBODY;
        }
        if (!(EVERYBODY.equals(privs) || NOBODY.equals(privs) || ALL_AUTH.equals(privs) || CLEARED.equals(privs))) {
            throw new IllegalArgumentException("Writerights must be a valid AccessInfo constant or a List");
        }
        this.writeRights = privs;
    }

    public void setWriteUsers(List users) {
        if (users == null || users.size() < 1) {
            throw new IllegalArgumentException("Writerights user list must not be empty");
        }
        Iterator iter = users.iterator();
        StringBuffer sb = new StringBuffer(users.size() * 30);
        sb.append(" ");
        if (validUserPattern == null) {
            validUserPattern = Pattern.compile("^[a-zA-Z0-9_.,;:-][a-zA-Z0-9_@.,;:-]*$");
        }
        while (iter.hasNext()) {
            String user = (String)iter.next();
            if (!validUserPattern.matcher(user).matches()) {
                throw new IllegalArgumentException("Writerights user contains illegal chars: " + user);
            }
            sb.append(user).append(" ");
        }
        this.writeRights = sb.toString();
    }
}

