/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.UserFunc;
import org.basex.query.item.FuncItem;
import org.basex.query.item.FuncType;
import org.basex.query.item.SeqType;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class InlineFunc
extends UserFunc {
    public InlineFunc(InputInfo ii, SeqType r, Var[] argv, Expr body) {
        super(ii, null, argv, r, true);
        this.expr = body;
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        super.comp(ctx);
        return this.expr.hasFreeVars(ctx) ? this : this.optPre(this.item(ctx, this.input), ctx);
    }

    @Override
    public FuncItem item(QueryContext ctx, InputInfo ii) {
        FuncType ft = FuncType.get(this);
        boolean c = ft.ret != null && !this.expr.type().instance(ft.ret);
        return new FuncItem(this.args, this.expr, ft, ctx.vars.local(), c);
    }

    @Override
    public Value value(QueryContext ctx) {
        return this.item(ctx, this.input);
    }

    @Override
    public Iter iter(QueryContext ctx) {
        return this.value(ctx).iter();
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 || super.uses(u);
    }

    @Override
    public boolean removable(Var v) {
        return false;
    }

    @Override
    public Expr remove(Var v) {
        throw Util.notexpected(v);
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[0][]);
        int i = 0;
        while (i < this.args.length) {
            ser.attribute(Token.token("arg" + i), this.args[i].name.atom());
            ++i;
        }
        this.expr.plan(ser);
        ser.closeElement();
    }

    @Override
    public String toString() {
        StringBuilder tb = new StringBuilder("function").append("(");
        int i = 0;
        while (i < this.args.length) {
            if (i > 0) {
                tb.append(", ");
            }
            tb.append(this.args[i].toString());
            ++i;
        }
        tb.append(")").append(' ');
        if (this.ret != null) {
            tb.append("as ").append(this.ret.toString()).append(' ');
        }
        return tb.append("{ ").append(this.expr).append(" }").toString();
    }
}

