/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin.profiles;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import nl.mpi.arbil.ArbilDesktopInjector;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.clarin.profiles.DataCategoryDescriptionHandler;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilEntityResolver;
import nl.mpi.arbil.data.ArbilVocabularies;
import nl.mpi.arbil.data.ArbilVocabulary;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.MessageDialogHandler;
import org.apache.xmlbeans.SchemaAnnotation;
import org.apache.xmlbeans.SchemaLocalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdiTemplate
extends ArbilTemplate {
    public static final String RESOURCE_REFERENCE_ATTRIBUTE = "ref";
    public static final String LANGUAGE_ATTRIBUTE = String.format("{%1$s}lang", ArbilComponentBuilder.encodeNsUriForAttributePath("http://www.w3.org/XML/1998/namespace"));
    public static final Collection<String> RESERVED_ATTRIBUTES = Collections.unmodifiableCollection(Arrays.asList("ref", LANGUAGE_ATTRIBUTE, "componentId", "ComponentId"));
    public static final String DATCAT_URI_DESCRIPTION_POSTFIX = ".dcif?workingLanguage=en";
    public static final int SCHEMA_CACHE_EXPIRY_DAYS = 100;
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private static MessageDialogHandler messageDialogHandler;
    private static BugCatcher bugCatcher;
    private static SessionStorage sessionStorage;
    private String nameSpaceString;
    private String[] filterString = new String[]{".CMD.Resources.", ".CMD.Header.", ".Kinnate.Entity."};
    private Document schemaDocument;
    private Map<String, String> dataCategoriesMap;
    private final Map<String, String> dataCategoryDescriptionMap = Collections.synchronizedMap(new HashMap());
    protected HashSet<String> allowsLanguageIdPathList;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public void loadTemplate(String nameSpaceStringLocal) {
        this.vocabularyHashTable = new Hashtable();
        this.nameSpaceString = nameSpaceStringLocal;
        try {
            CmdiProfileReader.CmdiProfile cmdiProfile = CmdiProfileReader.getSingleInstance().getProfile(this.nameSpaceString);
            this.loadedTemplateName = cmdiProfile != null ? cmdiProfile.name : this.nameSpaceString.substring(this.nameSpaceString.lastIndexOf("/") + 1);
            ArrayListGroup arrayListGroup = new ArrayListGroup();
            URI xsdUri = new URI(this.nameSpaceString);
            this.readSchema(xsdUri, arrayListGroup);
            this.childNodePaths = (String[][])arrayListGroup.childNodePathsList.toArray((T[])new String[0][]);
            this.templatesArray = (String[][])arrayListGroup.addableComponentPathsList.toArray((T[])new String[0][]);
            this.resourceNodePaths = (String[][])arrayListGroup.resourceNodePathsList.toArray((T[])new String[0][]);
            this.fieldConstraints = (String[][])arrayListGroup.fieldConstraintList.toArray((T[])new String[0][]);
            this.fieldUsageArray = (String[][])arrayListGroup.fieldUsageDescriptionList.toArray((T[])new String[0][]);
            this.allowsLanguageIdPathList = arrayListGroup.allowsLanguageIdPathsList;
            this.dataCategoriesMap = arrayListGroup.dataCategoriesMap;
            this.makeGuiNamesUnique();
            String[][] tempSortableArray = (String[][])arrayListGroup.displayNamePreferenceList.toArray((T[])new String[0][]);
            Arrays.sort(tempSortableArray, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    return Integer.valueOf(o1[1]) - Integer.valueOf(o2[1]);
                }
            });
            this.preferredNameFields = new String[tempSortableArray.length];
            for (int nameFieldCounter = 0; nameFieldCounter < this.preferredNameFields.length; ++nameFieldCounter) {
                this.preferredNameFields[nameFieldCounter] = tempSortableArray[nameFieldCounter][0];
            }
        }
        catch (URISyntaxException urise) {
            bugCatcher.logError(urise);
        }
        this.requiredFields = new String[0];
        this.fieldTriggersArray = new String[0][];
        this.autoFieldsArray = new String[0][];
        this.genreSubgenreArray = new String[0][];
    }

    private void makeGuiNamesUnique() {
        boolean allGuiNamesUnique = false;
        while (!allGuiNamesUnique) {
            allGuiNamesUnique = true;
            for (String[] currentTemplate : this.templatesArray) {
                String currentTemplateGuiName = currentTemplate[1];
                String currentTemplatePath = currentTemplate[0];
                for (String[] secondTemplate : this.templatesArray) {
                    String[] templateToChangePathParts;
                    int pathCount;
                    String templateToChangePath;
                    String templateToChangeGuiName;
                    String secondTemplateGuiName = secondTemplate[1];
                    String secondTemplatePath = secondTemplate[0];
                    if (currentTemplatePath.equals(secondTemplatePath) || !currentTemplateGuiName.equals(secondTemplateGuiName)) continue;
                    allGuiNamesUnique = false;
                    for (String[] templateToChange : this.templatesArray) {
                        templateToChangeGuiName = templateToChange[1];
                        templateToChangePath = templateToChange[0];
                        if (!templateToChangeGuiName.equals(currentTemplateGuiName)) continue;
                        pathCount = templateToChangeGuiName.split("\\.").length;
                        templateToChangePathParts = templateToChangePath.split("\\.");
                        templateToChange[1] = templateToChangePathParts[templateToChangePathParts.length - pathCount - 1] + "." + templateToChangeGuiName;
                    }
                    for (String[] templateToChange : this.childNodePaths) {
                        templateToChangeGuiName = templateToChange[1];
                        templateToChangePath = templateToChange[0];
                        if (!templateToChangeGuiName.equals(currentTemplateGuiName)) continue;
                        pathCount = templateToChangeGuiName.split("\\.").length;
                        templateToChangePathParts = templateToChangePath.split("\\.");
                        templateToChange[1] = templateToChangePathParts[templateToChangePathParts.length - pathCount - 1] + "." + templateToChangeGuiName;
                    }
                }
            }
        }
    }

    public List<String[]> getEditableAttributesForPath(String path) {
        LinkedList<String[]> attributePaths = new LinkedList<String[]>();
        String pathAsPrefix = path + ".";
        for (String[] templatePath : this.templatesArray) {
            if (!ArbilComponentBuilder.pathIsAttribute(templatePath[0]) || !templatePath[0].startsWith(pathAsPrefix) || !CmdiTemplate.pathIsEditableAttribute(templatePath[0])) continue;
            attributePaths.add(templatePath);
        }
        return attributePaths;
    }

    @Override
    public Enumeration listTypesFor(Object targetNodeUserObject) {
        String targetNodeXpath = ((ArbilDataNode)targetNodeUserObject).getURI().getFragment();
        boolean isComponentPath = false;
        if (targetNodeXpath != null) {
            isComponentPath = targetNodeXpath.endsWith(")");
            targetNodeXpath = targetNodeXpath.replaceAll("\\(\\d+\\)", "");
        }
        Vector<String[]> childTypes = new Vector<String[]>();
        if (targetNodeUserObject instanceof ArbilDataNode) {
            for (String[] childPathString : this.templatesArray) {
                boolean allowEntry = false;
                if (targetNodeXpath == null) {
                    allowEntry = true;
                } else if (childPathString[0].startsWith(targetNodeXpath)) {
                    allowEntry = true;
                }
                if (childPathString[0].equals(targetNodeXpath) && isComponentPath) {
                    allowEntry = false;
                }
                for (String currentFilter : this.filterString) {
                    if (!childPathString[0].startsWith(currentFilter)) continue;
                    allowEntry = false;
                }
                if (!allowEntry) continue;
                childTypes.add(new String[]{childPathString[1], childPathString[0]});
            }
            String[][] childTypesArray = (String[][])childTypes.toArray((T[])new String[0][]);
            childTypes.removeAllElements();
            for (String[] currentChildType : childTypesArray) {
                boolean keepChildType;
                boolean bl = keepChildType = !ArbilComponentBuilder.pathIsAttribute(currentChildType[1]) || this.pathIsEditableField(currentChildType[1]);
                if (keepChildType) {
                    for (String[] subChildType : childTypesArray) {
                        String remainderString;
                        if (ArbilComponentBuilder.pathIsAttribute(subChildType[1]) || !currentChildType[1].startsWith(subChildType[1]) || !(remainderString = currentChildType[1].substring(subChildType[1].length())).contains(".")) continue;
                        keepChildType = false;
                    }
                }
                if (!keepChildType) continue;
                childTypes.add(currentChildType);
            }
            Collections.sort(childTypes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String value1 = ((String[])o1)[0];
                    String value2 = ((String[])o2)[0];
                    return value1.compareTo(value2);
                }
            });
        }
        return childTypes.elements();
    }

    private void readSchema(URI xsdFile, ArrayListGroup arrayListGroup) {
        File schemaFile = xsdFile.getScheme().equals("file") ? new File(xsdFile) : sessionStorage.updateCache(xsdFile.toString(), 100, false);
        this.templateFile = schemaFile;
        try {
            FileInputStream inputStream = new FileInputStream(schemaFile);
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setCharacterEncoding("UTF-8");
            xmlOptions.setEntityResolver(new ArbilEntityResolver(xsdFile));
            SchemaTypeSystem sts = XmlBeans.compileXsd(new XmlObject[]{XmlObject.Factory.parse(inputStream, xmlOptions)}, XmlBeans.getBuiltinTypeSystem(), xmlOptions);
            SchemaType schemaType = sts.documentTypes()[0];
            this.constructXml(schemaType, arrayListGroup, "");
        }
        catch (IOException e) {
            bugCatcher.logError(this.templateFile.getName(), e);
            messageDialogHandler.addMessageDialogToQueue("Could not open the required template file: " + this.templateFile.getName(), "Load Clarin Template");
        }
        catch (XmlException e) {
            bugCatcher.logError(this.templateFile.getName(), e);
            messageDialogHandler.addMessageDialogToQueue("Could not read the required template file: " + this.templateFile.getName(), "Load Clarin Template");
        }
    }

    private int constructXml(SchemaType schemaType, ArrayListGroup arrayListGroup, String pathString) {
        int childCount = 0;
        int subNodeCount = 0;
        this.readControlledVocabularies(schemaType, pathString);
        this.readFieldConstrains(schemaType, pathString, arrayListGroup.fieldConstraintList);
        SchemaParticle topParticle = schemaType.getContentModel();
        this.searchForAnnotations(topParticle, pathString, arrayListGroup);
        SchemaProperty[] schemaPropertyArray = schemaType.getElementProperties();
        int currentNodeChildCount = 0;
        for (SchemaProperty schemaProperty : schemaPropertyArray) {
            ++childCount;
            String localName = schemaProperty.getName().getLocalPart();
            String currentPathString = pathString + "." + localName;
            if (localName == null) continue;
            ++currentNodeChildCount;
            ElementCardinality cardinality = this.determineElementCardinality(schemaProperty);
            SchemaType currentSchemaType = schemaProperty.getType();
            String currentNodeMenuName = localName;
            subNodeCount = this.constructXml(currentSchemaType, arrayListGroup, currentPathString);
            if (cardinality.canHaveMultiple) {
                if (subNodeCount > 0) {
                    arrayListGroup.childNodePathsList.add(new String[]{currentPathString, pathString.substring(pathString.lastIndexOf(".") + 1)});
                }
                String insertBefore = "";
                arrayListGroup.addableComponentPathsList.add(new String[]{currentPathString, currentNodeMenuName, insertBefore, Integer.toString(cardinality.maxOccurs)});
            }
            this.readElementAttributes(currentSchemaType, arrayListGroup, currentPathString, currentNodeMenuName, localName);
        }
        return subNodeCount += currentNodeChildCount;
    }

    private ElementCardinality determineElementCardinality(SchemaProperty schemaProperty) {
        ElementCardinality cardinality = new ElementCardinality();
        if (schemaProperty.getMaxOccurs() == null) {
            cardinality.maxOccurs = -1;
            cardinality.canHaveMultiple = true;
        } else if (schemaProperty.getMaxOccurs().toString().equals("unbounded")) {
            cardinality.maxOccurs = -1;
            cardinality.canHaveMultiple = true;
        } else {
            cardinality.maxOccurs = schemaProperty.getMaxOccurs().intValue();
            boolean bl = cardinality.canHaveMultiple = schemaProperty.getMaxOccurs().intValue() > 1;
        }
        if (!cardinality.canHaveMultiple) {
            cardinality.canHaveMultiple = schemaProperty.getMinOccurs().intValue() != schemaProperty.getMaxOccurs().intValue();
        }
        return cardinality;
    }

    private void readElementAttributes(SchemaType currentSchemaType, ArrayListGroup arrayListGroup, String currentPathString, String currentNodeMenuName, String localName) {
        boolean hasResourceAttribute = false;
        for (SchemaProperty attributesProperty : currentSchemaType.getAttributeProperties()) {
            String attributeName = CmdiTemplate.getAttributePathSection(attributesProperty.getName().getNamespaceURI(), attributesProperty.getName().getLocalPart());
            if (attributeName.equals(RESOURCE_REFERENCE_ATTRIBUTE)) {
                hasResourceAttribute = true;
            } else if (attributeName.equals(LANGUAGE_ATTRIBUTE)) {
                arrayListGroup.allowsLanguageIdPathsList.add(currentPathString);
            }
            String insertBefore = "";
            String attributePath = currentPathString + ".@" + attributeName;
            String displayName = currentNodeMenuName + "." + attributeName.replaceAll("\\{.*\\}", "");
            arrayListGroup.addableComponentPathsList.add(new String[]{attributePath, displayName, "", "1"});
        }
        if (hasResourceAttribute) {
            arrayListGroup.resourceNodePathsList.add(new String[]{currentPathString, localName});
        }
    }

    public static String getAttributePathSection(QName qName) {
        return CmdiTemplate.getAttributePathSection(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public static String getAttributePathSection(String nsURI, String localPart) {
        if (nsURI != null && nsURI.length() > 0) {
            nsURI = ArbilComponentBuilder.encodeNsUriForAttributePath(nsURI);
            StringBuilder attributeNameSb = new StringBuilder("{");
            attributeNameSb.append(nsURI);
            attributeNameSb.append("}");
            return attributeNameSb.append(localPart).toString();
        }
        return localPart;
    }

    private void searchForAnnotations(SchemaParticle schemaParticle, String nodePathBase, ArrayListGroup arrayListGroup) {
        block13: {
            block12: {
                if (schemaParticle == null) break block12;
                switch (schemaParticle.getParticleType()) {
                    case 3: {
                        for (SchemaParticle schemaParticleChild : schemaParticle.getParticleChildren()) {
                            String nodePath;
                            if (schemaParticleChild.getName() != null) {
                                nodePath = nodePathBase + "." + schemaParticleChild.getName().getLocalPart();
                            } else {
                                nodePath = nodePathBase + ".unnamed";
                                bugCatcher.logError(new Exception("unnamed node at: " + nodePath));
                            }
                            this.searchForAnnotations(schemaParticleChild, nodePath, arrayListGroup);
                        }
                        break block13;
                    }
                    case 4: {
                        SchemaLocalElement schemaLocalElement = (SchemaLocalElement)((Object)schemaParticle);
                        this.saveAnnotationData(schemaLocalElement, nodePathBase, arrayListGroup);
                    }
                }
                break block13;
            }
            Document schemaDoc = this.getSchemaDocument();
            if (schemaDoc != null) {
                String elementPath = nodePathBase.replaceFirst("\\.", "//*[@name='").replaceAll("\\.", "']//*[@name='") + "']";
                try {
                    Node elementSpecNode = XPathAPI.selectSingleNode((Node)schemaDoc, (String)elementPath);
                    if (elementSpecNode != null) {
                        NamedNodeMap attributes = elementSpecNode.getAttributes();
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            Node attrNode = attributes.item(i);
                            String nodeName = new QName(attrNode.getNamespaceURI(), attrNode.getLocalName()).toString();
                            this.saveAnnotationData(nodePathBase, nodeName, attrNode.getNodeValue(), arrayListGroup);
                        }
                    }
                }
                catch (TransformerException ex) {
                    // empty catch block
                }
            }
        }
    }

    private void saveAnnotationData(SchemaLocalElement schemaLocalElement, String nodePath, ArrayListGroup arrayListGroup) {
        SchemaAnnotation schemaAnnotation = schemaLocalElement.getAnnotation();
        if (schemaAnnotation != null) {
            for (SchemaAnnotation.Attribute annotationAttribute : schemaAnnotation.getAttributes()) {
                String annotationValue = annotationAttribute.getValue();
                String annotationName = annotationAttribute.getName().toString();
                this.saveAnnotationData(nodePath, annotationName, annotationValue, arrayListGroup);
            }
        }
    }

    private void saveAnnotationData(String nodePath, String annotationName, String annotationValue, ArrayListGroup arrayListGroup) {
        if (!"".equals(annotationValue)) {
            if ("{http://www.clarin.eu}displaypriority".equals(annotationName)) {
                arrayListGroup.displayNamePreferenceList.add(new String[]{nodePath, annotationValue});
            }
            if ("{http://www.clarin.eu}documentation".equals(annotationName)) {
                arrayListGroup.fieldUsageDescriptionList.add(new String[]{nodePath, annotationValue});
            }
            if ("{http://www.isocat.org/ns/dcr}datcat".equals(annotationName)) {
                arrayListGroup.dataCategoriesMap.put(nodePath, annotationValue);
            }
        }
    }

    private void readFieldConstrains(SchemaType schemaType, String nodePath, ArrayList<String[]> fieldConstraintList) {
        switch (schemaType.getBuiltinTypeCode()) {
            case 12: {
                break;
            }
            case 16: {
                fieldConstraintList.add(new String[]{nodePath, "([0-9][0-9][0-9][0-9])((-[0-1][0-9])(-[0-3][0-9])?)?"});
                break;
            }
            case 3: {
                fieldConstraintList.add(new String[]{nodePath, "true|false"});
                break;
            }
            case 6: {
                fieldConstraintList.add(new String[]{nodePath, "[^\\d]+://.*"});
                break;
            }
            case 0: {
                break;
            }
        }
    }

    private synchronized Document getSchemaDocument() {
        if (this.schemaDocument == null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                this.schemaDocument = documentBuilder.parse(this.templateFile);
            }
            catch (IOException ex) {
                bugCatcher.logError("Error while parsing schema", ex);
            }
            catch (ParserConfigurationException ex) {
                bugCatcher.logError("Error while parsing schema", ex);
            }
            catch (SAXException ex) {
                bugCatcher.logError("Error while parsing schema", ex);
            }
        }
        return this.schemaDocument;
    }

    private HashMap<String, String> getDescriptionsForVocabulary(String vocabularyName) throws TransformerException {
        Document schemaDoc = this.getSchemaDocument();
        if (schemaDoc == null) {
            return null;
        }
        NodeList enumNodes = XPathAPI.selectNodeList((Node)schemaDoc, (String)("//*[@name='" + vocabularyName + "']//xs:restriction/xs:enumeration"));
        HashMap<String, String> descriptions = new HashMap<String, String>(enumNodes.getLength());
        for (int i = 0; i < enumNodes.getLength(); ++i) {
            Node valueNode;
            NamedNodeMap attMap = enumNodes.item(i).getAttributes();
            Node labelNode = attMap.getNamedItem("ann:label");
            if (labelNode == null || (valueNode = attMap.getNamedItem("value")) == null) continue;
            descriptions.put(valueNode.getTextContent(), labelNode.getTextContent());
        }
        return descriptions;
    }

    private void readControlledVocabularies(SchemaType schemaType, String nodePath) {
        XmlAnySimpleType[] enumerationValues = schemaType.getEnumerationValues();
        if (enumerationValues != null && enumerationValues.length > 0) {
            ArbilVocabulary vocabulary = ArbilVocabularies.getSingleInstance().getEmptyVocabulary(this.nameSpaceString + "#" + schemaType.getName());
            HashMap<String, String> descriptions = null;
            try {
                descriptions = this.getDescriptionsForVocabulary(schemaType.getBaseType().getName().getLocalPart());
            }
            catch (Exception ex) {
                bugCatcher.logError(ex);
            }
            for (XmlAnySimpleType anySimpleType : schemaType.getEnumerationValues()) {
                String description;
                String entryCode = anySimpleType.getStringValue();
                String string = description = descriptions == null ? null : descriptions.get(entryCode);
                if (description == null || description.length() == 0) {
                    vocabulary.addEntry(entryCode, null);
                    continue;
                }
                vocabulary.addEntry(description, entryCode);
            }
            this.vocabularyHashTable.put(nodePath, vocabulary);
        }
    }

    @Override
    public String getHelpStringForField(String fieldName) {
        String fieldUsageString = this.getFieldUsageStringForField(fieldName = fieldName.replaceAll("\\([0-9]+\\)\\.", "."));
        if (fieldUsageString != null) {
            return fieldUsageString;
        }
        String datCat = this.dataCategoriesMap.get(fieldName);
        if (datCat != null) {
            return this.getDescriptionForDataCategory(datCat);
        }
        return "No usage description found in this template for: " + fieldName;
    }

    public synchronized void startLoadingDatacategoryDescriptions() {
        Runnable descriptionLoader = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                for (String dcUri : CmdiTemplate.this.dataCategoriesMap.values()) {
                    CmdiTemplate cmdiTemplate = CmdiTemplate.this;
                    synchronized (cmdiTemplate) {
                        try {
                            CmdiTemplate.this.getDescriptionForDataCategory(dcUri);
                            CmdiTemplate.this.wait(100L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        Thread descriptionLoaderThread = new Thread(descriptionLoader);
        descriptionLoaderThread.setPriority(1);
        descriptionLoaderThread.start();
    }

    private String getDescriptionForDataCategory(String dcUri) {
        if (this.dataCategoryDescriptionMap.containsKey(dcUri)) {
            return this.dataCategoryDescriptionMap.get(dcUri);
        }
        try {
            String description = this.readDescriptionForDataCategory(dcUri);
            if (description != null) {
                this.dataCategoryDescriptionMap.put(dcUri, description);
                return description;
            }
        }
        catch (ParserConfigurationException ex) {
            bugCatcher.logError(ex);
        }
        catch (SAXException ex) {
            bugCatcher.logError(ex);
        }
        catch (IOException ex) {
            bugCatcher.logError(ex);
        }
        return "Data category: <" + dcUri + ">. No description available. See error log for details.";
    }

    private String readDescriptionForDataCategory(String dcUri) throws ParserConfigurationException, SAXException, IOException {
        String datCatURI = dcUri.concat(DATCAT_URI_DESCRIPTION_POSTFIX);
        File datCatFile = sessionStorage.getFromCache(datCatURI, true);
        if (datCatFile == null) {
            bugCatcher.logError("File not found for data category URI " + dcUri, null);
            return null;
        }
        SAXParser parser = parserFactory.newSAXParser();
        DataCategoryDescriptionHandler handler = new DataCategoryDescriptionHandler();
        parser.parse(datCatFile, (DefaultHandler)handler);
        return handler.getDescription();
    }

    @Override
    public boolean pathIsEditableField(String nodePath) {
        String nodePathAsParent = nodePath + ".";
        String[] pathTokens = nodePath.split("\\.");
        if (ArbilComponentBuilder.pathIsAttribute(pathTokens)) {
            return CmdiTemplate.pathIsEditableAttribute(pathTokens) && !this.pathIsEditableField(nodePath.replaceAll("\\.[^.]*$", ""));
        }
        for (String[] pathString : this.childNodePaths) {
            if (ArbilComponentBuilder.pathIsAttribute(pathString[0]) || !pathString[0].startsWith(nodePathAsParent) && !pathString[0].equals(nodePath)) continue;
            return false;
        }
        for (String[] pathString : this.templatesArray) {
            if (ArbilComponentBuilder.pathIsAttribute(pathString[0]) || !pathString[0].startsWith(nodePathAsParent) || pathString[0].equals(nodePath)) continue;
            return false;
        }
        return true;
    }

    public static boolean pathIsEditableAttribute(String path) {
        return CmdiTemplate.pathIsEditableAttribute(path.split("\\."));
    }

    public static boolean pathIsEditableAttribute(String[] pathTokens) {
        if (pathTokens.length <= 3) {
            return false;
        }
        return !RESERVED_ATTRIBUTES.contains(pathTokens[pathTokens.length - 1].substring(1));
    }

    public boolean pathAllowsLanguageId(String path) {
        return this.allowsLanguageIdPathList.contains(path);
    }

    public static void main(String[] args) {
        new ArbilDesktopInjector().injectHandlers();
        CmdiTemplate template = new CmdiTemplate();
        template.loadTemplate("http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles/clarin.eu:cr1:p_1289827960126/xsd");
    }

    private static class ElementCardinality {
        public int maxOccurs;
        public boolean canHaveMultiple;

        private ElementCardinality() {
        }
    }

    private static class ArrayListGroup {
        public ArrayList<String[]> childNodePathsList = new ArrayList();
        public ArrayList<String[]> addableComponentPathsList = new ArrayList();
        public ArrayList<String[]> resourceNodePathsList = new ArrayList();
        public ArrayList<String[]> fieldConstraintList = new ArrayList();
        public ArrayList<String[]> displayNamePreferenceList = new ArrayList();
        public ArrayList<String[]> fieldUsageDescriptionList = new ArrayList();
        public Map<String, String> dataCategoriesMap = Collections.synchronizedMap(new HashMap());
        public HashSet<String> allowsLanguageIdPathsList = new HashSet();

        private ArrayListGroup() {
        }
    }
}

