/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.clarin.CmdiComponentLinkReader;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilJournal;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.FieldUpdateRequest;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.data.MetadataFormat;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.MimeHashQueue;
import nl.mpi.arbil.util.TreeHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilDataNodeService {
    private BugCatcher bugCatcher;
    private DataNodeLoader dataNodeLoader;
    private MessageDialogHandler messageDialogHandler;
    private SessionStorage sessionStorage;
    private MimeHashQueue mimeHashQueue;
    private TreeHelper treeHelper;

    public ArbilDataNodeService(BugCatcher bugCatcher, DataNodeLoader dataNodeLoader, MessageDialogHandler messageDialogHandler, SessionStorage sessionStorage, MimeHashQueue mimeHashQueue, TreeHelper treeHelper) {
        this.bugCatcher = bugCatcher;
        this.messageDialogHandler = messageDialogHandler;
        this.sessionStorage = sessionStorage;
        this.mimeHashQueue = mimeHashQueue;
        this.treeHelper = treeHelper;
        this.dataNodeLoader = dataNodeLoader;
    }

    public BugCatcher getBugCatcher() {
        return this.bugCatcher;
    }

    public boolean isEditable(ArbilDataNode dataNode) {
        if (dataNode.isLocal()) {
            return this.sessionStorage.pathIsInsideCache(dataNode.getFile()) || this.sessionStorage.pathIsInFavourites(dataNode.getFile());
        }
        return false;
    }

    public boolean isFavorite(ArbilDataNode dataNode) {
        if (!dataNode.isLocal()) {
            return false;
        }
        return this.sessionStorage.pathIsInFavourites(dataNode.getFile());
    }

    public void pasteIntoNode(ArbilDataNode dataNode) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transfer = clipboard.getContents(null);
        try {
            String clipBoardString = "";
            Object clipBoardData = transfer.getTransferData(DataFlavor.stringFlavor);
            if (clipBoardData != null) {
                clipBoardString = clipBoardData.toString();
                System.out.println("clipBoardString: " + clipBoardString);
                String[] elements = clipBoardString.contains("\n") ? clipBoardString.split("\n") : new String[]{clipBoardString};
                for (String element : elements) {
                }
                for (ArbilDataNode clipboardNode : this.pasteIntoNode(dataNode, elements)) {
                    new MetadataBuilder().requestAddNode(dataNode, "copy of " + clipboardNode, clipboardNode);
                }
            }
        }
        catch (Exception ex) {
            this.bugCatcher.logError(ex);
        }
    }

    private Collection<ArbilDataNode> pasteIntoNode(ArbilDataNode dataNode, String[] clipBoardStrings) {
        try {
            ArrayList<ArbilDataNode> nodesToAdd = new ArrayList<ArbilDataNode>();
            boolean ignoreSaveChanges = false;
            for (String clipBoardString : clipBoardStrings) {
                if (dataNode.isCorpus()) {
                    if (MetadataFormat.isPathMetadata(clipBoardString) || ArbilDataNode.isStringChildNode(clipBoardString)) {
                        ArbilDataNode clipboardNode = this.dataNodeLoader.getArbilDataNode(null, ArbilDataNodeService.conformStringToUrl(clipBoardString));
                        if (this.sessionStorage.pathIsInsideCache(clipboardNode.getFile())) {
                            if (!ArbilDataNode.isStringChildNode(clipBoardString) || dataNode.isSession() || dataNode.isChildNode()) {
                                if (dataNode.getFile().exists()) {
                                    if (!ignoreSaveChanges && clipboardNode.getNeedsSaveToDisk(false)) {
                                        if (2 == this.messageDialogHandler.showDialogBox("Some of the nodes to be copied contain unsaved changes.\nUnless they are saved, these changes will not be present in the resulting nodes. Continue anyway?", "Copying with unsaved changes", 2, -1)) {
                                            return new ArrayList<ArbilDataNode>(0);
                                        }
                                        ignoreSaveChanges = true;
                                    }
                                    nodesToAdd.add(clipboardNode);
                                    continue;
                                }
                                this.messageDialogHandler.addMessageDialogToQueue("The target node's file does not exist", null);
                                continue;
                            }
                            this.messageDialogHandler.addMessageDialogToQueue("Cannot paste session subnodes into a corpus", null);
                            continue;
                        }
                        this.messageDialogHandler.addMessageDialogToQueue("The target file is not in the cache", null);
                        continue;
                    }
                    this.messageDialogHandler.addMessageDialogToQueue("Pasted string is not and IMDI file", null);
                    continue;
                }
                if (dataNode.isMetaDataNode() || dataNode.isSession()) {
                    ArbilDataNode templateDataNode = this.dataNodeLoader.getArbilDataNode(null, ArbilDataNodeService.conformStringToUrl(clipBoardString));
                    if (MetadataReader.getSingleInstance().nodeCanExistInNode(dataNode, templateDataNode)) {
                        new MetadataBuilder().requestAddNode(dataNode, templateDataNode.toString(), templateDataNode);
                        continue;
                    }
                    this.messageDialogHandler.addMessageDialogToQueue("Cannot copy '" + templateDataNode.toString() + "' to '" + this.toString() + "'", "Cannot copy");
                    continue;
                }
                this.messageDialogHandler.addMessageDialogToQueue("Nodes of this type cannot be pasted into at this stage", null);
            }
            return nodesToAdd;
        }
        catch (URISyntaxException ex) {
            this.bugCatcher.logError(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCorpusLink(ArbilDataNode dataNode, ArbilDataNode targetNode) {
        boolean linkAlreadyExists = false;
        if (targetNode.isCatalogue() && dataNode.hasCatalogue()) {
            return false;
        }
        for (String[] currentLinkPair : dataNode.getChildLinks()) {
            String currentChildPath = currentLinkPair[0];
            if (!targetNode.waitTillLoaded()) {
                this.messageDialogHandler.addMessageDialogToQueue("Error adding node, could not wait for file to load", "Loading Error");
                return false;
            }
            if (!currentChildPath.equals(targetNode.getUrlString())) continue;
            linkAlreadyExists = true;
        }
        if (targetNode.getUrlString().equals(dataNode.getUrlString())) {
            this.messageDialogHandler.addMessageDialogToQueue("Cannot link or move a node into itself", null);
            return false;
        }
        if (linkAlreadyExists) {
            this.messageDialogHandler.addMessageDialogToQueue(targetNode + " already exists in " + this + " and will not be added again", null);
            return false;
        }
        if (dataNode.isNeedsSaveToDisk()) {
            dataNode.saveChangesToCache(true);
        }
        try {
            this.bumpHistory(dataNode);
            this.copyLastHistoryToCurrent(dataNode);
            Object object = dataNode.getParentDomLockObject();
            synchronized (object) {
                return dataNode.getMetadataUtils().addCorpusLink(dataNode.getURI(), new URI[]{targetNode.getURI()});
            }
        }
        catch (IOException iOException) {
            this.bugCatcher.logError("I/O exception while moving node " + targetNode.toString() + " to " + this.toString(), iOException);
            this.messageDialogHandler.addMessageDialogToQueue("Could not move nodes because an error occurred while saving history for node. See error log for details.", "Error while moving nodes");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCorpusLink(ArbilDataNode dataNode, ArbilDataNode[] targetImdiNodes) {
        if (dataNode.nodeNeedsSaveToDisk) {
            dataNode.saveChangesToCache(false);
        }
        try {
            dataNode.bumpHistory();
            this.copyLastHistoryToCurrent(dataNode);
            Object object = dataNode.getParentDomLockObject();
            synchronized (object) {
                System.out.println("deleting by corpus link");
                URI[] copusUriList = new URI[targetImdiNodes.length];
                for (int nodeCounter = 0; nodeCounter < targetImdiNodes.length; ++nodeCounter) {
                    copusUriList[nodeCounter] = targetImdiNodes[nodeCounter].getURI();
                }
                dataNode.getMetadataUtils().removeCorpusLink(dataNode.getURI(), copusUriList);
                dataNode.getParentDomNode().loadArbilDom();
            }
            for (ArbilDataNode removedChild : targetImdiNodes) {
                removedChild.removeFromAllContainers();
            }
        }
        catch (IOException ex) {
            this.bugCatcher.logError("I/O exception while deleting nodes from " + this.toString(), ex);
            this.messageDialogHandler.addMessageDialogToQueue("Could not delete nodes because an error occurred while saving history for node. See error log for details.", "Error while moving nodes");
        }
        dataNode.getParentDomNode().clearIcon();
        dataNode.getParentDomNode().clearChildIcons();
        dataNode.clearIcon();
    }

    public void insertResourceLocation(ArbilDataNode dataNode, URI location) throws ArbilMetadataException {
        if (dataNode.isCmdiMetaDataNode()) {
            ArbilDataNode resourceNode = null;
            try {
                resourceNode = this.dataNodeLoader.getArbilDataNodeWithoutLoading(location);
            }
            catch (Exception ex) {
                throw new ArbilMetadataException("Error creating resource node for URI: " + location.toString(), ex);
            }
            if (resourceNode == null) {
                throw new ArbilMetadataException("Unknown error creating resource node for URI: " + location.toString());
            }
            new MetadataBuilder().requestAddNode(dataNode, null, resourceNode);
        } else if (dataNode.hasResource()) {
            dataNode.resourceUrlField.setFieldValue(location.toString(), true, false);
        }
    }

    public void addField(ArbilDataNode dataNode, ArbilField fieldToAdd) {
        ArbilField[] currentFieldsArray = dataNode.getFieldArray(fieldToAdd.getTranslateFieldName());
        if (currentFieldsArray == null) {
            currentFieldsArray = new ArbilField[]{fieldToAdd};
        } else {
            ArbilField[] appendedFieldsArray = new ArbilField[currentFieldsArray.length + 1];
            System.arraycopy(currentFieldsArray, 0, appendedFieldsArray, 0, currentFieldsArray.length);
            appendedFieldsArray[appendedFieldsArray.length - 1] = fieldToAdd;
            currentFieldsArray = appendedFieldsArray;
        }
        dataNode.addFieldArray(fieldToAdd.getTranslateFieldName(), currentFieldsArray);
        if (fieldToAdd.xmlPath.endsWith(".ResourceLink") && fieldToAdd.getParentDataNode().isChildNode()) {
            dataNode.resourceUrlField = fieldToAdd;
            this.mimeHashQueue.addToQueue(dataNode);
        }
    }

    public synchronized void saveChangesToCache(ArbilDataNode datanode) {
        if (datanode != datanode.getParentDomNode()) {
            this.saveChangesToCache(datanode.getParentDomNode());
            return;
        }
        System.out.println("saveChangesToCache");
        ArbilJournal.getSingleInstance().clearFieldChangeHistory();
        if (!datanode.isLocal()) {
            System.out.println("should not try to save remote files");
            return;
        }
        ArrayList<FieldUpdateRequest> fieldUpdateRequests = new ArrayList<FieldUpdateRequest>();
        Vector<ArbilField[]> allFields = new Vector<ArbilField[]>();
        datanode.getAllFields(allFields);
        Enumeration<ArbilField[]> fieldsEnum = allFields.elements();
        while (fieldsEnum.hasMoreElements()) {
            ArbilField[] currentFieldArray = fieldsEnum.nextElement();
            for (int fieldCounter = 0; fieldCounter < currentFieldArray.length; ++fieldCounter) {
                ArbilField currentField = currentFieldArray[fieldCounter];
                if (!currentField.fieldNeedsSaveToDisk()) continue;
                FieldUpdateRequest currentFieldUpdateRequest = new FieldUpdateRequest();
                currentFieldUpdateRequest.keyNameValue = currentField.getKeyName();
                currentFieldUpdateRequest.fieldOldValue = currentField.originalFieldValue;
                currentFieldUpdateRequest.fieldNewValue = currentField.getFieldValueForXml();
                currentFieldUpdateRequest.fieldPath = currentField.getFullXmlPath();
                currentFieldUpdateRequest.fieldLanguageId = currentField.getLanguageId();
                currentFieldUpdateRequest.attributeValuesMap = currentField.getAttributeValuesMap();
                fieldUpdateRequests.add(currentFieldUpdateRequest);
            }
        }
        ArbilComponentBuilder componentBuilder = new ArbilComponentBuilder();
        boolean result = componentBuilder.setFieldValues(datanode, fieldUpdateRequests.toArray(new FieldUpdateRequest[0]));
        if (!result) {
            this.messageDialogHandler.addMessageDialogToQueue("Error saving changes to disk, check the log file via the help menu for more information.", "Save");
        } else {
            datanode.nodeNeedsSaveToDisk = false;
        }
    }

    public void setDataNodeNeedsSaveToDisk(ArbilDataNode dataNode, ArbilField originatingField, boolean updateUI) {
        boolean needsSaveToDisk;
        if (dataNode.resourceUrlField != null && dataNode.resourceUrlField.equals(originatingField)) {
            dataNode.hashString = null;
            dataNode.mpiMimeType = null;
            dataNode.thumbnailFile = null;
            dataNode.typeCheckerMessage = null;
            this.mimeHashQueue.addToQueue(dataNode);
        }
        boolean bl = needsSaveToDisk = dataNode.hasChangedFields() || dataNode.hasDomIdAttribute;
        if (dataNode.isMetaDataNode() && !dataNode.isChildNode()) {
            if (!needsSaveToDisk) {
                for (ArbilDataNode childNode : dataNode.getAllChildren()) {
                    if (!childNode.nodeNeedsSaveToDisk) continue;
                    needsSaveToDisk = true;
                }
            }
            if (dataNode.nodeNeedsSaveToDisk != needsSaveToDisk) {
                if (needsSaveToDisk) {
                    this.dataNodeLoader.addNodeNeedingSave(dataNode);
                } else {
                    this.dataNodeLoader.removeNodesNeedingSave(dataNode);
                }
                dataNode.nodeNeedsSaveToDisk = needsSaveToDisk;
            }
        } else {
            dataNode.nodeNeedsSaveToDisk = needsSaveToDisk;
            this.setDataNodeNeedsSaveToDisk(dataNode.getParentDomNode(), null, updateUI);
        }
        if (updateUI) {
            dataNode.clearIcon();
        }
    }

    public void bumpHistory(ArbilDataNode dataNode) throws IOException {
        int versionCounter = 0;
        File headVersion = dataNode.getFile();
        if (new File(dataNode.getFile().getAbsolutePath() + ".x").exists()) {
            ++versionCounter;
            headVersion = new File(dataNode.getFile().getAbsolutePath() + ".x");
        }
        while (new File(dataNode.getFile().getAbsolutePath() + "." + versionCounter).exists()) {
            ++versionCounter;
        }
        while (versionCounter >= 0) {
            File lastFile = new File(dataNode.getFile().getAbsolutePath() + "." + versionCounter);
            File nextFile = new File(dataNode.getFile().getAbsolutePath() + "." + --versionCounter);
            if (versionCounter >= 0) {
                System.out.println("renaming: " + nextFile + " : " + lastFile);
                if (nextFile.renameTo(lastFile)) continue;
                throw new IOException("Error while copying history files for metadata. Could not rename " + nextFile.toString() + " to " + lastFile.toString());
            }
            System.out.println("renaming: " + headVersion + " : " + lastFile);
            if (headVersion.renameTo(lastFile)) continue;
            throw new IOException("Error while copying history files for metadata. Could not rename " + nextFile.toString() + " to " + lastFile.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resurrectHistory(ArbilDataNode dataNode, String historyVersion) {
        block42: {
            InputStream historyFile = null;
            OutputStream activeVersionFile = null;
            try {
                int len;
                if (historyVersion.equals(".x")) {
                    if (dataNode.getFile().delete()) {
                        if (!new File(dataNode.getFile().getAbsolutePath() + ".x").renameTo(dataNode.getFile())) {
                            throw new IOException("Could not rename history file '" + dataNode.getFile().getAbsolutePath() + ".x'");
                        }
                        break block42;
                    }
                    throw new IOException("Could not delete old history file: " + dataNode.getFile().getAbsolutePath());
                }
                try {
                    this.messageDialogHandler.offerUserToSaveChanges();
                }
                catch (Exception e) {
                    boolean bl = false;
                    if (null != historyFile) {
                        try {
                            historyFile.close();
                        }
                        catch (IOException ex) {
                            this.bugCatcher.logError(ex);
                        }
                    }
                    if (null != activeVersionFile) {
                        try {
                            activeVersionFile.close();
                        }
                        catch (IOException ex) {
                            this.bugCatcher.logError(ex);
                        }
                    }
                    return bl;
                }
                if (!new File(dataNode.getFile().getAbsolutePath() + ".x").exists()) {
                    if (!dataNode.getFile().renameTo(new File(dataNode.getFile().getAbsolutePath() + ".x"))) {
                        throw new IOException("Could not rename to history file: " + dataNode.getFile().getAbsolutePath());
                    }
                } else if (!dataNode.getFile().delete()) {
                    throw new IOException("Could not delete history file: " + dataNode.getFile().getAbsolutePath());
                }
                historyFile = new FileInputStream(new File(dataNode.getFile().getAbsolutePath() + historyVersion));
                activeVersionFile = new FileOutputStream(dataNode.getFile(), true);
                byte[] copyBuffer = new byte[1024];
                while ((len = historyFile.read(copyBuffer)) > 0) {
                    activeVersionFile.write(copyBuffer, 0, len);
                }
            }
            catch (FileNotFoundException e) {
                this.messageDialogHandler.addMessageDialogToQueue(e.getLocalizedMessage() + ". History may be broken for " + this.toString(), "File not found");
                this.bugCatcher.logError(e);
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                this.messageDialogHandler.addMessageDialogToQueue(e.getLocalizedMessage() + ". History may be broken for " + this.toString(), "Error while reading or writing to disk");
                this.bugCatcher.logError(e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (null != historyFile) {
                    try {
                        historyFile.close();
                    }
                    catch (IOException ex) {
                        this.bugCatcher.logError(ex);
                    }
                }
                if (null != activeVersionFile) {
                    try {
                        activeVersionFile.close();
                    }
                    catch (IOException ex) {
                        this.bugCatcher.logError(ex);
                    }
                }
            }
        }
        this.dataNodeLoader.requestReload(dataNode.getParentDomNode());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyLastHistoryToCurrent(ArbilDataNode dataNode) {
        FileOutputStream outFile = null;
        InputStream inputStream = null;
        try {
            outFile = new FileOutputStream(dataNode.getFile());
            inputStream = new FileInputStream(new File(dataNode.getFile().getAbsolutePath() + ".0"));
            int bufferLength = 4096;
            byte[] buffer = new byte[bufferLength];
            int bytesread = 0;
            while (bytesread >= 0) {
                bytesread = inputStream.read(buffer);
                if (bytesread == -1) {
                    break;
                }
                outFile.write(buffer, 0, bytesread);
            }
        }
        catch (IOException iOException) {
            this.messageDialogHandler.addMessageDialogToQueue("Could not copy file when recovering from the last history file.", "Recover History");
            this.bugCatcher.logError(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    this.bugCatcher.logError(ex);
                }
            }
            if (outFile != null) {
                try {
                    outFile.close();
                }
                catch (IOException ex) {
                    this.bugCatcher.logError(ex);
                }
            }
        }
    }

    public ArbilDataNode loadArbilDataNode(Object registeringObject, URI localUri) {
        return this.dataNodeLoader.getArbilDataNode(registeringObject, localUri);
    }

    public void reloadNode(ArbilDataNode dataNode) {
        dataNode.getParentDomNode().nodeNeedsSaveToDisk = false;
        this.dataNodeLoader.requestReload(dataNode.getParentDomNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadArbilDom(ArbilDataNode dataNode) {
        if (dataNode.getParentDomNode() != dataNode) {
            dataNode.getParentDomNode().loadArbilDom();
        } else {
            Object object = dataNode.getParentDomLockObject();
            synchronized (object) {
                dataNode.initNodeVariables();
                if (!dataNode.isMetaDataNode() && !dataNode.isDirectory() && dataNode.isLocal()) {
                    this.mimeHashQueue.addToQueue(dataNode);
                    dataNode.setDataLoaded(true);
                }
                if (dataNode.isDirectory()) {
                    this.getDirectoryLinks(dataNode);
                    dataNode.setDataLoaded(true);
                }
                if (dataNode.isMetaDataNode()) {
                    this.loadMetadataDom(dataNode);
                    dataNode.setDataLoaded(true);
                }
            }
        }
    }

    public String urlEncodePath(String inputPath) {
        String encodedString = null;
        try {
            for (String inputStringPart : inputPath.split("/")) {
                encodedString = encodedString == null ? URLEncoder.encode(inputStringPart, "UTF-8") : encodedString + "/" + URLEncoder.encode(inputStringPart, "UTF-8");
            }
        }
        catch (Exception ex) {
            this.bugCatcher.logError(ex);
        }
        return encodedString;
    }

    public static URI conformStringToUrl(String inputUrlString) throws URISyntaxException {
        if (!(inputUrlString.toLowerCase().startsWith("http") || inputUrlString.toLowerCase().startsWith("file:") || inputUrlString.toLowerCase().startsWith("."))) {
            return new File(inputUrlString).toURI();
        }
        int protocolEndIndex = inputUrlString.startsWith(".") ? 0 : inputUrlString.indexOf(":/");
        String protocolComponent = inputUrlString.substring(0, protocolEndIndex);
        String remainingComponents = inputUrlString.substring(protocolEndIndex + 1);
        String[] pathComponentArray = remainingComponents.split("#");
        String pathComponent = pathComponentArray[0];
        String fragmentComponent = null;
        if (pathComponentArray.length > 1) {
            fragmentComponent = pathComponentArray[1];
        }
        return new URI(protocolComponent, pathComponent, fragmentComponent);
    }

    public static URI normaliseURI(URI inputURI) {
        boolean isUncPath = inputURI.toString().toLowerCase().startsWith("file:////");
        URI returnURI = inputURI.normalize();
        if (isUncPath) {
            try {
                returnURI = new URI("file:////" + returnURI.toString().substring("file:/".length()));
            }
            catch (URISyntaxException urise) {
                System.err.println(urise.toString());
            }
        }
        return returnURI;
    }

    private void loadMetadataDom(ArbilDataNode dataNode) {
        if (dataNode.isLocal() && !dataNode.getFile().exists() && new File(dataNode.getFile().getAbsolutePath() + ".0").exists()) {
            this.copyLastHistoryToCurrent(dataNode);
            this.messageDialogHandler.addMessageDialogToQueue("Missing file has been recovered from the last history item.", "Recover History");
        }
        try {
            dataNode.nodeText = "unknown";
            this.initComponentLinkReader(dataNode);
            this.updateMetadataChildNodes(dataNode);
        }
        catch (Exception mue) {
            this.bugCatcher.logError(dataNode.getUrlString(), mue);
            File nodeFile = dataNode.getFile();
            if (nodeFile != null && nodeFile.exists()) {
                dataNode.nodeText = "Could not load data";
            }
            dataNode.nodeText = "File not found";
            dataNode.fileNotFound = true;
        }
    }

    private void initComponentLinkReader(ArbilDataNode dataNode) {
        if (dataNode.isCmdiMetaDataNode()) {
            dataNode.cmdiComponentLinkReader = new CmdiComponentLinkReader();
            dataNode.cmdiComponentLinkReader.readLinks(dataNode.getURI());
        } else {
            dataNode.cmdiComponentLinkReader = null;
        }
    }

    private void updateMetadataChildNodes(ArbilDataNode dataNode) throws ParserConfigurationException, SAXException, IOException, TransformerException, ArbilMetadataException {
        Document nodDom = ArbilComponentBuilder.getDocument(dataNode.getURI());
        Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree = new Hashtable<ArbilDataNode, HashSet<ArbilDataNode>>();
        dataNode.childLinks = this.loadMetadataChildNodes(dataNode, nodDom, parentChildTree);
        this.checkRemovedChildNodes(parentChildTree);
    }

    private String[][] loadMetadataChildNodes(ArbilDataNode dataNode, Document nodDom, Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree) throws TransformerException, ArbilMetadataException {
        Vector<String[]> childLinks = new Vector<String[]>();
        Hashtable<String, Integer> siblingNodePathCounter = new Hashtable<String, Integer>();
        String fullNodePath = "";
        Node startNode = nodDom.getFirstChild();
        MetadataReader.getSingleInstance().iterateChildNodes(dataNode, childLinks, startNode, fullNodePath, fullNodePath, parentChildTree, siblingNodePathCounter, 0);
        if (dataNode.isCmdiMetaDataNode()) {
            MetadataReader.getSingleInstance().addUnreferencedResources(dataNode, parentChildTree, childLinks);
        }
        return (String[][])childLinks.toArray((T[])new String[0][]);
    }

    private void checkRemovedChildNodes(Hashtable<ArbilDataNode, HashSet<ArbilDataNode>> parentChildTree) {
        for (Map.Entry<ArbilDataNode, HashSet<ArbilDataNode>> entry : parentChildTree.entrySet()) {
            ArbilDataNode currentNode = entry.getKey();
            ArbilDataNode[] oldChildArray = currentNode.childArray;
            currentNode.childArray = parentChildTree.get(currentNode).toArray(new ArbilDataNode[0]);
            List<ArbilDataNode> currentChildList = Arrays.asList(currentNode.childArray);
            for (ArbilDataNode currentOldChild : oldChildArray) {
                if (currentChildList.indexOf(currentOldChild) != -1) continue;
                for (ArbilDataNodeContainer currentContainer : currentOldChild.getRegisteredContainers()) {
                    currentContainer.dataNodeRemoved(currentOldChild);
                }
            }
        }
    }

    private void getDirectoryLinks(ArbilDataNode dataNode) {
        File[] dirLinkArray = null;
        File nodeFile = dataNode.getFile();
        if (nodeFile != null && nodeFile.isDirectory()) {
            dirLinkArray = nodeFile.listFiles();
            Vector<ArbilDataNode> childLinksTemp = new Vector<ArbilDataNode>();
            for (int linkCount = 0; linkCount < dirLinkArray.length; ++linkCount) {
                try {
                    URI childURI = dirLinkArray[linkCount].toURI();
                    ArbilDataNode currentNode = this.dataNodeLoader.getArbilDataNodeWithoutLoading(childURI);
                    if (!this.treeHelper.isShowHiddenFilesInTree() && currentNode.getFile().isHidden()) continue;
                    childLinksTemp.add(currentNode);
                    continue;
                }
                catch (Exception ex) {
                    this.messageDialogHandler.addMessageDialogToQueue(dirLinkArray[linkCount] + " could not be loaded in\n" + dataNode.getUrlString(), "Load Directory");
                    this.bugCatcher.logError(ex);
                }
            }
            dataNode.childArray = childLinksTemp.toArray(new ArbilDataNode[0]);
        }
    }
}

