/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data.importexport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.MessageDialogHandler;

public class ArbilToHtmlConverter {
    private static MessageDialogHandler messageDialogHandler;
    private static BugCatcher bugCatcher;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public URI exportImdiToHtml(ArbilDataNode[] inputNodeArray) {
        File destinationDirectory = messageDialogHandler.showEmptyExportDirectoryDialogue("Export HTML");
        if (destinationDirectory == null) {
            return null;
        }
        this.copyDependancies(destinationDirectory, false);
        for (ArbilDataNode currentNode : inputNodeArray) {
            File destinationFile = new File(destinationDirectory, currentNode.toString() + ".html");
            int fileCounter = 1;
            while (destinationFile.exists()) {
                destinationFile = new File(destinationDirectory, currentNode.toString() + "(" + fileCounter + ").html");
            }
            try {
                this.transformNodeToHtml(currentNode, destinationFile);
            }
            catch (Exception exception) {
                messageDialogHandler.addMessageDialogToQueue("Cannot convert data", "HTML Export");
                bugCatcher.logError(exception);
            }
        }
        return destinationDirectory.toURI();
    }

    public File convertToHtml(ArbilDataNode inputNode) throws IOException, TransformerException {
        File tempHtmlFile = File.createTempFile("tmp", ".html");
        tempHtmlFile.deleteOnExit();
        this.copyDependancies(tempHtmlFile.getParentFile(), true);
        this.transformNodeToHtml(inputNode, tempHtmlFile);
        return tempHtmlFile;
    }

    private void transformNodeToHtml(ArbilDataNode inputNode, File destinationFile) throws IOException, TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        URL xslUrl = this.getClass().getResource("/nl/mpi/arbil/resources/xsl/imdi-viewer.xsl");
        File xslFile = null;
        xslFile = new File(inputNode.getNodeTemplate().getTemplateDirectory(), "format.xsl");
        if (xslFile != null && xslFile.exists()) {
            xslUrl = xslFile.toURL();
        }
        Transformer transformer = tFactory.newTransformer(new StreamSource(xslUrl.toString()));
        transformer.transform(new StreamSource(inputNode.getURI().toString()), new StreamResult(new FileOutputStream(destinationFile.getCanonicalPath())));
    }

    private void copyDependancies(File destinationDirectory, boolean deleteOnExit) {
        String[] dependentFiles;
        for (String dependantFileString : dependentFiles = new String[]{"imdi-viewer-open.gif", "imdi-viewer-closed.gif", "imdi-viewer.js", "imdi-viewer.css"}) {
            File tempDependantFile = new File(destinationDirectory, dependantFileString);
            if (deleteOnExit) {
                tempDependantFile.deleteOnExit();
            }
            try {
                FileOutputStream outFile = new FileOutputStream(tempDependantFile);
                InputStream inputStream = this.getClass().getResourceAsStream("/nl/mpi/arbil/resources/xsl/" + dependantFileString);
                if (inputStream == null) {
                    bugCatcher.logError(new Exception("Missing file in jar: " + dependantFileString));
                } else {
                    int bufferLength = 4096;
                    byte[] buffer = new byte[bufferLength];
                    int bytesread = 0;
                    while (bytesread >= 0 && (bytesread = inputStream.read(buffer)) != -1) {
                        outFile.write(buffer, 0, bytesread);
                    }
                    inputStream.close();
                }
                outFile.close();
            }
            catch (IOException iOException) {
                messageDialogHandler.addMessageDialogToQueue("Cannot copy requisite file", "HTML Export");
                bugCatcher.logError(iOException);
            }
        }
    }
}

