/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.templates;

import java.io.File;
import java.net.URI;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;

public class ArbilFavourites {
    private static MessageDialogHandler messageDialogHandler;
    private static BugCatcher bugCatcher;
    private static SessionStorage sessionStorage;
    private static TreeHelper treeHelper;
    private static ArbilFavourites singleInstance;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setTreeHelper(TreeHelper treeHelperInstance) {
        treeHelper = treeHelperInstance;
    }

    public static synchronized ArbilFavourites getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilFavourites();
        }
        return singleInstance;
    }

    public void convertOldFormatLocationListsX() {
        try {
            File oldLocationsFile = new File(sessionStorage.getStorageDirectory(), "locationsList");
            File oldFavouritesFile = new File(sessionStorage.getStorageDirectory(), "selectedFavourites");
            if (oldLocationsFile.exists()) {
                Vector locationsList = (Vector)sessionStorage.loadObject("locationsList");
                if (oldFavouritesFile.exists()) {
                    Vector userFavouritesStrings = (Vector)sessionStorage.loadObject("selectedFavourites");
                    locationsList.addAll(userFavouritesStrings);
                    sessionStorage.saveStringArray("locationsList", locationsList.toArray(new String[0]));
                    oldFavouritesFile.deleteOnExit();
                }
                if (null == sessionStorage.loadStringArray("locationsList")) {
                    sessionStorage.saveStringArray("locationsList", locationsList.toArray(new String[0]));
                }
            }
        }
        catch (Exception ex) {
            bugCatcher.logError(ex);
        }
    }

    public boolean toggleFavouritesList(ArbilDataNode[] dataNodeArray, boolean setAsTempate) {
        System.out.println("toggleFavouriteList: " + setAsTempate);
        if (setAsTempate) {
            boolean selectionNeedsSave = false;
            for (ArbilDataNode currentNode : dataNodeArray) {
                if (!currentNode.getNeedsSaveToDisk(false)) continue;
                selectionNeedsSave = true;
            }
            if (selectionNeedsSave) {
                messageDialogHandler.addMessageDialogToQueue("Changes must be saved before adding to the favourites.", "Add Favourites");
                return false;
            }
        }
        for (ArbilDataNode currentNode : dataNodeArray) {
            if (setAsTempate && currentNode.isContainerNode()) {
                if (currentNode.getChildArray().length <= 0) continue;
                this.toggleFavouritesList(currentNode.getChildArray(), true);
                continue;
            }
            if (setAsTempate) {
                this.addAsFavourite(currentNode.getURI());
                continue;
            }
            this.removeFromFavourites(currentNode.getURI());
        }
        return true;
    }

    private void addAsFavourite(URI imdiUri) {
        try {
            URI baseUri = new URI(imdiUri.toString().split("#")[0]);
            String fileSuffix = imdiUri.getPath().substring(imdiUri.getPath().lastIndexOf("."));
            File destinationFile = File.createTempFile("fav-", fileSuffix, sessionStorage.getFavouritesDir());
            ArbilDataNode.getMetadataUtils(baseUri.toString()).copyMetadataFile(baseUri, destinationFile, null, true);
            URI copiedFileURI = destinationFile.toURI();
            String uriString = copiedFileURI.toString().split("#")[0];
            if (imdiUri.getFragment() != null) {
                uriString = uriString + "#" + imdiUri.getFragment();
            }
            URI favouriteUri = new URI(uriString);
            treeHelper.addLocation(favouriteUri);
            treeHelper.applyRootLocations();
        }
        catch (Exception ex) {
            bugCatcher.logError(ex);
        }
    }

    private void removeFromFavourites(URI imdiUri) {
        treeHelper.removeLocation(imdiUri);
        treeHelper.applyRootLocations();
    }

    public Enumeration listFavouritesFor(Object targetNodeUserObject) {
        System.out.println("listFavouritesFor: " + targetNodeUserObject);
        Vector<String[]> validFavourites = new Vector<String[]>();
        if (targetNodeUserObject instanceof ArbilNode) {
            boolean targetIsLocalCorpusRoot;
            ArbilDataNode targetDataNode = null;
            boolean targetIsDataNode = targetNodeUserObject instanceof ArbilDataNode;
            if (targetIsDataNode) {
                targetDataNode = (ArbilDataNode)targetNodeUserObject;
                targetIsLocalCorpusRoot = false;
            } else {
                targetIsLocalCorpusRoot = targetNodeUserObject == ((DefaultMutableTreeNode)treeHelper.getLocalCorpusTreeModel().getRoot()).getUserObject();
            }
            boolean targetIsCorpus = targetIsDataNode && targetDataNode.isCorpus();
            boolean targetIsSession = targetIsDataNode && targetDataNode.isSession();
            boolean targetIsChildNode = targetIsDataNode && targetDataNode.isChildNode();
            for (ArbilDataNode currentFavouritesObject : treeHelper.getFavouriteNodes()) {
                boolean addThisFavourites = false;
                if (targetIsLocalCorpusRoot) {
                    addThisFavourites = !currentFavouritesObject.isChildNode();
                } else if (targetIsCorpus && !currentFavouritesObject.isChildNode()) {
                    addThisFavourites = true;
                } else if (targetIsSession && currentFavouritesObject.isChildNode()) {
                    addThisFavourites = MetadataReader.getSingleInstance().nodeCanExistInNode(targetDataNode, currentFavouritesObject);
                } else if (targetIsChildNode && currentFavouritesObject.isChildNode()) {
                    addThisFavourites = MetadataReader.getSingleInstance().nodeCanExistInNode(targetDataNode, currentFavouritesObject);
                }
                if (!addThisFavourites) continue;
                validFavourites.add(new String[]{currentFavouritesObject.toString(), currentFavouritesObject.getUrlString()});
            }
        }
        return validFavourites.elements();
    }

    public String getNodeType(ArbilDataNode favouriteNode, ArbilDataNode targetDataNode) {
        String returnValue;
        String favouriteXmlPath = favouriteNode.getURI().getFragment();
        String targetXmlPath = targetDataNode.getURI().getFragment();
        System.out.println("getNodeType: \nfavouriteXmlPath: " + favouriteXmlPath + "\ntargetXmlPath:" + targetXmlPath);
        if (favouriteNode.isSession()) {
            returnValue = ".METATRANSCRIPT.Session";
        } else if (favouriteNode.isCorpus()) {
            returnValue = ".METATRANSCRIPT.Corpus";
        } else if (favouriteNode.isChildNode()) {
            if (targetXmlPath == null) {
                returnValue = favouriteXmlPath.replaceAll("\\(\\d*?\\)$", "");
            } else {
                System.out.println("targetXmlPath: " + targetXmlPath);
                System.out.println("favouriteXmlPath: " + favouriteXmlPath);
                favouriteXmlPath = favouriteXmlPath.replaceAll("\\(\\d*?\\)$", "");
                String[] splitFavouriteXmlPath = favouriteXmlPath.split("\\)");
                String[] splitTargetXmlPath = targetXmlPath.split("\\)");
                System.out.println("splitFavouriteXmlPath: " + splitFavouriteXmlPath.length + " splitTargetXmlPath: " + splitTargetXmlPath.length);
                returnValue = "";
                for (int partCounter = 0; partCounter < splitFavouriteXmlPath.length; ++partCounter) {
                    returnValue = splitTargetXmlPath.length > partCounter ? returnValue.concat(splitTargetXmlPath[partCounter] + ")") : returnValue.concat(splitFavouriteXmlPath[partCounter] + ")");
                }
                returnValue = returnValue.replaceAll("\\)$", "");
                returnValue = returnValue.replaceAll("\\(\\d*?$", "");
            }
        } else {
            returnValue = null;
        }
        System.out.println("getNodeTypeReturnValue: " + returnValue);
        return returnValue;
    }

    static {
        singleInstance = null;
    }
}

