/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ArbilTableCell;
import nl.mpi.arbil.ui.AbstractArbilTableModel;
import nl.mpi.arbil.ui.ArbilFieldView;
import nl.mpi.arbil.ui.ArbilFieldViews;
import nl.mpi.arbil.ui.ArbilListDataListener;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilTableCellRenderer;
import nl.mpi.arbil.ui.ImageBoxRenderer;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilActionBuffer;
import nl.mpi.arbil.util.MessageDialogHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilTableModel
extends AbstractArbilTableModel
implements ClipboardOwner {
    public static final char CSV_NEWLINE = '\n';
    public static final String CSV_SEPARATOR = "\t";
    public static final String CSV_DOUBLE_QUOTE = "\"\"";
    public static final char CSV_QUOTE = '\"';
    public static final String CSV_QUOTE_STRING = "\"";
    private Hashtable<String, ArbilDataNode> dataNodeHash = new Hashtable();
    private ArbilTableCell[][] data = new ArbilTableCell[0][0];
    private DefaultListModel listModel = new DefaultListModel();
    private boolean widthsChanged = true;
    private JLabel hiddenColumnsLabel;
    public boolean hideContextMenuAndStatusBar;
    protected static MessageDialogHandler messageDialogHandler;
    private static ApplicationVersionManager versionManager;
    private ArbilActionBuffer reloadRunner = new ArbilActionBuffer("TableReload-" + this.hashCode(), 50){

        public void executeAction() {
            ArbilTableModel.this.reloadTableDataPrivate();
        }
    };

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setVersionManager(ApplicationVersionManager versionManagerInstance) {
        versionManager = versionManagerInstance;
    }

    public ArbilTableModel() {
        super(ArbilFieldViews.getSingleInstance().getCurrentGlobalView().clone());
    }

    public ArbilTableModel(ArbilFieldView tableFieldView) {
        super(tableFieldView);
    }

    public DefaultListModel getListModel(ArbilSplitPanel arbilSplitPanel) {
        ArbilListDataListener listDataListener = new ArbilListDataListener(arbilSplitPanel);
        this.listModel.addListDataListener(listDataListener);
        return this.listModel;
    }

    private void updateImageDisplayPanel() {
        this.listModel.removeAllElements();
        ImageBoxRenderer tempImageBoxRenderer = new ImageBoxRenderer();
        for (int rowCounter = 0; rowCounter < this.data.length; ++rowCounter) {
            ArbilDataNode currentRowDataNode = this.getDataNodeFromRow(rowCounter);
            if (currentRowDataNode == null || !tempImageBoxRenderer.canDisplay(currentRowDataNode) || this.listModel.contains(currentRowDataNode)) continue;
            this.listModel.addElement(currentRowDataNode);
        }
    }

    public void setHiddenColumnsLabel(JLabel hiddenColumnsLabelLocal) {
        this.hiddenColumnsLabel = hiddenColumnsLabelLocal;
    }

    @Override
    protected void updateHiddenColumnsLabel(int hiddenColumnCount) {
        if (this.hiddenColumnsLabel != null) {
            this.hiddenColumnsLabel.setVisible(!this.hideContextMenuAndStatusBar && hiddenColumnCount > 0);
            this.hiddenColumnsLabel.setText(hiddenColumnCount + " columns hidden (edit \"Column View\" in the table header to show)");
        }
    }

    private String joinArray(Object[] arrayToJoin) {
        StringBuilder joinedString = new StringBuilder();
        boolean first = true;
        for (Object currentArrayItem : arrayToJoin) {
            if (!first) {
                joinedString.append(',');
            }
            first = false;
            joinedString.append(currentArrayItem.toString());
        }
        return joinedString.toString();
    }

    public void copyHtmlEmbedTagToClipboard(int tableHeight, int tableWidth) {
        try {
            ApplicationVersion appVersion = versionManager.getApplicationVersion();
            String embedTagString = "<APPLET CODEBASE=\"http://www.mpi.nl/tg/j2se/jnlp/arbil/\" CODE=\"nl.mpi.arbil.ArbilTableApplet.class\" ARCHIVE=\"arbil-" + appVersion.currentMajor + "-" + appVersion.currentMinor + "-" + appVersion.currentRevision + ".jar,lib/corpusstructure-1.6.1.jar,lib/imdiapi-1.0.6.jar,lib/log4j-1.2.14.jar,lib/saxon8.jar,lib/saxon8-dom.jar,lib/typecheck-1.5.16185.jar,lib/xalan-2.6.0.jar,lib/xercesImpl-2.9.0.jar\"";
            embedTagString = embedTagString + " WIDTH=" + tableWidth + " HEIGHT=" + tableHeight + " >\n";
            embedTagString = embedTagString + "  <PARAM NAME=\"ImdiFileList\" VALUE=\"" + this.joinArray(this.getArbilDataNodesURLs()) + "\">\n";
            embedTagString = embedTagString + "  <PARAM NAME=\"ShowOnlyColumns\" VALUE=\"" + this.joinArray(this.getColumnNames()) + "\">\n";
            embedTagString = embedTagString + "  <PARAM NAME=\"ChildNodeColumns\" VALUE=\"" + this.joinArray(this.getChildColumnNames().toArray()) + "\">\n";
            embedTagString = embedTagString + "  <PARAM NAME=\"HighlightText\" VALUE=\"" + this.joinArray(this.getHighlightCells().toArray()) + "\">\n";
            embedTagString = embedTagString + "</APPLET>";
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(embedTagString);
            clipboard.setContents(stringSelection, this);
        }
        catch (Exception ex) {
            ArbilTableModel.getBugCatcher().logError(ex);
        }
    }

    @Override
    public void dataNodeRemoved(ArbilNode dataNode) {
        if (!(dataNode instanceof ArbilDataNode)) {
            throw new UnsupportedOperationException("Cannot remove an ArbilNode from the table");
        }
        this.removeArbilDataNodes(new ArbilDataNode[]{(ArbilDataNode)dataNode});
    }

    @Override
    public void dataNodeIconCleared(ArbilNode dataNode) {
        this.requestReloadTableData();
    }

    @Override
    public void dataNodeChildAdded(ArbilNode destination, ArbilNode newNode) {
    }

    public boolean isWidthsChanged() {
        return this.widthsChanged;
    }

    public void setWidthsChanged(boolean widthsChanged) {
        this.widthsChanged = widthsChanged;
    }

    @Override
    protected Hashtable<String, ArbilDataNode> getDataNodeHash() {
        return this.dataNodeHash;
    }

    @Override
    protected synchronized void reloadTableDataPrivate() {
        super.reloadTableDataPrivate();
        this.updateImageDisplayPanel();
        this.setWidthsChanged(false);
    }

    @Override
    public void requestReloadTableData() {
        this.reloadRunner.requestActionAndNotify();
    }

    public void setPreferredColumnWidth(String columnName, Integer width) {
        Integer currentWidth = this.getFieldView().getColumnWidth(columnName);
        if (!(this.isWidthsChanged() || width == null && currentWidth == null || width != null && width.equals(currentWidth))) {
            this.setWidthsChanged(true);
            this.fireTableStructureChanged();
        }
        this.getFieldView().setColumnWidth(columnName, width);
    }

    public Integer getPreferredColumnWidth(String columnName) {
        return this.getFieldView().getColumnWidth(columnName);
    }

    public void copyArbilRows(int[] selectedRows) {
        int firstColumn = 0;
        if (this.isShowIcons() && this.isHorizontalView()) {
            firstColumn = 1;
        }
        int columnCount = this.getColumnCount();
        StringBuilder copiedString = new StringBuilder();
        for (int selectedColCounter = firstColumn; selectedColCounter < columnCount; ++selectedColCounter) {
            copiedString.append('\"').append(this.getColumnName(selectedColCounter)).append('\"');
            if (selectedColCounter >= columnCount - 1) continue;
            copiedString.append(CSV_SEPARATOR);
        }
        copiedString.append('\n');
        for (int selectedRowCounter = 0; selectedRowCounter < selectedRows.length; ++selectedRowCounter) {
            System.out.println("copying row: " + selectedRowCounter);
            for (int selectedColCounter = firstColumn; selectedColCounter < columnCount; ++selectedColCounter) {
                copiedString.append('\"').append(this.data[selectedRows[selectedRowCounter]][selectedColCounter].toString().replace(CSV_QUOTE_STRING, CSV_DOUBLE_QUOTE)).append('\"');
                if (selectedColCounter >= columnCount - 1) continue;
                copiedString.append(CSV_SEPARATOR);
            }
            copiedString.append('\n');
        }
        System.out.println("copiedString: " + copiedString.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(copiedString.toString());
        clipboard.setContents(stringSelection, this);
    }

    public void copyArbilFields(ArbilField[] selectedCells) {
        StringBuilder copiedString = new StringBuilder();
        copiedString.append('\"').append("Field Name".replace(CSV_QUOTE_STRING, CSV_DOUBLE_QUOTE)).append('\"').append(CSV_SEPARATOR);
        copiedString.append('\"').append("Value".replace(CSV_QUOTE_STRING, CSV_DOUBLE_QUOTE)).append('\"');
        copiedString.append('\n');
        boolean isFirstCol = true;
        for (ArbilField currentField : selectedCells) {
            if (!isFirstCol) {
                copiedString.append(CSV_SEPARATOR);
                isFirstCol = false;
            }
            copiedString.append('\"').append(currentField.getTranslateFieldName()).append('\"').append(CSV_SEPARATOR);
            copiedString.append('\"').append(currentField.getFieldValue()).append('\"');
            copiedString.append('\n');
        }
        System.out.println("copiedString: " + copiedString.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(copiedString.toString());
        clipboard.setContents(stringSelection, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String pasteIntoArbilFields(ArbilField[] selectedCells) {
        boolean pastedFieldOverwritten = false;
        int pastedCount = 0;
        String resultMessage = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transfer = clipboard.getContents(null);
        try {
            String clipBoardString = "";
            Object clipBoardData = transfer.getTransferData(DataFlavor.stringFlavor);
            if (clipBoardData != null) {
                clipBoardString = clipBoardData.toString();
            }
            System.out.println("clipBoardString: " + clipBoardString);
            String[] clipBoardLines = clipBoardString.split("\"(\r?\n|\r)\"");
            if (clipBoardLines.length == 1) {
                clipBoardLines = clipBoardString.split("\r?\n|\r");
            }
            if (clipBoardLines.length == 1) {
                String messageString = selectedCells.length + " fields will be overwritten with the single value on the clipboard.\nContinue?";
                if (!messageDialogHandler.showConfirmDialogBox(messageString, "Paste")) return null;
                for (ArbilField targetField : selectedCells) {
                    targetField.setFieldValue(clipBoardString, true, false);
                    ++pastedCount;
                }
            } else if (clipBoardLines.length > 1) {
                String areYouSureMessageString = "";
                ArrayList<Object[]> pasteList = new ArrayList<Object[]>();
                int deletingValuesCounter = 0;
                String[] firstLine = clipBoardLines[0].split("\"\\t\"");
                if (firstLine.length == 1) {
                    firstLine = clipBoardLines[0].split(CSV_SEPARATOR);
                }
                boolean singleNodeAxis = false;
                String regexString = "[(\"^)($\")]";
                System.out.println("regexString: " + firstLine[0].replaceAll(regexString, ""));
                if (firstLine[0].replaceAll(regexString, "").equals("Field Name") && firstLine[1].replaceAll(regexString, "").equals("Value")) {
                    singleNodeAxis = true;
                }
                if (!singleNodeAxis) {
                    resultMessage = "Incorrect data to paste.\nThe data must be copied either from a table where only one IMDI file is displayed\nor by selecting individual cells in the table.";
                }
                if (singleNodeAxis) {
                    boolean pasteOneFieldToAll = clipBoardLines.length == 2;
                    HashSet<String> pastedFieldNames = new HashSet<String>();
                    for (int lineCounter = 1; lineCounter < clipBoardLines.length; ++lineCounter) {
                        String clipBoardLine = clipBoardLines[lineCounter];
                        System.out.println("clipBoardLine: " + clipBoardLine);
                        String[] clipBoardCells = clipBoardLine.split("\\t");
                        System.out.println("clipBoardCells.length: " + clipBoardCells.length);
                        if (clipBoardCells.length != 2) {
                            resultMessage = "Inconsistent number of columns in the data to paste.\nThe pasted data could be incorrect.";
                            continue;
                        }
                        String currentFieldName = clipBoardCells[0].replaceAll(regexString, "");
                        String currentFieldValue = clipBoardCells[1].replaceAll(regexString, "");
                        if (pastedFieldNames.contains(currentFieldName)) {
                            pastedFieldOverwritten = true;
                        } else {
                            pastedFieldNames.add(currentFieldName);
                        }
                        if (selectedCells == null) continue;
                        for (ArbilField targetField : selectedCells) {
                            System.out.println("targetField: " + targetField.getTranslateFieldName());
                            if (!currentFieldName.equals(targetField.getTranslateFieldName()) && !pasteOneFieldToAll) continue;
                            if (currentFieldValue.trim().length() == 0 && targetField.getFieldValue().trim().length() > 0) {
                                ++deletingValuesCounter;
                            }
                            pasteList.add(new Object[]{targetField, currentFieldValue});
                        }
                    }
                    if (pastedFieldOverwritten) {
                        areYouSureMessageString = areYouSureMessageString + "Two fields of the same name are to be pasted into this table,\nthis will cause at least one field to be overwritten by another.\n\n";
                    }
                    if (deletingValuesCounter > 0) {
                        areYouSureMessageString = areYouSureMessageString + "There are " + deletingValuesCounter + " fields that will have their contents deleted by this paste action.\n\n";
                    }
                    if (areYouSureMessageString.length() > 0 && !messageDialogHandler.showConfirmDialogBox(areYouSureMessageString + "Continue?", "Paste")) {
                        return null;
                    }
                    for (Object[] pasteListObject : pasteList) {
                        ArbilField currentField = (ArbilField)pasteListObject[0];
                        String currentValue = (String)pasteListObject[1];
                        currentField.setFieldValue(currentValue, true, false);
                        ++pastedCount;
                    }
                }
            } else {
                resultMessage = "No data to paste.";
            }
            if (pastedCount != 0) return resultMessage;
            if (resultMessage != null) return resultMessage;
            return "No fields matched the data on the clipboard.";
        }
        catch (Exception ex) {
            ArbilTableModel.getBugCatcher().logError(ex);
        }
        return resultMessage;
    }

    @Override
    public void removeAllArbilDataNodeRows() {
        this.listModel.removeAllElements();
        super.removeAllArbilDataNodeRows();
    }

    @Override
    protected void removeArbilDataNode(ArbilDataNode arbilDataNode) {
        System.out.println("removing: " + arbilDataNode.toString());
        this.listModel.removeElement(arbilDataNode);
        super.removeArbilDataNode(arbilDataNode);
    }

    @Override
    protected ArbilTableCell[][] getData() {
        return this.data;
    }

    @Override
    protected void setData(ArbilTableCell[][] data) {
        this.data = data;
    }

    @Override
    protected String getRenderedText(ArbilTableCell data) {
        return new ArbilTableCellRenderer(data).getText();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        System.out.println("lost clipboard ownership");
    }
}

