/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.wizard.setup;

import java.awt.Frame;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import nl.mpi.arbil.ArbilDesktopInjector;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.ui.wizard.ArbilWizard;
import nl.mpi.arbil.ui.wizard.setup.ArbilIconContentDecorator;
import nl.mpi.arbil.ui.wizard.setup.ArbilSetupWizardModel;
import nl.mpi.arbil.ui.wizard.setup.CmdiProfileSelectContent;
import nl.mpi.arbil.ui.wizard.setup.ConfirmationContent;
import nl.mpi.arbil.ui.wizard.setup.IntroductionContent;
import nl.mpi.arbil.ui.wizard.setup.MetadataFormatSelectContent;
import nl.mpi.arbil.ui.wizard.setup.RemoteLocationsContent;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.TreeHelper;

public class ArbilSetupWizard
extends ArbilWizard {
    private static SessionStorage sessionStorage;
    private static BugCatcher bugCatcher;
    private static TreeHelper treeHelper;
    protected static final String WIZARDSTATE_PROPERTY = "wizardState";
    public static final Object INTRODUCTION;
    public static final Object METADATA_FORMAT_SELECT;
    public static final Object CMDI_PROFILE_SELECT;
    public static final Object REMOTE_LOCATIONS;
    public static final Object CONFIRMATION;
    private ArbilSetupWizardModel model;

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setBugCatcher(BugCatcher bugCatherInstance) {
        bugCatcher = bugCatherInstance;
    }

    public static void setTreeHelper(TreeHelper treeHelperInstance) {
        treeHelper = treeHelperInstance;
    }

    public ArbilSetupWizard() {
        this(null);
    }

    public ArbilSetupWizard(Frame owner) {
        super(owner);
        this.getModel();
        this.addContent(INTRODUCTION, new ArbilIconContentDecorator(new IntroductionContent()));
        this.addContent(METADATA_FORMAT_SELECT, new ArbilIconContentDecorator(new MetadataFormatSelectContent(this.model)));
        this.addContent(CMDI_PROFILE_SELECT, new ArbilIconContentDecorator(new CmdiProfileSelectContent(this.model, this.getWizardDialog())));
        this.addContent(REMOTE_LOCATIONS, new ArbilIconContentDecorator(new RemoteLocationsContent(this.model)));
        this.addContent(CONFIRMATION, new ArbilIconContentDecorator(new ConfirmationContent()));
        this.setCurrent(INTRODUCTION);
    }

    protected boolean onFinish() {
        this.saveWizardState();
        this.applyConfiguration();
        return true;
    }

    protected boolean onCancel() {
        return 0 == JOptionPane.showConfirmDialog(this.getWizardDialog(), "Do you really want to cancel the wizard?", "Cancel wizard", 0, 3);
    }

    private void getModel() {
        try {
            Object wizardState = sessionStorage.loadObject(WIZARDSTATE_PROPERTY);
            if (wizardState instanceof ArbilSetupWizardModel) {
                this.model = (ArbilSetupWizardModel)wizardState;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.model = new ArbilSetupWizardModel();
    }

    private void saveWizardState() {
        try {
            sessionStorage.saveObject(this.model, WIZARDSTATE_PROPERTY);
        }
        catch (IOException ex) {
            bugCatcher.logError("Could not save wizard state", ex);
        }
    }

    private void applyConfiguration() {
        this.applyTemplatesConfiguration();
        this.applyRemoteLocationsConfiguration();
        this.applyFileFilterConfiguration();
    }

    private void applyTemplatesConfiguration() {
        ArbilTemplateManager templateManager = ArbilTemplateManager.getSingleInstance();
        if (this.model.isImdiSelected()) {
            templateManager.addDefaultImdiTemplates();
        } else {
            templateManager.removeDefaultImdiTemplates();
        }
        if (!this.model.isCmdiSelected()) {
            for (String template : templateManager.getSelectedTemplateArrayList().toArray(new String[0])) {
                if (!template.startsWith("clarin:")) continue;
                templateManager.removeSelectedTemplates(template);
            }
        }
    }

    private void applyFileFilterConfiguration() {
        if (this.model.isImdiSelected()) {
            sessionStorage.saveString("metadataFileFilter", "IMDI");
        } else if (this.model.isCmdiSelected()) {
            sessionStorage.saveString("metadataFileFilter", "CMDI");
        }
    }

    public static void main(String[] args) {
        new ArbilDesktopInjector().injectHandlers();
        ArbilSetupWizard wizard = new ArbilSetupWizard();
        wizard.showModalDialog();
    }

    private void applyRemoteLocationsConfiguration() {
        String newLine = System.getProperty("line.separator");
        treeHelper.clearRemoteLocations();
        String[] locations = this.model.getRemoteLocations().split(newLine);
        ArrayList<URI> locationURIs = new ArrayList<URI>(locations.length);
        for (String location : locations) {
            if (location == null || location.trim().length() <= 0) continue;
            try {
                URI uri = new URI(location);
                locationURIs.add(uri);
            }
            catch (URISyntaxException ex) {
                bugCatcher.logError("Invalid URI specified in wizard", ex);
            }
        }
        treeHelper.addLocations(locationURIs);
        treeHelper.applyRootLocations();
    }

    static {
        INTRODUCTION = IntroductionContent.class;
        METADATA_FORMAT_SELECT = MetadataFormatSelectContent.class;
        CMDI_PROFILE_SELECT = CmdiProfileSelectContent.class;
        REMOTE_LOCATIONS = RemoteLocationsContent.class;
        CONFIRMATION = ConfirmationContent.class;
    }
}

