/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindocument;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentLoader {
    protected SessionStorage sessionStorage;
    private MessageDialogHandler dialogHandler;
    protected HashMap<UniqueIdentifier, EntityDocument> entityMap = new HashMap();
    private EntityCollection entityCollection;
    protected BugCatcher bugCatcher;

    public DocumentLoader(SessionStorage sessionStorage, MessageDialogHandler dialogHandler, EntityCollection entityCollection, BugCatcher bugCatcher) {
        this.sessionStorage = sessionStorage;
        this.dialogHandler = dialogHandler;
        this.entityCollection = entityCollection;
        this.bugCatcher = bugCatcher;
    }

    protected EntityDocument getEntityDocument(UniqueIdentifier selectedIdentifier) throws ImportException, URISyntaxException {
        EntityDocument entityDocument = new EntityDocument(new URI(new EntityCollection(this.sessionStorage, this.dialogHandler, this.bugCatcher).getEntityPath(selectedIdentifier)), new ImportTranslator(true), this.sessionStorage);
        this.entityMap.put(entityDocument.entityData.getUniqueIdentifier(), entityDocument);
        for (EntityRelation entityRelation : entityDocument.entityData.getAllRelations()) {
            EntityDocument relatedDocument = this.entityMap.get(entityRelation.alterUniqueIdentifier);
            if (relatedDocument != null) continue;
            URI entityUri = new URI(new EntityCollection(this.sessionStorage, this.dialogHandler, this.bugCatcher).getEntityPath(entityRelation.alterUniqueIdentifier));
            relatedDocument = new EntityDocument(entityUri, new ImportTranslator(true), this.sessionStorage);
            this.entityMap.put(entityRelation.alterUniqueIdentifier, relatedDocument);
        }
        this.linkLoadedEntities();
        return entityDocument;
    }

    protected EntityDocument getEntityDocuments(UniqueIdentifier[] selectedIdentifiers, ArrayList<EntityDocument> entityDocumentList) throws ImportException, URISyntaxException {
        EntityDocument leadEntityDocument = null;
        for (UniqueIdentifier uniqueIdentifier : selectedIdentifiers) {
            EntityDocument entityDocument = this.getEntityDocument(uniqueIdentifier);
            if (leadEntityDocument == null) {
                leadEntityDocument = entityDocument;
                continue;
            }
            entityDocumentList.add(entityDocument);
        }
        return leadEntityDocument;
    }

    private void linkLoadedEntities() {
        for (EntityDocument entityDocument : this.entityMap.values()) {
            for (EntityRelation nodeRelation : entityDocument.entityData.getRelatedNodesToBeLoaded()) {
                EntityDocument entityData = this.entityMap.get(nodeRelation.alterUniqueIdentifier);
                if (entityData != null) {
                    nodeRelation.setAlterNode(entityData.entityData);
                    continue;
                }
                System.out.println("missing: " + nodeRelation.alterUniqueIdentifier.getAttributeIdentifier());
            }
        }
    }

    protected UniqueIdentifier[] getAffectedIdentifiers() {
        return this.entityMap.keySet().toArray(new UniqueIdentifier[0]);
    }

    protected void saveAllDocuments() throws ImportException {
        for (EntityDocument entityDocument : this.entityMap.values()) {
            entityDocument.saveDocument();
            this.entityCollection.updateDatabase(entityDocument.getFile().toURI());
        }
    }
}

