/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindocument;

import java.net.URISyntaxException;
import java.util.ArrayList;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindocument.DocumentLoader;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class EntityMerger
extends DocumentLoader {
    public EntityMerger(SessionStorage sessionStorage, MessageDialogHandler dialogHandler, EntityCollection entityCollection, BugCatcher bugCatcher) {
        super(sessionStorage, dialogHandler, entityCollection, bugCatcher);
    }

    public UniqueIdentifier[] mergeEntities(UniqueIdentifier[] selectedIdentifiers) throws ImportException {
        ArrayList<EntityDocument> nonLeadEntityDocuments = new ArrayList<EntityDocument>();
        try {
            EntityDocument leadEntityDocument = this.getEntityDocuments(selectedIdentifiers, nonLeadEntityDocuments);
            for (EntityDocument alterEntity : nonLeadEntityDocuments) {
                for (EntityRelation entityRelation : alterEntity.entityData.getAllRelations()) {
                    EntityDocument relatedDocument = (EntityDocument)this.entityMap.get(entityRelation.alterUniqueIdentifier);
                    leadEntityDocument.entityData.addRelatedNode(relatedDocument.entityData, entityRelation.getRelationType(), entityRelation.lineColour, entityRelation.labelString, entityRelation.dcrType, entityRelation.customType);
                    relatedDocument.entityData.removeRelationsWithNode(alterEntity.entityData);
                    alterEntity.entityData.removeRelationsWithNode(relatedDocument.entityData);
                }
                alterEntity.setAsDeletedDocument();
            }
            this.saveAllDocuments();
        }
        catch (URISyntaxException exception) {
            this.bugCatcher.logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
        return this.getAffectedIdentifiers();
    }

    public UniqueIdentifier[] duplicateEntities(UniqueIdentifier[] selectedIdentifiers) throws ImportException {
        ArrayList<UniqueIdentifier> addedIdentifiers = new ArrayList<UniqueIdentifier>();
        ArrayList<EntityDocument> entityDocumentList = new ArrayList<EntityDocument>();
        try {
            this.getEntityDocuments(selectedIdentifiers, entityDocumentList);
            for (UniqueIdentifier uniqueIdentifier : selectedIdentifiers) {
                EntityDocument masterDocument = (EntityDocument)this.entityMap.get(uniqueIdentifier);
                EntityDocument duplicateEntityDocument = new EntityDocument(masterDocument, new ImportTranslator(true), this.sessionStorage);
                addedIdentifiers.add(duplicateEntityDocument.getUniqueIdentifier());
                for (EntityRelation entityRelation : masterDocument.entityData.getAllRelations()) {
                    EntityDocument relatedDocument = (EntityDocument)this.entityMap.get(entityRelation.alterUniqueIdentifier);
                    duplicateEntityDocument.entityData.addRelatedNode(relatedDocument.entityData, entityRelation.getRelationType(), entityRelation.lineColour, entityRelation.labelString, entityRelation.dcrType, entityRelation.customType);
                }
                this.entityMap.put(duplicateEntityDocument.getUniqueIdentifier(), duplicateEntityDocument);
                this.saveAllDocuments();
            }
            return addedIdentifiers.toArray(new UniqueIdentifier[0]);
        }
        catch (URISyntaxException exception) {
            this.bugCatcher.logError((Exception)exception);
            throw new ImportException("Error: " + exception.getMessage());
        }
    }
}

