/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.entityprofiles;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.kinnate.kindocument.ProfileManager;
import nl.mpi.kinnate.ui.entityprofiles.ProfileTableModel;

public class CmdiProfileSelectionPanel
extends JPanel
implements ActionListener {
    private JTable profileTable;
    private JPanel topPanel;
    private JProgressBar profileReloadProgressBar;
    private JLabel statusLabel;
    private JButton reloadButton;
    private ProfileTableModel profileTableModel;
    private ProfileManager profileManager;

    public CmdiProfileSelectionPanel(String panelName, ProfileManager profileManager) {
        this.profileManager = profileManager;
        this.setName(panelName);
        this.setLayout(new BorderLayout());
        this.profileTableModel = new ProfileTableModel();
        this.profileTable = new JTable(this.profileTableModel);
        this.topPanel = new JPanel(new BorderLayout());
        this.profileReloadProgressBar = new JProgressBar();
        this.statusLabel = new JLabel();
        this.reloadButton = new JButton("Reload List");
        this.reloadButton.addActionListener(this);
        this.topPanel.add((Component)this.statusLabel, "Center");
        this.topPanel.add((Component)this.reloadButton, "After");
        this.add((Component)this.topPanel, "First");
        this.add((Component)this.profileReloadProgressBar, "Last");
        this.add((Component)new JScrollPane(this.profileTable), "Center");
    }

    public void setStatus(boolean reloadEnable, String statusText, boolean isError) {
        if (isError) {
            this.statusLabel.setForeground(Color.red);
        } else {
            this.statusLabel.setForeground(new JLabel().getForeground());
        }
        this.statusLabel.setText(statusText);
        this.reloadButton.setEnabled(reloadEnable);
        this.profileReloadProgressBar.setVisible(!reloadEnable);
    }

    public void setCmdiProfileReader(CmdiProfileReader cmdiProfileReader) {
        this.profileTableModel.setCmdiProfileReader(cmdiProfileReader);
    }

    public JProgressBar getProfileReloadProgressBar() {
        return this.profileReloadProgressBar;
    }

    public void actionPerformed(ActionEvent e) {
        this.profileManager.loadProfiles(true, this);
    }
}

