/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import nl.mpi.arbil.ArbilDesktopInjector;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.ArbilVersion;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilTaskStatusBar;
import nl.mpi.arbil.ui.ArbilTreePanels;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.PreviewSplitPanel;
import nl.mpi.arbil.ui.menu.ArbilMenuBar;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.arbil.util.ArbilMimeHashQueue;
import nl.mpi.arbil.util.TreeHelper;

public class ArbilMain
extends JFrame {
    private JSplitPane mainSplitPane;
    private ArbilMenuBar arbilMenuBar;
    private ArbilTaskStatusBar statusBar;

    public static void main(String[] args) {
        System.setProperty("sun.swing.enableImprovedDragGesture", "true");
        System.setProperty("apple.awt.graphics.UseQuartz", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ApplicationVersionManager versionManager = new ApplicationVersionManager(new ArbilVersion());
                try {
                    new ArbilMain(versionManager);
                }
                catch (Exception ex) {
                    new ArbilBugCatcher(new ArbilSessionStorage(), versionManager).logError(ex);
                }
            }
        });
    }

    public ArbilMain(ApplicationVersionManager versionManager) {
        ArbilDesktopInjector injector = new ArbilDesktopInjector();
        injector.injectHandlers(versionManager);
        this.initApplication(injector.getTreeHelper(), injector.getMimeHashQueue());
        this.initUI(injector.getTreeHelper(), injector.getWindowManager(), versionManager);
        this.checkFirstRun(injector.getWindowManager());
    }

    private void initApplication(TreeHelper treeHelper, ArbilMimeHashQueue hashQueue) {
        treeHelper.init();
        hashQueue.init();
    }

    private void initUI(ArbilTreeHelper treeHelper, ArbilWindowManager windowManager, ApplicationVersionManager versionManager) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ArbilMain.this.arbilMenuBar.performCleanExit();
            }
        });
        this.initComponents();
        windowManager.addTaskListener(this.statusBar);
        PreviewSplitPanel previewSplitPanel = PreviewSplitPanel.getInstance();
        this.mainSplitPane.setRightComponent(previewSplitPanel);
        ArbilTreePanels arbilTreePanels = new ArbilTreePanels(treeHelper);
        this.mainSplitPane.setLeftComponent(arbilTreePanels);
        this.arbilMenuBar = new ArbilMenuBar(previewSplitPanel, null);
        this.setJMenuBar(this.arbilMenuBar);
        this.mainSplitPane.setDividerLocation(0.25);
        windowManager.loadGuiState(this, this.statusBar);
        this.setTitle(versionManager.getApplicationVersion().applicationTitle + " " + versionManager.getApplicationVersion().compileDate);
        this.setIconImage(ArbilIcons.getSingleInstance().linorgIcon.getImage());
        this.setVisible(true);
        if (this.arbilMenuBar.checkNewVersionAtStartCheckBoxMenuItem.isSelected()) {
            versionManager.checkForUpdate();
        }
        this.initMacApplicationHandlers(windowManager);
    }

    private void checkFirstRun(ArbilWindowManager windowManager) {
        windowManager.showSetupWizardIfFirstRun();
        windowManager.openIntroductionPage();
    }

    private void initComponents() {
        this.mainSplitPane = new JSplitPane();
        this.statusBar = new ArbilTaskStatusBar();
        this.setDefaultCloseOperation(0);
        this.setTitle("Arbil");
        this.mainSplitPane.setDividerLocation(100);
        this.mainSplitPane.setDividerSize(5);
        this.mainSplitPane.setName("mainSplitPane");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.pack();
    }

    private void initMacApplicationHandlers(ArbilWindowManager windowManager) {
        try {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            Exception exception = null;
            try {
                Object application = applicationClass.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
                this.initMacQuitHandler(applicationClass, application);
                this.initMacAboutHandler(windowManager, applicationClass, application);
                this.arbilMenuBar.setMacOsMenu(true);
                return;
            }
            catch (IllegalAccessException ex) {
                exception = ex;
            }
            catch (IllegalArgumentException ex) {
                exception = ex;
            }
            catch (InvocationTargetException ex) {
                exception = ex;
            }
            catch (NoSuchMethodException ex) {
                exception = ex;
            }
            catch (SecurityException ex) {
                exception = ex;
            }
            catch (ClassNotFoundException ex) {
                exception = ex;
            }
            System.err.println("Could not configure MacOS application handlers");
            if (exception != null) {
                System.err.println(exception);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void initMacQuitHandler(Class applicationClass, Object application) throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException, SecurityException, NoSuchMethodException, InvocationTargetException {
        ArbilMain.initMacHandler(applicationClass, application, "com.apple.eawt.QuitHandler", "setQuitHandler", new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("handleQuitRequestWith") && !ArbilMain.this.arbilMenuBar.performCleanExit() && args.length >= 2) {
                    Object quitResponse = args[1];
                    Class<?> quitResponseClass = Class.forName("com.apple.eawt.QuitResponse");
                    if (quitResponse.getClass().equals(quitResponseClass)) {
                        quitResponseClass.getMethod("cancelQuit", new Class[0]).invoke(quitResponse, new Object[0]);
                    }
                }
                return null;
            }
        });
    }

    private void initMacAboutHandler(final ArbilWindowManager windowManager, Class applicationClass, Object application) throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException, SecurityException, NoSuchMethodException, InvocationTargetException {
        ArbilMain.initMacHandler(applicationClass, application, "com.apple.eawt.AboutHandler", "setAboutHandler", new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                windowManager.openAboutPage();
                return null;
            }
        });
    }

    private static void initMacHandler(Class applicationClass, Object application, String interfaceName, String setMethodName, InvocationHandler invocationHandler) throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException, SecurityException, NoSuchMethodException, InvocationTargetException {
        Class<?> handlerInterface = Class.forName(interfaceName);
        Object handler = Proxy.newProxyInstance(handlerInterface.getClassLoader(), new Class[]{handlerInterface}, invocationHandler);
        applicationClass.getMethod(setMethodName, handlerInterface).invoke(application, handler);
    }
}

