/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin.profiles;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JProgressBar;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import org.apache.commons.digester.Digester;

public class CmdiProfileReader {
    private static SessionStorage sessionStorage;
    private static BugCatcher bugCatcher;
    public static final String PARAM_PROFILESELECTION = "profileSelection";
    public static final String PARAM_PROFILES_URL = "profilesUrlAll";
    public static final String PARAM_SELECTED_PROFILES_URL = "profilesUrlSelected";
    public static final String DEFAULT_ALL_PROFILES_URL_STRING = "http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles";
    public static final String DEFAULT_SELECTED_PROFILES_URL_STRING = "http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles?mdEditor=true";
    private ProfileSelection selection;
    public ArrayList<CmdiProfile> cmdiProfileArray = null;
    static CmdiProfileReader singleInstance;

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static synchronized CmdiProfileReader getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new CmdiProfileReader(CmdiProfileReader.getStoredProfileSelection());
        }
        return singleInstance;
    }

    public static boolean pathIsProfile(String pathString) {
        return pathString.startsWith("http") || pathString.contains("clarin") || pathString.endsWith(".xsd") || pathString.endsWith("/xsd");
    }

    public CmdiProfile getProfile(String XsdHref) {
        for (CmdiProfile currentProfile : this.cmdiProfileArray) {
            if (!currentProfile.getXsdHref().equals(XsdHref)) continue;
            return currentProfile;
        }
        return null;
    }

    private CmdiProfileReader(ProfileSelection selection) {
        this.setSelection(selection);
        this.loadProfiles(this.getProfilesUrlStringForSelection(this.getSelection()));
    }

    public void refreshProfiles(JProgressBar progressBar, boolean forceUpdate) {
        progressBar.setIndeterminate(true);
        progressBar.setString("");
        int updateDays = forceUpdate ? 0 : 100;
        sessionStorage.updateCache(this.getProfilesUrlStringForSelection(this.getSelection()), updateDays, false);
        this.loadProfiles(this.getProfilesUrlStringForSelection(this.getSelection()));
        progressBar.setIndeterminate(false);
        progressBar.setMinimum(0);
        progressBar.setMaximum(this.cmdiProfileArray.size() + 1);
        progressBar.setValue(1);
        for (CmdiProfile currentCmdiProfile : this.cmdiProfileArray) {
            progressBar.setString(currentCmdiProfile.name);
            sessionStorage.updateCache(currentCmdiProfile.getXsdHref(), updateDays, false);
            progressBar.setValue(progressBar.getValue() + 1);
        }
        progressBar.setString("");
        progressBar.setValue(0);
    }

    private void loadProfiles(String profilesUrl) {
        File profileXmlFile = sessionStorage.updateCache(profilesUrl, 10, false);
        try {
            Digester digester = new Digester();
            digester.push((Object)this);
            digester.addCallMethod("profileDescriptions/profileDescription", "addProfile", 6);
            digester.addCallParam("profileDescriptions/profileDescription/id", 0);
            digester.addCallParam("profileDescriptions/profileDescription/description", 1);
            digester.addCallParam("profileDescriptions/profileDescription/name", 2);
            digester.addCallParam("profileDescriptions/profileDescription/registrationDate", 3);
            digester.addCallParam("profileDescriptions/profileDescription/creatorName", 4);
            digester.addCallParam("profileDescriptions/profileDescription/ns2:href", 5);
            this.cmdiProfileArray = new ArrayList();
            digester.parse(profileXmlFile);
        }
        catch (Exception e) {
            bugCatcher.logError(e);
        }
    }

    public void addProfile(String id, String description, String name, String registrationDate, String creatorName, String href) {
        CmdiProfile cmdiProfile = new CmdiProfile();
        cmdiProfile.id = id;
        cmdiProfile.description = description;
        cmdiProfile.name = name;
        cmdiProfile.registrationDate = registrationDate;
        cmdiProfile.creatorName = creatorName;
        cmdiProfile.href = href;
        this.cmdiProfileArray.add(cmdiProfile);
    }

    public final ProfileSelection getSelection() {
        return this.selection;
    }

    public final void setSelection(ProfileSelection selection) {
        this.selection = selection;
        this.storeProfileSelection(selection);
    }

    protected final String getProfilesUrlStringForSelection(ProfileSelection selection) {
        return selection == ProfileSelection.SELECTED ? this.getSelectedProfileUrlString() : this.getAllProfilesUrlString();
    }

    public static void main(String[] args) {
        new CmdiProfileReader(ProfileSelection.SELECTED);
    }

    private static synchronized ProfileSelection getStoredProfileSelection() {
        String selectionString = sessionStorage.loadString(PARAM_PROFILESELECTION);
        if (selectionString == null) {
            selectionString = ProfileSelection.SELECTED.toString();
        }
        return ProfileSelection.valueOf(selectionString);
    }

    private void storeProfileSelection(ProfileSelection selection) {
        sessionStorage.saveString(PARAM_PROFILESELECTION, selection.toString());
    }

    private String getAllProfilesUrlString() {
        String savedProfilesUrlString = sessionStorage.loadString(PARAM_PROFILES_URL);
        if (savedProfilesUrlString == null) {
            sessionStorage.saveString(PARAM_PROFILES_URL, DEFAULT_ALL_PROFILES_URL_STRING);
            return DEFAULT_ALL_PROFILES_URL_STRING;
        }
        return savedProfilesUrlString;
    }

    private String getSelectedProfileUrlString() {
        String savedProfilesUrlString = sessionStorage.loadString(PARAM_SELECTED_PROFILES_URL);
        if (savedProfilesUrlString == null) {
            sessionStorage.saveString(PARAM_SELECTED_PROFILES_URL, DEFAULT_SELECTED_PROFILES_URL_STRING);
            return DEFAULT_SELECTED_PROFILES_URL_STRING;
        }
        return savedProfilesUrlString;
    }

    static {
        singleInstance = null;
    }

    public static class CmdiProfile {
        public String id;
        public String description;
        public String name;
        public String registrationDate;
        public String creatorName;
        public String href;

        public String getXsdHref() {
            return this.href + "/xsd";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProfileSelection {
        SELECTED,
        ALL;

    }
}

