/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item.map;

import org.basex.query.QueryException;
import org.basex.query.item.AtomType;
import org.basex.query.item.Item;
import org.basex.query.item.SeqType;
import org.basex.query.item.Value;
import org.basex.query.item.map.Leaf;
import org.basex.query.item.map.List;
import org.basex.query.item.map.TrieNode;
import org.basex.query.iter.ItemCache;
import org.basex.util.InputInfo;

final class Branch
extends TrieNode {
    private final TrieNode[] kids;
    final int used;
    private static final String[] ENDS = new String[]{"|-- ", "|   ", "`-- ", "    "};

    Branch(TrieNode[] ch, int u, int s) {
        super(s);
        this.kids = ch;
        this.used = u;
        assert (this.verify());
    }

    TrieNode[] copyKids() {
        TrieNode[] copy = new TrieNode[32];
        System.arraycopy(this.kids, 0, copy, 0, 32);
        return copy;
    }

    @Override
    TrieNode insert(int h, Item k, Value v, int l, InputInfo ii) throws QueryException {
        int rem;
        int bs;
        TrieNode nsub;
        int key = Branch.key(h, l);
        TrieNode sub = this.kids[key];
        if (sub != null) {
            nsub = sub.insert(h, k, v, l + 1, ii);
            if (nsub == sub) {
                return this;
            }
            bs = this.used;
            rem = sub.size;
        } else {
            nsub = new Leaf(h, k, v);
            bs = this.used | 1 << key;
            rem = 0;
        }
        TrieNode[] ks = this.copyKids();
        ks[key] = nsub;
        return new Branch(ks, bs, this.size - rem + nsub.size);
    }

    @Override
    TrieNode delete(int h, Item k, int l, InputInfo ii) throws QueryException {
        int nu;
        int key = Branch.key(h, l);
        TrieNode sub = this.kids[key];
        if (sub == null) {
            return this;
        }
        TrieNode nsub = sub.delete(h, k, l + 1, ii);
        if (nsub == sub) {
            return this;
        }
        if (nsub == null) {
            TrieNode single;
            nu = this.used ^ 1 << key;
            if (Integer.bitCount(nu) == 1 && !((single = this.kids[Integer.numberOfTrailingZeros(nu)]) instanceof Branch)) {
                return single;
            }
        } else {
            nu = this.used;
        }
        TrieNode[] ks = this.copyKids();
        ks[key] = nsub;
        return new Branch(ks, nu, this.size - 1);
    }

    @Override
    Value get(int h, Item k, int l, InputInfo ii) throws QueryException {
        int key = Branch.key(h, l);
        TrieNode sub = this.kids[key];
        return sub == null ? null : sub.get(h, k, l + 1, ii);
    }

    @Override
    boolean contains(int h, Item k, int l, InputInfo ii) throws QueryException {
        int key = Branch.key(h, l);
        TrieNode sub = this.kids[key];
        return sub != null && sub.contains(h, k, l + 1, ii);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    StringBuilder toString(StringBuilder sb, String ind) {
        s = Integer.bitCount(this.used);
        i = 0;
        j = 0;
        ** GOTO lbl15
        {
            ++j;
            do {
                if ((this.used & 1 << j) == 0) continue block0;
                e = i == s - 1 ? 2 : 0;
                sb.append(ind).append(Branch.ENDS[e]).append(String.format("%x", new Object[]{j})).append("\n");
                this.kids[j].toString(sb, String.valueOf(ind) + Branch.ENDS[e + 1]);
                ++i;
                ++j;
lbl15:
                // 2 sources

            } while (i < s);
        }
        return sb;
    }

    @Override
    TrieNode addAll(TrieNode o, int l, InputInfo ii) throws QueryException {
        return o.add(this, l, ii);
    }

    @Override
    TrieNode add(Leaf o, int l, InputInfo ii) throws QueryException {
        TrieNode nw;
        int k = Branch.key(o.hash, l);
        TrieNode ch = this.kids[k];
        if (ch != null) {
            TrieNode ins = ch.add(o, l + 1, ii);
            if (ins == ch) {
                return this;
            }
            nw = ins;
        } else {
            nw = o;
        }
        TrieNode[] ks = this.copyKids();
        ks[k] = nw;
        return new Branch(ks, this.used | 1 << k, this.size + 1);
    }

    @Override
    TrieNode add(List o, int l, InputInfo ii) throws QueryException {
        TrieNode nw;
        int k = Branch.key(o.hash, l);
        TrieNode ch = this.kids[k];
        int n = o.size;
        if (ch != null) {
            TrieNode ins = ch.add(o, l + 1, ii);
            if (ins == ch) {
                return this;
            }
            n = ins.size - ch.size;
            nw = ins;
        } else {
            nw = o;
        }
        TrieNode[] ks = this.copyKids();
        ks[k] = nw;
        return new Branch(ks, this.used | 1 << k, this.size + n);
    }

    @Override
    TrieNode add(Branch o, int l, InputInfo ii) throws QueryException {
        TrieNode[] ch = null;
        int nu = this.used;
        int ns = this.size;
        int i = 0;
        while (i < this.kids.length) {
            TrieNode k = this.kids[i];
            TrieNode ok = o.kids[i];
            if (ok != null) {
                TrieNode nw;
                TrieNode trieNode = nw = k == null ? ok : ok.addAll(k, l + 1, ii);
                if (nw != k) {
                    if (ch == null) {
                        ch = this.copyKids();
                    }
                    ch[i] = nw;
                    nu |= 1 << i;
                    ns += nw.size - (k == null ? 0 : k.size);
                }
            }
            ++i;
        }
        return ch == null ? this : new Branch(ch, nu, ns);
    }

    @Override
    boolean verify() {
        int c = 0;
        int i = 0;
        while (i < 32) {
            boolean act;
            boolean bit = (this.used & 1 << i) != 0;
            boolean bl = act = this.kids[i] != null;
            if (bit ^ act) {
                return false;
            }
            if (act) {
                c += this.kids[i].size;
            }
            ++i;
        }
        return c == this.size;
    }

    @Override
    void keys(ItemCache ks) {
        TrieNode[] trieNodeArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            TrieNode nd = trieNodeArray[n2];
            if (nd != null) {
                nd.keys(ks);
            }
            ++n2;
        }
    }

    @Override
    boolean hasType(AtomType kt, SeqType vt) {
        TrieNode[] trieNodeArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            TrieNode k = trieNodeArray[n2];
            if (k != null && !k.hasType(kt, vt)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    int hash(InputInfo ii) throws QueryException {
        int hash = 0;
        TrieNode[] trieNodeArray = this.kids;
        int n = this.kids.length;
        int n2 = 0;
        while (n2 < n) {
            TrieNode ch = trieNodeArray[n2];
            if (ch != null) {
                hash = 31 * hash + ch.hash(ii);
            }
            ++n2;
        }
        return hash;
    }

    @Override
    boolean deep(InputInfo ii, TrieNode o) throws QueryException {
        if (!(o instanceof Branch)) {
            return false;
        }
        Branch ob = (Branch)o;
        if (this.used != ob.used) {
            return false;
        }
        int i = 0;
        while (i < 32) {
            if (this.kids[i] != null && !this.kids[i].deep(ii, ob.kids[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    StringBuilder toString(StringBuilder sb) {
        int i = 0;
        while (i < 32) {
            if (this.kids[i] != null) {
                this.kids[i].toString(sb);
            }
            ++i;
        }
        return sb;
    }
}

