/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.data;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.svg.SymbolGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinTreeNode
extends ArbilNode
implements Comparable {
    public EntityData entityData;
    private IndexerParameters indexerParameters;
    DataTypes.RelationType subnodeFilter;
    ArbilNode[] childNodes = null;
    private static SymbolGraphic symbolGraphic;
    private EntityCollection entityCollection;
    private MessageDialogHandler dialogHandler;
    private BugCatcher bugCatcher;
    private ArbilDataNodeLoader dataNodeLoader;

    public KinTreeNode(EntityData entityData, IndexerParameters indexerParameters, MessageDialogHandler dialogHandler, BugCatcher bugCatcher, EntityCollection entityCollection, ArbilDataNodeLoader dataNodeLoader) {
        this.indexerParameters = indexerParameters;
        this.entityData = entityData;
        this.subnodeFilter = null;
        this.entityCollection = entityCollection;
        this.dialogHandler = dialogHandler;
        this.bugCatcher = bugCatcher;
        this.dataNodeLoader = dataNodeLoader;
        symbolGraphic = new SymbolGraphic(dialogHandler, bugCatcher);
    }

    public KinTreeNode(EntityData entityData, DataTypes.RelationType subnodeFilter, IndexerParameters indexerParameters, MessageDialogHandler dialogHandler, BugCatcher bugCatcher, EntityCollection entityCollection, ArbilDataNodeLoader dataNodeLoader) {
        this.indexerParameters = indexerParameters;
        this.entityData = entityData;
        this.subnodeFilter = subnodeFilter;
        this.entityCollection = entityCollection;
        this.dialogHandler = dialogHandler;
        this.bugCatcher = bugCatcher;
        this.dataNodeLoader = dataNodeLoader;
        symbolGraphic = new SymbolGraphic(dialogHandler, bugCatcher);
    }

    public String toString() {
        StringBuilder labelBuilder = new StringBuilder();
        if (this.entityData == null) {
            labelBuilder.append("(entity not loaded)");
        } else {
            String[] labelArray = this.entityData.getLabel();
            if (labelArray != null && labelArray.length > 0) {
                for (String labelString : labelArray) {
                    labelBuilder.append(labelString);
                    labelBuilder.append(" ");
                }
            } else {
                labelBuilder.append("(unnamed entity)");
            }
        }
        return labelBuilder.toString();
    }

    public ArbilDataNode[] getAllChildren() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void getAllChildren(Vector<ArbilDataNode> allChildren) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ArbilNode[] getChildArray() {
        if (this.childNodes != null) {
            return this.childNodes;
        }
        if (this.entityData != null) {
            ArrayList<KinTreeNode> relationList = new ArrayList<KinTreeNode>();
            for (EntityRelation entityRelation : this.entityData.getAllRelations()) {
                boolean showFiltered;
                boolean bl = showFiltered = this.subnodeFilter == DataTypes.RelationType.ancestor || this.subnodeFilter == DataTypes.RelationType.descendant;
                if (this.subnodeFilter != null && (this.subnodeFilter != entityRelation.getRelationType() || !showFiltered)) continue;
                EntityData alterEntity = entityRelation.getAlterNode();
                if (alterEntity == null) {
                    alterEntity = this.entityCollection.getEntity(entityRelation.alterUniqueIdentifier, this.indexerParameters);
                    entityRelation.setAlterNode(alterEntity);
                }
                relationList.add(new KinTreeNode(alterEntity, entityRelation.getRelationType(), this.indexerParameters, this.dialogHandler, this.bugCatcher, this.entityCollection, this.dataNodeLoader));
            }
            if (this.entityData.archiveLinkArray != null) {
                for (Comparable<EntityRelation> comparable : this.entityData.archiveLinkArray) {
                    ArbilDataNode linkedArbilDataNode = this.dataNodeLoader.getArbilDataNode(null, comparable);
                    relationList.add((KinTreeNode)linkedArbilDataNode);
                }
            }
            this.childNodes = relationList.toArray(new ArbilNode[0]);
            return this.childNodes;
        }
        return new ArbilNode[0];
    }

    public int getChildCount() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ImageIcon getIcon() {
        if (this.entityData != null) {
            return symbolGraphic.getSymbolGraphic(this.entityData.getSymbolType(), this.entityData.isEgo);
        }
        return null;
    }

    public boolean hasCatalogue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasHistory() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasLocalResource() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasResource() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isArchivableFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isCatalogue() {
        return false;
    }

    public boolean isChildNode() {
        return false;
    }

    public boolean isCmdiMetaDataNode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isCorpus() {
        return false;
    }

    public boolean isDataLoaded() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isEditable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isEmptyMetaNode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isFavorite() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isLoading() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isLocal() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isMetaDataNode() {
        return false;
    }

    public boolean isResourceSet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isSession() {
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof KinTreeNode) {
            int compResult = this.toString().compareTo(o.toString());
            if (compResult == 0) {
                // empty if block
            }
            return compResult;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KinTreeNode other = (KinTreeNode)obj;
        if (this.entityData == null || other.entityData == null) {
            return false;
        }
        return this.entityData.getUniqueIdentifier() == other.entityData.getUniqueIdentifier() || this.entityData.getUniqueIdentifier() != null && this.entityData.getUniqueIdentifier().equals(other.entityData.getUniqueIdentifier());
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.entityData.getUniqueIdentifier() != null ? this.entityData.getUniqueIdentifier().hashCode() : 0);
        return hash;
    }
}

