/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.entityindexer;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JProgressBar;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.kinnate.entityindexer.EntityService;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.entityindexer.IndexerEntityData;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.entityindexer.ParameterElement;
import nl.mpi.kinnate.entityindexer.ProcessAbortException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kintypestrings.KinType;
import nl.mpi.kinnate.kintypestrings.KinTypeStringConverter;
import nl.mpi.kinnate.kintypestrings.ParserHighlight;
import nl.mpi.kinnate.svg.DataStoreSvg;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class EntityIndex
implements EntityService {
    private HashMap<String, IndexerEntityData> knownEntities = new HashMap();

    private IndexerEntityData getEntityData(String egoEntityUriString, IndexerParameters indexParameters) throws URISyntaxException {
        URI egoEntityUri = new URI(egoEntityUriString);
        return this.getEntityData(egoEntityUri, indexParameters);
    }

    private IndexerEntityData getEntityData(URI egoEntityUri, IndexerParameters indexParameters) {
        IndexerEntityData entityData = this.knownEntities.get(egoEntityUri.toASCIIString());
        if (entityData != null) {
            return entityData;
        }
        entityData = new IndexerEntityData(null);
        this.knownEntities.put(egoEntityUri.toASCIIString(), entityData);
        try {
            Document linksDom = ArbilComponentBuilder.getDocument((URI)egoEntityUri);
            NodeList relationLinkNodeList = XPathAPI.selectNodeList((Node)linksDom, (String)indexParameters.linkPath);
            for (int nodeCounter = 0; nodeCounter < relationLinkNodeList.getLength(); ++nodeCounter) {
                Node relationLinkNode = relationLinkNodeList.item(nodeCounter);
                if (relationLinkNode == null) continue;
                URI alterUri = egoEntityUri.resolve(relationLinkNode.getTextContent());
                entityData.addRelation(alterUri.toASCIIString());
                for (ParameterElement relevantDataPath : indexParameters.relevantLinkData.getValues()) {
                    for (Node linkDataNode = relationLinkNode.getParentNode().getFirstChild(); linkDataNode != null; linkDataNode = linkDataNode.getNextSibling()) {
                        if (!relevantDataPath.getXpathString().equals(linkDataNode.getNodeName())) continue;
                        entityData.addRelationData(alterUri.toASCIIString(), relevantDataPath.getXpathString(), linkDataNode.getTextContent());
                    }
                }
            }
        }
        catch (TransformerException exception) {
        }
        catch (ParserConfigurationException exception) {
        }
        catch (DOMException exception) {
        }
        catch (IOException exception) {
        }
        catch (SAXException exception) {
            // empty catch block
        }
        return entityData;
    }

    public void printKnownEntities() {
        for (String currentEgo : this.knownEntities.keySet()) {
            System.out.println("currentEgo: " + currentEgo);
            IndexerEntityData currentEntityData = this.knownEntities.get(currentEgo);
            for (String[] stringArray : currentEntityData.getEntityFields()) {
                System.out.println("-> entityField: " + stringArray[0] + " : " + stringArray[1]);
            }
            for (String[] stringArray : currentEntityData.getRelationPaths()) {
                System.out.println("--> currentLink: " + (String)stringArray);
                for (String[] currentRecord : currentEntityData.getRelationData((String)stringArray)) {
                    System.out.println("---> linkField: " + currentRecord[0] + " : " + currentRecord[1]);
                }
            }
        }
    }

    public void loadAllEntities(IndexerParameters indexParameters) {
    }

    public void setKinTypeStringTerm(String symbolString, String fieldPath, String fieldValue) {
    }

    private EntityData getGraphDataNode(boolean isEgo, URI entityUri, IndexerParameters indexParameters) {
        IndexerEntityData entityData = this.getEntityData(entityUri, indexParameters);
        ArrayList<String> labelTextList = new ArrayList<String>();
        for (ParameterElement currentLabelField : indexParameters.labelFields.getValues()) {
            String labelTextTemp = entityData.getEntityField(currentLabelField.getXpathString());
            if (labelTextTemp == null) continue;
            labelTextList.add(labelTextTemp);
        }
        for (ParameterElement currentSymbolField : indexParameters.symbolFieldsFields.getValues()) {
            String linkSymbolString = entityData.getEntityField(currentSymbolField.getXpathString());
            if (linkSymbolString == null) continue;
            return null;
        }
        return null;
    }

    private void setRelationData(EntityData egoNode, EntityData alterNode, IndexerEntityData egoData, String alterPath, IndexerParameters indexParameters) {
        DataTypes.RelationType egoType = null;
        DataTypes.RelationType alterType = null;
        String[][] alterRelationFields = egoData.getRelationData(alterPath);
        if (alterRelationFields != null && egoType != null && alterType != null) {
            egoNode.addRelatedNode(alterNode, egoType, null, null, null, null);
            alterNode.addRelatedNode(egoNode, alterType, null, null, null, null);
        }
    }

    public EntityData[] getEgoGraphData(URI[] egoNodes, IndexerParameters indexParameters) {
        ArrayList<EntityData> graphDataNodeList = new ArrayList<EntityData>();
        for (URI currentEgoUri : egoNodes) {
            graphDataNodeList.add(this.getGraphDataNode(true, currentEgoUri, indexParameters));
        }
        return graphDataNodeList.toArray(new EntityData[0]);
    }

    private void getNextRelations(HashMap<String, EntityData> createdGraphNodes, String currentEgoPath, EntityData egoNode, ArrayList<KinType> remainingKinTypes, IndexerParameters indexParameters) throws URISyntaxException {
        IndexerEntityData egoData = this.getEntityData(currentEgoPath, indexParameters);
        KinType currentKinType = remainingKinTypes.remove(0);
        for (String alterPath : egoData.getRelationPaths()) {
            try {
                EntityData alterNode;
                boolean relationAdded = false;
                if (createdGraphNodes.containsKey(alterPath)) {
                    alterNode = createdGraphNodes.get(alterPath);
                } else {
                    alterNode = this.getGraphDataNode(false, new URI(alterPath), indexParameters);
                    createdGraphNodes.put(alterPath, alterNode);
                    relationAdded = true;
                }
                IndexerEntityData alterData = this.getEntityData(currentEgoPath, indexParameters);
                this.setRelationData(egoNode, alterNode, egoData, alterPath, indexParameters);
                this.setRelationData(alterNode, egoNode, alterData, currentEgoPath, indexParameters);
                if (remainingKinTypes.size() <= 0) continue;
                this.getNextRelations(createdGraphNodes, alterPath, alterNode, remainingKinTypes, indexParameters);
            }
            catch (URISyntaxException urise) {
                // empty catch block
            }
        }
    }

    @Override
    public void clearAbortRequest() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void requestAbortProcess() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EntityData[] processKinTypeStrings(URI[] egoNodes, String[] kinTypeStrings, ParserHighlight[] parserHighlight, IndexerParameters indexParameters, DataStoreSvg dataStoreSvg, JProgressBar progressBar) throws EntityServiceException, ProcessAbortException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public EntityData[] getRelationsOfEgo(URI[] egoNodes, String[] uniqueIdentifiers, String[] kinTypeStrings, ParserHighlight[] parserHighlight, IndexerParameters indexParameters) throws EntityServiceException {
        KinTypeStringConverter kinTypeStringConverter = new KinTypeStringConverter(new DataStoreSvg());
        HashMap<String, EntityData> createdGraphNodes = new HashMap<String, EntityData>();
        for (URI currentEgoUri : egoNodes) {
            EntityData egoNode;
            if (createdGraphNodes.containsKey(currentEgoUri.toASCIIString())) {
                egoNode = (EntityData)createdGraphNodes.get(currentEgoUri.toASCIIString());
            } else {
                egoNode = this.getGraphDataNode(true, currentEgoUri, indexParameters);
                createdGraphNodes.put(currentEgoUri.toASCIIString(), egoNode);
            }
            if (kinTypeStrings == null) continue;
            for (String currentKinString : kinTypeStrings) {
                ArrayList<KinType> kinTypes = kinTypeStringConverter.getKinTypes(currentKinString);
                try {
                    this.getNextRelations(createdGraphNodes, currentEgoUri.toASCIIString(), egoNode, kinTypes, indexParameters);
                }
                catch (URISyntaxException exception) {
                    throw new EntityServiceException(exception.getMessage());
                }
            }
        }
        return createdGraphNodes.values().toArray(new EntityData[0]);
    }

    public static void main(String[] args) {
        boolean uriCounter = false;
        EntityIndex testEntityIndex = new EntityIndex();
        testEntityIndex.loadAllEntities(new IndexerParameters());
        testEntityIndex.printKnownEntities();
    }
}

