/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.util.ArrayList;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.kinnate.data.KinTreeNode;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class KinTree
extends ArbilTree {
    KinDiagramPanel kinDiagramPanel;
    GraphPanel graphPanel;

    public KinTree(KinDiagramPanel kinDiagramPanel, GraphPanel graphPanel) {
        this.kinDiagramPanel = kinDiagramPanel;
        this.graphPanel = graphPanel;
    }

    protected void putSelectionIntoPreviewTable() {
        ArbilNode[] arbilNodeArray = this.getAllSelectedNodes();
        ArrayList<UniqueIdentifier> identifierList = new ArrayList<UniqueIdentifier>();
        this.graphPanel.metadataPanel.removeAllArbilDataNodeRows();
        this.graphPanel.metadataPanel.removeAllEditors();
        for (ArbilNode arbilNode : arbilNodeArray) {
            if (arbilNode instanceof ArbilDataNode) {
                this.graphPanel.metadataPanel.addArbilDataNode((ArbilDataNode)arbilNode);
                continue;
            }
            if (!(arbilNode instanceof KinTreeNode)) continue;
            KinTreeNode kinTreeNode = (KinTreeNode)arbilNode;
            if (kinTreeNode.entityData == null) continue;
            identifierList.add(kinTreeNode.entityData.getUniqueIdentifier());
            this.graphPanel.metadataPanel.addEntityDataNode(this.kinDiagramPanel, ((KinTreeNode)arbilNode).entityData);
        }
        this.graphPanel.setSelectedIds(identifierList.toArray(new UniqueIdentifier[0]));
        this.graphPanel.metadataPanel.updateEditorPane();
    }
}

