/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindocument;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.KinOathVersion;
import nl.mpi.kinnate.kindocument.KinXsdException;
import nl.mpi.kinnate.userstorage.KinSessionStorage;

public class CmdiTransformer {
    private URL component2SchemaXsl = this.getClass().getResource("/xsd/comp2schema.xsl");
    private URL component2SchemaXslHeader = this.getClass().getResource("/xsd/comp2schema-header.xsl");
    private URL component2SchemaXslCleanup = this.getClass().getResource("/xsd/cleanup-xsd.xsl");
    private URL cmdi2kmdiXsl = this.getClass().getResource("/xsd/cmdi2kmdi.xsl");
    private SessionStorage sessionStorage;

    public CmdiTransformer(SessionStorage sessionStorage) {
        this.sessionStorage = sessionStorage;
    }

    public URI getXsdUrlString(String entityType) throws KinXsdException {
        String profileId = "clarin.eu:cr1:p_1320657629627";
        File xsdFile = new File(this.sessionStorage.getCacheDirectory(), entityType + "-" + profileId + ".xsd");
        try {
            if (!xsdFile.exists()) {
                this.transformProfileXmlToXsd(xsdFile, profileId);
            }
            return xsdFile.toURI();
        }
        catch (IOException exception) {
            System.out.println("exception: " + exception.getMessage());
            throw new KinXsdException();
        }
        catch (TransformerException exception) {
            System.out.println("exception: " + exception.getMessage());
            throw new KinXsdException();
        }
    }

    public File transformProfileXmlToXsd(File outputFile, String profileId) throws IOException, TransformerException {
        String cmdiProfileXmlUrl = "http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles/" + profileId + "/xml";
        System.out.println("outputFile: " + outputFile.getAbsolutePath());
        File xlsFile = this.sessionStorage.updateCache(this.component2SchemaXsl.toExternalForm(), 1, false);
        System.out.println(this.sessionStorage.updateCache(this.component2SchemaXslHeader.toExternalForm(), 1, false));
        System.out.println(this.sessionStorage.updateCache(this.component2SchemaXslCleanup.toExternalForm(), 1, false));
        File intermediateFile = new File(outputFile.getParentFile(), profileId + "-cmdi.xsd");
        System.out.println(intermediateFile);
        System.out.println(outputFile);
        this.generateXsd(xlsFile, cmdiProfileXmlUrl, intermediateFile);
        File cmdi2kmdiFile = this.sessionStorage.updateCache(this.cmdi2kmdiXsl.toExternalForm(), 1, false);
        this.generateXsd(cmdi2kmdiFile, intermediateFile.toURI().toString(), outputFile);
        return outputFile;
    }

    private void generateXsd(File xlsFile, String cmdiProfileXmlUrl, File outputFile) {
        Templates componentToSchemaTemplates;
        try {
            System.setProperty("javax.xml.transform.TransformerFactory", TransformerFactoryImpl.class.getName());
            componentToSchemaTemplates = TransformerFactory.newInstance().newTemplates(new StreamSource(xlsFile));
        }
        catch (TransformerConfigurationException e) {
            BugCatcherManager.getBugCatcher().logError("Cannot create Template", (Exception)e);
            return;
        }
        try {
            Transformer transformer = componentToSchemaTemplates.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            transformer.transform(new StreamSource(cmdiProfileXmlUrl), new StreamResult(new FileOutputStream(outputFile)));
        }
        catch (TransformerConfigurationException e) {
            BugCatcherManager.getBugCatcher().logError("Cannot create Transformer", (Exception)e);
        }
        catch (TransformerException e) {
            BugCatcherManager.getBugCatcher().logError("Cannot transform xml file: ", (Exception)e);
        }
        catch (FileNotFoundException e) {
            BugCatcherManager.getBugCatcher().logError((Exception)e);
        }
    }

    public static void main(String[] args) {
        try {
            String profileId = "clarin.eu:cr1:p_1320657629627";
            KinSessionStorage kinSessionStorage = new KinSessionStorage(new ApplicationVersionManager((ApplicationVersion)new KinOathVersion()));
            File xsdFile = new File(kinSessionStorage.getCacheDirectory(), "individual-" + profileId + ".xsd");
            new CmdiTransformer((SessionStorage)kinSessionStorage).transformProfileXmlToXsd(xsdFile, profileId);
        }
        catch (IOException exception) {
            System.out.println("exception: " + exception.getMessage());
        }
        catch (TransformerException exception) {
            System.out.println("exception: " + exception.getMessage());
        }
    }
}

