/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kindocument;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.kindocument.CmdiTransformer;
import nl.mpi.kinnate.ui.entityprofiles.CmdiProfileSelectionPanel;

public class ProfileManager {
    private SessionStorage sessionStorage;

    public ProfileManager(SessionStorage sessionStorage) {
        this.sessionStorage = sessionStorage;
    }

    public void loadProfiles(final boolean forceUpdate, final CmdiProfileSelectionPanel cmdiProfileSelectionPanel) {
        CmdiProfileReader.getSingleInstance().setSelection(CmdiProfileReader.ProfileSelection.ALL);
        cmdiProfileSelectionPanel.setStatus(false, "Loading, please wait...", false);
        new Thread("loadProfiles"){

            public void run() {
                ArrayList<String> problemProfiles = new ArrayList<String>();
                for (String profileId : new String[]{"clarin.eu:cr1:p_1320657629627"}) {
                    try {
                        cmdiProfileSelectionPanel.setStatus(false, "Loading: " + profileId + ", please wait...", false);
                        File xsdFile = new File(ProfileManager.this.sessionStorage.getCacheDirectory(), "individual-" + profileId + ".xsd");
                        if (xsdFile.exists() && !forceUpdate) continue;
                        new CmdiTransformer(ProfileManager.this.sessionStorage).transformProfileXmlToXsd(xsdFile, profileId);
                    }
                    catch (IOException exception) {
                        problemProfiles.add(profileId);
                        BugCatcherManager.getBugCatcher().logError((Exception)exception);
                    }
                    catch (TransformerException exception) {
                        problemProfiles.add(profileId);
                        BugCatcherManager.getBugCatcher().logError((Exception)exception);
                    }
                }
                cmdiProfileSelectionPanel.setStatus(false, "Loading the profile list from the server, please wait...", false);
                CmdiProfileReader cmdiProfileReader = CmdiProfileReader.getSingleInstance();
                cmdiProfileReader.refreshProfilesAndUpdateCache(cmdiProfileSelectionPanel.getProfileReloadProgressBar(), forceUpdate);
                cmdiProfileSelectionPanel.setCmdiProfileReader(cmdiProfileReader);
                if (!problemProfiles.isEmpty()) {
                    cmdiProfileSelectionPanel.setStatus(true, "There were " + problemProfiles.size() + " selected profiles that could not be retrieved", true);
                } else {
                    cmdiProfileSelectionPanel.setStatus(true, "", false);
                }
            }
        }.start();
    }
}

