/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kintypestrings;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import nl.mpi.kinnate.kintypestrings.KinTerm;

public class KinTermGroup {
    @XmlAttribute(name="GroupName", namespace="http://mpi.nl/tla/kin")
    public String titleString = "Kin Term Group (unnamed)";
    @XmlAttribute(name="GroupDescription", namespace="http://mpi.nl/tla/kin")
    public String descriptionString;
    @XmlAttribute(name="GroupColour", namespace="http://mpi.nl/tla/kin")
    public String graphColour = "#0000FF";
    @XmlAttribute(name="Show", namespace="http://mpi.nl/tla/kin")
    public boolean graphShow = true;
    @XmlAttribute(name="Generate", namespace="http://mpi.nl/tla/kin")
    public boolean graphGenerate = true;
    @XmlElement(name="KinTerm", namespace="http://mpi.nl/tla/kin")
    private ArrayList<KinTerm> kinTermArray = new ArrayList();

    public void addKinTerm(String kinTypeStrings, String kinTerm) {
        this.kinTermArray.add(new KinTerm(kinTerm, null, null, kinTypeStrings, null));
    }

    public void addKinTerm(KinTerm kinTerm) {
        this.kinTermArray.add(kinTerm);
    }

    public void updateKinTerm(String kinTypeStrings, String kinTerm) {
        for (KinTerm kinTermItem : this.kinTermArray) {
            if (!kinTermItem.kinTerm.equals(kinTerm)) continue;
            kinTermItem.alterKinTypeStrings = kinTypeStrings;
        }
    }

    public void removeKinTerm(String kinTerm) {
        for (KinTerm kinTermItem : this.getKinTerms()) {
            if (!kinTermItem.kinTerm.equals(kinTerm)) continue;
            this.kinTermArray.remove(kinTermItem);
        }
    }

    public void removeKinTerm(KinTerm kinTerm) {
        this.kinTermArray.remove(kinTerm);
    }

    public KinTerm[] getKinTerms() {
        return this.kinTermArray.toArray(new KinTerm[0]);
    }

    public String[] getTermLabel(String kinTypeString) {
        ArrayList<String> foundKinTerms = new ArrayList<String>();
        for (KinTerm kinTermItem : this.kinTermArray) {
            for (String kinType : kinTermItem.alterKinTypeStrings.split("\\|")) {
                if (!kinTypeString.trim().equals(kinType.trim())) continue;
                foundKinTerms.add(kinTermItem.kinTerm);
            }
        }
        return foundKinTerms.toArray(new String[0]);
    }
}

