/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashSet;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.KinTermSavePanel;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.RelationTypeDefinition;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.EntitySvg;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.GraphicsDragHandle;
import nl.mpi.kinnate.svg.LineLookUpTable;
import nl.mpi.kinnate.svg.RelationDragHandle;
import nl.mpi.kinnate.svg.RelationSvg;
import nl.mpi.kinnate.uniqueidentifiers.IdentifierException;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.apache.batik.bridge.UpdateManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGRect;

public class SvgUpdateHandler {
    private GraphPanel graphPanel;
    private KinTermSavePanel kinTermSavePanel;
    private MessageDialogHandler dialogHandler;
    private boolean dragUpdateRequired = false;
    private boolean threadRunning = false;
    private boolean relationThreadRunning = false;
    private int updateDragNodeX = 0;
    private int updateDragNodeY = 0;
    private int updateDragRelationX = 0;
    private int updateDragRelationY = 0;
    private float[][] dragRemainders = null;
    private boolean resizeRequired = false;
    protected RelationDragHandle relationDragHandle = null;
    private HashSet<UniqueIdentifier> highlightedIdentifiers = new HashSet();

    public SvgUpdateHandler(GraphPanel graphPanel, KinTermSavePanel kinTermSavePanel, MessageDialogHandler dialogHandler) {
        this.graphPanel = graphPanel;
        this.kinTermSavePanel = kinTermSavePanel;
        this.dialogHandler = dialogHandler;
    }

    public void clearHighlights() {
        this.removeRelationHighLights();
        for (UniqueIdentifier currentIdentifier : this.highlightedIdentifiers.toArray(new UniqueIdentifier[0])) {
            Element existingHighlight = this.graphPanel.doc.getElementById("highlight_" + currentIdentifier.getAttributeIdentifier());
            if (existingHighlight != null) {
                existingHighlight.getParentNode().removeChild(existingHighlight);
            }
            this.highlightedIdentifiers.remove(currentIdentifier);
        }
    }

    private void removeRelationHighLights() {
        Element relationOldHighlightGroup = this.graphPanel.doc.getElementById("RelationHighlightGroup");
        if (relationOldHighlightGroup != null) {
            relationOldHighlightGroup.getParentNode().removeChild(relationOldHighlightGroup);
        }
    }

    private void removeEntityHighLights() {
        Element entityHighlightGroup = this.graphPanel.doc.getElementById("highlight");
        while (entityHighlightGroup != null) {
            entityHighlightGroup.getParentNode().removeChild(entityHighlightGroup);
            entityHighlightGroup = this.graphPanel.doc.getElementById("highlight");
        }
    }

    private void updateSanguineHighlights(Element entityGroup) {
        this.removeRelationHighLights();
        if (this.graphPanel.dataStoreSvg.highlightRelationLines) {
            Element relationHighlightGroup = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "g");
            relationHighlightGroup.setAttribute("id", "RelationHighlightGroup");
            entityGroup.getParentNode().insertBefore(relationHighlightGroup, entityGroup);
            Element relationsGroup = this.graphPanel.doc.getElementById("RelationGroup");
            for (Node currentRelation = relationsGroup.getFirstChild(); currentRelation != null; currentRelation = currentRelation.getNextSibling()) {
                NamedNodeMap dataAttributes;
                Node dataElement = currentRelation.getFirstChild();
                if (dataElement == null || !dataElement.hasAttributes() || !DataTypes.isSanguinLine((dataAttributes = dataElement.getAttributes()).getNamedItemNS(DataStoreSvg.kinDataNameSpace, "relationType").getNodeValue())) continue;
                Element polyLineElement = (Element)dataElement.getNextSibling().getFirstChild();
                try {
                    if (!this.graphPanel.selectedGroupId.contains(new UniqueIdentifier(dataAttributes.getNamedItemNS(DataStoreSvg.kinDataNameSpace, "ego").getNodeValue())) && !this.graphPanel.selectedGroupId.contains(new UniqueIdentifier(dataAttributes.getNamedItemNS(DataStoreSvg.kinDataNameSpace, "alter").getNodeValue()))) continue;
                    Element highlightBackgroundLine = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "polyline");
                    highlightBackgroundLine.setAttribute("stroke-width", polyLineElement.getAttribute("stroke-width"));
                    highlightBackgroundLine.setAttribute("fill", polyLineElement.getAttribute("fill"));
                    highlightBackgroundLine.setAttribute("points", polyLineElement.getAttribute("points"));
                    highlightBackgroundLine.setAttribute("stroke", "white");
                    relationHighlightGroup.appendChild(highlightBackgroundLine);
                    Element highlightLine = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "polyline");
                    highlightLine.setAttribute("stroke-width", polyLineElement.getAttribute("stroke-width"));
                    highlightLine.setAttribute("fill", polyLineElement.getAttribute("fill"));
                    highlightLine.setAttribute("points", polyLineElement.getAttribute("points"));
                    highlightLine.setAttribute("stroke", "blue");
                    highlightLine.setAttribute("stroke-dasharray", "3");
                    highlightLine.setAttribute("stroke-dashoffset", "0");
                    relationHighlightGroup.appendChild(highlightLine);
                    continue;
                }
                catch (IdentifierException exception) {
                    BugCatcherManager.getBugCatcher().logError((Exception)exception);
                    this.dialogHandler.addMessageDialogToQueue("Failed to read relation data, highlight might not be correct", "Sanguine Highlights");
                }
            }
        }
    }

    private void updateDragRelationLines(Element entityGroup, float localDragNodeX, float localDragNodeY) {
        RelationDragHandle localRelationDragHandle = this.relationDragHandle;
        if (localRelationDragHandle != null) {
            if (localRelationDragHandle instanceof GraphicsDragHandle) {
                ((GraphicsDragHandle)localRelationDragHandle).updatedElement(localDragNodeX, localDragNodeY);
            } else {
                float dragNodeX = localRelationDragHandle.getTranslatedX(localDragNodeX);
                float dragNodeY = localRelationDragHandle.getTranslatedY(localDragNodeY);
                localRelationDragHandle.targetIdentifier = this.graphPanel.entitySvg.getClosestEntity(new float[]{dragNodeX, dragNodeY}, 30, this.graphPanel.selectedGroupId);
                if (localRelationDragHandle.targetIdentifier != null) {
                    float[] closestEntityPoint = this.graphPanel.entitySvg.getEntityLocation(localRelationDragHandle.targetIdentifier);
                    dragNodeX = closestEntityPoint[0];
                    dragNodeY = closestEntityPoint[1];
                }
                Element relationHighlightGroup = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "g");
                relationHighlightGroup.setAttribute("id", "RelationHighlightGroup");
                entityGroup.getParentNode().insertBefore(relationHighlightGroup, entityGroup);
                float vSpacing = this.graphPanel.graphPanelSize.getVerticalSpacing();
                float hSpacing = this.graphPanel.graphPanelSize.getHorizontalSpacing();
                for (UniqueIdentifier uniqueIdentifier : this.graphPanel.selectedGroupId) {
                    float[] parentPoint;
                    float[] dragPoint;
                    float[] egoSymbolPoint;
                    String dragLineElementId = "dragLine-" + uniqueIdentifier.getAttributeIdentifier();
                    DataTypes.RelationType directedRelation = localRelationDragHandle.getRelationType();
                    if (directedRelation == DataTypes.RelationType.descendant) {
                        egoSymbolPoint = new float[]{dragNodeX, dragNodeY};
                        parentPoint = dragPoint = this.graphPanel.entitySvg.getEntityLocation(uniqueIdentifier);
                        directedRelation = DataTypes.RelationType.ancestor;
                    } else {
                        egoSymbolPoint = this.graphPanel.entitySvg.getEntityLocation(uniqueIdentifier);
                        parentPoint = dragPoint = new float[]{dragNodeX, dragNodeY};
                    }
                    String svgLineType = DataTypes.isSanguinLine(directedRelation) ? "polyline" : "path";
                    Element highlightBackgroundLine = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, svgLineType);
                    highlightBackgroundLine.setAttribute("stroke-width", Integer.toString(EntitySvg.strokeWidth));
                    highlightBackgroundLine.setAttribute("fill", "none");
                    highlightBackgroundLine.setAttribute("stroke", "white");
                    if (DataTypes.isSanguinLine(directedRelation)) {
                        new RelationSvg(this.dialogHandler).setPolylinePointsAttribute(null, dragLineElementId, highlightBackgroundLine, directedRelation, vSpacing, egoSymbolPoint[0], egoSymbolPoint[1], dragPoint[0], dragPoint[1], parentPoint);
                    } else {
                        new RelationSvg(this.dialogHandler).setPathPointsAttribute(highlightBackgroundLine, localRelationDragHandle.getCurveLineOrientation(), hSpacing, vSpacing, egoSymbolPoint[0], egoSymbolPoint[1], dragPoint[0], dragPoint[1]);
                    }
                    relationHighlightGroup.appendChild(highlightBackgroundLine);
                    Element highlightLine = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, svgLineType);
                    highlightLine.setAttribute("stroke-width", Integer.toString(EntitySvg.strokeWidth));
                    highlightLine.setAttribute("fill", "none");
                    if (DataTypes.isSanguinLine(directedRelation)) {
                        new RelationSvg(this.dialogHandler).setPolylinePointsAttribute(null, dragLineElementId, highlightLine, directedRelation, vSpacing, egoSymbolPoint[0], egoSymbolPoint[1], dragPoint[0], dragPoint[1], parentPoint);
                    } else {
                        new RelationSvg(this.dialogHandler).setPathPointsAttribute(highlightLine, localRelationDragHandle.getCurveLineOrientation(), hSpacing, vSpacing, egoSymbolPoint[0], egoSymbolPoint[1], dragPoint[0], dragPoint[1]);
                    }
                    highlightLine.setAttribute("stroke", localRelationDragHandle.getRelationColour());
                    highlightLine.setAttribute("stroke-dasharray", "3");
                    highlightLine.setAttribute("stroke-dashoffset", "0");
                    relationHighlightGroup.appendChild(highlightLine);
                }
                Element symbolNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "circle");
                symbolNode.setAttribute("cx", Float.toString(dragNodeX));
                symbolNode.setAttribute("cy", Float.toString(dragNodeY));
                symbolNode.setAttribute("r", "5");
                symbolNode.setAttribute("fill", localRelationDragHandle.getRelationColour());
                symbolNode.setAttribute("stroke", "none");
                relationHighlightGroup.appendChild(symbolNode);
            }
        }
    }

    protected void addRelationDragHandles(RelationTypeDefinition[] relationTypeDefinitions, Element highlightGroupNode, SVGRect bbox, int paddingDistance) {
        float minCY;
        for (DataTypes.RelationType relationType : new DataTypes.RelationType[]{DataTypes.RelationType.ancestor, DataTypes.RelationType.descendant}) {
            Element symbolNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "circle");
            symbolNode.setAttribute("cx", Float.toString(bbox.getX() + bbox.getWidth() / 2.0f));
            switch (relationType) {
                case ancestor: {
                    symbolNode.setAttribute("cy", Float.toString(bbox.getY() - (float)paddingDistance));
                    break;
                }
                case descendant: {
                    symbolNode.setAttribute("cy", Float.toString(bbox.getY() + bbox.getHeight() + (float)paddingDistance));
                }
            }
            symbolNode.setAttribute("r", "5");
            symbolNode.setAttribute("handletype", relationType.name());
            symbolNode.setAttribute("fill", "blue");
            symbolNode.setAttribute("stroke", "none");
            ((EventTarget)((Object)symbolNode)).addEventListener("mousedown", this.graphPanel.mouseListenerSvg, false);
            highlightGroupNode.appendChild(symbolNode);
        }
        float currentCX = bbox.getX() + bbox.getWidth() + (float)paddingDistance;
        float currentCY = minCY = bbox.getY() - (float)paddingDistance;
        float stepC = 12.0f;
        float maxCY = bbox.getHeight() + (float)paddingDistance;
        for (RelationTypeDefinition typeDefinition : relationTypeDefinitions) {
            Element symbolNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "circle");
            symbolNode.setAttribute("cx", Float.toString(currentCX));
            symbolNode.setAttribute("cy", Float.toString(currentCY));
            currentCY += stepC;
            if (currentCY >= maxCY) {
                currentCY = minCY;
                currentCX += stepC;
            }
            symbolNode.setAttribute("r", "5");
            symbolNode.setAttribute("handletype", "custom:" + typeDefinition.hashCode());
            symbolNode.setAttribute("fill", typeDefinition.getLineColour());
            symbolNode.setAttribute("stroke", "none");
            ((EventTarget)((Object)symbolNode)).addEventListener("mousedown", this.graphPanel.mouseListenerSvg, false);
            highlightGroupNode.appendChild(symbolNode);
        }
    }

    protected void addGraphicsDragHandles(Element highlightGroupNode, UniqueIdentifier targetIdentifier, SVGRect bbox, int paddingDistance) {
        Element symbolNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "circle");
        symbolNode.setAttribute("cx", Float.toString(bbox.getX() + bbox.getWidth() + (float)paddingDistance));
        symbolNode.setAttribute("cy", Float.toString(bbox.getY() + bbox.getHeight() + (float)paddingDistance));
        symbolNode.setAttribute("r", "5");
        symbolNode.setAttribute("target", targetIdentifier.getAttributeIdentifier());
        symbolNode.setAttribute("fill", "blue");
        symbolNode.setAttribute("stroke", "none");
        ((EventTarget)((Object)symbolNode)).addEventListener("mousedown", this.graphPanel.mouseListenerSvg, false);
        highlightGroupNode.appendChild(symbolNode);
    }

    protected void updateSvgSelectionHighlights() {
        UpdateManager updateManager;
        if (this.kinTermSavePanel != null) {
            String kinTypeStrings = "";
            for (UniqueIdentifier entityID : this.graphPanel.selectedGroupId) {
                if (kinTypeStrings.length() != 0) {
                    kinTypeStrings = kinTypeStrings + "|";
                }
                kinTypeStrings = kinTypeStrings + this.graphPanel.getKinTypeForElementId(entityID);
            }
            if (kinTypeStrings != null) {
                this.kinTermSavePanel.setSelectedKinTypeSting(kinTypeStrings);
            }
        }
        if ((updateManager = this.graphPanel.svgCanvas.getUpdateManager()) != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                public void run() {
                    if (((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc != null) {
                        boolean isLeadSelection = true;
                        for (UniqueIdentifier currentIdentifier : SvgUpdateHandler.this.highlightedIdentifiers.toArray(new UniqueIdentifier[0])) {
                            if (((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.selectedGroupId.contains(currentIdentifier)) continue;
                            Element existingHighlight = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("highlight_" + currentIdentifier.getAttributeIdentifier());
                            if (existingHighlight != null) {
                                existingHighlight.getParentNode().removeChild(existingHighlight);
                            }
                            SvgUpdateHandler.this.highlightedIdentifiers.remove(currentIdentifier);
                        }
                        for (UniqueIdentifier uniqueIdentifier : ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.selectedGroupId) {
                            Element selectedGroup = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById(uniqueIdentifier.getAttributeIdentifier());
                            Element existingHighlight = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("highlight_" + uniqueIdentifier.getAttributeIdentifier());
                            if (existingHighlight == null && selectedGroup != null) {
                                SVGRect bbox = ((SVGLocatable)selectedGroup).getBBox();
                                Element highlightGroupNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "g");
                                ((EventTarget)((Object)highlightGroupNode)).addEventListener("mousedown", ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.mouseListenerSvg, false);
                                highlightGroupNode.setAttribute("id", "highlight_" + uniqueIdentifier.getAttributeIdentifier());
                                Element symbolNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "rect");
                                int paddingDistance = 20;
                                symbolNode.setAttribute("x", Float.toString(bbox.getX() - (float)paddingDistance));
                                symbolNode.setAttribute("y", Float.toString(bbox.getY() - (float)paddingDistance));
                                symbolNode.setAttribute("width", Float.toString(bbox.getWidth() + (float)(paddingDistance * 2)));
                                symbolNode.setAttribute("height", Float.toString(bbox.getHeight() + (float)(paddingDistance * 2)));
                                symbolNode.setAttribute("fill", "#999999");
                                symbolNode.setAttribute("fill-opacity", "0");
                                symbolNode.setAttribute("stroke-width", "1");
                                if (isLeadSelection) {
                                    symbolNode.setAttribute("stroke-dasharray", "3");
                                    symbolNode.setAttribute("stroke-dashoffset", "0");
                                } else {
                                    symbolNode.setAttribute("stroke-dasharray", "6");
                                    symbolNode.setAttribute("stroke-dashoffset", "0");
                                }
                                symbolNode.setAttribute("stroke", "blue");
                                highlightGroupNode.appendChild(symbolNode);
                                if (selectedGroup.getAttributeNS(DataStoreSvg.kinDataNameSpaceLocation, "path").length() > 0) {
                                    SvgUpdateHandler.this.addRelationDragHandles(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.dataStoreSvg.getRelationTypeDefinitions(), highlightGroupNode, bbox, paddingDistance);
                                } else if (uniqueIdentifier.isGraphicsIdentifier() && !"text".equals(selectedGroup.getLocalName())) {
                                    SvgUpdateHandler.this.addGraphicsDragHandles(highlightGroupNode, uniqueIdentifier, bbox, paddingDistance);
                                }
                                if ("g".equals(selectedGroup.getLocalName())) {
                                    selectedGroup.appendChild(highlightGroupNode);
                                } else {
                                    highlightGroupNode.setAttribute("transform", selectedGroup.getAttribute("transform"));
                                    selectedGroup.getParentNode().appendChild(highlightGroupNode);
                                }
                                SvgUpdateHandler.this.highlightedIdentifiers.add(uniqueIdentifier);
                            }
                            isLeadSelection = false;
                        }
                        SvgUpdateHandler.this.updateSanguineHighlights(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("EntityGroup"));
                    }
                }
            });
        }
    }

    protected void dragCanvas(int updateDragNodeXLocal, int updateDragNodeYLocal) {
        AffineTransform at = new AffineTransform();
        at.translate(updateDragNodeXLocal, updateDragNodeYLocal);
        at.concatenate(this.graphPanel.svgCanvas.getRenderingTransform());
        this.graphPanel.svgCanvas.setRenderingTransform(at);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDragRelation(int updateDragNodeXLocal, int updateDragNodeYLocal) {
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        SvgUpdateHandler svgUpdateHandler = this;
        synchronized (svgUpdateHandler) {
            this.updateDragRelationX = updateDragNodeXLocal;
            this.updateDragRelationY = updateDragNodeYLocal;
            if (!this.relationThreadRunning) {
                this.relationThreadRunning = true;
                updateManager.getUpdateRunnableQueue().invokeLater(this.getRelationRunnable());
            }
        }
    }

    private Runnable getRelationRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SvgUpdateHandler svgUpdateHandler;
                Element entityGroup = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("EntityGroup");
                int updateDragNodeXLocal = 0;
                int updateDragNodeYLocal = 0;
                while (updateDragNodeXLocal != SvgUpdateHandler.this.updateDragRelationX && updateDragNodeYLocal != SvgUpdateHandler.this.updateDragRelationY) {
                    svgUpdateHandler = SvgUpdateHandler.this;
                    synchronized (svgUpdateHandler) {
                        updateDragNodeXLocal = SvgUpdateHandler.this.updateDragRelationX;
                        updateDragNodeYLocal = SvgUpdateHandler.this.updateDragRelationY;
                    }
                    SvgUpdateHandler.this.removeRelationHighLights();
                    SvgUpdateHandler.this.removeEntityHighLights();
                    SvgUpdateHandler.this.updateDragRelationLines(entityGroup, updateDragNodeXLocal, updateDragNodeYLocal);
                }
                svgUpdateHandler = SvgUpdateHandler.this;
                synchronized (svgUpdateHandler) {
                    SvgUpdateHandler.this.relationThreadRunning = false;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startDrag() {
        float[][] tempRemainders = new float[this.graphPanel.selectedGroupId.size()][];
        for (int dragCounter = 0; dragCounter < tempRemainders.length; ++dragCounter) {
            tempRemainders[dragCounter] = new float[]{0.0f, 0.0f};
        }
        SvgUpdateHandler svgUpdateHandler = this;
        synchronized (svgUpdateHandler) {
            this.dragRemainders = tempRemainders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDragNode(int updateDragNodeXLocal, int updateDragNodeYLocal) {
        this.resizeRequired = true;
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        SvgUpdateHandler svgUpdateHandler = this;
        synchronized (svgUpdateHandler) {
            this.dragUpdateRequired = true;
            this.updateDragNodeX += updateDragNodeXLocal;
            this.updateDragNodeY += updateDragNodeYLocal;
            if (!this.threadRunning) {
                this.threadRunning = true;
                updateManager.getUpdateRunnableQueue().invokeLater(this.getRunnable());
            }
        }
    }

    private Runnable getRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Element entityGroup = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("EntityGroup");
                boolean continueUpdating = true;
                while (continueUpdating) {
                    int updateDragNodeYInner;
                    int updateDragNodeXInner;
                    continueUpdating = false;
                    SvgUpdateHandler svgUpdateHandler = SvgUpdateHandler.this;
                    synchronized (svgUpdateHandler) {
                        SvgUpdateHandler.this.dragUpdateRequired = false;
                        updateDragNodeXInner = SvgUpdateHandler.this.updateDragNodeX;
                        updateDragNodeYInner = SvgUpdateHandler.this.updateDragNodeY;
                        SvgUpdateHandler.this.updateDragNodeX = 0;
                        SvgUpdateHandler.this.updateDragNodeY = 0;
                    }
                    if (((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc == null || ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.dataStoreSvg.graphData == null) {
                        BugCatcherManager.getBugCatcher().logError(new Exception("graphData or the svg document is null, is this an old file format? try redrawing before draging."));
                    } else {
                        boolean allRealtionsSelected = true;
                        block10: for (EntityData selectedEntity : ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.dataStoreSvg.graphData.getDataNodes()) {
                            if (!selectedEntity.isVisible || !((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.selectedGroupId.contains(selectedEntity.getUniqueIdentifier())) continue;
                            for (EntityData relatedEntity : selectedEntity.getVisiblyRelated()) {
                                if (!relatedEntity.isVisible || ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.selectedGroupId.contains(relatedEntity.getUniqueIdentifier())) continue;
                                allRealtionsSelected = false;
                                break block10;
                            }
                        }
                        int dragCounter = 0;
                        for (UniqueIdentifier entityId : ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.selectedGroupId) {
                            SvgUpdateHandler svgUpdateHandler2 = SvgUpdateHandler.this;
                            synchronized (svgUpdateHandler2) {
                                if (SvgUpdateHandler.this.dragRemainders.length > dragCounter) {
                                    ((SvgUpdateHandler)SvgUpdateHandler.this).dragRemainders[dragCounter] = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.entitySvg.moveEntity(SvgUpdateHandler.this.graphPanel, entityId, (float)updateDragNodeXInner + SvgUpdateHandler.this.dragRemainders[dragCounter][0], (float)updateDragNodeYInner + SvgUpdateHandler.this.dragRemainders[dragCounter][1], ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.dataStoreSvg.snapToGrid, allRealtionsSelected);
                                }
                            }
                            ++dragCounter;
                        }
                        int vSpacing = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.graphPanelSize.getVerticalSpacing();
                        int hSpacing = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.graphPanelSize.getHorizontalSpacing();
                        new RelationSvg(SvgUpdateHandler.this.dialogHandler).updateRelationLines(SvgUpdateHandler.this.graphPanel, ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.selectedGroupId, hSpacing, vSpacing);
                        SvgUpdateHandler.this.updateSanguineHighlights(entityGroup);
                    }
                    svgUpdateHandler = SvgUpdateHandler.this;
                    synchronized (svgUpdateHandler) {
                        continueUpdating = SvgUpdateHandler.this.dragUpdateRequired;
                        if (!continueUpdating) {
                            SvgUpdateHandler.this.threadRunning = false;
                        }
                    }
                }
                SvgUpdateHandler.this.graphPanel.setRequiresSave();
            }
        };
    }

    private void resizeCanvas(Element svgRoot, Element diagramGroupNode) {
        Rectangle graphSize = this.graphPanel.dataStoreSvg.graphData.getGraphSize(this.graphPanel.entitySvg.entityPositions);
        diagramGroupNode.setAttribute("transform", "translate(" + Integer.toString(-graphSize.x) + ", " + Integer.toString(-graphSize.y) + ")");
        svgRoot.setAttribute("width", Integer.toString(graphSize.width - graphSize.x));
        svgRoot.setAttribute("height", Integer.toString(graphSize.height - graphSize.y));
        if (this.graphPanel.dataStoreSvg.showDiagramBorder) {
            Element pageBorderNode = this.graphPanel.doc.getElementById("PageBorder");
            if (pageBorderNode == null) {
                pageBorderNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "rect");
                pageBorderNode.setAttribute("id", "PageBorder");
                pageBorderNode.setAttribute("x", Float.toString(graphSize.x + 2));
                pageBorderNode.setAttribute("y", Float.toString(graphSize.y + 2));
                pageBorderNode.setAttribute("width", Float.toString(graphSize.width - graphSize.x - 4));
                pageBorderNode.setAttribute("height", Float.toString(graphSize.height - graphSize.y - 4));
                pageBorderNode.setAttribute("fill", "none");
                pageBorderNode.setAttribute("stroke-width", "2");
                pageBorderNode.setAttribute("stroke", "grey");
                diagramGroupNode.appendChild(pageBorderNode);
            } else {
                pageBorderNode.setAttribute("x", Float.toString(graphSize.x + 2));
                pageBorderNode.setAttribute("y", Float.toString(graphSize.y + 2));
                pageBorderNode.setAttribute("width", Float.toString(graphSize.width - graphSize.x - 4));
                pageBorderNode.setAttribute("height", Float.toString(graphSize.height - graphSize.y - 4));
            }
        } else {
            Element pageBorderNode = this.graphPanel.doc.getElementById("PageBorder");
            if (pageBorderNode != null) {
                pageBorderNode.getParentNode().removeChild(pageBorderNode);
            }
        }
    }

    public void updateCanvasSize() {
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                public void run() {
                    if (SvgUpdateHandler.this.resizeRequired) {
                        SvgUpdateHandler.this.resizeRequired = false;
                        Element svgRoot = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getDocumentElement();
                        Element diagramGroupNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("DiagramGroup");
                        SvgUpdateHandler.this.resizeCanvas(svgRoot, diagramGroupNode);
                    }
                }
            });
        }
    }

    public void addGraphics(final GraphicsTypes graphicsType, float xPos, float yPos) {
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                public void run() {
                    Element labelText;
                    Rectangle graphSize = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.dataStoreSvg.graphData.getGraphSize(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.entitySvg.entityPositions);
                    switch (graphicsType) {
                        case Circle: {
                            labelText = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "circle");
                            labelText.setAttribute("r", "100");
                            labelText.setAttribute("fill", "#ffffff");
                            labelText.setAttribute("stroke", "#000000");
                            labelText.setAttribute("stroke-width", "2");
                            break;
                        }
                        case Ellipse: {
                            labelText = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "ellipse");
                            labelText.setAttribute("rx", "100");
                            labelText.setAttribute("ry", "100");
                            labelText.setAttribute("fill", "#ffffff");
                            labelText.setAttribute("stroke", "#000000");
                            labelText.setAttribute("stroke-width", "2");
                            break;
                        }
                        case Label: {
                            labelText = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "text");
                            labelText.setAttribute("fill", "#000000");
                            labelText.setAttribute("stroke-width", "0");
                            labelText.setAttribute("font-size", "28");
                            Text textNode = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createTextNode("Label");
                            labelText.appendChild(textNode);
                            break;
                        }
                        case Polyline: {
                            labelText = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "polyline");
                            break;
                        }
                        case Square: {
                            labelText = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.createElementNS(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.svgNameSpace, "rect");
                            labelText.setAttribute("width", "100");
                            labelText.setAttribute("height", "100");
                            labelText.setAttribute("fill", "#ffffff");
                            labelText.setAttribute("stroke", "#000000");
                            labelText.setAttribute("stroke-width", "2");
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    UniqueIdentifier labelId = new UniqueIdentifier(UniqueIdentifier.IdentifierType.gid);
                    float[] labelPosition = new float[]{graphSize.x + graphSize.width / 2, graphSize.y + graphSize.height / 2};
                    labelText.setAttribute("id", labelId.getAttributeIdentifier());
                    labelText.setAttribute("transform", "translate(" + Float.toString(labelPosition[0]) + ", " + Float.toString(labelPosition[1]) + ")");
                    if (graphicsType.equals((Object)GraphicsTypes.Label)) {
                        Element labelGroup = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("LabelsGroup");
                        labelGroup.appendChild(labelText);
                    } else {
                        Element graphicsGroup = ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("GraphicsGroup");
                        graphicsGroup.appendChild(labelText);
                    }
                    ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.entitySvg.entityPositions.put(labelId, labelPosition);
                    ((EventTarget)((Object)labelText)).addEventListener("mousedown", ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.mouseListenerSvg, false);
                    SvgUpdateHandler.this.resizeCanvas(((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getDocumentElement(), ((SvgUpdateHandler)SvgUpdateHandler.this).graphPanel.doc.getElementById("DiagramGroup"));
                }
            });
        }
    }

    public void updateEntities() {
        UpdateManager updateManager = this.graphPanel.svgCanvas.getUpdateManager();
        if (updateManager != null) {
            updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(){

                public void run() {
                    SvgUpdateHandler.this.drawEntities();
                }
            });
        } else {
            this.drawEntities();
        }
    }

    public void drawEntities() {
        this.graphPanel.dataStoreSvg.graphData.setPadding(this.graphPanel.graphPanelSize);
        this.graphPanel.lineLookUpTable = new LineLookUpTable();
        int vSpacing = this.graphPanel.graphPanelSize.getVerticalSpacing();
        int hSpacing = this.graphPanel.graphPanelSize.getHorizontalSpacing();
        try {
            Element labelsGroup;
            this.removeRelationHighLights();
            Element svgRoot = this.graphPanel.doc.getDocumentElement();
            Element diagramGroupNode = this.graphPanel.doc.getElementById("DiagramGroup");
            if (diagramGroupNode == null) {
                diagramGroupNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "g");
                diagramGroupNode.setAttribute("id", "DiagramGroup");
                svgRoot.appendChild(diagramGroupNode);
            }
            if ((labelsGroup = this.graphPanel.doc.getElementById("LabelsGroup")) == null) {
                labelsGroup = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "g");
                labelsGroup.setAttribute("id", "LabelsGroup");
                diagramGroupNode.appendChild(labelsGroup);
            } else if (!labelsGroup.getParentNode().equals(diagramGroupNode)) {
                labelsGroup.getParentNode().removeChild(labelsGroup);
                diagramGroupNode.appendChild(labelsGroup);
            }
            Element relationGroupNodeOld = this.graphPanel.doc.getElementById("RelationGroup");
            Element entityGroupNodeOld = this.graphPanel.doc.getElementById("EntityGroup");
            Element relationGroupNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "g");
            relationGroupNode.setAttribute("id", "RelationGroup");
            diagramGroupNode.insertBefore(relationGroupNode, labelsGroup);
            if (relationGroupNodeOld != null) {
                relationGroupNodeOld.getParentNode().removeChild(relationGroupNodeOld);
            }
            Element entityGroupNode = this.graphPanel.doc.createElementNS(this.graphPanel.svgNameSpace, "g");
            entityGroupNode.setAttribute("id", "EntityGroup");
            diagramGroupNode.insertBefore(entityGroupNode, labelsGroup);
            if (entityGroupNodeOld != null) {
                entityGroupNodeOld.getParentNode().removeChild(entityGroupNodeOld);
            }
            NodeList dataNodes = this.graphPanel.doc.getElementsByTagNameNS("http://mpi.nl/tla/kin", "KinDiagramData");
            for (int nodeCounter = 0; nodeCounter < dataNodes.getLength(); ++nodeCounter) {
                dataNodes.item(nodeCounter).getParentNode().removeChild(dataNodes.item(nodeCounter));
            }
            this.graphPanel.dataStoreSvg.graphData.placeAllNodes(this.graphPanel.entitySvg.entityPositions);
            this.resizeCanvas(svgRoot, diagramGroupNode);
            this.graphPanel.dataStoreSvg.storeAllData(this.graphPanel.doc);
            for (EntityData currentNode : this.graphPanel.dataStoreSvg.graphData.getDataNodes()) {
                if (!currentNode.isVisible) continue;
                entityGroupNode.appendChild(this.graphPanel.entitySvg.createEntitySymbol(this.graphPanel, currentNode));
            }
            RelationSvg relationSvg = new RelationSvg(this.dialogHandler);
            ArrayList<String> doneRelations = new ArrayList<String>();
            for (EntityData currentNode : this.graphPanel.dataStoreSvg.graphData.getDataNodes()) {
                if (!currentNode.isVisible) continue;
                for (EntityRelation graphLinkNode : currentNode.getAllRelations()) {
                    EntityData rightEntity;
                    EntityData leftEntity;
                    if (!this.graphPanel.dataStoreSvg.showKinTermLines && graphLinkNode.getRelationType() == DataTypes.RelationType.kinterm || !this.graphPanel.dataStoreSvg.showSanguineLines && DataTypes.isSanguinLine(graphLinkNode.getRelationType()) || graphLinkNode.getAlterNode() == null || !graphLinkNode.getAlterNode().isVisible) continue;
                    DataTypes.RelationType directedRelation = graphLinkNode.getRelationType();
                    if (graphLinkNode.getRelationType() == DataTypes.RelationType.descendant) {
                        directedRelation = DataTypes.RelationType.ancestor;
                        leftEntity = graphLinkNode.getAlterNode();
                        rightEntity = currentNode;
                    } else if (graphLinkNode.getRelationType() == DataTypes.RelationType.ancestor) {
                        leftEntity = currentNode;
                        rightEntity = graphLinkNode.getAlterNode();
                    } else if (currentNode.getUniqueIdentifier().getQueryIdentifier().compareTo(graphLinkNode.getAlterNode().getUniqueIdentifier().getQueryIdentifier()) > 0) {
                        leftEntity = graphLinkNode.getAlterNode();
                        rightEntity = currentNode;
                    } else {
                        leftEntity = currentNode;
                        rightEntity = graphLinkNode.getAlterNode();
                    }
                    String compoundIdentifier = leftEntity.getUniqueIdentifier().getQueryIdentifier() + rightEntity.getUniqueIdentifier().getQueryIdentifier() + directedRelation.name() + ":" + graphLinkNode.dcrType + ":" + graphLinkNode.customType;
                    if (doneRelations.contains(compoundIdentifier)) continue;
                    boolean skipCurrentRelation = false;
                    if (DataTypes.isSanguinLine(graphLinkNode.getRelationType()) && relationSvg.hasCommonParent(leftEntity, graphLinkNode)) {
                        skipCurrentRelation = true;
                    }
                    if (skipCurrentRelation) continue;
                    doneRelations.add(compoundIdentifier);
                    String lineColour = graphLinkNode.lineColour;
                    RelationTypeDefinition.CurveLineOrientation curveLineOrientation = RelationTypeDefinition.CurveLineOrientation.horizontal;
                    int lineWidth = EntitySvg.strokeWidth;
                    if (lineColour == null) {
                        for (RelationTypeDefinition relationTypeDefinition : this.graphPanel.dataStoreSvg.getRelationTypeDefinitions()) {
                            if (!relationTypeDefinition.matchesType(graphLinkNode)) continue;
                            lineColour = relationTypeDefinition.getLineColour();
                            lineWidth = relationTypeDefinition.getLineWidth();
                            curveLineOrientation = relationTypeDefinition.getCurveLineOrientation();
                            break;
                        }
                    }
                    relationSvg.insertRelation(this.graphPanel, relationGroupNode, leftEntity, rightEntity, directedRelation, lineWidth, curveLineOrientation, lineColour, graphLinkNode.labelString, hSpacing, vSpacing);
                }
            }
        }
        catch (DOMException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
        }
        this.graphPanel.svgCanvas.repaint();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GraphicsTypes {
        Label,
        Circle,
        Square,
        Polyline,
        Ellipse;

    }
}

