/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.data.KinTreeNode;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.kindata.EntityData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateEditorPanel
extends JPanel {
    JPanel outerPanel;
    private IndexerParameters indexerParameters;
    private MessageDialogHandler dialogHandler;
    private EntityCollection entityCollection;
    private ArbilDataNodeLoader dataNodeLoader;

    public DateEditorPanel(IndexerParameters indexerParameters, MessageDialogHandler dialogHandler, EntityCollection entityCollection, ArbilDataNodeLoader dataNodeLoader) {
        this.indexerParameters = indexerParameters;
        this.dialogHandler = dialogHandler;
        this.entityCollection = entityCollection;
        this.dataNodeLoader = dataNodeLoader;
        this.setLayout(new BorderLayout());
        this.outerPanel = new JPanel(new GridLayout(0, 1));
        JPanel sideWrapperPanel = new JPanel(new BorderLayout());
        sideWrapperPanel.add((Component)this.outerPanel, "First");
        this.add(new JScrollPane(sideWrapperPanel));
    }

    private JPanel getDateSpinners(EntityData entityData) {
        JPanel rowPanel = new JPanel(new FlowLayout());
        KinTreeNode kinTreeNode = new KinTreeNode(entityData, this.indexerParameters, this.dialogHandler, this.entityCollection, this.dataNodeLoader);
        rowPanel.add(new JLabel(kinTreeNode.toString(), kinTreeNode.getIcon(), 2));
        SpinnerDateModel startDateModel = new SpinnerDateModel();
        JSpinner startSpinner = new JSpinner(startDateModel);
        startSpinner.setEditor(new JSpinner.DateEditor(startSpinner, "yyyy/MM/dd"));
        rowPanel.add(startSpinner);
        startSpinner.setEnabled(entityData.getDateOfBirth() != null);
        JCheckBox startCheckBox = new JCheckBox();
        startCheckBox.setSelected(entityData.getDateOfBirth() != null);
        rowPanel.add(startCheckBox);
        return rowPanel;
    }

    public void setEntities(ArrayList<EntityData> selectedEntities) {
        this.outerPanel.removeAll();
        for (EntityData entityData : selectedEntities) {
            this.outerPanel.add((Component)this.getDateSpinners(entityData), "First");
        }
    }

    private void addDeleteButton(final Element svgElement, JPanel sidePanel) {
        final Node parentElement = svgElement.getParentNode();
        final JButton unDeleteButton = new JButton("Undelete");
        final JButton deleteButton = new JButton("Delete");
        sidePanel.add(unDeleteButton);
        unDeleteButton.setEnabled(false);
        unDeleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DateEditorPanel.this.reAddElement(parentElement, svgElement);
                unDeleteButton.setEnabled(false);
                deleteButton.setEnabled(true);
            }
        });
        sidePanel.add(deleteButton);
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DateEditorPanel.this.removeElement(parentElement, svgElement);
                unDeleteButton.setEnabled(true);
                deleteButton.setEnabled(false);
            }
        });
    }

    private void addNumberSpinner(final Element svgElement, JPanel sidePanel, String labelString, final String attributeString, int minValue, int maxValue) {
        int initialValue = 0;
        try {
            String initialValueString = svgElement.getAttribute(attributeString).trim();
            if (initialValueString.length() > 0) {
                initialValue = Integer.decode(initialValueString);
            }
        }
        catch (NumberFormatException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
        }
        sidePanel.add(new JLabel(labelString));
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(initialValue, minValue, maxValue, 1);
        final JSpinner numberSpinner = new JSpinner(spinnerModel);
        numberSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DateEditorPanel.this.updateValue(svgElement, attributeString, numberSpinner.getValue().toString());
            }
        });
        sidePanel.add(numberSpinner);
    }

    private void addColourInput(final Element svgElement, JPanel sidePanel, final JPanel pickerPanel, final String attributeString) {
        Color initialColour = Color.white;
        try {
            String attributeValue = svgElement.getAttribute(attributeString).trim();
            if (!attributeValue.equals("none")) {
                initialColour = Color.decode(attributeValue);
            }
        }
        catch (NumberFormatException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
        }
        sidePanel.add(new JLabel(attributeString));
        final JPanel colourSquare = new JPanel();
        colourSquare.setBackground(initialColour);
        colourSquare.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                pickerPanel.removeAll();
                final JColorChooser colourChooser = new JColorChooser(colourSquare.getBackground());
                final Color revertColour = colourSquare.getBackground();
                JPanel buttonPanel = new JPanel();
                buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
                JButton cancelButton = new JButton("Cancel");
                buttonPanel.add(cancelButton);
                JButton revertButton = new JButton("Revert");
                buttonPanel.add(revertButton);
                JButton noneButton = new JButton("None (Transparent)");
                buttonPanel.add(noneButton);
                JButton okButton = new JButton("OK");
                buttonPanel.add(okButton);
                cancelButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        colourSquare.setBackground(revertColour);
                        colourChooser.setColor(revertColour);
                        pickerPanel.removeAll();
                        DateEditorPanel.this.revalidate();
                        DateEditorPanel.this.repaint();
                    }
                });
                revertButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        colourSquare.setBackground(revertColour);
                        colourChooser.setColor(revertColour);
                        DateEditorPanel.this.updateValue(svgElement, attributeString, "#" + Integer.toHexString(colourChooser.getColor().getRGB()).substring(2));
                    }
                });
                noneButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        DateEditorPanel.this.updateValue(svgElement, attributeString, "none");
                        colourSquare.setBackground(Color.WHITE);
                    }
                });
                okButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        pickerPanel.removeAll();
                        DateEditorPanel.this.revalidate();
                        DateEditorPanel.this.repaint();
                    }
                });
                colourChooser.setPreviewPanel(new JPanel());
                colourChooser.getSelectionModel().addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        colourSquare.setBackground(colourChooser.getColor());
                        DateEditorPanel.this.updateValue(svgElement, attributeString, "#" + Integer.toHexString(colourChooser.getColor().getRGB()).substring(2));
                    }
                });
                pickerPanel.add((Component)colourChooser.getChooserPanels()[0], "Center");
                pickerPanel.add((Component)buttonPanel, "After");
                DateEditorPanel.this.revalidate();
                DateEditorPanel.this.repaint();
            }
        });
        sidePanel.add(colourSquare);
    }

    protected void updateValue(Element changeTarget, String attributeName, String changeValue) {
    }

    protected void updateValue(Element changeTarget, String changeValue) {
    }

    protected void removeElement(Node parentTarget, Element changeTarget) {
    }

    protected void reAddElement(Node parentTarget, Element changeTarget) {
    }
}

