/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.data.KinTreeNode;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.KinDragTransferHandler;
import nl.mpi.kinnate.ui.KinTree;

public class EntitySearchPanel
extends JPanel {
    private EntityCollection entityCollection;
    private KinTree resultsTree;
    private JTextArea resultsArea = new JTextArea();
    private JTextField searchField;
    private JProgressBar progressBar;
    private JButton searchButton;
    private JPanel searchPanel;
    private GraphPanel graphPanel;
    private MessageDialogHandler dialogHandler;
    private ArbilDataNodeLoader dataNodeLoader;

    public EntitySearchPanel(EntityCollection entityCollection, KinDiagramPanel kinDiagramPanel, GraphPanel graphPanel, MessageDialogHandler dialogHandler, ArbilDataNodeLoader dataNodeLoader) {
        this.entityCollection = entityCollection;
        this.graphPanel = graphPanel;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
        this.setLayout(new BorderLayout());
        this.resultsTree = new KinTree(kinDiagramPanel, graphPanel);
        this.resultsTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Test Tree"), true));
        this.resultsTree.setRootVisible(false);
        JLabel searchLabel = new JLabel("Search Entity Names");
        this.searchField = new JTextField();
        this.searchField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EntitySearchPanel.this.performSearch();
                }
                super.keyReleased(e);
            }
        });
        this.progressBar = new JProgressBar();
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitySearchPanel.this.performSearch();
            }
        });
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout(new BorderLayout());
        this.searchPanel.add((Component)searchLabel, "First");
        this.searchPanel.add((Component)this.searchField, "Center");
        this.searchPanel.add((Component)this.searchButton, "Last");
        this.add((Component)this.searchPanel, "First");
        this.add((Component)new JScrollPane((Component)((Object)this.resultsTree)), "Center");
        this.add((Component)this.resultsArea, "Last");
    }

    public void setTransferHandler(KinDragTransferHandler dragTransferHandler) {
        this.resultsTree.setTransferHandler(dragTransferHandler);
        this.resultsTree.setDragEnabled(true);
    }

    protected void performSearch() {
        this.searchPanel.remove(this.searchButton);
        this.progressBar.setIndeterminate(true);
        this.searchPanel.add((Component)this.progressBar, "Last");
        this.searchPanel.revalidate();
        new Thread(){

            public void run() {
                ArrayList<KinTreeNode> resultsArray = new ArrayList<KinTreeNode>();
                EntityData[] searchResults = EntitySearchPanel.this.entityCollection.getEntityByKeyWord(EntitySearchPanel.this.searchField.getText(), EntitySearchPanel.this.graphPanel.getIndexParameters());
                EntitySearchPanel.this.resultsArea.setText("Found " + searchResults.length + " entities\n");
                for (EntityData entityData : searchResults) {
                    resultsArray.add(new KinTreeNode(entityData, EntitySearchPanel.this.graphPanel.getIndexParameters(), EntitySearchPanel.this.dialogHandler, EntitySearchPanel.this.entityCollection, EntitySearchPanel.this.dataNodeLoader));
                }
                ((EntitySearchPanel)EntitySearchPanel.this).resultsTree.rootNodeChildren = resultsArray.toArray(new KinTreeNode[0]);
                EntitySearchPanel.this.resultsTree.requestResort();
                EntitySearchPanel.this.searchPanel.remove(EntitySearchPanel.this.progressBar);
                EntitySearchPanel.this.searchPanel.add((Component)EntitySearchPanel.this.searchButton, "Last");
                EntitySearchPanel.this.searchPanel.revalidate();
            }
        }.start();
    }
}

