/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.EntityMerger;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.kindocument.RelationLinker;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.SvgUpdateHandler;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class GraphPanelContextMenu
extends JPopupMenu
implements ActionListener {
    private KinDiagramPanel kinDiagramPanel;
    private GraphPanel graphPanel;
    private JMenuItem addEntityMenuItem;
    private JMenuItem duplicateEntitiesMenu;
    private JMenuItem mergeEntitiesMenu;
    private JMenuItem addRelationEntityMenu;
    private JMenuItem removeRelationEntityMenu;
    private JMenuItem setAsEgoMenuItem;
    private JMenuItem addAsEgoMenuItem;
    private JMenuItem removeEgoMenuItem;
    private JMenuItem addAsRequiredMenuItem;
    private JMenuItem removeRequiredMenuItem;
    private JMenuItem saveFileMenuItem;
    private UniqueIdentifier[] selectedIdentifiers = null;
    private float xPos;
    private float yPos;
    private ArbilDataNodeLoader dataNodeLoader;

    public GraphPanelContextMenu(KinDiagramPanel egoSelectionPanelLocal, GraphPanel graphPanelLocal, final EntityCollection entityCollection, final ArbilWindowManager arbilWindowManager, ArbilDataNodeLoader dataNodeLoaderL, final SessionStorage sessionStorage) {
        this.kinDiagramPanel = egoSelectionPanelLocal;
        this.graphPanel = graphPanelLocal;
        this.dataNodeLoader = dataNodeLoaderL;
        if (egoSelectionPanelLocal != null) {
            this.addEntityMenuItem = new JMenuItem("Add Entity");
            this.addEntityMenuItem.setActionCommand(EntityDocument.defaultEntityType);
            this.addEntityMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(final ActionEvent evt) {
                    new Thread(){

                        public void run() {
                            GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                            String nodeType = evt.getActionCommand();
                            try {
                                EntityDocument entityDocument = new EntityDocument(nodeType, new ImportTranslator(true), sessionStorage);
                                entityDocument.saveDocument();
                                URI addedEntityUri = entityDocument.getFile().toURI();
                                entityCollection.updateDatabase(addedEntityUri);
                                GraphPanelContextMenu.this.kinDiagramPanel.addRequiredNodes(new UniqueIdentifier[]{entityDocument.getUniqueIdentifier()});
                            }
                            catch (ImportException exception) {
                                BugCatcherManager.getBugCatcher().logError((Exception)exception);
                                arbilWindowManager.addMessageDialogToQueue("Failed to create entity: " + exception.getMessage(), "Add Entity");
                            }
                        }
                    }.start();
                }
            });
            this.add(this.addEntityMenuItem);
            this.duplicateEntitiesMenu = new JMenuItem("Duplicate Selected Entities");
            this.duplicateEntitiesMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        UniqueIdentifier[] duplicateEntities = new EntityMerger(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection).duplicateEntities(GraphPanelContextMenu.this.selectedIdentifiers);
                        GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(GraphPanelContextMenu.this.selectedIdentifiers);
                        GraphPanelContextMenu.this.kinDiagramPanel.addRequiredNodes(duplicateEntities);
                    }
                    catch (ImportException exception) {
                        arbilWindowManager.addMessageDialogToQueue("Failed to duplicate: " + exception.getMessage(), GraphPanelContextMenu.this.duplicateEntitiesMenu.getText());
                    }
                }
            });
            this.add(this.duplicateEntitiesMenu);
            this.mergeEntitiesMenu = new JMenuItem("Merge Selected Entities");
            this.mergeEntitiesMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        UniqueIdentifier[] affectedIdentifiers = new EntityMerger(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection).mergeEntities(GraphPanelContextMenu.this.selectedIdentifiers);
                        GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(affectedIdentifiers);
                    }
                    catch (ImportException exception) {
                        arbilWindowManager.addMessageDialogToQueue("Failed to merge: " + exception.getMessage(), GraphPanelContextMenu.this.mergeEntitiesMenu.getText());
                    }
                }
            });
            this.add(this.mergeEntitiesMenu);
            this.addRelationEntityMenu = new JMenu("Add Relation");
            this.add(this.addRelationEntityMenu);
            for (DataTypes.RelationType relationType : DataTypes.RelationType.values()) {
                JMenuItem addRelationEntityMenuItem = new JMenuItem(relationType.name());
                addRelationEntityMenuItem.setActionCommand(relationType.name());
                addRelationEntityMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        try {
                            UniqueIdentifier[] affectedIdentifiers = new RelationLinker(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection).linkEntities(GraphPanelContextMenu.this.selectedIdentifiers, DataTypes.RelationType.valueOf(evt.getActionCommand()), null, null);
                            GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(affectedIdentifiers);
                        }
                        catch (ImportException exception) {
                            arbilWindowManager.addMessageDialogToQueue("Failed to create relation: " + exception.getMessage(), GraphPanelContextMenu.this.addRelationEntityMenu.getText());
                        }
                    }
                });
                this.addRelationEntityMenu.add(addRelationEntityMenuItem);
            }
            this.removeRelationEntityMenu = new JMenu("Remove Relations");
            this.add(this.removeRelationEntityMenu);
            String actionString = "Remove Relations to Lead Selection";
            JMenuItem removeRelationEntityMenuItem = new JMenuItem(actionString);
            removeRelationEntityMenuItem.setActionCommand(actionString);
            removeRelationEntityMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    new RelationLinker(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection).unlinkEntities(GraphPanelContextMenu.this.graphPanel, GraphPanelContextMenu.this.selectedIdentifiers);
                    GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(GraphPanelContextMenu.this.selectedIdentifiers);
                }
            });
            this.removeRelationEntityMenu.add(removeRelationEntityMenuItem);
            JMenu shapeSubMenu = new JMenu("Add Geometry");
            for (SvgUpdateHandler.GraphicsTypes graphicsType : SvgUpdateHandler.GraphicsTypes.values()) {
                JMenuItem addLabel = new JMenuItem("Add " + graphicsType.name());
                addLabel.setActionCommand(graphicsType.name());
                shapeSubMenu.add(addLabel);
                if (SvgUpdateHandler.GraphicsTypes.Polyline.equals((Object)graphicsType)) {
                    addLabel.setEnabled(false);
                }
                addLabel.addActionListener(this);
            }
            this.add(shapeSubMenu);
        }
        this.setAsEgoMenuItem = new JMenuItem("Set as Ego (relacing existing)");
        this.setAsEgoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.setEgoNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.setAsEgoMenuItem);
        this.addAsEgoMenuItem = new JMenuItem("Add as Ego");
        this.addAsEgoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.addEgoNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.addAsEgoMenuItem);
        this.removeEgoMenuItem = new JMenuItem("Remove Ego");
        this.removeEgoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.removeEgoNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.removeEgoMenuItem);
        this.addAsRequiredMenuItem = new JMenuItem("Set as required");
        this.addAsRequiredMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.addRequiredNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.addAsRequiredMenuItem);
        this.removeRequiredMenuItem = new JMenuItem("Remove requirement");
        this.removeRequiredMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.removeRequiredNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.removeRequiredMenuItem);
        JMenuItem resetZoomMenuItem = new JMenuItem("Reset Zoom");
        resetZoomMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.graphPanel.resetZoom();
            }
        });
        this.add(resetZoomMenuItem);
        JMenuItem resetLayoutMenuItem = new JMenuItem("Reset Layout");
        resetLayoutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.graphPanel.resetLayout();
            }
        });
        this.add(resetLayoutMenuItem);
        JMenuItem searchEntityServiceMenuItem = new JMenuItem("Search Entity Service");
        searchEntityServiceMenuItem.setToolTipText("Search the entity database for entities matching the current kin terms and populate he diagram with the results");
        searchEntityServiceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
            }
        });
        searchEntityServiceMenuItem.setEnabled(false);
        this.add(searchEntityServiceMenuItem);
        this.saveFileMenuItem = new JMenuItem();
        this.saveFileMenuItem.setText("Save All Data Changes");
        this.saveFileMenuItem.setEnabled(false);
        this.saveFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    arbilWindowManager.stopEditingInCurrentWindow();
                    GraphPanelContextMenu.this.dataNodeLoader.saveNodesNeedingSave(true);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(this.saveFileMenuItem);
    }

    public void show(Component cmpnt, int i, int i1) {
        this.xPos = cmpnt.getMousePosition().x;
        this.yPos = cmpnt.getMousePosition().y;
        this.selectedIdentifiers = this.graphPanel.getSelectedIds();
        int nonTransientNodeCount = 0;
        for (UniqueIdentifier uniqueIdentifier : this.selectedIdentifiers) {
            if (uniqueIdentifier.isTransientIdentifier() || uniqueIdentifier.isGraphicsIdentifier()) continue;
            ++nonTransientNodeCount;
        }
        if (this.addRelationEntityMenu != null) {
            this.duplicateEntitiesMenu.setVisible(nonTransientNodeCount > 0);
            this.mergeEntitiesMenu.setVisible(nonTransientNodeCount > 1);
            this.addRelationEntityMenu.setVisible(nonTransientNodeCount > 1);
            this.setAsEgoMenuItem.setVisible(nonTransientNodeCount > 0);
            this.addAsEgoMenuItem.setVisible(nonTransientNodeCount > 0);
            this.removeEgoMenuItem.setVisible(nonTransientNodeCount > 0);
            this.addAsRequiredMenuItem.setVisible(nonTransientNodeCount > 0);
            this.removeRequiredMenuItem.setVisible(nonTransientNodeCount > 0);
        } else {
            this.setAsEgoMenuItem.setVisible(false);
            this.addAsEgoMenuItem.setVisible(false);
            this.removeEgoMenuItem.setVisible(false);
            this.addAsRequiredMenuItem.setVisible(false);
            this.removeRequiredMenuItem.setVisible(false);
        }
        this.saveFileMenuItem.setEnabled(this.dataNodeLoader.nodesNeedSave());
        this.addEntityMenuItem.setEnabled(this.graphPanel.dataStoreSvg.diagramMode != DataStoreSvg.DiagramMode.FreeForm);
        this.removeRelationEntityMenu.setEnabled(this.graphPanel.dataStoreSvg.diagramMode != DataStoreSvg.DiagramMode.FreeForm);
        super.show(cmpnt, i, i1);
    }

    public void actionPerformed(ActionEvent e) {
        this.graphPanel.svgUpdateHandler.addGraphics(SvgUpdateHandler.GraphicsTypes.valueOf(e.getActionCommand()), this.xPos, this.yPos);
    }
}

