/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.net.URI;
import javax.swing.AbstractButton;
import org.basex.core.Command;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.Cs;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.DropIndex;
import org.basex.core.cmd.Export;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Optimize;
import org.basex.core.cmd.XQuery;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.dialog.DialogAbout;
import org.basex.gui.dialog.DialogAdd;
import org.basex.gui.dialog.DialogColors;
import org.basex.gui.dialog.DialogCreate;
import org.basex.gui.dialog.DialogEdit;
import org.basex.gui.dialog.DialogExport;
import org.basex.gui.dialog.DialogFonts;
import org.basex.gui.dialog.DialogHelp;
import org.basex.gui.dialog.DialogInfo;
import org.basex.gui.dialog.DialogInput;
import org.basex.gui.dialog.DialogInsert;
import org.basex.gui.dialog.DialogMapLayout;
import org.basex.gui.dialog.DialogOpen;
import org.basex.gui.dialog.DialogPrefs;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.dialog.DialogServer;
import org.basex.gui.dialog.DialogTreeOptions;
import org.basex.gui.view.ViewData;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.Itr;
import org.basex.query.item.NodeType;
import org.basex.query.item.Str;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public enum GUICommands implements GUICommand
{
    CREATE(String.valueOf(Text.GUICREATE) + "...", "% N", Text.GUICREATETT, false, false){

        @Override
        public void execute(GUI gui) {
            DialogCreate dialog = new DialogCreate(gui);
            if (!dialog.ok()) {
                return;
            }
            String in = gui.gprop.get(GUIProp.CREATEPATH);
            String db = gui.gprop.get(GUIProp.CREATENAME);
            DialogProgress.execute(dialog, Text.PROGCREATE, new CreateDB(db, in.isEmpty() ? null : in));
        }
    }
    ,
    OPEN(String.valueOf(Text.GUIOPEN) + "...", "% O", Text.GUIOPENTT, false, false){

        @Override
        public void execute(GUI gui) {
            DialogOpen dialog = new DialogOpen(gui, false);
            if (dialog.ok()) {
                new Close().run(gui.context);
                gui.notify.init();
                gui.execute(new Open(dialog.db()));
            } else if (dialog.nodb() && Dialog.confirm(gui, Text.NODBQUESTION)) {
                CREATE.execute(gui);
            }
        }
    }
    ,
    MANAGE(String.valueOf(Text.GUIMANAGE) + "...", "% M", Text.GUIMANAGETT, false, false){

        @Override
        public void execute(GUI gui) {
            if (new DialogOpen(gui, true).nodb()) {
                Dialog.warn(gui, Text.INFONODB);
            }
        }
    }
    ,
    ADD(String.valueOf(Text.GUIADD) + "...", null, Text.GUIADDTT, true, false){

        @Override
        public void execute(GUI gui) {
            DialogAdd dialog = new DialogAdd(gui);
            if (dialog.ok()) {
                DialogProgress.execute(dialog, "", dialog.cmd());
            }
        }
    }
    ,
    DROP(String.valueOf(Text.GUIDROP) + "...", null, Text.GUIDROPTT, true, false){

        @Override
        public void execute(GUI gui) {
            DialogInput d = new DialogInput("", Text.DROPTITLE, gui, 0);
            if (d.ok()) {
                DialogProgress.execute(d, "", new Delete(d.input()));
            }
        }
    }
    ,
    EXPORT(String.valueOf(Text.GUIEXPORT) + "...", null, Text.GUIEXPORTTT, true, false){

        @Override
        public void execute(GUI gui) {
            DialogExport dialog = new DialogExport(gui);
            if (!dialog.ok()) {
                return;
            }
            IOFile root = new IOFile(dialog.path());
            if (root.exists()) {
                IOFile file = null;
                boolean overwrite = false;
                Data d = gui.context.data;
                IntList il = d.doc();
                int i = 0;
                int is = il.size();
                while (i < is) {
                    file = root.merge(Token.string(d.text(il.get(i), true)));
                    if (((IO)file).exists()) {
                        if (overwrite) {
                            file = null;
                            break;
                        }
                        overwrite = true;
                    }
                    ++i;
                }
                if (overwrite) {
                    String msg;
                    String string = msg = file == null ? Text.DIRREPLACE : Text.FILEREPLACE;
                    if (file == null) {
                        file = root;
                    }
                    if (!Dialog.confirm(gui, Util.info(msg, file))) {
                        return;
                    }
                }
            }
            gui.execute(new Export(root.path()));
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(gui.context.data != null && !gui.context.data.empty());
        }
    }
    ,
    INFO(String.valueOf(Text.GUIPROPS) + "...", "% D", Text.GUIPROPSTT, true, false){

        @Override
        public void execute(GUI gui) {
            DialogInfo info = new DialogInfo(gui);
            if (info.ok()) {
                Data d = gui.context.data;
                boolean[] ind = info.indexes();
                if (info.opt) {
                    d.meta.textindex = ind[0];
                    d.meta.attrindex = ind[1];
                    d.meta.ftindex = ind[2];
                    DialogProgress.execute(info, Text.INFOOPT, new Optimize());
                } else {
                    Command[] cmd = new Command[]{};
                    if (ind[0] != d.meta.pathindex) {
                        cmd = Array.add(cmd, this.cmd(ind[0], Commands.CmdIndex.PATH));
                    }
                    if (ind[1] != d.meta.textindex) {
                        cmd = Array.add(cmd, this.cmd(ind[1], Commands.CmdIndex.TEXT));
                    }
                    if (ind[2] != d.meta.attrindex) {
                        cmd = Array.add(cmd, this.cmd(ind[2], Commands.CmdIndex.ATTRIBUTE));
                    }
                    if (ind[3] != d.meta.ftindex) {
                        cmd = Array.add(cmd, this.cmd(ind[3], Commands.CmdIndex.FULLTEXT));
                    }
                    DialogProgress.execute(info, Text.PROGINDEX, cmd);
                }
            }
        }

        private Command cmd(boolean create, Commands.CmdIndex index) {
            return create ? new CreateIndex((Object)index) : new DropIndex((Object)index);
        }
    }
    ,
    CLOSE(Text.GUICLOSE, "% W", Text.GUICLOSETT, true, false){

        @Override
        public void execute(GUI gui) {
            gui.execute(new Close());
        }
    }
    ,
    SERVER(String.valueOf(Text.GUISERVER) + "...", null, Text.GUISERVERTT, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogServer(gui);
        }
    }
    ,
    EDITNEW(String.valueOf(Text.GUIXQNEW) + "...", "% shift N", Text.GUIXQNEWTT, false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.newFile();
        }
    }
    ,
    EDITOPEN(String.valueOf(Text.GUIXQOPEN) + "...", "% R", Text.GUIXQOPENTT, false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.open();
        }
    }
    ,
    EDITSAVE(Text.GUISAVE, "% S", Text.GUISAVETT, false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.save();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(gui.editor != null && gui.editor.saveable());
        }
    }
    ,
    EDITSAVEAS(String.valueOf(Text.GUISAVEAS) + "...", "% shift S", Text.GUISAVETT, false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.saveAs();
        }
    }
    ,
    EDITCLOSE(Text.GUIXQCLOSE, "% shift W", Text.GUIXQCLOSETT, false, false){

        @Override
        public void execute(GUI gui) {
            gui.editor.close(null);
        }
    }
    ,
    EXIT(Text.GUIEXIT, null, Text.GUIEXITTT, false, false){

        @Override
        public void execute(GUI gui) {
            gui.dispose();
        }
    }
    ,
    COPYPATH(Text.GUICPPATH, "% shift C", Text.GUICPPATHTT, true, false){

        @Override
        public void execute(GUI gui) {
            int pre = gui.context.marked.list[0];
            byte[] txt = ViewData.path(gui.context.data, pre);
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip.setContents(new StringSelection(Token.string(txt)), null);
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            Nodes marked = gui.context.marked;
            b.setEnabled(marked != null && marked.size() != 0L);
        }
    }
    ,
    COPY(Text.GUICOPY, "", Text.GUICOPYTT, true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            Nodes n = ctx.marked;
            ctx.copied = new Nodes(n.list, n.data);
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(17.updatable(gui.context.marked, new int[0]));
        }
    }
    ,
    PASTE(Text.GUIPASTE, "", Text.GUIPASTETT, true, false){

        @Override
        public void execute(GUI gui) {
            StringBuilder sb = new StringBuilder();
            Nodes n = gui.context.copied;
            int i = 0;
            while ((long)i < n.size()) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(18.openPre(n, i));
                ++i;
            }
            gui.context.copied = null;
            gui.execute(new XQuery("insert nodes (" + sb + ") into " + 18.openPre(gui.context.marked, 0)));
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            Context ctx = gui.context;
            b.setEnabled(18.updatable(ctx.marked, 0) && ctx.copied != null);
        }
    }
    ,
    DELETE(String.valueOf(Text.GUIDELETE) + "...", "", Text.GUIDELETETT, true, false){

        @Override
        public void execute(GUI gui) {
            if (!Dialog.confirm(gui, Text.DELETECONF)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            Nodes n = gui.context.marked;
            int i = 0;
            while ((long)i < n.size()) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(19.openPre(n, i));
                ++i;
            }
            gui.context.marked = new Nodes(n.data);
            gui.context.copied = null;
            gui.context.focused = -1;
            gui.execute(new XQuery("delete nodes (" + sb + ")"));
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(19.updatable(gui.context.marked, new int[0]));
        }
    }
    ,
    INSERT(String.valueOf(Text.GUIINSERT) + "...", "", Text.GUIINSERTTT, true, false){

        @Override
        public void execute(GUI gui) {
            Nodes n = gui.context.marked;
            DialogInsert insert = new DialogInsert(gui);
            if (!insert.ok()) {
                return;
            }
            StringList sl = insert.result;
            NodeType type = ANode.type(insert.kind);
            String item = String.valueOf(Token.string(type.nam())) + " { " + 20.quote(sl.get(0)) + " }";
            if (type == NodeType.ATT || type == NodeType.PI) {
                item = String.valueOf(item) + " { " + 20.quote(sl.get(1)) + " }";
            } else if (type == NodeType.ELM) {
                item = String.valueOf(item) + " { () }";
            }
            gui.context.copied = null;
            gui.execute(new XQuery("insert node " + item + " into " + 20.openPre(n, 0)));
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(20.updatable(gui.context.marked, 3, 5, 4, 2));
        }
    }
    ,
    EDIT(String.valueOf(Text.GUIEDIT) + "...", "", Text.GUIEDITTT, true, false){

        @Override
        public void execute(GUI gui) {
            Nodes n = gui.context.marked;
            DialogEdit edit = new DialogEdit(gui, n.list[0]);
            if (!edit.ok()) {
                return;
            }
            String rename = null;
            String replace = null;
            int k = edit.kind;
            if (k == 1 || k == 5 || k == 3) {
                rename = edit.result.get(0);
                if (k != 1) {
                    replace = edit.result.get(1);
                }
            } else {
                replace = edit.result.get(0);
            }
            if (rename != null) {
                gui.execute(new XQuery("rename node " + 21.openPre(n, 0) + " as " + 21.quote(rename)));
            }
            if (replace != null) {
                gui.execute(new XQuery("replace value of node " + 21.openPre(n, 0) + " with " + 21.quote(replace)));
            }
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(21.updatable(gui.context.marked, 0));
        }
    }
    ,
    FILTER(Text.GUIFILTER, "", Text.GUIFILTERTT, true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            Nodes marked = ctx.marked;
            if (marked.size() == 0L) {
                int pre = gui.context.focused;
                if (pre == -1) {
                    return;
                }
                marked = new Nodes(pre, ctx.data);
            }
            gui.notify.context(marked, false, null);
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            Nodes marked = gui.context.marked;
            b.setEnabled(marked != null && marked.size() != 0L);
        }
    }
    ,
    SHOWXQUERY(Text.GUISHOWXQUERY, "% E", Text.GUISHOWXQUERYTT, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWEDITOR);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWEDITOR));
        }
    }
    ,
    SHOWINFO(Text.GUISHOWINFO, "% I", Text.GUISHOWINFOTT, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWINFO);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWINFO));
        }
    }
    ,
    SHOWMENU(Text.GUISHOWMENU, null, Text.GUISHOWMENUTT, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWMENU);
            gui.updateControl(gui.menu, gui.gprop.is(GUIProp.SHOWMENU), "North");
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWMENU));
        }
    }
    ,
    SHOWBUTTONS(Text.GUISHOWBUTTONS, null, Text.GUISHOWBUTTONSTT, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWBUTTONS);
            gui.updateControl(gui.buttons, gui.gprop.is(GUIProp.SHOWBUTTONS), "Center");
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWBUTTONS));
        }
    }
    ,
    SHOWINPUT(Text.GUISHOWINPUT, null, Text.GUISHOWINPUTTT, false, true){

        @Override
        public void execute(GUI gui) {
            gui.updateControl(gui.nav, gui.gprop.invert(GUIProp.SHOWINPUT), "South");
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWINPUT));
        }
    }
    ,
    SHOWSTATUS(Text.GUISHOWSTATUS, null, Text.GUISHOWSTATUSTT, false, true){

        @Override
        public void execute(GUI gui) {
            gui.updateControl(gui.status, gui.gprop.invert(GUIProp.SHOWSTATUS), "South");
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWSTATUS));
        }
    }
    ,
    SHOWTEXT(Text.GUISHOWTEXT, "% 1", Text.GUISHOWTEXTTT, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWTEXT);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWTEXT));
        }
    }
    ,
    SHOWMAP(Text.GUISHOWMAP, "% 2", Text.GUISHOWMAPTT, true, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWMAP);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWMAP));
        }
    }
    ,
    SHOWTREE(Text.GUISHOWTREE, "% 3", Text.GUISHOWTREETT, true, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWTREE);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWTREE));
        }
    }
    ,
    SHOWFOLDER(Text.GUISHOWFOLDER, "% 4", Text.GUISHOWFOLDERTT, true, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWFOLDER);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWFOLDER));
        }
    }
    ,
    SHOWPLOT(Text.GUISHOWPLOT, "% 5", Text.GUISHOWPLOTTT, true, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWPLOT);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWPLOT));
        }
    }
    ,
    SHOWTABLE(Text.GUISHOWTABLE, "% 6", Text.GUISHOWTABLETT, true, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWTABLE);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWTABLE));
        }
    }
    ,
    SHOWEXPLORE(Text.GUISHOWEXPLORE, "% 7", Text.GUISHOWEXPLORETT, true, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.SHOWEXPLORE);
            gui.layoutViews();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWEXPLORE));
        }
    }
    ,
    FULL(Text.GUIFULL, Prop.MAC ? "% shift F" : "F11", Text.GUIFULLTT, false, true){

        @Override
        public void execute(GUI gui) {
            gui.fullscreen();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.fullscreen);
        }
    }
    ,
    RTEXEC(Text.GUIRTEXEC, null, Text.GUIRTEXECTT, false, true){

        @Override
        public void execute(GUI gui) {
            gui.gprop.invert(GUIProp.EXECRT);
            gui.refreshControls();
            gui.notify.layout();
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.EXECRT));
        }
    }
    ,
    RTFILTER(Text.GUIRTFILTER, null, Text.GUIRTFILTERTT, true, true){

        @Override
        public void execute(GUI gui) {
            boolean rt = gui.gprop.invert(GUIProp.FILTERRT);
            gui.refreshControls();
            gui.notify.layout();
            Context ctx = gui.context;
            boolean root = ctx.root();
            if (!rt) {
                if (!root) {
                    gui.notify.context(new Nodes(0, ctx.data), true, null);
                    gui.notify.mark(ctx.current, null);
                }
            } else if (root) {
                gui.notify.mark(new Nodes(ctx.data), null);
            } else {
                Nodes mark = ctx.marked;
                ctx.marked = new Nodes(ctx.data);
                gui.notify.context(mark, true, null);
            }
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.FILTERRT));
        }
    }
    ,
    COLOR(String.valueOf(Text.GUICOLOR) + "...", null, Text.GUICOLORTT, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogColors(gui);
        }
    }
    ,
    FONTS(Text.GUIFONTS, null, Text.GUIFONTSTT, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogFonts(gui);
        }
    }
    ,
    MAPLAYOUT(Text.GUIMAPLAYOUT, null, Text.GUIMAPLAYOUTTT, true, false){

        @Override
        public void execute(GUI gui) {
            new DialogMapLayout(gui);
        }
    }
    ,
    TREEOPTIONS(Text.GUITREEOPTIONS, null, Text.GUITREEOPTIONSTT, true, false){

        @Override
        public void execute(GUI gui) {
            new DialogTreeOptions(gui);
        }
    }
    ,
    PREFS(String.valueOf(Text.GUIPREFS) + "...", Prop.MAC ? "% COMMA" : "% P", Text.GUIPREFSTT, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogPrefs(gui);
        }
    }
    ,
    SHOWHELP(Text.GUISHOWHELP, "F1", Text.GUISHOWHELPTT, false, true){

        @Override
        public void execute(GUI gui) {
            if (!gui.gprop.is(GUIProp.SHOWHELP)) {
                gui.gprop.set(GUIProp.SHOWHELP, true);
                gui.help = new DialogHelp(gui);
                gui.refreshControls();
            } else {
                gui.help.close();
            }
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            super.refresh(gui, b);
            b.setSelected(gui.gprop.is(GUIProp.SHOWHELP));
        }
    }
    ,
    SHOWCOMMUNITY(Text.GUISHOWCOMMUNITY, null, Text.GUISHOWCOMMUNITYTT, false, false){

        @Override
        public void execute(GUI gui) {
            String url = Text.COMMUNITY_URL;
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (Exception ex) {
                Dialog.error(gui, Util.info(Text.INFOBROSERERR, url));
            }
        }
    }
    ,
    SHOWUPDATES(Text.GUISHOWUPDATES, null, Text.GUISHOWUPDATESTT, false, false){

        @Override
        public void execute(GUI gui) {
            String url = Text.UPDATE_URL;
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (Exception ex) {
                Dialog.error(gui, Util.info(Text.INFOBROSERERR, url));
            }
        }
    }
    ,
    ABOUT(String.valueOf(Text.GUIABOUT) + "...", null, Text.GUIABOUTTT, false, false){

        @Override
        public void execute(GUI gui) {
            new DialogAbout(gui);
        }
    }
    ,
    GOBACK(Text.GUIGOBACK, "alt LEFT", Text.GUIGOBACK, true, false){

        @Override
        public void execute(GUI gui) {
            gui.notify.hist(false);
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            String tt = gui.notify.tooltip(true);
            b.setEnabled(tt != null);
            b.setToolTipText(tt != null && tt.isEmpty() ? Text.GUIGOBACK : tt);
        }
    }
    ,
    GOFORWARD(Text.GUIGOFORWARD, "alt RIGHT", Text.GUIGOFORWARD, true, false){

        @Override
        public void execute(GUI gui) {
            gui.notify.hist(true);
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            String tt = gui.notify.tooltip(false);
            b.setEnabled(tt != null);
            b.setToolTipText(tt != null && tt.isEmpty() ? Text.GUIGOFORWARD : tt);
        }
    }
    ,
    GOUP(Text.GUIGOUP, "alt UP", Text.GUIGOUPTT, true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            if (ctx.root()) {
                return;
            }
            boolean r = true;
            int[] nArray = ctx.current.list;
            int n = ctx.current.list.length;
            int n2 = 0;
            while (n2 < n) {
                int pre = nArray[n2];
                r &= ctx.data.kind(pre) == 0;
                ++n2;
            }
            if (r) {
                Nodes nodes = new Nodes(ctx.data.doc().toArray(), ctx.data);
                nodes.root = true;
                gui.notify.context(nodes, false, null);
            } else {
                gui.execute(new Cs(".."));
            }
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(!gui.gprop.is(GUIProp.FILTERRT) && gui.context.current != null && !gui.context.root());
        }
    }
    ,
    GOHOME(Text.GUIROOT, "alt HOME", Text.GUIROOTTT, true, false){

        @Override
        public void execute(GUI gui) {
            Context ctx = gui.context;
            if (ctx.root()) {
                return;
            }
            Nodes nodes = new Nodes(ctx.data.doc().toArray(), ctx.data);
            nodes.root = true;
            gui.notify.context(nodes, false, null);
        }

        @Override
        public void refresh(GUI gui, AbstractButton b) {
            b.setEnabled(gui.context.current != null && !gui.context.root());
        }
    }
    ,
    HOME(Text.GUIROOT, null, Text.GUIROOTTT, true, false){

        @Override
        public void execute(GUI gui) {
            gui.execute(new XQuery("/"));
        }
    };

    private final boolean data;
    private final String entry;
    private final String key;
    private final String help;
    private final boolean checked;

    private GUICommands(String e, String k, String h, boolean d, boolean c) {
        this.entry = e;
        this.key = k;
        this.help = h;
        this.data = d;
        this.checked = c;
    }

    @Override
    public void refresh(GUI gui, AbstractButton b) {
        b.setEnabled(!this.data || gui.context.data != null);
    }

    @Override
    public final boolean checked() {
        return this.checked;
    }

    @Override
    public String help() {
        return this.help;
    }

    @Override
    public String label() {
        return this.entry;
    }

    @Override
    public String key() {
        return this.key;
    }

    static boolean updatable(Nodes n, int ... no) {
        if (n == null || (no.length == 0 ? n.size() < 1L : n.size() != 1L)) {
            return false;
        }
        int k = n.data.kind(n.list[0]);
        int[] nArray = no;
        int n2 = no.length;
        int n3 = 0;
        while (n3 < n2) {
            int i = nArray[n3];
            if (k == i) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    static String quote(String s) {
        return "\"" + s.replaceAll("\\\"", "&quot;") + "\"";
    }

    static String openPre(Nodes n, int i) {
        return Function.DBOPENPRE.get(null, Str.get(n.data.meta.name), Itr.get(n.list[i])).toString();
    }

    /* synthetic */ GUICommands(String string, int n, String string2, String string3, String string4, boolean bl, boolean bl2, GUICommands gUICommands) {
        this(string2, string3, string4, bl, bl2);
    }
}

