/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.gedcomimport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.gedcomimport.EntityImporter;
import nl.mpi.kinnate.gedcomimport.GenericImporter;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityDate;
import nl.mpi.kinnate.kindata.EntityDateException;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class GedcomImporter
extends EntityImporter
implements GenericImporter {
    public GedcomImporter(JProgressBar progressBarLocal, JTextArea importTextAreaLocal, boolean overwriteExistingLocal, SessionStorage sessionStorage) {
        super(progressBarLocal, importTextAreaLocal, overwriteExistingLocal, sessionStorage);
    }

    public boolean canImport(String inputFileString) {
        return inputFileString.toLowerCase().endsWith(".ged");
    }

    public URI[] importFile(InputStreamReader inputStreamReader) {
        ArrayList<URI> createdNodes = new ArrayList<URI>();
        HashMap socialGroupRoleMap = new HashMap();
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ImportTranslator importTranslator = new ImportTranslator(true);
        try {
            String strLine;
            int gedcomLevel = 0;
            ArrayList<String> gedcomLevelStrings = new ArrayList<String>();
            EntityDocument currentEntity = null;
            boolean skipFileEntity = false;
            while ((strLine = bufferedReader.readLine()) != null) {
                String lineContents;
                if (skipFileEntity) {
                    skipFileEntity = false;
                    while ((strLine = bufferedReader.readLine()) != null && !strLine.startsWith("0")) {
                    }
                }
                String[] lineParts = strLine.split(" ", 3);
                gedcomLevel = Integer.parseInt(lineParts[0]);
                while (gedcomLevelStrings.size() > gedcomLevel) {
                    gedcomLevelStrings.remove(gedcomLevelStrings.size() - 1);
                }
                gedcomLevelStrings.add(lineParts[1]);
                System.out.println(strLine);
                boolean lastFieldContinued = false;
                if (lineParts[1].equals("CONT")) {
                    lineContents = "";
                    if (lineParts.length > 2) {
                        lineContents = lineParts[2];
                    }
                    currentEntity.appendValueToLast("\n" + lineContents);
                    lastFieldContinued = true;
                } else if (lineParts[1].equals("CONC")) {
                    lineContents = "";
                    if (lineParts.length > 2) {
                        lineContents = lineParts[2];
                    }
                    currentEntity.appendValueToLast(lineContents);
                    lastFieldContinued = true;
                }
                if (!lastFieldContinued) {
                    if (gedcomLevel == 0) {
                        if (lineParts[1].equals("TRLR")) {
                            this.appendToTaskOutput("End of file found");
                        } else {
                            String typeString = lineParts.length > 2 ? lineParts[2] : lineParts[1];
                            currentEntity = this.getEntityDocument(createdNodes, typeString, lineParts[1], importTranslator);
                            if (lineParts[1].equals("HEAD")) {
                                this.appendToTaskOutput("Reading Gedcom Header");
                                currentEntity.appendValue(lineParts[1], null, gedcomLevel);
                            } else if (lineParts.length > 2) {
                                currentEntity.appendValue(lineParts[2], lineParts[1], gedcomLevel);
                            } else {
                                currentEntity.appendValue("gedcom-id", lineParts[1], gedcomLevel);
                            }
                        }
                    } else if (lineParts.length == 2) {
                        currentEntity.appendValue(lineParts[1], null, gedcomLevel);
                    } else if (lineParts.length > 2) {
                        currentEntity.appendValue(lineParts[1], lineParts[2], gedcomLevel);
                        if (gedcomLevelStrings.size() == 3 && ((String)gedcomLevelStrings.get(2)).equals("DATE") && (((String)gedcomLevelStrings.get(1)).equals("BIRT") || ((String)gedcomLevelStrings.get(1)).equals("DEAT"))) {
                            String dateText = lineParts[2].trim();
                            String qualifierString = null;
                            String yearString = null;
                            String monthString = null;
                            String dayString = null;
                            for (String prefixString : new String[]{"ABT", "BEF", "AFT"}) {
                                if (!dateText.startsWith(prefixString)) continue;
                                qualifierString = prefixString.toLowerCase();
                                dateText = dateText.substring(prefixString.length()).trim();
                            }
                            try {
                                SimpleDateFormat formatter;
                                if (dateText.matches("[0-9]{1,4}")) {
                                    while (dateText.length() < 4) {
                                        dateText = "0" + dateText;
                                    }
                                    yearString = dateText;
                                } else if (dateText.matches("[a-zA-Z]{3} [0-9]{4}")) {
                                    formatter = new SimpleDateFormat("MMM yyyy");
                                    Date parsedDate = formatter.parse(dateText);
                                    monthString = new SimpleDateFormat("MM").format(parsedDate);
                                    yearString = new SimpleDateFormat("yyyy").format(parsedDate);
                                } else {
                                    formatter = new SimpleDateFormat("dd MMM yyyy");
                                    Date parsedDate = formatter.parse(dateText);
                                    dayString = new SimpleDateFormat("dd").format(parsedDate);
                                    monthString = new SimpleDateFormat("MM").format(parsedDate);
                                    yearString = new SimpleDateFormat("yyyy").format(parsedDate);
                                }
                                EntityDate entityDate = new EntityDate(yearString, monthString, dayString, qualifierString);
                                if (((String)gedcomLevelStrings.get(1)).equals("BIRT")) {
                                    currentEntity.insertValue("DateOfBirth", entityDate.getDateString());
                                } else {
                                    currentEntity.insertValue("DateOfDeath", entityDate.getDateString());
                                }
                            }
                            catch (ParseException exception) {
                                System.out.println(exception.getMessage());
                                this.appendToTaskOutput("Failed to parse date: " + strLine);
                            }
                            catch (EntityDateException exception) {
                                System.out.println(exception.getMessage());
                                this.appendToTaskOutput("Failed to parse date: " + strLine + " " + exception.getMessage());
                            }
                        }
                        if (gedcomLevelStrings.size() == 2 && ((String)gedcomLevelStrings.get(1)).equals("SEX")) {
                            String genderString = lineParts[2];
                            if ("F".equals(genderString)) {
                                genderString = "Female";
                            } else if ("M".equals(genderString)) {
                                genderString = "Male";
                            } else {
                                this.appendToTaskOutput("Unknown gender type: " + genderString);
                            }
                            currentEntity.insertValue("Gender", genderString);
                        }
                        if (((String)gedcomLevelStrings.get(gedcomLevelStrings.size() - 1)).equals("FILE")) {
                            if (lineParts[2].toLowerCase().startsWith("mailto:")) {
                                currentEntity.insertValue("mailto", lineParts[2]);
                            } else {
                                URI resolvedUri = "jar".equals(this.inputFileUri.getScheme()) ? URI.create("http://example.net/example/files/not/included/demo").resolve(lineParts[2]) : this.inputFileUri.resolve(lineParts[2]);
                                currentEntity.entityData.addArchiveLink(resolvedUri);
                            }
                        }
                        if (lineParts[2].startsWith("@") && lineParts[2].endsWith("@")) {
                            DataTypes.RelationType targetRelation = DataTypes.RelationType.other;
                            if (lineParts[1].equals("FAMS") || lineParts[1].equals("FAMC") || lineParts[1].equals("HUSB") || lineParts[1].equals("WIFE") || lineParts[1].equals("CHIL")) {
                                EntityData socialGroupMember;
                                UniqueIdentifier socialGroupIdentifier;
                                if (lineParts[1].equals("FAMS") || lineParts[1].equals("FAMC")) {
                                    socialGroupIdentifier = this.getEntityDocument(createdNodes, null, (String)lineParts[2], (ImportTranslator)importTranslator).entityData.getUniqueIdentifier();
                                    socialGroupMember = currentEntity.entityData;
                                } else {
                                    socialGroupIdentifier = currentEntity.entityData.getUniqueIdentifier();
                                    socialGroupMember = this.getEntityDocument(createdNodes, null, (String)lineParts[2], (ImportTranslator)importTranslator).entityData;
                                }
                                if (!socialGroupRoleMap.containsKey(socialGroupIdentifier)) {
                                    socialGroupRoleMap.put(socialGroupIdentifier, new ArrayList());
                                }
                                ((ArrayList)socialGroupRoleMap.get(socialGroupIdentifier)).add(new SocialMemberElement(lineParts[1], socialGroupMember));
                            }
                            currentEntity.entityData.addRelatedNode(this.getEntityDocument(createdNodes, null, (String)lineParts[2], (ImportTranslator)importTranslator).entityData, targetRelation, null, null, null, lineParts[1]);
                        }
                    }
                }
                super.incrementLineProgress();
            }
            for (ArrayList currentSocialGroup : socialGroupRoleMap.values()) {
                for (SocialMemberElement outerMemberElement : currentSocialGroup) {
                    for (SocialMemberElement innerMemberElement : currentSocialGroup) {
                        if (innerMemberElement.memberEntity.equals(outerMemberElement.memberEntity)) continue;
                        if (innerMemberElement.typeString.equals("FAMC") || innerMemberElement.typeString.equals("CHIL")) {
                            if (outerMemberElement.typeString.equals("FAMC") || outerMemberElement.typeString.equals("CHIL")) {
                                innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.sibling, null, null, null, null);
                                continue;
                            }
                            innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.ancestor, null, null, null, null);
                            continue;
                        }
                        if (outerMemberElement.typeString.equals("FAMC") || outerMemberElement.typeString.equals("CHIL")) {
                            innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.descendant, null, null, null, null);
                            continue;
                        }
                        innerMemberElement.memberEntity.addRelatedNode(outerMemberElement.memberEntity, DataTypes.RelationType.union, null, null, null, null);
                    }
                }
            }
            this.saveAllDocuments();
        }
        catch (IOException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            this.appendToTaskOutput("Error: " + exception.getMessage());
        }
        catch (ImportException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            this.appendToTaskOutput("Error: " + exception.getMessage());
        }
        return createdNodes.toArray(new URI[0]);
    }

    class SocialMemberElement {
        String typeString;
        EntityData memberEntity;

        public SocialMemberElement(String typeString, EntityData memberEntity) {
            this.typeString = typeString;
            this.memberEntity = memberEntity;
        }
    }
}

