/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kintypestrings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kindata.GraphSorter;
import nl.mpi.kinnate.kintypestrings.KinTerm;
import nl.mpi.kinnate.kintypestrings.KinTermGroup;
import nl.mpi.kinnate.kintypestrings.KinType;
import nl.mpi.kinnate.kintypestrings.LabelStringsParser;
import nl.mpi.kinnate.kintypestrings.ParserHighlight;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinTypeStringConverter
extends GraphSorter {
    DataStoreSvg dataStoreSvg;

    public KinTypeStringConverter(DataStoreSvg dataStoreSvg) {
        this.dataStoreSvg = dataStoreSvg;
    }

    public void setEgoKinTypeString(EntityData entityData) {
        for (KinType kinType : this.dataStoreSvg.getKinTypeDefinitions()) {
            if (!kinType.isEgoType() || !kinType.matchesEgonessAndSymbol(entityData, null)) continue;
            entityData.addKinTypeString(kinType.codeString);
        }
    }

    public ArrayList<KinTypeElement> getKinTypeElements(String consumableString, ParserHighlight parserHighlight) {
        int initialLength = consumableString.length();
        if (consumableString.startsWith("[")) {
            consumableString = "x=" + consumableString;
        }
        ArrayList<KinTypeElement> kinTypeElementList = new ArrayList<KinTypeElement>();
        KinTypeElement previousElement = null;
        boolean foundKinType = true;
        String errorMessage = null;
        block0: while (foundKinType && consumableString.length() > 0) {
            for (KinType currentReferenceKinType : this.dataStoreSvg.getKinTypeDefinitions()) {
                foundKinType = false;
                if (!consumableString.startsWith(currentReferenceKinType.codeString)) continue;
                parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.KinType, initialLength - consumableString.length(), currentReferenceKinType.displayString);
                KinTypeElement currentElement = new KinTypeElement();
                if (previousElement != null) {
                    previousElement.nextType = currentElement;
                    currentElement.prevType = previousElement;
                }
                previousElement = currentElement;
                currentElement.kinType = currentReferenceKinType;
                if ((consumableString = consumableString.substring(currentReferenceKinType.codeString.length())).startsWith("[")) {
                    int highlightPosition = initialLength - consumableString.length();
                    String highlightMessage = "Query: ";
                    while (consumableString.startsWith("[")) {
                        int queryStart = "[".length();
                        int queryEnd = consumableString.indexOf("]");
                        if (queryEnd == -1) {
                            errorMessage = highlightMessage = highlightMessage + "No closing bracket ']' found";
                            foundKinType = false;
                            break;
                        }
                        if (queryEnd - queryStart < 3) {
                            errorMessage = highlightMessage = highlightMessage + "Query must be over 2 chars long";
                            foundKinType = false;
                            break;
                        }
                        if (currentElement.queryTerms == null) {
                            currentElement.queryTerms = new ArrayList();
                        }
                        String queryText = consumableString.substring(queryStart, queryEnd);
                        consumableString = consumableString.substring(queryEnd + 1);
                        QueryType currentQueryType = null;
                        String[] queryTerm = queryText.split("==");
                        if (queryTerm.length > 1) {
                            currentQueryType = QueryType.Equals;
                        } else {
                            queryTerm = queryText.split("=");
                            if (queryTerm.length > 1) {
                                currentQueryType = QueryType.Contains;
                            } else {
                                queryTerm = queryText.split("\\>");
                                if (queryTerm.length > 1) {
                                    currentQueryType = QueryType.Greater;
                                } else {
                                    queryTerm = queryText.split("\\<");
                                    if (queryTerm.length > 1) {
                                        currentQueryType = QueryType.Less;
                                    }
                                }
                            }
                        }
                        if (currentQueryType == null) {
                            currentElement.queryTerms.add(new QueryTerm("*", QueryType.Contains, queryText));
                            highlightMessage = highlightMessage + "Any field containing '" + queryText + "'";
                            continue;
                        }
                        if (queryTerm[0].length() <= 0 || queryTerm[1].length() <= 0) continue;
                        currentElement.queryTerms.add(new QueryTerm("*:" + queryTerm[0].replaceAll("\\.", "/*:"), currentQueryType, queryTerm[1]));
                        highlightMessage = highlightMessage + "Only the field '" + queryTerm[0] + "' containing '" + queryTerm[1] + "'";
                    }
                    parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, highlightPosition, highlightMessage);
                }
                kinTypeElementList.add(currentElement);
                foundKinType = true;
                continue block0;
            }
        }
        if (!foundKinType && !consumableString.startsWith("#")) {
            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - consumableString.length(), errorMessage);
        }
        if (consumableString.contains("#")) {
            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Comment, initialLength - consumableString.length() + consumableString.indexOf("#"), null);
        }
        return kinTypeElementList;
    }

    public ArrayList<KinType> getKinTypes(String consumableString) {
        ArrayList<KinType> kinTypeList = new ArrayList<KinType>();
        boolean foundKinType = true;
        block0: while (foundKinType && consumableString.length() > 0) {
            for (KinType currentReferenceKinType : this.dataStoreSvg.getKinTypeDefinitions()) {
                foundKinType = false;
                if (!consumableString.startsWith(currentReferenceKinType.codeString)) continue;
                kinTypeList.add(currentReferenceKinType);
                consumableString = consumableString.substring(currentReferenceKinType.codeString.length());
                foundKinType = true;
                continue block0;
            }
        }
        return kinTypeList;
    }

    public void readKinTypes(String[] inputStringArray, KinTermGroup[] kinTermsArray, DataStoreSvg dataStoreSvg, ParserHighlight[] parserHighlightArray) {
        HashMap<UniqueIdentifier, EntityData> namedEntitiesMap = new HashMap<UniqueIdentifier, EntityData>();
        HashSet<EntityData> allEntitiesSet = new HashSet<EntityData>();
        ArrayList<String> inputStringList = new ArrayList<String>();
        inputStringList.addAll(Arrays.asList(inputStringArray));
        for (KinTermGroup kinTerms : kinTermsArray) {
            if (!kinTerms.graphGenerate) continue;
            for (KinTerm kinTerm : kinTerms.getKinTerms()) {
                String[] alterKinTypeStrings = kinTerm.alterKinTypeStrings.split("\\|");
                inputStringList.addAll(Arrays.asList(alterKinTypeStrings));
                if (kinTerm.propositusKinTypeStrings == null) continue;
                String[] propositusKinTypeStrings = kinTerm.propositusKinTypeStrings.split("\\|");
                inputStringList.addAll(Arrays.asList(propositusKinTypeStrings));
            }
        }
        ArrayList<EntityData> egoDataNodeList = new ArrayList<EntityData>();
        int lineCounter = -1;
        block2: for (String inputString : inputStringList) {
            ParserHighlight parserHighlight = new ParserHighlight();
            if (parserHighlightArray.length > ++lineCounter) {
                parserHighlightArray[lineCounter] = parserHighlight;
            }
            if (inputString == null || inputString.length() <= 0) continue;
            if (inputString.startsWith("#")) {
                parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Comment, 0, null);
                continue;
            }
            int initialLength = inputString.length();
            String consumableString = inputString;
            HashSet<EntityData> parentDataNodes = new HashSet<EntityData>();
            String fullKinTypeString = "";
            while (consumableString.length() > 0) {
                int parserHighlightPosition = initialLength - consumableString.length();
                boolean kinTypeFound = false;
                for (KinType currentReferenceKinType : dataStoreSvg.getKinTypeDefinitions()) {
                    if (!consumableString.startsWith(currentReferenceKinType.codeString) || currentReferenceKinType.getRelationTypes() == null || currentReferenceKinType.getSymbolTypes() == null) continue;
                    String previousConsumableString = consumableString;
                    if (currentReferenceKinType.hasNoRelationTypes() && !parentDataNodes.isEmpty()) break;
                    parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.KinType, parserHighlightPosition, currentReferenceKinType.displayString);
                    String currentKinTypeString = consumableString;
                    consumableString = consumableString.substring(currentReferenceKinType.codeString.length());
                    consumableString = consumableString.replaceAll("^[-\\+\\d]*", "");
                    currentKinTypeString = currentKinTypeString.substring(0, currentKinTypeString.length() - consumableString.length());
                    String kinTypeModifier = currentKinTypeString.substring(currentReferenceKinType.codeString.length());
                    HashSet<EntityData> currentGraphDataNodeSet = new HashSet<EntityData>();
                    fullKinTypeString = fullKinTypeString + previousConsumableString.substring(0, previousConsumableString.length() - consumableString.length());
                    LabelStringsParser labelStringsParser = new LabelStringsParser(consumableString, currentKinTypeString);
                    if (labelStringsParser.userDefinedIdentifierFound) {
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, initialLength - consumableString.length(), "Label text");
                        consumableString = labelStringsParser.remainingInputString;
                    }
                    if (labelStringsParser.uidStartLocation > -1) {
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Parameter, initialLength - labelStringsParser.uidStartLocation, "User defined identifier");
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, initialLength - labelStringsParser.uidEndLocation, "Label text");
                    }
                    if (labelStringsParser.dateLocation > -1) {
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Parameter, initialLength - labelStringsParser.dateLocation, "Date of birth/death");
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, initialLength - labelStringsParser.dateEndLocation, "Label text");
                    }
                    if (labelStringsParser.dateError) {
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - labelStringsParser.dateLocation, "Incorrect date format: Valid formats are yyyy, yyyy/mm, yyyy/mm/dd with the birth date followed by death date eg yyyy/mm/dd-yyyy/mm/dd");
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Query, initialLength - labelStringsParser.dateEndLocation, "Label text");
                    }
                    if (parentDataNodes.isEmpty()) {
                        this.generateNeededEntities(null, labelStringsParser, parentDataNodes, currentReferenceKinType, currentGraphDataNodeSet, kinTypeModifier, fullKinTypeString, egoDataNodeList, namedEntitiesMap, allEntitiesSet);
                    } else {
                        for (EntityData currentParentNode : parentDataNodes.toArray(new EntityData[0])) {
                            this.generateNeededEntities(currentParentNode, labelStringsParser, parentDataNodes, currentReferenceKinType, currentGraphDataNodeSet, kinTypeModifier, fullKinTypeString, egoDataNodeList, namedEntitiesMap, allEntitiesSet);
                        }
                    }
                    for (EntityData currentGraphDataNode : currentGraphDataNodeSet) {
                        currentGraphDataNode.isVisible = true;
                    }
                    for (KinTermGroup kinTerms : kinTermsArray) {
                        if (!kinTerms.graphShow) continue;
                        for (EntityData currentGraphDataNode : currentGraphDataNodeSet) {
                            for (String kinTermLabel : kinTerms.getTermLabel(fullKinTypeString)) {
                                currentGraphDataNode.addKinTermString(kinTermLabel, kinTerms.graphColour);
                            }
                        }
                    }
                    parentDataNodes = currentGraphDataNodeSet;
                    kinTypeFound = true;
                    break;
                }
                if (kinTypeFound) continue;
                if ((consumableString = consumableString.replaceAll("^[\\s]*", "")).startsWith("#")) {
                    parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Comment, initialLength - consumableString.length(), null);
                    continue block2;
                }
                parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - consumableString.length(), "Incorrect syntax");
                int commentPosition = consumableString.indexOf("#");
                if (commentPosition <= 0) continue block2;
                consumableString = consumableString.substring(commentPosition);
                parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Comment, initialLength - consumableString.length(), null);
                continue block2;
            }
        }
        super.setEntitys(allEntitiesSet.toArray(new EntityData[0]));
    }

    private void generateNeededEntities(EntityData currentParentNode, LabelStringsParser labelStringsParser, HashSet<EntityData> parentDataNodes, KinType currentReferenceKinType, HashSet<EntityData> currentGraphDataNodeSet, String kinTypeModifier, String fullKinTypeString, ArrayList<EntityData> egoDataNodeList, HashMap<UniqueIdentifier, EntityData> namedEntitiesMap, HashSet<EntityData> allEntitiesSet) {
        if (!parentDataNodes.isEmpty() && !labelStringsParser.userDefinedIdentifierFound) {
            for (EntityData parentDataNode : parentDataNodes) {
                for (EntityRelation entityRelation : parentDataNode.getAllRelations()) {
                    if (!currentReferenceKinType.matchesRelation(entityRelation, kinTypeModifier)) continue;
                    EntityData alterNode = entityRelation.getAlterNode();
                    currentGraphDataNodeSet.add(alterNode);
                    alterNode.addKinTypeString(fullKinTypeString);
                }
            }
        } else if (parentDataNodes.isEmpty() && !labelStringsParser.userDefinedIdentifierFound) {
            for (EntityData egoEntity : egoDataNodeList) {
                if (!currentReferenceKinType.matchesEgonessAndSymbol(egoEntity, kinTypeModifier)) continue;
                currentGraphDataNodeSet.add(egoEntity);
                egoEntity.addKinTypeString(fullKinTypeString);
            }
        }
        for (EntityData.SymbolType symbolType : currentReferenceKinType.getSymbolTypes()) {
            EntityData currentGraphDataNode = null;
            if (labelStringsParser.userDefinedIdentifierFound) {
                currentGraphDataNode = namedEntitiesMap.get(labelStringsParser.getUniqueIdentifier());
            } else if (currentParentNode != null) {
                for (EntityRelation entityRelation : currentParentNode.getAllRelations()) {
                    boolean symbolMatchFound = false;
                    for (String symbolName : entityRelation.getAlterNode().getSymbolNames()) {
                        if (!symbolType.toString().equals(symbolName)) continue;
                        symbolMatchFound = true;
                        break;
                    }
                    if (!symbolMatchFound || !currentReferenceKinType.matchesRelation(entityRelation, kinTypeModifier)) continue;
                    currentGraphDataNode = entityRelation.getAlterNode();
                    currentGraphDataNodeSet.add(currentGraphDataNode);
                    currentGraphDataNode.addKinTypeString(fullKinTypeString);
                }
            } else {
                for (EntityData existingEntity : currentGraphDataNodeSet) {
                    if (!currentReferenceKinType.matchesEgonessAndSymbol(existingEntity, kinTypeModifier)) continue;
                    currentGraphDataNode = existingEntity;
                }
            }
            if (currentGraphDataNode == null) {
                currentGraphDataNode = new EntityData(labelStringsParser, currentParentNode, fullKinTypeString, symbolType, currentReferenceKinType.isEgoType());
            }
            if (currentGraphDataNode.isEgo) {
                egoDataNodeList.add(currentGraphDataNode);
            }
            if (labelStringsParser.userDefinedIdentifierFound) {
                namedEntitiesMap.put(currentGraphDataNode.getUniqueIdentifier(), currentGraphDataNode);
            }
            currentGraphDataNodeSet.add(currentGraphDataNode);
            allEntitiesSet.add(currentGraphDataNode);
            if (parentDataNodes.isEmpty() || currentReferenceKinType.hasNoRelationTypes() || currentParentNode == null) continue;
            for (DataTypes.RelationType relationType : currentReferenceKinType.getRelationTypes()) {
                EntityRelation nodeRelation = currentParentNode.addRelatedNode(currentGraphDataNode, relationType, null, null, null, null);
                if (kinTypeModifier == null || kinTypeModifier.isEmpty()) continue;
                if (kinTypeModifier.equals("-")) {
                    nodeRelation.setRelationOrder(-1);
                    continue;
                }
                if (kinTypeModifier.equals("+")) {
                    nodeRelation.setRelationOrder(1);
                    continue;
                }
                nodeRelation.setRelationOrder(Integer.parseInt(kinTypeModifier.replaceFirst("^\\+", "")));
            }
        }
    }

    public class KinTypeElement {
        public KinTypeElement prevType;
        public KinTypeElement nextType;
        public KinType kinType;
        public ArrayList<QueryTerm> queryTerms;
        public ArrayList<EntityData> entityData = new ArrayList();
        ParserHighlight[] highlightLocs;
    }

    public class QueryTerm {
        public String fieldXPath;
        public QueryType comparatorType;
        public String searchValue;

        public QueryTerm(String fieldXPath, QueryType comparatorType, String searchValue) {
            this.fieldXPath = fieldXPath;
            this.comparatorType = comparatorType;
            this.searchValue = searchValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueryType {
        Contains,
        Greater,
        Less,
        Equals;

    }
}

