/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.ImageIcon;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.clarin.CmdiComponentLinkReader;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilDataNodeService;
import nl.mpi.arbil.data.ArbilFavouritesSorter;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilFieldComparator;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ArbilNodeSorter;
import nl.mpi.arbil.data.MetadataFormat;
import nl.mpi.arbil.data.metadatafile.CmdiUtils;
import nl.mpi.arbil.data.metadatafile.ImdiUtils;
import nl.mpi.arbil.data.metadatafile.MetadataUtils;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.util.ArrayComparator;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MimeHashQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilDataNode
extends ArbilNode
implements Comparable {
    private ArbilDataNodeService dataNodeService;
    public MetadataUtils metadataUtils;
    public ArbilTemplate nodeTemplate;
    private Hashtable<String, ArbilField[]> fieldHashtable;
    protected ArbilDataNode[] childArray = new ArbilDataNode[0];
    private boolean dataLoaded;
    public int resourceFileServerResponse = -1;
    public String hashString;
    public String mpiMimeType = null;
    public String typeCheckerMessage;
    private MimeHashQueue.TypeCheckerState typeCheckerState = MimeHashQueue.TypeCheckerState.UNCHECKED;
    public int matchesInCache;
    public int matchesRemote;
    public int matchesLocalFileSystem;
    public boolean fileNotFound;
    public boolean isInfoLink = false;
    private boolean singletonMetadataNode = false;
    protected boolean nodeNeedsSaveToDisk;
    protected String nodeText;
    protected String lastNodeText = "loading node...";
    private URI nodeUri;
    private boolean containerNode = false;
    public ArbilField resourceUrlField;
    public CmdiComponentLinkReader cmdiComponentLinkReader = null;
    public boolean isDirectory;
    private ImageIcon icon;
    private boolean nodeEnabled;
    public boolean hasSchemaError = false;
    protected String[][] childLinks = new String[0][0];
    private int isLoadingCount = 0;
    private final Object loadingCountLock = new Object();
    @Deprecated
    public boolean lockedByLoadingThread = false;
    public String archiveHandle = null;
    public boolean hasDomIdAttribute = false;
    public boolean scrollToRequested = false;
    private ArbilDataNode domParentNode = null;
    public File thumbnailFile = null;
    private final Object domLockObjectPrivate = new Object();
    private static final String NODE_LOADING_TEXT = "loading node...";
    private Boolean isFavorite = null;
    private static ArbilNodeSorter dataNodeSorter = new ArbilNodeSorter();
    private static ArbilNodeSorter favouriteSorter = new ArbilFavouritesSorter();

    protected ArbilDataNode(ArbilDataNodeService dataNodeService, URI localUri) {
        this.dataNodeService = dataNodeService;
        this.nodeUri = localUri;
        if (this.nodeUri != null) {
            this.metadataUtils = ArbilDataNode.getMetadataUtils(this.nodeUri.toString());
        }
        this.initNodeVariables();
    }

    public void setNodeText(String localNodeText) {
        if (this.nodeText == null) {
            this.nodeText = localNodeText;
        }
    }

    public static boolean isArbilDataNode(Object unknownObj) {
        if (unknownObj == null) {
            return false;
        }
        return unknownObj instanceof ArbilDataNode;
    }

    public static boolean isStringLocal(String urlString) {
        return urlString.startsWith("file:");
    }

    public static boolean isUriLocal(URI uri) {
        return uri.getScheme().equalsIgnoreCase("file");
    }

    public static boolean isPathHistoryFile(String urlString) {
        return MetadataFormat.isPathMetadata(urlString.replaceAll("mdi.[0-9]*$", "mdi"));
    }

    public static boolean isPathMetadata(String urlString) {
        return ArbilDataNode.isPathImdi(urlString) || ArbilDataNode.isPathCmdi(urlString);
    }

    public static boolean isPathImdi(String urlString) {
        return urlString.endsWith(".imdi");
    }

    public static boolean isPathCmdi(String urlString) {
        return urlString.endsWith(".cmdi");
    }

    public static boolean isStringChildNode(String urlString) {
        return urlString.contains("#.");
    }

    public static MetadataUtils getMetadataUtils(String urlString) {
        if (MetadataFormat.isPathCmdi(urlString)) {
            return new CmdiUtils();
        }
        if (MetadataFormat.isPathImdi(urlString)) {
            return new ImdiUtils();
        }
        return null;
    }

    public MetadataUtils getMetadataUtils() {
        return this.metadataUtils;
    }

    public boolean getNeedsSaveToDisk(boolean onlyOfSubNode) {
        if (this.nodeNeedsSaveToDisk && !this.getParentDomNode().nodeNeedsSaveToDisk) {
            this.nodeNeedsSaveToDisk = false;
        }
        if (onlyOfSubNode) {
            return this.nodeNeedsSaveToDisk;
        }
        return this.getParentDomNode().nodeNeedsSaveToDisk;
    }

    protected boolean isNeedsSaveToDisk() {
        return this.isNeedsSaveToDisk();
    }

    public boolean hasChangedFields() {
        for (ArbilField[] currentFieldArray : this.fieldHashtable.values()) {
            for (ArbilField currentField : currentFieldArray) {
                if (!currentField.fieldNeedsSaveToDisk()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasChangedFieldsInSubtree() {
        if (this.hasChangedFields()) {
            return true;
        }
        for (ArbilDataNode child : this.getChildArray()) {
            if (!child.hasChangedFieldsInSubtree()) continue;
            return true;
        }
        return false;
    }

    public void setDataNodeNeedsSaveToDisk(ArbilField originatingField, boolean updateUI) {
        this.dataNodeService.setDataNodeNeedsSaveToDisk(this, originatingField, updateUI);
    }

    public String getAnyMimeType() {
        ArbilField[] formatField;
        if (this.mpiMimeType == null && this.hasResource() && (formatField = this.getFieldArray("Format")) != null && formatField.length > 0) {
            return formatField[0].getFieldValue();
        }
        return this.mpiMimeType;
    }

    public void setMimeType(String[] typeCheckerMessageArray) {
        this.mpiMimeType = typeCheckerMessageArray[0];
        this.typeCheckerMessage = typeCheckerMessageArray[1];
        if (!this.isMetaDataNode() && this.isLocal() && this.mpiMimeType != null) {
            ArbilField mimeTypeField = new ArbilField(this.fieldHashtable.size(), this, "Format", this.mpiMimeType, 0, false, null, null);
            this.addField(mimeTypeField);
        }
    }

    private String getNodeTypeNameFromUriFragment(String nodeFragmentName) {
        if (nodeFragmentName == null) {
            return null;
        }
        nodeFragmentName = nodeFragmentName.substring(nodeFragmentName.lastIndexOf(".") + 1);
        nodeFragmentName = nodeFragmentName.replaceAll("\\(\\d+\\)", "");
        return nodeFragmentName;
    }

    protected final void initNodeVariables() {
        if (this.childArray != null) {
            for (ArbilDataNode currentNode : this.childArray) {
                if (!currentNode.isChildNode()) continue;
                currentNode.initNodeVariables();
            }
        }
        this.fieldHashtable = new Hashtable();
        this.dataLoaded = false;
        this.hashString = null;
        this.matchesInCache = 0;
        this.matchesRemote = 0;
        this.matchesLocalFileSystem = 0;
        this.fileNotFound = false;
        this.nodeNeedsSaveToDisk = false;
        this.isDirectory = false;
        this.icon = null;
        this.nodeEnabled = true;
        this.singletonMetadataNode = false;
        this.containerNode = false;
        if (this.nodeUri != null) {
            File fileObject;
            if (!this.isMetaDataNode() && this.isLocal() && (fileObject = this.getFile()) != null) {
                this.nodeText = fileObject.getName();
                this.isDirectory = fileObject.isDirectory();
            }
            if (!this.isMetaDataNode() && this.nodeText == null) {
                this.nodeText = this.getUrlString();
            }
        }
    }

    public void reloadNode() {
        this.dataNodeService.reloadNode(this);
    }

    public void loadArbilDom() {
        this.dataNodeService.loadArbilDom(this);
    }

    @Override
    public int getChildCount() {
        return this.childArray.length;
    }

    @Override
    public ArbilDataNode[] getAllChildren() {
        Vector<ArbilDataNode> allChildren = new Vector<ArbilDataNode>();
        this.getAllChildren(allChildren);
        return allChildren.toArray(new ArbilDataNode[0]);
    }

    @Override
    public void getAllChildren(Vector<ArbilDataNode> allChildren) {
        System.out.println("getAllChildren: " + this.getUrlString());
        if (this.isSession() || this.isCatalogue() || this.isChildNode() || this.isCmdiMetaDataNode()) {
            for (ArbilDataNode currentChild : this.childArray) {
                if (currentChild == this) continue;
                currentChild.getAllChildren(allChildren);
                allChildren.add(currentChild);
            }
        }
    }

    public ArbilDataNode[] getChildArray() {
        return this.childArray;
    }

    public ArbilDataNode[] getChildNodesArray(String childType) {
        for (ArbilDataNode currentNode : this.childArray) {
            if (!currentNode.toString().equals(childType)) continue;
            return currentNode.getChildArray();
        }
        return null;
    }

    public ArbilDataNode getChildByPath(String path) {
        if (this.childArray != null && this.childArray.length > 0) {
            for (ArbilDataNode child : this.childArray) {
                if (child.getURI() != null && path.equals(child.getURI().getFragment())) {
                    return child;
                }
                ArbilDataNode childMatch = child.getChildByPath(path);
                if (childMatch == null) continue;
                return childMatch;
            }
        }
        return null;
    }

    public ArbilTemplate getNodeTemplate() {
        if (this.nodeTemplate != null && !this.isCorpus()) {
            return this.nodeTemplate;
        }
        if (this.isChildNode()) {
            return this.getParentDomNode().getNodeTemplate();
        }
        return ArbilTemplateManager.getSingleInstance().getDefaultTemplate();
    }

    public File getSubDirectory() {
        String currentFileName = this.getFile().getParent();
        if (MetadataFormat.isPathImdi(this.nodeUri.getPath()) || MetadataFormat.isPathCmdi(this.nodeUri.getPath())) {
            File destinationDir = new File(currentFileName = currentFileName + File.separatorChar + this.getFile().getName().substring(0, this.getFile().getName().length() - 5));
            if (!destinationDir.exists() && !destinationDir.mkdir()) {
                BugCatcherManager.getBugCatcher().logError(new Exception("Could not create directory " + destinationDir.getAbsolutePath()));
            }
            return destinationDir;
        }
        return new File(this.getFile().getParent());
    }

    public boolean containsFieldValue(String fieldName, String searchValue) {
        boolean findResult = false;
        ArbilField[] currentFieldArray = this.fieldHashtable.get(fieldName);
        if (currentFieldArray != null) {
            for (ArbilField currentField : currentFieldArray) {
                System.out.println("containsFieldValue: " + currentField.getFieldValue() + ":" + searchValue);
                if (!currentField.getFieldValue().toLowerCase().contains(searchValue.toLowerCase())) continue;
                return true;
            }
        }
        System.out.println("result: " + findResult + ":" + this);
        return findResult;
    }

    public boolean containsFieldValue(String searchValue) {
        boolean findResult = false;
        for (ArbilField[] currentFieldArray : this.fieldHashtable.values()) {
            for (ArbilField currentField : currentFieldArray) {
                System.out.println("containsFieldValue: " + currentField.getFieldValue() + ":" + searchValue);
                if (!currentField.getFieldValue().toLowerCase().contains(searchValue.toLowerCase())) continue;
                return true;
            }
        }
        System.out.println("result: " + findResult + ":" + this);
        return findResult;
    }

    public boolean getNodeEnabled() {
        return this.nodeEnabled;
    }

    public boolean canHaveChildren() {
        return this.childArray.length > 0;
    }

    protected void getAllFields(Vector<ArbilField[]> allFields) {
        System.out.println("getAllFields: " + this.toString());
        allFields.addAll(this.fieldHashtable.values());
        for (ArbilDataNode currentChild : this.childArray) {
            if (!currentChild.isChildNode()) continue;
            currentChild.getAllFields(allFields);
        }
    }

    public void deleteCorpusLink(ArbilDataNode[] targetImdiNodes) {
        this.dataNodeService.deleteCorpusLink(this, targetImdiNodes);
    }

    @Override
    public boolean hasCatalogue() {
        for (ArbilDataNode childNode : this.childArray) {
            if (!childNode.isCatalogue()) continue;
            return true;
        }
        return false;
    }

    public boolean addCorpusLink(ArbilDataNode targetImdiNode) {
        return this.dataNodeService.addCorpusLink(this, targetImdiNode);
    }

    public void pasteIntoNode() {
        this.dataNodeService.pasteIntoNode(this);
    }

    public synchronized void saveChangesToCache(boolean updateUI) {
        this.dataNodeService.saveChangesToCache(this);
    }

    public void addField(ArbilField fieldToAdd) {
        this.dataNodeService.addField(this, fieldToAdd);
    }

    public Hashtable<String, ArbilField[]> getFields() {
        return this.fieldHashtable;
    }

    public List<ArbilField[]> getFieldsSorted() {
        ArrayList<ArbilField[]> fieldArrays = new ArrayList<ArbilField[]>(this.getFields().values());
        Collections.sort(fieldArrays, new ArrayComparator<ArbilField>(new ArbilFieldComparator(), 0));
        return fieldArrays;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this.isFavorite()) {
            return favouriteSorter.compare(this, o);
        }
        return dataNodeSorter.compare(this, o);
    }

    public synchronized void notifyLoaded() {
        this.getParentDomNode().notifyAll();
    }

    public synchronized boolean waitTillLoaded() {
        System.out.println("waitTillLoaded");
        if (this != this.getParentDomNode()) {
            return this.getParentDomNode().waitTillLoaded();
        }
        if (this.isLoading()) {
            System.out.println("isLoading");
            try {
                this.getParentDomNode().wait();
                System.out.println("wait");
                if (this.isLoading()) {
                    BugCatcherManager.getBugCatcher().logError(new Exception("waited till loaded but its still loading: " + this.getUrlString()));
                }
            }
            catch (Exception ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLoadingState(int countChange) {
        if (this != this.getParentDomNode()) {
            this.getParentDomNode().updateLoadingState(countChange);
        } else {
            Object object = this.loadingCountLock;
            synchronized (object) {
                this.isLoadingCount += countChange;
            }
            if (!this.isLoading()) {
                this.clearChildIcons();
                this.clearIcon();
            }
        }
    }

    @Override
    public synchronized boolean isLoading() {
        return this.getParentDomNode().isLoadingCount > 0;
    }

    public String toString() {
        if (this.lastNodeText != null) {
            return this.lastNodeText;
        }
        return "unknown";
    }

    public boolean isNodeTextDetermined() {
        return this.lastNodeText != null && !this.lastNodeText.equals(NODE_LOADING_TEXT);
    }

    public String refreshStringValue() {
        URI resourceUri;
        if (this.isLoading()) {
            return this.lastNodeText;
        }
        if (this.lastNodeText.equals(NODE_LOADING_TEXT) && this.getParentDomNode().dataLoaded) {
            this.lastNodeText = "                      ";
        }
        boolean foundPreferredNameField = false;
        boolean preferredNameFieldExists = false;
        block2: for (String currentPreferredName : this.getNodeTemplate().preferredNameFields) {
            for (ArbilField[] currentFieldArray : (ArbilField[][])this.fieldHashtable.values().toArray((T[])new ArbilField[0][])) {
                if (!currentFieldArray[0].getFullXmlPath().replaceAll("\\(\\d+\\)", "").equals(currentPreferredName)) continue;
                preferredNameFieldExists = true;
                for (ArbilField currentField : currentFieldArray) {
                    if (currentField == null || currentField.toString().trim().length() <= 0) continue;
                    this.nodeText = currentField.toString();
                    foundPreferredNameField = true;
                    break block2;
                }
            }
            ArbilField[] currentFieldArray = this.getFieldArray(currentPreferredName);
            if (currentFieldArray == null) continue;
            for (ArbilField currentField : currentFieldArray) {
                if (currentField == null || currentField.toString().trim().length() <= 0) continue;
                this.nodeText = currentField.toString();
                foundPreferredNameField = true;
                break block2;
            }
        }
        if (!foundPreferredNameField && this.isCmdiMetaDataNode()) {
            String nodeFragmentName = this.getURI().getFragment();
            String unamedText = nodeFragmentName != null ? (nodeFragmentName = this.getNodeTypeNameFromUriFragment(nodeFragmentName)) : (this.nodeTemplate != null ? this.nodeTemplate.getTemplateName() : "");
            this.nodeText = preferredNameFieldExists ? unamedText + " (unnamed)" : unamedText;
        }
        if (this.hasResource() && (resourceUri = this.getFullResourceURI()) != null) {
            String resourcePathString = resourceUri.toString();
            int lastIndex = resourcePathString.lastIndexOf("/");
            resourcePathString = resourcePathString.substring(lastIndex + 1);
            try {
                resourcePathString = URLDecoder.decode(resourcePathString, "UTF-8");
            }
            catch (UnsupportedEncodingException encodingException) {
                BugCatcherManager.getBugCatcher().logError(encodingException);
            }
            this.nodeText = resourcePathString;
        }
        if (this.isInfoLink) {
            String infoTitle = this.fieldHashtable.values().iterator().next()[0].getFieldValue();
            if ((infoTitle = infoTitle.trim()).length() > 0) {
                this.nodeText = infoTitle;
            }
        }
        if (this.nodeText != null) {
            File nodeFile;
            if (this.isMetaDataNode() && (nodeFile = this.getFile()) != null && !this.isHeadRevision()) {
                this.nodeText = this.nodeText + " (rev:" + this.getHistoryLabelStringForFile(nodeFile) + ")";
            }
            this.lastNodeText = this.nodeText;
        }
        if (this.isContainerNode()) {
            this.lastNodeText = String.format("%1$s (%2$d)", this.lastNodeText, this.getChildCount());
        } else if (this.isSingletonMetadataNode()) {
            StringBuilder nodeTextSB = new StringBuilder(this.getNodeTypeNameFromUriFragment(this.getURI().getFragment()));
            if (this.nodeText != null && this.nodeText.length() > 0) {
                nodeTextSB.append(" (").append(this.nodeText).append(")");
            }
            this.lastNodeText = nodeTextSB.toString();
        }
        if (this.lastNodeText.length() == 0) {
            this.lastNodeText = "                      ";
        }
        return this.lastNodeText;
    }

    @Override
    public boolean isArchivableFile() {
        return this.mpiMimeType != null;
    }

    @Override
    public boolean hasResource() {
        return this.resourceUrlField != null;
    }

    public boolean canHaveResource() {
        ArbilTemplate template;
        if (this.hasResource()) {
            return true;
        }
        if (this.isCmdiMetaDataNode() && (template = this.getNodeTemplate()) != null) {
            return template.pathCanHaveResource(this.nodeUri.getFragment());
        }
        return false;
    }

    public void insertResourceLocation(URI location) throws ArbilMetadataException {
        this.dataNodeService.insertResourceLocation(this, location);
    }

    @Override
    public boolean hasLocalResource() {
        if (!this.hasResource()) {
            return false;
        }
        if (this.resourceUrlField.getFieldValue().toLowerCase().startsWith("http")) {
            return false;
        }
        return this.isLocal();
    }

    public boolean resourceFileNotFound() {
        if (this.hasLocalResource()) {
            if (this.resourceUrlField.getFieldValue().length() == 0) {
                return true;
            }
            try {
                return !new File(this.getFullResourceURI()).exists();
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    private String getResource() {
        return this.resourceUrlField.getFieldValue();
    }

    @Override
    public boolean hasHistory() {
        if (!this.isLocal()) {
            return false;
        }
        return !this.isChildNode() && new File(this.getFile().getAbsolutePath() + ".0").exists();
    }

    private boolean isHeadRevision() {
        return !new File(this.getFile().getAbsolutePath() + ".x").exists();
    }

    private String getHistoryLabelStringForFile(File historyFile) {
        Date mtime = new Date(historyFile.lastModified());
        String mTimeString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mtime);
        return mTimeString;
    }

    public String[][] getHistoryList() {
        File currentHistoryFile;
        Vector<String[]> historyVector = new Vector<String[]>();
        int versionCounter = 0;
        if (!this.isHeadRevision()) {
            historyVector.add(new String[]{"Last Save", ".x"});
        }
        do {
            if ((currentHistoryFile = new File(this.getFile().getAbsolutePath() + "." + versionCounter)).exists()) {
                String mTimeString = this.getHistoryLabelStringForFile(currentHistoryFile);
                historyVector.add(new String[]{mTimeString, "." + versionCounter});
            }
            ++versionCounter;
        } while (currentHistoryFile.exists());
        return (String[][])historyVector.toArray((T[])new String[][]{new String[0]});
    }

    public boolean resurrectHistory(String historyVersion) {
        return this.dataNodeService.resurrectHistory(this, historyVersion);
    }

    public void bumpHistory() throws IOException {
        this.dataNodeService.bumpHistory(this);
    }

    public URI getFullResourceURI() {
        try {
            boolean isUncPath;
            URI targetUri;
            String targetUriString = this.resourceUrlField.getFieldValue();
            String[] uriParts = targetUriString.split(":/", 2);
            if (uriParts.length > 1) {
                String bracketEncodedPath = uriParts[1];
                targetUri = new URI(uriParts[0], "/" + bracketEncodedPath, null);
            } else {
                targetUri = new URI(null, targetUriString, null);
            }
            URI resourceUri = this.nodeUri.resolve(targetUri);
            if (!targetUri.equals(resourceUri) && (isUncPath = this.nodeUri.toString().toLowerCase().startsWith("file:////"))) {
                try {
                    resourceUri = new URI("file:////" + resourceUri.toString().substring("file:/".length()));
                }
                catch (URISyntaxException urise) {
                    BugCatcherManager.getBugCatcher().logError(urise);
                }
            }
            return resourceUri;
        }
        catch (Exception urise) {
            BugCatcherManager.getBugCatcher().logError(urise);
            System.out.println("URISyntaxException: " + urise.getMessage());
            return null;
        }
    }

    public String getUrlString() {
        return this.nodeUri.toString();
    }

    public Object getParentDomLockObject() {
        return this.getParentDomNode().domLockObjectPrivate;
    }

    public synchronized ArbilDataNode getParentDomNode() {
        if (this.domParentNode == null) {
            if (this.nodeUri.getFragment() != null) {
                try {
                    this.domParentNode = this.dataNodeService.loadArbilDataNode(null, new URI(this.nodeUri.toString().split("#")[0]));
                }
                catch (URISyntaxException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            } else {
                this.domParentNode = this;
            }
        }
        return this.domParentNode;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isMetaDataNode() {
        if (this.nodeUri != null) {
            if (this.isChildNode()) {
                return true;
            }
            return MetadataFormat.isPathMetadata(this.nodeUri.getPath());
        }
        return false;
    }

    @Override
    public boolean isCmdiMetaDataNode() {
        if (this.nodeUri != null) {
            if (this.isChildNode()) {
                return this.getParentDomNode().isCmdiMetaDataNode();
            }
            return MetadataFormat.isPathCmdi(this.nodeUri.getPath());
        }
        return false;
    }

    @Override
    public boolean isChildNode() {
        return ArbilDataNode.isStringChildNode(this.getUrlString());
    }

    @Override
    public boolean isSession() {
        ArbilField[] nameFields = this.getFieldArray("Name");
        if (nameFields != null) {
            return nameFields[0].xmlPath.equals(".METATRANSCRIPT.Session.Name");
        }
        return false;
    }

    @Override
    public boolean isEmptyMetaNode() {
        return this.getFields().isEmpty();
    }

    @Override
    public boolean isCatalogue() {
        ArbilField[] nameFields = this.getFieldArray("Name");
        if (nameFields != null) {
            return nameFields[0].xmlPath.equals(".METATRANSCRIPT.Catalogue.Name");
        }
        return false;
    }

    @Override
    public boolean isCorpus() {
        if (this.isCmdiMetaDataNode()) {
            return false;
        }
        ArbilField[] nameFields = this.getFieldArray("Name");
        if (nameFields != null) {
            return nameFields[0].xmlPath.equals(".METATRANSCRIPT.Corpus.Name");
        }
        return false;
    }

    @Override
    public boolean isLocal() {
        if (this.nodeUri != null) {
            return ArbilDataNode.isUriLocal(this.nodeUri);
        }
        return false;
    }

    @Override
    public boolean isEditable() {
        return this.dataNodeService.isEditable(this);
    }

    public URI getURI() {
        try {
            return this.nodeUri;
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
            return null;
        }
    }

    public File getFile() {
        if (this.nodeUri.getScheme().toLowerCase().equals("file")) {
            try {
                return new File(new URI(this.nodeUri.toString().split("#")[0]));
            }
            catch (Exception urise) {
                BugCatcherManager.getBugCatcher().logError(this.nodeUri.toString(), urise);
            }
        }
        return null;
    }

    public String getParentDirectory() {
        String parentPath = this.getUrlString().substring(0, this.getUrlString().lastIndexOf("/")) + "/";
        return parentPath;
    }

    @Override
    public void registerContainer(ArbilDataNodeContainer containerToAdd) {
        if (!this.getParentDomNode().dataLoaded && !this.isLoading()) {
            this.dataNodeService.reloadNode(this);
        }
        super.registerContainer(containerToAdd);
    }

    public void clearChildIcons() {
        for (ArbilDataNode currentChild : this.childArray) {
            currentChild.clearChildIcons();
            currentChild.clearIcon();
        }
    }

    public void clearIcon() {
        this.refreshStringValue();
        this.icon = ArbilIcons.getSingleInstance().getIconForNode(this);
        Enumeration containersIterator = this.containersOfThisNode.elements();
        while (containersIterator.hasMoreElements()) {
            try {
                ArbilDataNodeContainer currentContainer = (ArbilDataNodeContainer)containersIterator.nextElement();
                currentContainer.dataNodeIconCleared(this);
            }
            catch (NoSuchElementException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
    }

    public synchronized void removeFromAllContainers() {
        for (ArbilDataNode currentChildNode : this.getAllChildren()) {
            currentChildNode.removeFromAllContainers();
        }
        for (ArbilDataNodeContainer currentContainer : this.containersOfThisNode.toArray(new ArbilDataNodeContainer[0])) {
            try {
                currentContainer.dataNodeRemoved(this);
            }
            catch (NoSuchElementException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
    }

    @Override
    public boolean isFavorite() {
        if (this.isFavorite == null) {
            this.isFavorite = this.dataNodeService.isFavorite(this);
        }
        return this.isFavorite;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.icon == null) {
            return ArbilIcons.getSingleInstance().loadingIcon;
        }
        return this.icon;
    }

    @Override
    public boolean isDataLoaded() {
        if (this.isChildNode()) {
            return this.getParentDomNode().dataLoaded;
        }
        return this.dataLoaded;
    }

    public void setDataLoaded(boolean dataLoaded) {
        this.dataLoaded = dataLoaded;
    }

    @Override
    public boolean isResourceSet() {
        return this.resourceUrlField != null && this.resourceUrlField.getFieldValue().length() > 0;
    }

    public void invalidateThumbnails() {
        this.thumbnailFile = null;
        for (ArbilDataNode node : this.getChildArray()) {
            node.invalidateThumbnails();
        }
    }

    public boolean isSingletonMetadataNode() {
        return this.singletonMetadataNode;
    }

    public void setSingletonMetadataNode(boolean singletonMetadataNodeName) {
        this.singletonMetadataNode = singletonMetadataNodeName;
    }

    public boolean isContainerNode() {
        return this.containerNode;
    }

    public void setContainerNode(boolean containerNode) {
        this.containerNode = containerNode;
    }

    public CmdiComponentLinkReader getCmdiComponentLinkReader() {
        return this.getParentDomNode().cmdiComponentLinkReader;
    }

    public MimeHashQueue.TypeCheckerState getTypeCheckerState() {
        return this.typeCheckerState;
    }

    public void setTypeCheckerState(MimeHashQueue.TypeCheckerState typeCheckerState) {
        this.typeCheckerState = typeCheckerState;
    }

    protected String[][] getChildLinks() {
        return this.childLinks;
    }

    protected ArbilField[] getFieldArray(String translateFieldName) {
        return this.fieldHashtable.get(translateFieldName);
    }

    protected void addFieldArray(String translateFieldName, ArbilField[] fieldArray) {
        this.fieldHashtable.put(translateFieldName, fieldArray);
    }
}

