/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.templates;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilVocabulary;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilTemplate {
    private static MessageDialogHandler messageDialogHandler;
    public File templateFile;
    protected Hashtable<String, ArbilVocabulary> vocabularyHashTable = null;
    public String loadedTemplateName;
    public String[] preferredNameFields;
    public String[][] fieldTriggersArray;
    public String[][] genreSubgenreArray;
    public String[] requiredFields;
    public String[][] fieldConstraints;
    protected String[][] childNodePaths;
    protected String[][] fieldUsageArray;
    protected String[][] resourceNodePaths;
    protected String[][] templatesArray;
    protected String[][] rootTemplatesArray;
    public String[][] autoFieldsArray;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public boolean pathCanHaveResource(String nodePath) {
        if (this.resourceNodePaths != null) {
            if (nodePath == null) {
                if (this.resourceNodePaths.length > 0) {
                    return true;
                }
            } else {
                nodePath = nodePath.replaceAll("\\(\\d+\\)", "");
                for (String[] currentPath : this.resourceNodePaths) {
                    if (!currentPath[0].equals(nodePath)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean pathIsEditableField(String nodePath) {
        for (String[] pathString : this.childNodePaths) {
            if (!pathString[0].startsWith(nodePath) && !pathString[0].equals(nodePath)) continue;
            return false;
        }
        for (String[] pathString : this.templatesArray) {
            if (!pathString[0].startsWith(nodePath) || pathString[0].equals(nodePath)) continue;
            return false;
        }
        return true;
    }

    public String pathIsChildNode(String nodePath) {
        for (String[] pathString : this.childNodePaths) {
            if (!nodePath.endsWith(pathString[0])) continue;
            return pathString[1];
        }
        return null;
    }

    public boolean pathIsDeleteableField(String nodePath) {
        String imdiNodePath = nodePath.substring(1) + ".xml";
        String cmdiNodePath = nodePath.replaceAll("\\(x\\)", "");
        for (String[] pathString : this.templatesArray) {
            if (!pathString[0].equals(cmdiNodePath) && !pathString[0].equals(imdiNodePath)) continue;
            return true;
        }
        return false;
    }

    public int getMaxOccursForTemplate(String templatPath) {
        String cmdiNodePath = templatPath.replaceAll("\\(\\d*?\\)", "(x)");
        cmdiNodePath = cmdiNodePath.replaceAll("\\(x\\)$", "");
        String imdiNodePath = cmdiNodePath.substring(1) + ".xml";
        for (String[] pathString : this.templatesArray) {
            if (!pathString[0].equals(cmdiNodePath) && !pathString[0].equals(imdiNodePath)) continue;
            Integer returnValue = Integer.parseInt(pathString[3]);
            if (returnValue == null) {
                return -1;
            }
            return returnValue;
        }
        return -1;
    }

    public String getInsertBeforeOfTemplate(String templatPath) {
        String cmdiNodePath = templatPath.replaceAll("\\(\\d*?\\)", "(x)");
        cmdiNodePath = cmdiNodePath.replaceAll("\\(x\\)$", "");
        String imdiNodePath = cmdiNodePath.substring(1) + ".xml";
        for (String[] pathString : this.templatesArray) {
            if (!pathString[0].equals(cmdiNodePath) && !pathString[0].equals(imdiNodePath)) continue;
            if (pathString[2] != null) {
                return pathString[2];
            }
            return "";
        }
        return "";
    }

    public boolean isArbilChildNode(String childType) {
        boolean returnValue = false;
        if (childType != null) {
            if (CmdiProfileReader.pathIsProfile(childType)) {
                returnValue = false;
            } else {
                returnValue = true;
                String childTypeTemp = (childType + ".xml").substring(1);
                for (String[] currentTemplate : this.rootTemplatesArray) {
                    if (!childTypeTemp.equals(currentTemplate[0])) continue;
                    returnValue = false;
                }
                if (returnValue) {
                    returnValue = false;
                    for (String[] currentTemplate : this.templatesArray) {
                        if (!childTypeTemp.equals(currentTemplate[0])) continue;
                        returnValue = true;
                    }
                }
            }
        }
        return returnValue;
    }

    private List<String[]> getSubnodesFromTemplatesDir(String nodepath) {
        Vector<String[]> returnVector = new Vector<String[]>();
        System.out.println("getSubnodesOf: " + nodepath);
        String targetNodePath = nodepath.substring(0, nodepath.lastIndexOf(")") + 1);
        nodepath = nodepath.replaceAll("\\(\\d*?\\)", "\\(x\\)");
        System.out.println("nodepath: " + nodepath);
        System.out.println("targetNodePath: " + targetNodePath);
        for (String[] currentTemplate : this.templatesArray) {
            if (currentTemplate[0].endsWith("Session.xml") || currentTemplate[0].endsWith("Catalogue.xml") || !currentTemplate[0].startsWith(nodepath.substring(1)) || targetNodePath.replaceAll("[^(]*", "").length() < currentTemplate[0].replaceAll("[^(]*", "").length()) continue;
            String currentValue = currentTemplate[0].replaceFirst("\\.xml$", "");
            returnVector.add(new String[]{currentTemplate[1], "." + currentValue});
        }
        return returnVector;
    }

    public String getParentOfField(String targetFieldPath) {
        if (targetFieldPath == null) {
            return "";
        }
        String testString = targetFieldPath.replaceAll("\\(\\d+\\)", "");
        String bestMatch = "";
        for (String[] currentTemplate : this.childNodePaths) {
            String currentNodePath = currentTemplate[0];
            if (!testString.startsWith(currentNodePath) || bestMatch.length() >= currentNodePath.length()) continue;
            bestMatch = currentNodePath;
        }
        String returnString = targetFieldPath;
        while (returnString.split("\\.").length > bestMatch.split("\\.").length) {
            returnString = returnString.replaceFirst("\\.[^\\.]+$", "");
        }
        return returnString;
    }

    public Enumeration listTypesFor(Object targetNodeUserObject) {
        return this.listTypesFor(targetNodeUserObject, false);
    }

    public Enumeration listTypesFor(Object targetNodeUserObject, boolean includeCorpusNodeEntries) {
        List<String[]> childTypes = this.getTypesFor(targetNodeUserObject, includeCorpusNodeEntries);
        Collections.sort(childTypes, new Comparator(){

            public int compare(Object o1, Object o2) {
                String value1 = ((String[])o1)[0];
                String value2 = ((String[])o2)[0];
                return value1.compareTo(value2);
            }
        });
        return Collections.enumeration(childTypes);
    }

    private List<String[]> getTypesFor(Object targetNodeUserObject, boolean includeCorpusNodeEntries) {
        ArrayList<String[]> childTypes;
        block4: {
            block3: {
                if (!(targetNodeUserObject instanceof ArbilDataNode)) break block3;
                ArbilDataNode targetNode = (ArbilDataNode)targetNodeUserObject;
                String xpath = MetadataReader.getNodePath(targetNode);
                childTypes = this.getSubnodesFromTemplatesDir(xpath);
                if (!includeCorpusNodeEntries || !targetNode.isCorpus()) break block4;
                for (String[] currentTemplate : this.rootTemplatesArray) {
                    boolean suppressEntry = false;
                    if (currentTemplate[1].equals("Catalogue") && targetNode.hasCatalogue()) {
                        suppressEntry = true;
                    }
                    if (suppressEntry) continue;
                    childTypes.add(new String[]{currentTemplate[1], "." + currentTemplate[0].replaceFirst("\\.xml$", "")});
                }
                break block4;
            }
            childTypes = new ArrayList();
            for (String[] currentTemplate : this.rootTemplatesArray) {
                if (currentTemplate[1].equals("Catalogue")) continue;
                childTypes.add(new String[]{"Unattached " + currentTemplate[1], "." + currentTemplate[0].replaceFirst("\\.xml$", "")});
            }
        }
        return childTypes;
    }

    public boolean nodeCanContainType(ArbilDataNode dataNode, String type) {
        for (String[] currentField : this.getTypesFor(dataNode, true)) {
            String nodeType = currentField[1];
            if (!nodeType.equals(type)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> listAllTemplates() {
        ArrayList<String> returnArrayList = new ArrayList<String>();
        for (String[] currentTemplate : this.templatesArray) {
            returnArrayList.add(currentTemplate[0]);
        }
        return returnArrayList;
    }

    protected String getFieldUsageStringForField(String normalizedFieldName) {
        for (String[] currentUsageArray : this.fieldUsageArray) {
            if (!currentUsageArray[0].equals(normalizedFieldName)) continue;
            return currentUsageArray[1];
        }
        return null;
    }

    public String getHelpStringForField(String fieldName) {
        String helpString = this.getFieldUsageStringForField(fieldName.replaceAll("\\([0-9]+\\)\\.", "."));
        if (helpString != null) {
            return helpString;
        }
        return "No usage description found in this template for: " + fieldName;
    }

    public ArbilVocabulary getFieldVocabulary(String nodePath) {
        if (this.vocabularyHashTable != null) {
            return this.vocabularyHashTable.get(nodePath);
        }
        return null;
    }

    public boolean readTemplate(File templateConfigFile, String templateName) {
        this.templateFile = templateConfigFile;
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xmlReader.setContentHandler(new DefaultHandler(){
                ArrayList<String> requiredFieldsList = new ArrayList();
                ArrayList<String[]> genreSubgenreList = new ArrayList();
                ArrayList<String[]> fieldConstraintList = new ArrayList();
                ArrayList<String[]> fieldTriggersList = new ArrayList();
                ArrayList<String[]> childNodePathsList = new ArrayList();
                ArrayList<String[]> templateComponentList = new ArrayList();
                ArrayList<String[]> rootTemplateComponentList = new ArrayList();
                ArrayList<String[]> fieldUsageList = new ArrayList();
                ArrayList<String[]> autoFieldsList = new ArrayList();
                ArrayList<String> preferredNameFieldsList = new ArrayList();

                public void startElement(String uri, String name, String qName, Attributes atts) {
                    String displayName;
                    String fileName;
                    String fieldPath;
                    String description;
                    if (name.equals("RequiredField")) {
                        String vocabName = atts.getValue("FieldPath");
                        this.requiredFieldsList.add(vocabName);
                    }
                    if (name.equals("GenreSubgenre")) {
                        String subgenre = atts.getValue("Subgenre");
                        String genre = atts.getValue("Genre");
                        description = atts.getValue("Description");
                        this.genreSubgenreList.add(new String[]{subgenre, genre, description});
                    }
                    if (name.equals("FieldConstraint")) {
                        fieldPath = atts.getValue("FieldPath");
                        String constraint = atts.getValue("Constraint");
                        this.fieldConstraintList.add(new String[]{fieldPath, constraint});
                    }
                    if (name.equals("FieldTrigger")) {
                        String sourceFieldPath = atts.getValue("SourceFieldPath");
                        String targetFieldPath = atts.getValue("TargetFieldPath");
                        description = atts.getValue("SourceFieldValue");
                        this.fieldTriggersList.add(new String[]{sourceFieldPath, targetFieldPath, description});
                    }
                    if (name.equals("ChildNodePath")) {
                        String childPath = atts.getValue("ChildPath");
                        String subNodeName = atts.getValue("SubNodeName");
                        this.childNodePathsList.add(new String[]{childPath, subNodeName});
                    }
                    if (name.equals("TemplateComponent")) {
                        fileName = atts.getValue("FileName");
                        displayName = atts.getValue("DisplayName");
                        String insertBefore = atts.getValue("InsertBefore");
                        String maxOccurs = atts.getValue("MaxOccurs");
                        if (insertBefore == null) {
                            insertBefore = "";
                        }
                        if (maxOccurs == null) {
                            maxOccurs = "-1";
                        }
                        this.templateComponentList.add(new String[]{fileName, displayName, insertBefore, maxOccurs});
                    }
                    if (name.equals("RootTemplateComponent")) {
                        fileName = atts.getValue("FileName");
                        displayName = atts.getValue("DisplayName");
                        this.rootTemplateComponentList.add(new String[]{fileName, displayName});
                    }
                    if (name.equals("FieldUsage")) {
                        fieldPath = atts.getValue("FieldPath");
                        String fieldDescription = atts.getValue("FieldDescription");
                        this.fieldUsageList.add(new String[]{fieldPath, fieldDescription});
                    }
                    if (name.equals("AutoField")) {
                        fieldPath = atts.getValue("FieldPath");
                        String fileAttribute = atts.getValue("FileAttribute");
                        this.autoFieldsList.add(new String[]{fieldPath, fileAttribute});
                    }
                    if (name.equals("TreeNodeNameField")) {
                        String fieldsShortName = atts.getValue("FieldsShortName");
                        this.preferredNameFieldsList.add(fieldsShortName);
                    }
                }

                public void endDocument() throws SAXException {
                    super.endDocument();
                    ArbilTemplate.this.requiredFields = this.requiredFieldsList.toArray(new String[0]);
                    ArbilTemplate.this.genreSubgenreArray = (String[][])this.genreSubgenreList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.fieldConstraints = (String[][])this.fieldConstraintList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.fieldTriggersArray = (String[][])this.fieldTriggersList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.childNodePaths = (String[][])this.childNodePathsList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.templatesArray = (String[][])this.templateComponentList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.rootTemplatesArray = (String[][])this.rootTemplateComponentList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.fieldUsageArray = (String[][])this.fieldUsageList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.autoFieldsArray = (String[][])this.autoFieldsList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.preferredNameFields = this.preferredNameFieldsList.toArray(new String[0]);
                }
            });
            this.loadedTemplateName = templateName;
            URL internalTemplateName = MetadataReader.class.getResource("/nl/mpi/arbil/resources/templates/" + templateName + ".xml");
            if (templateConfigFile.exists()) {
                xmlReader.parse(templateConfigFile.getPath());
            } else if (templateName.equals("Sign Language") || templateName.equals("template_cmdi")) {
                xmlReader.parse(internalTemplateName.toExternalForm());
            } else {
                this.loadedTemplateName = "Default";
                xmlReader.parse(MetadataReader.class.getResource("/nl/mpi/arbil/resources/templates/template.xml").toExternalForm());
            }
            return true;
        }
        catch (Exception ex) {
            messageDialogHandler.addMessageDialogToQueue("The required template could not be read.", "Load Template");
            BugCatcherManager.getBugCatcher().logError("A template could not be read.", ex);
            return false;
        }
    }

    public String getTemplateName() {
        return this.loadedTemplateName;
    }

    public File getTemplateDirectory() {
        File currentTemplateDirectory = new File(ArbilTemplateManager.getSingleInstance().getTemplateDirectory(), this.loadedTemplateName);
        if (!currentTemplateDirectory.exists() && !currentTemplateDirectory.mkdirs()) {
            throw new RuntimeException("Could not create template directory: " + currentTemplateDirectory);
        }
        return currentTemplateDirectory;
    }

    public File getTemplateComponentDirectory() {
        File currentTemplateComponentDirectory = new File(this.getTemplateDirectory(), "components");
        if (!currentTemplateComponentDirectory.exists() && !currentTemplateComponentDirectory.mkdirs()) {
            throw new RuntimeException("Could not create component template directory: " + currentTemplateComponentDirectory);
        }
        return currentTemplateComponentDirectory;
    }

    public String[][] getRootTemplatesArray() {
        return this.rootTemplatesArray;
    }
}

