/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.StatefulMappingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ItemMappingIterator<F extends Item, T extends Item>
implements SequenceIterator<T>,
LookaheadIterator<T>,
LastPositionFinder<T> {
    private SequenceIterator<F> base;
    private ItemMappingFunction<F, T> action;
    private T current = null;
    private int position = 0;
    private boolean oneToOne = false;

    public ItemMappingIterator(SequenceIterator<F> base, ItemMappingFunction<F, T> action) {
        this.base = base;
        this.action = action;
    }

    public ItemMappingIterator(SequenceIterator<F> base, ItemMappingFunction<F, T> action, boolean oneToOne) {
        this.base = base;
        this.action = action;
        this.oneToOne = oneToOne;
    }

    public void setOneToOne(boolean oneToOne) {
        this.oneToOne = oneToOne;
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    @Override
    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }

    @Override
    public T next() throws XPathException {
        do {
            F nextSource;
            if ((nextSource = this.base.next()) == null) {
                this.current = null;
                this.position = -1;
                return null;
            }
            this.current = this.action.mapItem(nextSource);
        } while (this.current == null);
        ++this.position;
        return this.current;
    }

    @Override
    public T current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public SequenceIterator<T> getAnother() throws XPathException {
        SequenceIterator<F> newBase = this.base.getAnother();
        ItemMappingFunction newAction = this.action instanceof StatefulMappingFunction ? (ItemMappingFunction)((Object)((StatefulMappingFunction)((Object)this.action)).getAnother()) : this.action;
        return new ItemMappingIterator<F, T>(newBase, newAction, this.oneToOne);
    }

    @Override
    public int getLength() throws XPathException {
        return ((LastPositionFinder)((Object)this.base)).getLength();
    }

    @Override
    public int getProperties() {
        if (this.oneToOne) {
            return this.base.getProperties() & 6;
        }
        return 0;
    }
}

