/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.entityindexer;

import nl.mpi.kinnate.entityindexer.IndexerParam;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.entityindexer.ParameterElement;
import nl.mpi.kinnate.kintypestrings.KinTypeStringConverter;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class QueryBuilder {
    public String asSequenceString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String currentEntry : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            } else {
                stringBuilder.append("(");
            }
            stringBuilder.append("\"");
            stringBuilder.append(currentEntry);
            stringBuilder.append("\"");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String asSequenceString(IndexerParam indexerParam) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ParameterElement currentEntry : indexerParam.getValues()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            } else {
                stringBuilder.append("(");
            }
            stringBuilder.append("\"");
            stringBuilder.append(currentEntry.getXpathString());
            stringBuilder.append("\"");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String getLabelsClause(IndexerParameters indexParameters, String docRootVar) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ParameterElement currentEntry : indexParameters.labelFields.getValues()) {
            stringBuilder.append("for $labelNode in ");
            stringBuilder.append(docRootVar);
            stringBuilder.append(currentEntry.getXpathString());
            stringBuilder.append("\nreturn\ninsert node <kin:Label xmlns:kin=\"http://mpi.nl/tla/kin\">{$labelNode/text()}</kin:Label> after $copyNode/*:Identifier,\n");
        }
        return stringBuilder.toString();
    }

    public String getDatesClause(IndexerParameters indexParameters, String docRootVar) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ParameterElement currentEntry : indexParameters.dateOfBirthField.getValues()) {
            stringBuilder.append("for $dateOfBirthNode in ");
            stringBuilder.append(docRootVar);
            stringBuilder.append(currentEntry.getXpathString());
            stringBuilder.append("\nreturn\ninsert node <kin:DateOfBirth xmlns:kin=\"http://mpi.nl/tla/kin\">{$dateOfBirthNode/text()}</kin:DateOfBirth> after $copyNode/*:Identifier,\n");
        }
        for (ParameterElement currentEntry : indexParameters.dateOfDeathField.getValues()) {
            stringBuilder.append("for $dateOfDeathNode in ");
            stringBuilder.append(docRootVar);
            stringBuilder.append(currentEntry.getXpathString());
            stringBuilder.append("\nreturn\ninsert node <kin:DateOfDeath xmlns:kin=\"http://mpi.nl/tla/kin\">{$dateOfDeathNode/text()}</kin:DateOfDeath> after $copyNode/*:Identifier,\n");
        }
        return stringBuilder.toString();
    }

    public String getSymbolClause(IndexerParameters indexParameters, String docRootVar) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ParameterElement currentEntry : indexParameters.symbolFieldsFields.getValues()) {
            String trimmedXpath = currentEntry.getXpathString().substring("*:Kinnate".length());
            stringBuilder.append("if (exists(");
            stringBuilder.append(docRootVar);
            stringBuilder.append(trimmedXpath);
            stringBuilder.append(")) then ");
            stringBuilder.append("insert node <kin:Symbol xmlns:kin=\"http://mpi.nl/tla/kin\">");
            stringBuilder.append(currentEntry.getSelectedValue());
            stringBuilder.append("</kin:Symbol> after $copyNode/*:Identifier ");
            stringBuilder.append("else (),\n");
        }
        return stringBuilder.toString();
    }

    public String getArchiveLinksClause() {
        return "for $corpusLink in $entityNode/*:CorpusLink\nreturn <ArchiveLink>{$corpusLink/text()}</ArchiveLink>";
    }

    public String getRelationQuery() {
        return "<Relations>{$entityNode/*:Relations\n}</Relations>";
    }

    public String getEntityQueryReturn(IndexerParameters indexParameters) {
        return "return copy $copyNode := $entityNode\nmodify (\n" + this.getLabelsClause(indexParameters, "root($entityNode)/") + this.getDatesClause(indexParameters, "root($entityNode)/") + this.getSymbolClause(indexParameters, "root($entityNode)/") + "insert nodes <kin:Path xmlns:kin=\"http://mpi.nl/tla/kin\">{base-uri($entityNode)}</kin:Path> after $copyNode/*:Identifier\n" + ")\n" + "return $copyNode\n";
    }

    public String getEntityByKeyWordQuery(String keyWords, IndexerParameters indexParameters) {
        return "<Entities> { for $doc in collection('nl-mpi-kinnate') where contains(string-join($doc//text()), \"" + keyWords + "\")\n" + "return let $entityNode := $doc/*:Kinnate/*:Entity\n" + this.getEntityQueryReturn(indexParameters) + "}</Entities>";
    }

    public String getEntityWithRelationsQuery(UniqueIdentifier uniqueIdentifier, String[] excludeUniqueIdentifiers, IndexerParameters indexParameters) {
        return "for $entityNode := collection('nl-mpi-kinnate')/*:Kinnate/*:Entity[**/*:Identifier/text() = \"" + uniqueIdentifier.getQueryIdentifier() + "\"]\n" + this.getEntityQueryReturn(indexParameters);
    }

    public String getEntityPath(UniqueIdentifier uniqueIdentifier) {
        return "let $identifierNode := collection('nl-mpi-kinnate')/*:Kinnate/*:Entity[*:Identifier/text() = \"" + uniqueIdentifier.getQueryIdentifier() + "\"]\n" + "return base-uri($identifierNode)";
    }

    public String getEntityQuery(UniqueIdentifier uniqueIdentifier, IndexerParameters indexParameters) {
        return "for $entityNode in collection('nl-mpi-kinnate')/*:Kinnate/*:Entity[*:Identifier/text() = \"" + uniqueIdentifier.getQueryIdentifier() + "\"]\n" + this.getEntityQueryReturn(indexParameters);
    }

    public String getTermQuery(KinTypeStringConverter.KinTypeElement queryTerms) {
        StringBuilder stringBuilder = new StringBuilder();
        for (KinTypeStringConverter.QueryTerm queryTerm : queryTerms.queryTerms) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and ");
            }
            stringBuilder.append("$entityNode//*/");
            stringBuilder.append(queryTerm.fieldXPath);
            stringBuilder.append("[text() ");
            switch (queryTerm.comparatorType) {
                case Equals: {
                    stringBuilder.append("=");
                    break;
                }
                case Greater: {
                    stringBuilder.append(">");
                    break;
                }
                case Less: {
                    stringBuilder.append("<");
                    break;
                }
                default: {
                    stringBuilder.append("contains text");
                }
            }
            stringBuilder.append(" \"");
            stringBuilder.append(queryTerm.searchValue);
            stringBuilder.append("\"]");
        }
        return "<IdentifierArray xmlns=\"http://mpi.nl/tla/kin\">{for $entityNode in collection('nl-mpi-kinnate')\nwhere " + stringBuilder.toString() + "\n" + "return\n" + "$entityNode/*:Kinnate/*:Entity/*:Identifier\n" + "}</IdentifierArray>";
    }
}

