/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.transcoder;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.SavePanel;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.fop.svg.PDFTranscoder;

public class DiagramTranscoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsJpg(SavePanel savePanel) {
        if (savePanel.hasSaveFileName()) {
            // empty if block
        }
        if (savePanel.requiresSave()) {
            // empty if block
        }
        File diagramSvg = savePanel.getFileName();
        File diagramJpg = new File(diagramSvg.getParentFile(), diagramSvg.getName().replaceFirst("\\.[Ss][Vv][Gg]$", ".jpg"));
        JPEGTranscoder transcoder = new JPEGTranscoder();
        transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
        int dpi = 300;
        transcoder.addTranscodingHint(ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)new Float(0.08466667f));
        transcoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
        transcoder.addTranscodingHint(PDFTranscoder.KEY_STROKE_TEXT, (Object)Boolean.FALSE);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(diagramSvg);
            TranscoderInput transcoderInput = new TranscoderInput((InputStream)inputStream);
            transcoderInput.setURI(diagramSvg.toURI().toASCIIString());
            OutputStream outputStream = new FileOutputStream(diagramJpg);
            outputStream = new BufferedOutputStream(outputStream);
            try {
                TranscoderOutput transcoderOutput = new TranscoderOutput(outputStream);
                transcoder.transcode(transcoderInput, transcoderOutput);
            }
            finally {
                outputStream.close();
            }
        }
        catch (TranscoderException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
        }
        catch (IOException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException exception) {
                    BugCatcherManager.getBugCatcher().logError((Exception)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsPdf(SavePanel savePanel) {
        if (savePanel.hasSaveFileName()) {
            // empty if block
        }
        if (savePanel.requiresSave()) {
            // empty if block
        }
        File diagramSvg = savePanel.getFileName();
        File diagramPdf = new File(diagramSvg.getParentFile(), diagramSvg.getName().replaceFirst("\\.[Ss][Vv][Gg]$", ".pdf"));
        PDFTranscoder transcoder = new PDFTranscoder();
        int dpi = 300;
        transcoder.addTranscodingHint(ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)new Float(0.08466667f));
        transcoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
        transcoder.addTranscodingHint(PDFTranscoder.KEY_STROKE_TEXT, (Object)Boolean.FALSE);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(diagramSvg);
            TranscoderInput transcoderInput = new TranscoderInput((InputStream)inputStream);
            transcoderInput.setURI(diagramSvg.toURI().toASCIIString());
            OutputStream outputStream = new FileOutputStream(diagramPdf);
            outputStream = new BufferedOutputStream(outputStream);
            try {
                TranscoderOutput transcoderOutput = new TranscoderOutput(outputStream);
                transcoder.transcode(transcoderInput, transcoderOutput);
            }
            finally {
                outputStream.close();
            }
        }
        catch (TranscoderException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)((Object)exception));
        }
        catch (IOException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException exception) {
                    BugCatcherManager.getBugCatcher().logError((Exception)exception);
                }
            }
        }
    }
}

