/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.basex.core.Main;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.server.ClientDelayer;
import org.basex.server.ClientListener;
import org.basex.server.ClientSession;
import org.basex.server.LocalSession;
import org.basex.server.Log;
import org.basex.server.LoginException;
import org.basex.server.Session;
import org.basex.util.Args;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenIntMap;
import org.basex.util.list.StringList;

public class BaseXServer
extends Main {
    public boolean running;
    protected boolean quiet;
    protected boolean service;
    protected Log log;
    ServerSocket esocket;
    IOFile stop;
    private final EventListener events = new EventListener();
    public final TokenIntMap failed = new TokenIntMap();
    private ServerSocket socket;
    private String commands;

    public static void main(String[] args) {
        new BaseXServer(args);
    }

    public BaseXServer(String ... args) {
        super(args);
        BaseXServer.check(this.success);
        int port = this.context.mprop.num(MainProp.SERVERPORT);
        if (this.service) {
            Util.outln(BaseXServer.start(port, this.getClass(), args), new Object[0]);
            Performance.sleep(1000L);
            return;
        }
        try {
            if (this.commands != null) {
                Boolean b = this.execute(this.commands);
                BaseXServer.check(b == null || b != false);
            }
            this.log = new Log(this.context, this.quiet);
            this.log.write(Text.SERVERSTART);
            this.socket = new ServerSocket(port);
            this.esocket = new ServerSocket(this.context.mprop.num(MainProp.EVENTPORT));
            this.stop = BaseXServer.stopFile(port);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    BaseXServer.this.log.write(Text.SERVERSTOPPED);
                    BaseXServer.this.log.close();
                    Util.outln(Text.SERVERSTOPPED, new Object[0]);
                }
            });
            new Thread(this).start();
            while (!this.running) {
                Performance.sleep(100L);
            }
            Util.outln(String.valueOf(Text.CONSOLE) + (this.console ? Text.CONSOLE2 : Text.SERVERSTART), "Server");
            if (this.console) {
                this.quit(this.console());
            }
        }
        catch (Exception ex) {
            if (this.log != null) {
                this.log.write(ex.getMessage());
            }
            Util.errln(Util.server(ex), new Object[0]);
            BaseXServer.check(false);
        }
    }

    @Override
    public void run() {
        this.events.start();
        this.running = true;
        while (this.running) {
            try {
                Socket s = this.socket.accept();
                ClientListener cl = new ClientListener(s, this.context, this.log);
                if (this.stop.exists()) {
                    if (!this.stop.delete()) {
                        this.log.write(Util.info(Text.DBNOTDELETED, this.stop));
                    }
                    this.quit(false);
                    continue;
                }
                byte[] address = s.getInetAddress().getAddress();
                if (cl.init()) {
                    this.failed.delete(address);
                    this.context.add(cl);
                    continue;
                }
                int delay = this.failed.get(address);
                delay = delay == -1 ? 1 : Math.min(delay, 1024) * 2;
                this.failed.add(address, delay);
                new ClientDelayer(delay, cl, this);
            }
            catch (IOException ex) {
                break;
            }
        }
    }

    private static IOFile stopFile(int port) {
        return new IOFile(Prop.TMP, String.valueOf(Util.name(BaseXServer.class)) + port);
    }

    @Override
    public void quit(boolean user) {
        if (!this.running) {
            return;
        }
        this.running = false;
        super.quit(user);
        try {
            if (this.console) {
                System.in.close();
            }
            this.esocket.close();
            this.socket.close();
        }
        catch (IOException ex) {
            this.log.write(ex.getMessage());
            Util.stack(ex);
        }
        this.console = false;
        this.context.close();
    }

    @Override
    protected Session session() {
        if (this.session == null) {
            this.session = new LocalSession(this.context, this.out);
        }
        return this.session;
    }

    @Override
    protected boolean parseArguments(String[] args) {
        Args arg = new Args(args, this, Text.SERVERINFO, Util.info(Text.CONSOLE, "Server"));
        boolean daemon = false;
        while (arg.more()) {
            if (arg.dash()) {
                char c = arg.next();
                if (c == 'c') {
                    this.commands = arg.remaining();
                    continue;
                }
                if (c == 'd') {
                    this.context.mprop.set(MainProp.DEBUG, true);
                    continue;
                }
                if (c == 'D') {
                    daemon = true;
                    continue;
                }
                if (c == 'e') {
                    this.context.mprop.set(MainProp.EVENTPORT, arg.num());
                    continue;
                }
                if (c == 'i') {
                    this.console = true;
                    continue;
                }
                if (c == 'p') {
                    this.context.mprop.set(MainProp.SERVERPORT, arg.num());
                    continue;
                }
                if (c == 's') {
                    this.service = !daemon;
                    continue;
                }
                if (c == 'z') {
                    this.quiet = true;
                    continue;
                }
                arg.check(false);
                continue;
            }
            arg.check(false);
            if (!arg.string().equalsIgnoreCase("stop")) continue;
            BaseXServer.stop(this.context.mprop.num(MainProp.SERVERPORT), this.context.mprop.num(MainProp.EVENTPORT));
            Performance.sleep(1000L);
            return false;
        }
        if (this.context.mprop.num(MainProp.SERVERPORT) == this.context.mprop.num(MainProp.EVENTPORT)) {
            arg.check(this.error(null, Text.SERVERPORTS));
        }
        return arg.finish();
    }

    public void stop() {
        try {
            this.stop.write(Token.EMPTY);
            new Socket("localhost", this.context.mprop.num(MainProp.EVENTPORT));
            new Socket("localhost", this.context.mprop.num(MainProp.SERVERPORT));
        }
        catch (IOException ex) {
            Util.errln(Util.server(ex), new Object[0]);
        }
    }

    public static String start(int port, Class<?> clz, String ... args) {
        String a;
        String[] largs;
        if (BaseXServer.ping("localhost", port)) {
            return Text.SERVERBIND;
        }
        StringList sl = new StringList();
        String[] stringArray = largs = new String[]{"java", "-Xmx" + Runtime.getRuntime().maxMemory(), "-cp", System.getProperty("java.class.path"), clz.getName(), "-D"};
        int n = largs.length;
        int n2 = 0;
        while (n2 < n) {
            a = stringArray[n2];
            sl.add(a);
            ++n2;
        }
        stringArray = args;
        n = args.length;
        n2 = 0;
        while (n2 < n) {
            a = stringArray[n2];
            sl.add(a);
            ++n2;
        }
        try {
            new ProcessBuilder(sl.toArray()).start();
            int c = 0;
            while (c < 5) {
                if (BaseXServer.ping("localhost", port)) {
                    return Text.SERVERSTART;
                }
                Performance.sleep(100L);
                ++c;
            }
        }
        catch (IOException ex) {
            Util.notexpected(ex);
        }
        return Text.SERVERERROR;
    }

    public static boolean ping(String host, int port) {
        try {
            new ClientSession(host, port, "", "");
            return false;
        }
        catch (IOException ex) {
            return ex instanceof LoginException;
        }
    }

    public static void stop(int port, int eport) {
        IOFile stop = BaseXServer.stopFile(port);
        try {
            stop.write(Token.EMPTY);
            new Socket("localhost", eport);
            new Socket("localhost", port);
            while (BaseXServer.ping("localhost", port)) {
                Performance.sleep(100L);
            }
            Util.outln(Text.SERVERSTOPPED, new Object[0]);
        }
        catch (IOException ex) {
            stop.delete();
            Util.errln(Util.server(ex), new Object[0]);
        }
    }

    final class EventListener
    extends Thread {
        EventListener() {
        }

        @Override
        public void run() {
            block2: while (BaseXServer.this.running) {
                try {
                    Socket es = BaseXServer.this.esocket.accept();
                    if (BaseXServer.this.stop.exists()) {
                        BaseXServer.this.esocket.close();
                        break;
                    }
                    BufferInput bi = new BufferInput(es.getInputStream());
                    long id = Long.parseLong(bi.readString());
                    for (ClientListener s : BaseXServer.this.context.sessions) {
                        if (s.getId() != id) continue;
                        s.register(es);
                        continue block2;
                    }
                }
                catch (IOException ex) {
                    break;
                }
            }
        }
    }
}

