/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.mpi.arbil.clarin.profiles.CmdiTemplate;
import nl.mpi.arbil.data.ArbilVocabularies;
import nl.mpi.arbil.data.ArbilVocabulary;
import nl.mpi.arbil.data.ArbilVocabularyFilter;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentationLanguages
implements ArbilVocabularyFilter {
    private static SessionStorage sessionStorage;
    private static final String IMDI_LANGUAGE_VOCABULARY_URL_KEY = "LanguageVocabularyUrl";
    private static final String CMDI_LANGUAGE_VOCABULARY_URL_KEY = "CmdiLanguageVocabularyUrl";
    private static final String CMDI_LANGUAGE_VOCABULARY_PATH_KEY = "CmdiLanguageVocabularyPath";
    private static final String SELECTED_LANGUAGES_KEY = "selectedLanguages";
    private static final String OLD_MPI_LANGUAGE_VOCABULARY_URL = "http://www.mpi.nl/IMDI/Schema/ISO639-2Languages.xml";
    private static final String MPI_LANGUAGE_VOCABULARY_URL = "http://www.mpi.nl/IMDI/Schema/MPI-Languages.xml";
    public static final String CMDI_VOCABULARY_URL = "http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/components/clarin.eu:cr1:c_1271859438110/xsd";
    public static final String CMDI_VOCABULARY_PATH = ".CMD.Components.ISO639.iso-639-3-code";
    private static String imdiLanguageVocabularyUrl;
    private static String cmdiLanguageVocabularyUrl;
    private static String cmdiLanguageVocabularyPath;
    private static DocumentationLanguages singleInstance;

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static synchronized String getLanguageVocabularyUrlForImdi() {
        if (imdiLanguageVocabularyUrl == null && ((imdiLanguageVocabularyUrl = sessionStorage.loadString(IMDI_LANGUAGE_VOCABULARY_URL_KEY)) == null || imdiLanguageVocabularyUrl.equals(OLD_MPI_LANGUAGE_VOCABULARY_URL))) {
            imdiLanguageVocabularyUrl = MPI_LANGUAGE_VOCABULARY_URL;
            sessionStorage.saveString(IMDI_LANGUAGE_VOCABULARY_URL_KEY, imdiLanguageVocabularyUrl);
        }
        return imdiLanguageVocabularyUrl;
    }

    public static synchronized String getLanguageVocabularyUrlForCmdi() {
        if (cmdiLanguageVocabularyUrl == null && (cmdiLanguageVocabularyUrl = sessionStorage.loadString(CMDI_LANGUAGE_VOCABULARY_URL_KEY)) == null) {
            cmdiLanguageVocabularyUrl = CMDI_VOCABULARY_URL;
            sessionStorage.saveString(CMDI_LANGUAGE_VOCABULARY_URL_KEY, cmdiLanguageVocabularyUrl);
        }
        return cmdiLanguageVocabularyUrl;
    }

    public static synchronized String getLanguageVocabularyPathForCmdi() {
        if (cmdiLanguageVocabularyPath == null && (cmdiLanguageVocabularyPath = sessionStorage.loadString(CMDI_LANGUAGE_VOCABULARY_PATH_KEY)) == null) {
            cmdiLanguageVocabularyPath = CMDI_VOCABULARY_PATH;
            sessionStorage.saveString(CMDI_LANGUAGE_VOCABULARY_PATH_KEY, cmdiLanguageVocabularyPath);
        }
        return cmdiLanguageVocabularyPath;
    }

    public static synchronized DocumentationLanguages getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new DocumentationLanguages();
        }
        return singleInstance;
    }

    private DocumentationLanguages() {
    }

    public synchronized List<ArbilVocabularyItem> getAllLanguagesForImdi() {
        return ArbilVocabularies.getSingleInstance().getVocabulary(null, DocumentationLanguages.getLanguageVocabularyUrlForImdi()).getVocabularyItemsUnfiltered();
    }

    public synchronized List<ArbilVocabularyItem> getAllLanguagesForCmdi() {
        ArbilVocabulary vocab;
        CmdiTemplate profile = (CmdiTemplate)ArbilTemplateManager.getSingleInstance().getCmdiTemplate(DocumentationLanguages.getLanguageVocabularyUrlForCmdi());
        if (profile != null && (vocab = profile.getFieldVocabulary(DocumentationLanguages.getLanguageVocabularyPathForCmdi())) != null) {
            return vocab.getVocabularyItems();
        }
        return null;
    }

    public synchronized List<String> getSelectedLanguagesArrayList() {
        ArrayList<String> selectedLanguages = new ArrayList<String>();
        try {
            selectedLanguages.addAll(Arrays.asList(sessionStorage.loadStringArray(SELECTED_LANGUAGES_KEY)));
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError("No selectedLanguages file, will create one now.", e);
            this.addDefaultTemplates();
        }
        return selectedLanguages;
    }

    public List<ArbilVocabularyItem> getLanguageListSubsetForCmdi() {
        return this.getAllLanguagesForCmdi();
    }

    public List<ArbilVocabularyItem> getLanguageListSubsetForImdi() {
        return this.getLanguageListSubset(this.getAllLanguagesForImdi());
    }

    private synchronized List<ArbilVocabularyItem> getLanguageListSubset(List<ArbilVocabularyItem> allLanguages) {
        ArrayList<ArbilVocabularyItem> languageListSubset = new ArrayList<ArbilVocabularyItem>();
        if (allLanguages != null) {
            List<String> selectedLanguages = this.getSelectedLanguagesArrayList();
            for (ArbilVocabularyItem currentVocabItem : allLanguages) {
                if (!selectedLanguages.contains(currentVocabItem.itemDisplayName)) continue;
                languageListSubset.add(currentVocabItem);
            }
        }
        return languageListSubset;
    }

    private void addDefaultTemplates() {
        for (ArbilVocabularyItem currentTemplate : this.getAllLanguagesForImdi()) {
            this.addselectedLanguages(currentTemplate.itemDisplayName);
        }
    }

    public synchronized void addselectedLanguages(String templateString) {
        ArrayList<String> selectedLanguages = new ArrayList<String>();
        try {
            selectedLanguages.addAll(Arrays.asList(sessionStorage.loadStringArray(SELECTED_LANGUAGES_KEY)));
        }
        catch (Exception e) {
            BugCatcherManager.getBugCatcher().logError("No selectedLanguages file, will create one now.", e);
        }
        selectedLanguages.add(templateString);
        this.saveSelectedLanguages(selectedLanguages);
    }

    public synchronized void removeselectedLanguages(String templateString) {
        ArrayList<String> selectedLanguages = new ArrayList<String>();
        try {
            selectedLanguages.addAll(Arrays.asList(sessionStorage.loadStringArray(SELECTED_LANGUAGES_KEY)));
            while (selectedLanguages.contains(templateString)) {
                selectedLanguages.remove(templateString);
            }
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        this.saveSelectedLanguages(selectedLanguages);
    }

    private void saveSelectedLanguages(ArrayList<String> selectedLanguages) {
        try {
            sessionStorage.saveStringArray(SELECTED_LANGUAGES_KEY, selectedLanguages.toArray(new String[0]));
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    @Override
    public List<ArbilVocabularyItem> filterVocabularyItems(List<ArbilVocabularyItem> items) {
        ArrayList<ArbilVocabularyItem> vocabClone = new ArrayList<ArbilVocabularyItem>(items);
        vocabClone.retainAll(this.getLanguageListSubsetForImdi());
        return vocabClone;
    }

    static {
        imdiLanguageVocabularyUrl = null;
        cmdiLanguageVocabularyUrl = null;
        cmdiLanguageVocabularyPath = null;
        singleInstance = null;
    }
}

