/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.importexport.ArbilToHtmlConverter;
import nl.mpi.arbil.ui.ArbilDragDrop;
import nl.mpi.arbil.ui.ArbilFieldView;
import nl.mpi.arbil.ui.ArbilHelp;
import nl.mpi.arbil.ui.ArbilHyperlinkListener;
import nl.mpi.arbil.ui.ArbilNodeSearchPanel;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilSubnodesScrollPane;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilTaskStatusBar;
import nl.mpi.arbil.ui.ArbilWindowComponent;
import nl.mpi.arbil.ui.ArbilWindowState;
import nl.mpi.arbil.ui.fieldeditors.ArbilLongFieldEditor;
import nl.mpi.arbil.ui.menu.ArbilMenuBar;
import nl.mpi.arbil.ui.wizard.setup.ArbilSetupWizard;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;
import nl.mpi.arbil.util.task.ArbilTaskListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilWindowManager
implements MessageDialogHandler,
WindowManager {
    private Hashtable<String, Component[]> windowList = new Hashtable();
    private Hashtable windowStatesHashtable;
    private JDesktopPane desktopPane;
    private JFrame linorgFrame;
    private ArbilTaskStatusBar statusBar;
    private static final int defaultWindowX = 50;
    private static final int defaultWindowY = 50;
    private static final int nextWindowWidth = 800;
    private static final int nextWindowHeight = 600;
    private int nextWindowX = 50;
    private int nextWindowY = 50;
    float fontScale = 1.0f;
    private Hashtable<String, String> messageDialogQueue = new Hashtable();
    private boolean messagesCanBeShown = false;
    boolean showMessageThreadrunning = false;
    private Map<String, FileFilter> fileFilterMap;
    private Collection<ArbilTaskListener> taskListeners = new HashSet<ArbilTaskListener>();
    private ApplicationVersionManager versionManager;
    private SessionStorage sessionStorage;
    private TreeHelper treeHelper;
    private DataNodeLoader dataNodeLoader;

    public void setVersionManager(ApplicationVersionManager versionManagerInstance) {
        this.versionManager = versionManagerInstance;
    }

    public void setSessionStorage(SessionStorage sessionStorageInstance) {
        this.sessionStorage = sessionStorageInstance;
    }

    public void setTreeHelper(TreeHelper treeHelperInstance) {
        this.treeHelper = treeHelperInstance;
    }

    public void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        this.dataNodeLoader = dataNodeLoaderInstance;
    }

    public ArbilWindowManager() {
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setBackground(new Color(204, 204, 204));
        ArbilDragDrop.getSingleInstance().setTransferHandlerOnComponent(this.desktopPane);
        this.initFileFilterMap();
    }

    public void setMessagesCanBeShown(boolean messagesCanBeShown) {
        this.messagesCanBeShown = messagesCanBeShown;
    }

    public void loadGuiState(JFrame linorgFrameLocal, ArbilTaskStatusBar statusBar) {
        this.linorgFrame = linorgFrameLocal;
        this.statusBar = statusBar;
        try {
            int screenDeviceCount;
            this.setStatusBarVisible(this.sessionStorage.loadBoolean("showStatusBar", true));
            this.windowStatesHashtable = (Hashtable)this.sessionStorage.loadObject("windowStates");
            Object linorgFrameBounds = this.windowStatesHashtable.get("linorgFrameBounds");
            if (linorgFrameBounds != null) {
                this.getMainFrame().setBounds((Rectangle)linorgFrameBounds);
            }
            this.getMainFrame().setExtendedState((Integer)this.windowStatesHashtable.get("linorgFrameExtendedState"));
            if (this.getMainFrame().getExtendedState() == 1) {
                this.getMainFrame().setExtendedState(0);
            }
            if (this.windowStatesHashtable.containsKey("ScreenDeviceCount") && (screenDeviceCount = ((Integer)this.windowStatesHashtable.get("ScreenDeviceCount")).intValue()) > GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length) {
                this.getMainFrame().setLocationRelativeTo(null);
                Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
                if (linorgFrameBounds instanceof Rectangle && ((Rectangle)linorgFrameBounds).intersects(new Rectangle(screenDimension))) {
                    this.getMainFrame().setBounds(((Rectangle)linorgFrameBounds).intersection(new Rectangle(screenDimension)));
                } else {
                    this.getMainFrame().setBounds(0, 0, 800, 600);
                    this.getMainFrame().setLocationRelativeTo(null);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("load windowStates failed: " + ex.getMessage());
            System.out.println("setting default windowStates");
            this.windowStatesHashtable = new Hashtable();
            this.getMainFrame().setBounds(0, 0, 800, 600);
            this.getMainFrame().setLocationRelativeTo(null);
            this.getMainFrame().setExtendedState(6);
        }
        this.loadSplitPlanes(this.getMainFrame().getContentPane().getComponent(0));
    }

    public void openAboutPage() {
        ApplicationVersion appVersion = this.versionManager.getApplicationVersion();
        String messageString = "Archive Builder\nA local tool for organising linguistic data.\nMax Planck Institute for Psycholinguistics\n\nApplication design and programming by Peter Withers and Twan Goosen\nArbil also uses components of the IMDI API and Lamus Type Checker\n\nVersion: " + appVersion.currentMajor + "." + appVersion.currentMinor + "." + appVersion.currentRevision + "\n" + appVersion.lastCommitDate + "\n" + "Compile Date: " + appVersion.compileDate + "\n\n" + "Java version: " + System.getProperty("java.version") + " by " + System.getProperty("java.vendor");
        JOptionPane.showMessageDialog(this.getMainFrame(), messageString, "About " + appVersion.applicationTitle, -1);
    }

    @Override
    public void offerUserToSaveChanges() throws Exception {
        if (this.dataNodeLoader.nodesNeedSave()) {
            if (0 == JOptionPane.showConfirmDialog(this.getMainFrame(), "There are unsaved changes.\nSave now?", "Save Changes", 2, -1)) {
                this.dataNodeLoader.saveNodesNeedingSave(true);
            } else {
                throw new Exception("user canceled save action");
            }
        }
    }

    @Override
    public File showEmptyExportDirectoryDialogue(String titleText) {
        boolean fileSelectDone = false;
        try {
            while (!fileSelectDone) {
                File[] selectedFiles = this.showFileSelectBox(titleText + " Destination Directory", true, false, false);
                if (selectedFiles != null && selectedFiles.length > 0) {
                    File destinationDirectory = selectedFiles[0];
                    boolean mkdirsOkay = true;
                    if (destinationDirectory != null && !destinationDirectory.exists()) {
                        mkdirsOkay = destinationDirectory.mkdirs();
                    }
                    if (destinationDirectory == null || !mkdirsOkay || !destinationDirectory.exists()) {
                        JOptionPane.showMessageDialog(this.getMainFrame(), "The export directory\n\"" + destinationDirectory + "\"\ndoes not exist.\nPlease select or create a directory.", titleText, -1);
                        continue;
                    }
                    if (!destinationDirectory.exists()) continue;
                    if (destinationDirectory.list().length == 0) {
                        fileSelectDone = true;
                        return destinationDirectory;
                    }
                    if (!this.showConfirmDialogBox("The selected export directory is not empty.\nTo continue will merge and may overwrite files.\nDo you want to continue?", titleText)) continue;
                    return destinationDirectory;
                }
                fileSelectDone = true;
            }
        }
        catch (Exception e) {
            System.out.println("aborting export: " + e.getMessage());
        }
        return null;
    }

    @Override
    public File[] showFileSelectBox(String titleText, boolean directorySelectOnly, boolean multipleSelect, boolean requireMetadataFiles) {
        Object returnFile;
        File lastUsedWorkingDirectory;
        File workingDirectory = null;
        String workingDirectoryPathString = this.sessionStorage.loadString("fileSelect." + titleText);
        workingDirectory = workingDirectoryPathString == null ? new File(System.getProperty("user.home")) : new File(workingDirectoryPathString);
        boolean isMac = true;
        boolean useAtwSelect = false;
        if (useAtwSelect) {
            if (directorySelectOnly) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
            } else {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
            FileDialog fileDialog = new FileDialog(this.getMainFrame());
            if (requireMetadataFiles) {
                fileDialog.setFilenameFilter(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".imdi");
                    }
                });
            }
            fileDialog.setDirectory(workingDirectory.getAbsolutePath());
            fileDialog.setVisible(true);
            String selectedFile = fileDialog.getFile();
            lastUsedWorkingDirectory = new File(fileDialog.getDirectory());
            returnFile = selectedFile != null ? new File[]{new File(selectedFile)} : null;
        } else {
            JFileChooser fileChooser = this.createFileChooser(requireMetadataFiles);
            if (directorySelectOnly) {
                FileFilter imdiFileFilter = new FileFilter(){

                    public String getDescription() {
                        return "Directories";
                    }

                    public boolean accept(File selectedFile) {
                        return selectedFile.exists() && selectedFile.isDirectory();
                    }
                };
                fileChooser.addChoosableFileFilter(imdiFileFilter);
            }
            if (directorySelectOnly) {
                fileChooser.setFileSelectionMode(1);
            } else {
                fileChooser.setFileSelectionMode(0);
            }
            fileChooser.setCurrentDirectory(workingDirectory);
            fileChooser.setMultiSelectionEnabled(multipleSelect);
            if (0 == fileChooser.showDialog(this.getMainFrame(), titleText)) {
                returnFile = fileChooser.getSelectedFiles();
                if (((File[])returnFile).length == 0) {
                    returnFile = new File[]{fileChooser.getSelectedFile()};
                }
                if (requireMetadataFiles) {
                    this.storeSelectedMetadataFileFilter(fileChooser);
                }
            } else {
                returnFile = null;
            }
            if (returnFile != null && ((File[])returnFile).length == 1 && !returnFile[0].exists()) {
                returnFile[0] = returnFile[0].getParentFile();
                if (!returnFile[0].exists()) {
                    returnFile = null;
                }
            }
            lastUsedWorkingDirectory = fileChooser.getCurrentDirectory();
        }
        this.sessionStorage.saveString("fileSelect." + titleText, lastUsedWorkingDirectory.getAbsolutePath());
        return returnFile;
    }

    private JFileChooser createFileChooser(boolean requireMetadataFiles) {
        JFileChooser fileChooser = new JFileChooser();
        if (requireMetadataFiles) {
            for (FileFilter filter : this.fileFilterMap.values()) {
                fileChooser.addChoosableFileFilter(filter);
            }
            String lastFileFilter = this.sessionStorage.loadString("metadataFileFilter");
            if (lastFileFilter != null && this.fileFilterMap.containsKey(lastFileFilter)) {
                fileChooser.setFileFilter(this.fileFilterMap.get(lastFileFilter));
            }
        }
        return fileChooser;
    }

    private void storeSelectedMetadataFileFilter(JFileChooser fileChooser) {
        FileFilter selectedFilter = fileChooser.getFileFilter();
        if (selectedFilter != null && this.fileFilterMap.containsValue(selectedFilter)) {
            for (Map.Entry<String, FileFilter> filterEntry : this.fileFilterMap.entrySet()) {
                if (filterEntry.getValue() != selectedFilter) continue;
                this.sessionStorage.saveString("metadataFileFilter", filterEntry.getKey());
                return;
            }
        }
    }

    @Override
    public boolean showConfirmDialogBox(String messageString, String messageTitle) {
        if (messageTitle == null) {
            messageTitle = "Arbil";
        }
        return 0 == JOptionPane.showConfirmDialog(this.getMainFrame(), messageString, messageTitle, 2, -1);
    }

    @Override
    public void addMessageDialogToQueue(String messageString, String messageTitle) {
        String currentMessage;
        if (messageTitle == null) {
            messageTitle = this.versionManager.getApplicationVersion().applicationTitle;
        }
        if ((currentMessage = this.messageDialogQueue.get(messageTitle)) != null) {
            messageString = messageString + "\n-------------------------------\n" + currentMessage;
        }
        this.messageDialogQueue.put(messageTitle, messageString);
        this.showMessageDialogQueue();
    }

    private void applyWindowDefaults(JInternalFrame currentInternalFrame) {
        int tempWindowWidth = this.desktopPane.getWidth() > 800 ? 800 : this.desktopPane.getWidth() - 50;
        int tempWindowHeight = this.desktopPane.getHeight() > 600 ? 600 : this.desktopPane.getHeight() - 50;
        if (tempWindowHeight < 100) {
            tempWindowHeight = 100;
        }
        currentInternalFrame.setSize(tempWindowWidth, tempWindowHeight);
        currentInternalFrame.setClosable(true);
        currentInternalFrame.setIconifiable(true);
        currentInternalFrame.setMaximizable(true);
        currentInternalFrame.setResizable(true);
        currentInternalFrame.setVisible(true);
        currentInternalFrame.setLocation(this.nextWindowX, this.nextWindowY);
        this.nextWindowX += Math.max(10, currentInternalFrame.getInsets().left);
        this.nextWindowY += Math.max(10, currentInternalFrame.getInsets().top - 10);
        if (this.nextWindowX + tempWindowWidth > this.desktopPane.getWidth()) {
            this.nextWindowX = 0;
        }
        if (this.nextWindowY + tempWindowHeight > this.desktopPane.getHeight()) {
            this.nextWindowY = 0;
        }
    }

    private synchronized void showMessageDialogQueue() {
        if (!this.showMessageThreadrunning) {
            new Thread("showMessageThread"){

                public void run() {
                    try {
                        3.sleep(100L);
                    }
                    catch (Exception ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                    ArbilWindowManager.this.showMessageThreadrunning = true;
                    if (ArbilWindowManager.this.messagesCanBeShown) {
                        while (ArbilWindowManager.this.messageDialogQueue.size() > 0) {
                            String messageTitle = (String)ArbilWindowManager.this.messageDialogQueue.keys().nextElement();
                            String messageText = (String)ArbilWindowManager.this.messageDialogQueue.remove(messageTitle);
                            if (messageText == null) continue;
                            JOptionPane.showMessageDialog(ArbilWindowManager.this.getMainFrame(), messageText, messageTitle, -1);
                        }
                    }
                    ArbilWindowManager.this.showMessageThreadrunning = false;
                }
            }.start();
        }
    }

    public void showSetupWizardIfFirstRun() {
        if (!this.treeHelper.locationsHaveBeenAdded() && !"yes".equals(this.sessionStorage.loadString("wizardHasRun"))) {
            this.sessionStorage.saveString("wizardHasRun", "yes");
            new ArbilSetupWizard(this.getMainFrame()).showModalDialog();
        }
    }

    public void openIntroductionPage() {
        this.initWindows();
        if (!this.treeHelper.locationsHaveBeenAdded()) {
            System.out.println("no local locations found, showing help window");
            ArbilHelp helpComponent = ArbilHelp.getSingleInstance();
            if (null == this.focusWindow("Help Viewer")) {
                this.createWindow("Help Viewer", helpComponent);
            }
            helpComponent.setCurrentPage("2. Quick Introduction");
        }
        this.startKeyListener();
        this.setMessagesCanBeShown(true);
        this.showMessageDialogQueue();
    }

    private void initWindows() {
        try {
            Hashtable windowListHashtable = (Hashtable)this.sessionStorage.loadObject("openWindows");
            Enumeration windowNamesEnum = windowListHashtable.keys();
            while (windowNamesEnum.hasMoreElements()) {
                ArbilWindowState windowState;
                String currentWindowName = windowNamesEnum.nextElement().toString();
                System.out.println("currentWindowName: " + currentWindowName);
                Object windowStateObject = windowListHashtable.get(currentWindowName);
                if (windowStateObject instanceof Vector) {
                    windowState = new ArbilWindowState();
                    windowState.currentNodes = (Vector)windowStateObject;
                } else if (windowStateObject instanceof ArbilWindowState) {
                    windowState = (ArbilWindowState)windowStateObject;
                } else {
                    throw new Exception("Unknown window state format");
                }
                if (windowState.currentNodes == null) continue;
                ArbilDataNode[] imdiObjectsArray = new ArbilDataNode[windowState.currentNodes.size()];
                for (int arrayCounter = 0; arrayCounter < imdiObjectsArray.length; ++arrayCounter) {
                    try {
                        imdiObjectsArray[arrayCounter] = this.dataNodeLoader.getArbilDataNode(null, new URI(windowState.currentNodes.elementAt(arrayCounter).toString()));
                        continue;
                    }
                    catch (URISyntaxException ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
                Component[] window = new Component[1];
                if (windowState.windowType == ArbilWindowState.ArbilWindowType.nodeTable) {
                    this.openFloatingTableGetModel(imdiObjectsArray, currentWindowName, window, windowState.fieldView);
                } else if (windowState.windowType == ArbilWindowState.ArbilWindowType.subnodesPanel) {
                    this.openFloatingSubnodesWindowOnce(imdiObjectsArray[0], currentWindowName, window);
                }
                if (window[0] == null) continue;
                if (windowState.size != null) {
                    window[0].setSize(windowState.size);
                }
                if (windowState.location == null) continue;
                window[0].setLocation(this.fixLocation(windowState.location));
            }
            System.out.println("done loading windowStates");
        }
        catch (Exception ex) {
            this.windowStatesHashtable = new Hashtable();
            System.out.println("load windowStates failed: " + ex.getMessage());
        }
    }

    public void loadSplitPlanes(Component targetComponent) {
        if (targetComponent instanceof JSplitPane) {
            System.out.println("loadSplitPlanes: " + targetComponent.getName());
            Object linorgSplitPosition = this.windowStatesHashtable.get(targetComponent.getName());
            if (linorgSplitPosition instanceof Integer) {
                System.out.println(targetComponent.getName() + ": " + linorgSplitPosition);
                ((JSplitPane)targetComponent).setDividerLocation((Integer)linorgSplitPosition);
            } else if (targetComponent.getName().equals("rightSplitPane")) {
                ((JSplitPane)targetComponent).setDividerLocation(150);
            } else {
                ((JSplitPane)targetComponent).setDividerLocation(200);
            }
            for (Component childComponent : ((JSplitPane)targetComponent).getComponents()) {
                this.loadSplitPlanes(childComponent);
            }
        }
        if (targetComponent instanceof JPanel) {
            for (Component childComponent : ((JPanel)targetComponent).getComponents()) {
                this.loadSplitPlanes(childComponent);
            }
        }
    }

    public void saveSplitPlanes(Component targetComponent) {
        if (targetComponent instanceof JSplitPane) {
            System.out.println("saveSplitPlanes: " + targetComponent.getName());
            this.windowStatesHashtable.put(targetComponent.getName(), ((JSplitPane)targetComponent).getDividerLocation());
            for (Component childComponent : ((JSplitPane)targetComponent).getComponents()) {
                this.saveSplitPlanes(childComponent);
            }
        }
        if (targetComponent instanceof JPanel) {
            for (Component childComponent : ((JPanel)targetComponent).getComponents()) {
                this.saveSplitPlanes(childComponent);
            }
        }
    }

    public void resetWindows() {
        this.nextWindowX = 50;
        this.nextWindowY = 50;
        Enumeration<String> windowNamesEnum = this.windowList.keys();
        while (windowNamesEnum.hasMoreElements()) {
            String currentWindowName = windowNamesEnum.nextElement().toString();
            System.out.println("currentWindowName: " + currentWindowName);
            Component windowObject = this.windowList.get(currentWindowName)[0];
            if (windowObject == null) continue;
            this.applyWindowDefaults((JInternalFrame)windowObject);
        }
    }

    @Override
    public void saveWindowStates() {
        try {
            this.windowStatesHashtable.put("linorgFrameBounds", this.getMainFrame().getBounds());
            this.windowStatesHashtable.put("ScreenDeviceCount", GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length);
            this.windowStatesHashtable.put("linorgFrameExtendedState", this.getMainFrame().getExtendedState());
            this.saveSplitPlanes(this.getMainFrame().getContentPane().getComponent(0));
            this.sessionStorage.saveObject(this.windowStatesHashtable, "windowStates");
            Hashtable<String, ArbilWindowState> windowListHashtable = new Hashtable<String, ArbilWindowState>();
            Enumeration<String> windowNamesEnum = this.windowList.keys();
            while (windowNamesEnum.hasMoreElements()) {
                ArbilWindowState windowState = new ArbilWindowState();
                String currentWindowName = windowNamesEnum.nextElement().toString();
                System.out.println("currentWindowName: " + currentWindowName);
                Component windowObject = this.windowList.get(currentWindowName)[0];
                try {
                    if (windowObject == null) continue;
                    windowState.location = ((JInternalFrame)windowObject).getLocation();
                    windowState.size = ((JInternalFrame)windowObject).getSize();
                    Component currentComponent = ((JInternalFrame)windowObject).getContentPane().getComponent(0);
                    if (currentComponent != null) {
                        if (currentComponent instanceof ArbilSplitPanel) {
                            windowState.windowType = ArbilWindowState.ArbilWindowType.nodeTable;
                            if (0 < ((ArbilSplitPanel)currentComponent).arbilTable.getRowCount()) {
                                Vector<String> currentNodesVector;
                                ArbilTable table = ((ArbilSplitPanel)currentComponent).arbilTable;
                                table.updateStoredColumnWidhts();
                                windowState.fieldView = table.getArbilTableModel().getFieldView();
                                windowState.currentNodes = currentNodesVector = new Vector<String>(Arrays.asList(table.getArbilTableModel().getArbilDataNodesURLs()));
                                System.out.println("saved");
                            }
                        } else if (currentComponent instanceof ArbilSubnodesScrollPane) {
                            windowState.windowType = ArbilWindowState.ArbilWindowType.subnodesPanel;
                            Vector<String> nodeVector = new Vector<String>(1);
                            nodeVector.add(((ArbilSubnodesScrollPane)currentComponent).getDataNode().getUrlString());
                            windowState.currentNodes = nodeVector;
                        }
                    }
                    windowListHashtable.put(currentWindowName, windowState);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
            this.sessionStorage.saveObject(windowListHashtable, "openWindows");
            System.out.println("saved windowStates");
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    private String addWindowToList(String windowName, final JInternalFrame windowFrame) {
        int instanceCount = 0;
        String currentWindowName = windowName;
        while (this.windowList.containsKey(currentWindowName)) {
            currentWindowName = windowName + "(" + ++instanceCount + ")";
        }
        JMenuItem windowMenuItem = new JMenuItem();
        windowMenuItem.setText(currentWindowName);
        windowMenuItem.setName(currentWindowName);
        windowFrame.setName(currentWindowName);
        windowMenuItem.setActionCommand(currentWindowName);
        windowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilWindowManager.this.focusWindow(evt.getActionCommand());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        windowFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent e) {
                String windowName = e.getInternalFrame().getName();
                System.out.println("Closing window: " + windowName);
                Component[] windowAndMenu = (Component[])ArbilWindowManager.this.windowList.get(windowName);
                if (ArbilMenuBar.windowMenu != null && windowAndMenu != null) {
                    ArbilMenuBar.windowMenu.remove(windowAndMenu[1]);
                }
                for (Component childComponent : windowFrame.getContentPane().getComponents()) {
                    if (!(childComponent instanceof ArbilWindowComponent)) continue;
                    ((ArbilWindowComponent)((Object)childComponent)).arbilWindowClosed();
                }
                ArbilWindowManager.this.windowList.remove(windowName);
                super.internalFrameClosed(e);
            }
        });
        this.windowList.put(currentWindowName, new Component[]{windowFrame, windowMenuItem});
        if (ArbilMenuBar.windowMenu != null) {
            ArbilMenuBar.windowMenu.add(windowMenuItem);
        }
        return currentWindowName;
    }

    public void stopEditingInCurrentWindow() {
        for (Component focusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); focusedComponent != null; focusedComponent = focusedComponent.getParent()) {
            TableCellEditor editor;
            if (focusedComponent instanceof ArbilLongFieldEditor) {
                ((ArbilLongFieldEditor)focusedComponent).storeChanges();
                continue;
            }
            if (!(focusedComponent instanceof JTable) || (editor = ((JTable)focusedComponent).getCellEditor()) == null) continue;
            editor.stopCellEditing();
        }
    }

    @Override
    public void closeAllWindows() {
        for (JInternalFrame focusedWindow : this.desktopPane.getAllFrames()) {
            if (focusedWindow == null) continue;
            String windowName = focusedWindow.getName();
            Component[] windowAndMenu = this.windowList.get(windowName);
            if (windowAndMenu != null && ArbilMenuBar.windowMenu != null) {
                ArbilMenuBar.windowMenu.remove(windowAndMenu[1]);
            }
            this.windowList.remove(windowName);
            this.desktopPane.remove(focusedWindow);
        }
        this.desktopPane.repaint();
    }

    public JInternalFrame focusWindow(String windowName) {
        if (this.windowList.containsKey(windowName)) {
            Component windowObject = this.windowList.get(windowName)[0];
            try {
                if (windowObject != null) {
                    ((JInternalFrame)windowObject).setIcon(false);
                    ((JInternalFrame)windowObject).setSelected(true);
                    return (JInternalFrame)windowObject;
                }
            }
            catch (Exception ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
        return null;
    }

    private void startKeyListener() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            public void eventDispatched(AWTEvent e) {
                boolean isKeybordRepeat = false;
                if (e instanceof KeyEvent && e.getID() == 402) {
                    KeyEvent nextPress = (KeyEvent)Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent(401);
                    if (nextPress != null && nextPress.getWhen() == ((KeyEvent)e).getWhen() && nextPress.getKeyCode() == ((KeyEvent)e).getKeyCode()) {
                        isKeybordRepeat = true;
                    }
                    if (!isKeybordRepeat) {
                        if ((((KeyEvent)e).isMetaDown() || ((KeyEvent)e).isControlDown()) && ((KeyEvent)e).getKeyCode() == 87) {
                            JInternalFrame[] windowsToClose = ((KeyEvent)e).isShiftDown() ? ArbilWindowManager.this.getDesktopPane().getAllFrames() : new JInternalFrame[]{ArbilWindowManager.this.getDesktopPane().getSelectedFrame()};
                            for (JInternalFrame focusedWindow : windowsToClose) {
                                if (focusedWindow == null) continue;
                                String windowName = focusedWindow.getName();
                                Component[] windowAndMenu = (Component[])ArbilWindowManager.this.windowList.get(windowName);
                                if (windowAndMenu != null && ArbilMenuBar.windowMenu != null) {
                                    ArbilMenuBar.windowMenu.remove(windowAndMenu[1]);
                                }
                                ArbilWindowManager.this.windowList.remove(windowName);
                                ArbilWindowManager.this.getDesktopPane().remove(focusedWindow);
                                try {
                                    JInternalFrame topMostWindow;
                                    JInternalFrame[] allWindows = ArbilWindowManager.this.getDesktopPane().getAllFrames();
                                    if (allWindows.length <= 0 || (topMostWindow = allWindows[0]) == null) continue;
                                    System.out.println("topMostWindow: " + topMostWindow);
                                    topMostWindow.setIcon(false);
                                    topMostWindow.setSelected(true);
                                }
                                catch (Exception ex) {
                                    BugCatcherManager.getBugCatcher().logError(ex);
                                }
                            }
                            ArbilWindowManager.this.getDesktopPane().repaint();
                        }
                        if (((KeyEvent)e).getKeyCode() == 9 && ((KeyEvent)e).isControlDown()) {
                            try {
                                int targetLayerInt;
                                JInternalFrame[] allWindows = ArbilWindowManager.this.getDesktopPane().getAllFrames();
                                if (((KeyEvent)e).isShiftDown()) {
                                    allWindows[0].moveToBack();
                                    targetLayerInt = 1;
                                } else {
                                    targetLayerInt = allWindows.length - 1;
                                }
                                allWindows[targetLayerInt].setIcon(false);
                                allWindows[targetLayerInt].setSelected(true);
                            }
                            catch (Exception ex) {
                                BugCatcherManager.getBugCatcher().logError(ex);
                            }
                        }
                        if ((((KeyEvent)e).isMetaDown() || ((KeyEvent)e).isControlDown()) && (((KeyEvent)e).getKeyCode() == 45 || ((KeyEvent)e).getKeyCode() == 61 || ((KeyEvent)e).getKeyCode() == 521)) {
                            ArbilWindowManager.this.fontScale = ((KeyEvent)e).getKeyCode() != 45 ? (ArbilWindowManager.this.fontScale += 0.1f) : (ArbilWindowManager.this.fontScale -= 0.1f);
                            if (ArbilWindowManager.this.fontScale < 1.0f) {
                                ArbilWindowManager.this.fontScale = 1.0f;
                            }
                            System.out.println("fontScale: " + ArbilWindowManager.this.fontScale);
                            UIDefaults defaults = UIManager.getDefaults();
                            Enumeration keys = defaults.keys();
                            while (keys.hasMoreElements()) {
                                Object key = keys.nextElement();
                                Object value = defaults.get(key);
                                if (value == null || !(value instanceof Font)) continue;
                                UIManager.put(key, null);
                                Font font = UIManager.getFont(key);
                                if (font == null) continue;
                                float size = font.getSize2D();
                                UIManager.put(key, new FontUIResource(font.deriveFont(size * ArbilWindowManager.this.fontScale)));
                            }
                            SwingUtilities.updateComponentTreeUI(ArbilWindowManager.this.getDesktopPane().getParent().getParent());
                        }
                        if ((((KeyEvent)e).isMetaDown() || ((KeyEvent)e).isControlDown()) && ((KeyEvent)e).getKeyCode() == 70) {
                            JInternalFrame windowToSearch = ArbilWindowManager.this.getDesktopPane().getSelectedFrame();
                            for (Component childComponent : windowToSearch.getContentPane().getComponents()) {
                                if (!(childComponent instanceof ArbilSplitPanel)) continue;
                                ((ArbilSplitPanel)childComponent).showSearchPane();
                            }
                        }
                    }
                }
            }
        }, 8L);
    }

    public JInternalFrame createWindow(String windowTitle, Component contentsComponent) {
        JInternalFrame currentInternalFrame = new JInternalFrame();
        currentInternalFrame.setLayout(new BorderLayout());
        currentInternalFrame.add(contentsComponent, "Center");
        windowTitle = this.addWindowToList(windowTitle, currentInternalFrame);
        currentInternalFrame.setTitle(windowTitle);
        currentInternalFrame.setToolTipText(windowTitle);
        currentInternalFrame.setName(windowTitle);
        this.applyWindowDefaults(currentInternalFrame);
        this.desktopPane.add((Component)currentInternalFrame, 0);
        try {
            currentInternalFrame.setSelected(true);
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        currentInternalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameDeactivated(InternalFrameEvent e) {
                this.fixLocation(e.getInternalFrame());
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                this.fixLocation(e.getInternalFrame());
            }

            private void fixLocation(JInternalFrame frame) {
                if (frame.getLocation().getY() < 0.0) {
                    frame.setLocation(new Point((int)frame.getLocation().getX(), 0));
                }
            }
        });
        return currentInternalFrame;
    }

    @Override
    public JEditorPane openUrlWindowOnce(String frameTitle, URL locationUrl) {
        JEditorPane htmlDisplay = new JEditorPane();
        htmlDisplay.setEditable(false);
        htmlDisplay.setContentType("text/html");
        try {
            htmlDisplay.setPage(locationUrl);
            htmlDisplay.addHyperlinkListener(new ArbilHyperlinkListener());
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        JInternalFrame existingWindow = this.focusWindow(frameTitle);
        if (existingWindow == null) {
            JScrollPane jScrollPane6 = new JScrollPane();
            jScrollPane6.setViewportView(htmlDisplay);
            this.createWindow(frameTitle, jScrollPane6);
        } else {
            ((JScrollPane)existingWindow.getContentPane().getComponent(0)).setViewportView(htmlDisplay);
        }
        return htmlDisplay;
    }

    @Override
    public void openSearchTable(ArbilNode[] selectedNodes, String frameTitle) {
        ArbilTableModel resultsTableModel = new ArbilTableModel();
        ArbilTable arbilTable = new ArbilTable(resultsTableModel, frameTitle);
        arbilTable.setAllowNodeDrop(false);
        ArbilSplitPanel tablePanel = new ArbilSplitPanel(arbilTable);
        JInternalFrame searchFrame = this.createWindow(frameTitle, tablePanel);
        ArbilNodeSearchPanel searchPanel = new ArbilNodeSearchPanel(searchFrame, resultsTableModel, selectedNodes);
        searchFrame.add((Component)searchPanel, "North");
        tablePanel.setSplitDisplay();
        tablePanel.addFocusListener(searchFrame);
        searchFrame.pack();
    }

    @Override
    public void openFloatingTableOnce(URI[] rowNodesArray, String frameTitle) {
        this.openFloatingTableOnceGetModel(rowNodesArray, frameTitle);
    }

    @Override
    public void openFloatingTableOnce(ArbilDataNode[] rowNodesArray, String frameTitle) {
        this.openFloatingTableOnceGetModel(rowNodesArray, frameTitle);
    }

    @Override
    public void openFloatingTable(ArbilDataNode[] rowNodesArray, String frameTitle) {
        this.openFloatingTableGetModel(rowNodesArray, frameTitle, null, null);
    }

    @Override
    public ArbilTableModel openFloatingTableOnceGetModel(URI[] rowNodesArray, String frameTitle) {
        ArbilDataNode[] tableNodes = new ArbilDataNode[rowNodesArray.length];
        ArrayList<String> fieldPathsToHighlight = new ArrayList<String>();
        for (int arrayCounter = 0; arrayCounter < rowNodesArray.length; ++arrayCounter) {
            try {
                String parentNodeFragment;
                if (rowNodesArray[arrayCounter] == null) continue;
                ArbilDataNode parentNode = this.dataNodeLoader.getArbilDataNode(null, new URI(rowNodesArray[arrayCounter].toString().split("#")[0]));
                String fieldPath = rowNodesArray[arrayCounter].getFragment();
                if (parentNode.nodeTemplate == null) {
                    BugCatcherManager.getBugCatcher().logError(new Exception("nodeTemplate null in: " + parentNode.getUrlString()));
                    parentNodeFragment = "";
                } else {
                    parentNodeFragment = parentNode.nodeTemplate.getParentOfField(fieldPath);
                }
                URI targetNode = parentNodeFragment.length() > 0 ? new URI(rowNodesArray[arrayCounter].toString().split("#")[0] + "#" + parentNodeFragment) : new URI(rowNodesArray[arrayCounter].toString().split("#")[0]);
                tableNodes[arrayCounter] = this.dataNodeLoader.getArbilDataNode(null, targetNode);
                fieldPathsToHighlight.add(fieldPath);
                continue;
            }
            catch (URISyntaxException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
        }
        ArbilTableModel targetTableModel = this.openFloatingTableOnceGetModel(tableNodes, frameTitle);
        targetTableModel.highlightMatchingFieldPaths(fieldPathsToHighlight.toArray(new String[0]));
        return targetTableModel;
    }

    @Override
    public ArbilTableModel openAllChildNodesInFloatingTableOnce(URI[] rowNodesArray, String frameTitle) {
        HashSet<ArbilDataNode> tableNodes = new HashSet<ArbilDataNode>();
        for (int arrayCounter = 0; arrayCounter < rowNodesArray.length; ++arrayCounter) {
            ArbilDataNode currentNode = this.dataNodeLoader.getArbilDataNode(null, rowNodesArray[arrayCounter]);
            tableNodes.add(currentNode);
            for (ArbilDataNode currentChildNode : currentNode.getAllChildren()) {
                tableNodes.add(currentChildNode);
            }
        }
        return this.openFloatingTableOnceGetModel(tableNodes.toArray(new ArbilDataNode[0]), frameTitle);
    }

    public ArbilTableModel openFloatingTableOnceGetModel(ArbilDataNode[] rowNodesArray, String frameTitle) {
        if (rowNodesArray.length == 1 && rowNodesArray[0] != null && rowNodesArray[0].isInfoLink) {
            try {
                if (rowNodesArray[0].getUrlString().toLowerCase().endsWith(".html") || rowNodesArray[0].getUrlString().toLowerCase().endsWith(".txt")) {
                    this.openUrlWindowOnce(rowNodesArray[0].toString(), rowNodesArray[0].getURI().toURL());
                    return null;
                }
            }
            catch (MalformedURLException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
        }
        for (Component[] currentWindow : (Component[][])this.windowList.values().toArray((T[])new Component[0][])) {
            for (Component childComponent : ((JInternalFrame)currentWindow[0]).getContentPane().getComponents()) {
                ArbilTableModel currentTableModel;
                if (!(childComponent instanceof ArbilSplitPanel) || (currentTableModel = ((ArbilSplitPanel)childComponent).arbilTable.getArbilTableModel()).getArbilDataNodeCount() != rowNodesArray.length) continue;
                boolean tableMatches = true;
                for (ArbilDataNode currentItem : rowNodesArray) {
                    if (currentTableModel.containsArbilDataNode(currentItem)) continue;
                    tableMatches = false;
                    break;
                }
                if (!tableMatches) continue;
                try {
                    ((JInternalFrame)currentWindow[0]).setIcon(false);
                    ((JInternalFrame)currentWindow[0]).setSelected(true);
                    return currentTableModel;
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        }
        return this.openFloatingTableGetModel(rowNodesArray, frameTitle, null, null);
    }

    private ArbilTableModel openFloatingTableGetModel(ArbilDataNode[] rowNodesArray, String frameTitle, Component[] window, ArbilFieldView fieldView) {
        if (frameTitle == null) {
            frameTitle = rowNodesArray.length == 1 ? rowNodesArray[0].toString() : "Selection";
        }
        ArbilTableModel arbilTableModel = fieldView == null ? new ArbilTableModel() : new ArbilTableModel(fieldView);
        ArbilTable arbilTable = new ArbilTable(arbilTableModel, frameTitle);
        ArbilSplitPanel arbilSplitPanel = new ArbilSplitPanel(arbilTable);
        arbilTableModel.addArbilDataNodes(rowNodesArray);
        arbilSplitPanel.setSplitDisplay();
        JInternalFrame tableFrame = this.createWindow(frameTitle, arbilSplitPanel);
        arbilSplitPanel.addFocusListener(tableFrame);
        if (window != null && window.length > 0) {
            window[0] = tableFrame;
        }
        return arbilTableModel;
    }

    @Override
    public void openFloatingSubnodesWindows(ArbilDataNode[] arbilDataNodes) {
        for (ArbilDataNode arbilDataNode : arbilDataNodes) {
            this.openFloatingSubnodesWindowOnce(arbilDataNode, arbilDataNode.toString(), null);
        }
    }

    private void openFloatingSubnodesWindowOnce(ArbilDataNode arbilDataNode, String frameTitle, Component[] window) {
        for (String currentWindowName : this.windowList.keySet()) {
            Component[] currentWindow = this.windowList.get(currentWindowName);
            for (Component childComponent : ((JInternalFrame)currentWindow[0]).getContentPane().getComponents()) {
                if (!(childComponent instanceof ArbilSubnodesScrollPane) || !((ArbilSubnodesScrollPane)childComponent).getDataNode().equals(arbilDataNode)) continue;
                this.focusWindow(currentWindowName);
                return;
            }
        }
        ArbilSubnodesScrollPane scrollPane = new ArbilSubnodesScrollPane(arbilDataNode);
        JInternalFrame tableFrame = this.createWindow(frameTitle, scrollPane);
        tableFrame.addInternalFrameListener(scrollPane.getInternalFrameListener());
        if (window != null && window.length > 0) {
            window[0] = tableFrame;
        }
    }

    @Override
    public boolean openFileInExternalApplication(URI targetUri) {
        boolean result;
        block19: {
            result = false;
            boolean awtDesktopFound = false;
            try {
                Class.forName("java.awt.Desktop");
                awtDesktopFound = true;
            }
            catch (ClassNotFoundException cnfE) {
                awtDesktopFound = false;
                System.out.println("java.awt.Desktop class not found");
            }
            if (awtDesktopFound) {
                try {
                    if (targetUri.getScheme().toLowerCase().equals("file")) {
                        File targetFile = new File(targetUri);
                        Desktop.getDesktop().open(targetFile);
                    } else {
                        Desktop.getDesktop().browse(targetUri);
                    }
                    result = true;
                }
                catch (MalformedURLException muE) {
                    BugCatcherManager.getBugCatcher().logError("awtDesktopFound", muE);
                    this.addMessageDialogToQueue("Failed to find the file: " + muE.getMessage(), "Open In External Application");
                }
                catch (IOException ioE) {
                    BugCatcherManager.getBugCatcher().logError("awtDesktopFound", ioE);
                    if (targetUri.getScheme().equalsIgnoreCase("file")) {
                        if (this.showConfirmDialogBox("Failed to open the file. Please check that it is accessible and has an application associated with it.\n\nDo you want to open the parent directory?", "Open In External Application")) {
                            this.openFileInExternalApplication(new File(targetUri).getParentFile().toURI());
                        }
                        break block19;
                    }
                    this.addMessageDialogToQueue("Failed to open the remote location: " + ioE.getMessage(), "Open In External Application");
                }
            } else {
                String osNameString = null;
                try {
                    osNameString = System.getProperty("os.name").toLowerCase();
                    String fileString = ArbilDataNode.isUriLocal(targetUri) ? new File(targetUri).getAbsolutePath() : targetUri.toString();
                    Process launchedProcess = null;
                    if (osNameString.indexOf("windows") != -1 || osNameString.indexOf("nt") != -1) {
                        launchedProcess = Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", fileString});
                    }
                    if (osNameString.equals("windows 95") || osNameString.equals("windows 98")) {
                        launchedProcess = Runtime.getRuntime().exec(new String[]{"command.com", "/C", "start", fileString});
                    }
                    if (osNameString.indexOf("mac") != -1) {
                        launchedProcess = Runtime.getRuntime().exec(new String[]{"open", fileString});
                    }
                    if (osNameString.indexOf("linux") != -1) {
                        launchedProcess = Runtime.getRuntime().exec(new String[]{"gnome-open", fileString});
                    }
                    if (launchedProcess != null) {
                        String line;
                        BufferedReader errorStreamReader = new BufferedReader(new InputStreamReader(launchedProcess.getErrorStream()));
                        while ((line = errorStreamReader.readLine()) != null) {
                            this.addMessageDialogToQueue(line, "Open In External Application");
                            System.out.println("Launched process error stream: \"" + line + "\"");
                        }
                        result = true;
                    }
                }
                catch (Exception e) {
                    BugCatcherManager.getBugCatcher().logError(osNameString, e);
                }
            }
        }
        return result;
    }

    @Override
    public void openImdiXmlWindow(Object userObject, boolean formatXml, boolean launchInBrowser) {
        block11: {
            if (userObject instanceof ArbilDataNode) {
                if (((ArbilDataNode)userObject).getNeedsSaveToDisk(false)) {
                    if (0 == this.showDialogBox("The node must be saved first.\nSave now?", "View IMDI XML", 2, -1)) {
                        ((ArbilDataNode)userObject).saveChangesToCache(true);
                    } else {
                        return;
                    }
                }
                URI nodeUri = ((ArbilDataNode)userObject).getURI();
                System.out.println("openImdiXmlWindow: " + nodeUri);
                String nodeName = ((ArbilDataNode)userObject).toString();
                if (formatXml) {
                    try {
                        File tempHtmlFile = new ArbilToHtmlConverter().convertToHtml((ArbilDataNode)userObject);
                        if (!launchInBrowser) {
                            this.openUrlWindowOnce(nodeName + " formatted", tempHtmlFile.toURL());
                            break block11;
                        }
                        this.openFileInExternalApplication(tempHtmlFile.toURI());
                    }
                    catch (Exception ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                } else {
                    try {
                        this.openUrlWindowOnce(nodeName + "-xml", nodeUri.toURL());
                    }
                    catch (Exception ex) {
                        BugCatcherManager.getBugCatcher().logError(ex);
                    }
                }
            }
        }
    }

    @Override
    public int showDialogBox(String message, String title, int optionType, int messageType) {
        return JOptionPane.showConfirmDialog(this.getMainFrame(), message, title, optionType, messageType);
    }

    @Override
    public int showDialogBox(String message, String title, int optionType, int messageType, Object[] options, Object initialValue) {
        return JOptionPane.showOptionDialog(this.getMainFrame(), message, title, optionType, messageType, null, options, initialValue);
    }

    @Override
    public ProgressMonitor newProgressMonitor(Object message, String note, int min, int max) {
        return new ProgressMonitor(this.desktopPane, message, note, min, max);
    }

    @Override
    public JFrame getMainFrame() {
        return this.linorgFrame;
    }

    @Override
    public boolean askUserToSaveChanges(String entityName) {
        return this.showConfirmDialogBox("This action will save all pending changes on " + entityName + " to disk. Continue?", "Save to disk?");
    }

    private Point fixLocation(Point location) {
        if (location.getY() < 0.0) {
            location.move((int)location.getX(), Math.max(0, (int)location.getY()));
        }
        return location;
    }

    private void initFileFilterMap() {
        this.fileFilterMap = new HashMap<String, FileFilter>(2);
        this.addToFileFilterMap("IMDI", ".imdi");
        this.addToFileFilterMap("CMDI", ".cmdi");
    }

    private void addToFileFilterMap(final String name, final String extension) {
        this.fileFilterMap.put(name, new FileFilter(){

            public boolean accept(File selectedFile) {
                String extensionLowerCase = extension.toLowerCase();
                return selectedFile.exists() && (selectedFile.isDirectory() || selectedFile.getName().toLowerCase().endsWith(extensionLowerCase));
            }

            public String getDescription() {
                return name;
            }
        });
    }

    public void setStatusBarVisible(boolean visible) {
        this.statusBar.setVisible(visible);
    }

    public boolean getStatusBarVisible() {
        return this.statusBar.isVisible();
    }

    public synchronized Collection<ArbilTaskListener> getTaskListeners() {
        return this.taskListeners;
    }

    public synchronized void addTaskListener(ArbilTaskListener taskListener) {
        this.taskListeners.add(taskListener);
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }
}

