/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.ui.TemplateDialogue;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.WindowManager;

public class CmdiProfilesPanel
extends JPanel {
    private boolean firstLoad = true;
    private static WindowManager windowManager;
    private static MessageDialogHandler dialogHandler;
    private JPanel clarinPanel;
    private JPanel profileReloadPanel;
    private JProgressBar profileReloadProgressBar;
    protected JCheckBox profileSelectionCheckBox;
    private JScrollPane clarinScrollPane;
    private JButton reloadButton;
    private JDialog parentFrame;
    private JButton downloadAllButton;
    private JTextArea profileInstructionsArea;

    public static void setWindowManager(WindowManager windowManagerInstance) {
        windowManager = windowManagerInstance;
    }

    public static void setMessageDialogHandler(MessageDialogHandler dialogHandlerInstance) {
        dialogHandler = dialogHandlerInstance;
    }

    public CmdiProfilesPanel(JDialog parentFrameLocal) {
        this.parentFrame = parentFrameLocal;
        this.profileReloadPanel = new JPanel();
        this.profileReloadProgressBar = new JProgressBar();
        this.clarinScrollPane = new JScrollPane();
        this.profileSelectionCheckBox = new JCheckBox();
        this.reloadButton = new JButton();
        this.downloadAllButton = new JButton();
        this.clarinPanel = new JPanel();
        JPanel profileReloadTopPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.profileReloadPanel.setLayout(new BorderLayout());
        this.profileReloadPanel.setAlignmentX(2.0f);
        profileReloadTopPanel.setLayout(new BoxLayout(profileReloadTopPanel, 2));
        this.reloadButton.setText("Reload Clarin Profiles");
        this.reloadButton.setToolTipText("Download the latest clarin profiles");
        this.reloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CmdiProfilesPanel.this.reloadButtonActionPerformed(evt);
            }
        });
        this.downloadAllButton.setText("Download all profiles");
        this.downloadAllButton.setToolTipText("Download all profiles for offline use (including unselected profiles)");
        this.downloadAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CmdiProfilesPanel.this.downloadAllButtonActionPerformed(evt);
            }
        });
        this.profileSelectionCheckBox.setText("Only load profiles selected for manual editing");
        this.profileSelectionCheckBox.setSelected(CmdiProfileReader.getSingleInstance().getSelection() == CmdiProfileReader.ProfileSelection.SELECTED);
        profileReloadTopPanel.add(this.reloadButton);
        profileReloadTopPanel.add(this.downloadAllButton);
        profileReloadTopPanel.add(this.profileReloadProgressBar);
        this.profileReloadPanel.add((Component)profileReloadTopPanel, "Center");
        this.profileReloadPanel.add((Component)this.profileSelectionCheckBox, "South");
        this.add((Component)this.profileReloadPanel, "Last");
        this.clarinScrollPane.setViewportView(this.clarinPanel);
        this.add((Component)this.clarinScrollPane, "Center");
        this.profileInstructionsArea = new JTextArea("Profiles selected below will become available in the 'Add' menu of the local corpus. By default, only selected profiles will be downloaded for offline use.");
        this.profileInstructionsArea.setEditable(false);
        this.profileInstructionsArea.setLineWrap(true);
        this.profileInstructionsArea.setWrapStyleWord(true);
        this.profileInstructionsArea.setOpaque(false);
        JPanel profilesTopButtonsPanel = new JPanel();
        profilesTopButtonsPanel.setLayout(new BoxLayout(profilesTopButtonsPanel, 2));
        JButton addButton = new JButton();
        addButton.setText("Add URL");
        addButton.setToolTipText("Add a profile URL to the list");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String newDirectoryName = JOptionPane.showInputDialog(windowManager.getMainFrame(), "Enter the profile URL", "Add Profile", -1, null, null, null).toString();
                ArbilTemplateManager.getSingleInstance().addSelectedTemplates("custom:" + newDirectoryName);
                CmdiProfilesPanel.this.populateList();
            }
        });
        profilesTopButtonsPanel.add(addButton);
        JButton browseButton = new JButton();
        browseButton.setText("Add File");
        browseButton.setToolTipText("Browse for local profiles");
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (File selectedFile : dialogHandler.showFileSelectBox("Select Profile", false, true, false)) {
                    ArbilTemplateManager.getSingleInstance().addSelectedTemplates("custom:" + selectedFile.toURI().toString());
                }
                CmdiProfilesPanel.this.populateList();
            }
        });
        profilesTopButtonsPanel.add(browseButton);
        JPanel profilesTopPanel = new JPanel();
        profilesTopPanel.setLayout(new BoxLayout(profilesTopPanel, 1));
        this.profileInstructionsArea.setAlignmentX(0.0f);
        profilesTopButtonsPanel.setAlignmentX(0.0f);
        profilesTopPanel.add(this.profileInstructionsArea);
        profilesTopPanel.add(profilesTopButtonsPanel);
        this.add((Component)profilesTopPanel, "First");
    }

    public void downloadProfiles(boolean forceUpdate) {
        this.loadProfiles(forceUpdate, true);
    }

    public void loadProfileDescriptions(boolean forceUpdate) {
        this.loadProfiles(forceUpdate, false);
    }

    public void setInstructionsVisible(boolean visible) {
        this.profileInstructionsArea.setVisible(visible);
    }

    private void loadProfiles(final boolean forceUpdate, final boolean updateProfilesCache) {
        CmdiProfileReader.getSingleInstance().setSelection(this.profileSelectionCheckBox.isSelected() ? CmdiProfileReader.ProfileSelection.SELECTED : CmdiProfileReader.ProfileSelection.ALL);
        this.clarinPanel.removeAll();
        this.clarinPanel.add(new JTextField("Loading, please wait..."));
        this.reloadButton.setVisible(false);
        this.downloadAllButton.setVisible(false);
        this.profileSelectionCheckBox.setEnabled(false);
        this.profileReloadProgressBar.setVisible(true);
        this.doLayout();
        new Thread("loadProfiles"){

            public void run() {
                CmdiProfileReader cmdiProfileReader = CmdiProfileReader.getSingleInstance();
                if (updateProfilesCache) {
                    cmdiProfileReader.refreshProfilesAndUpdateCache(CmdiProfilesPanel.this.profileReloadProgressBar, forceUpdate);
                } else {
                    cmdiProfileReader.refreshProfiles(forceUpdate);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CmdiProfilesPanel.this.profileReloadProgressBar.setVisible(false);
                        CmdiProfilesPanel.this.reloadButton.setVisible(true);
                        CmdiProfilesPanel.this.downloadAllButton.setVisible(true);
                        CmdiProfilesPanel.this.profileSelectionCheckBox.setEnabled(true);
                        CmdiProfilesPanel.this.populateList();
                        CmdiProfilesPanel.this.doLayout();
                    }
                });
            }
        }.start();
    }

    private void reloadButtonActionPerformed(ActionEvent evt) {
        this.loadProfileDescriptions(true);
    }

    private void downloadAllButtonActionPerformed(ActionEvent evt) {
        this.downloadProfiles(true);
    }

    public synchronized void populateList() {
        this.populateProfilesList();
        if (this.firstLoad) {
            this.parentFrame.pack();
            this.firstLoad = false;
        }
    }

    protected void populateProfilesList() {
        ArrayList<String> selectedTemplates = ArbilTemplateManager.getSingleInstance().getSelectedTemplateArrayList();
        ArrayList<JCheckBox> checkBoxArray = new ArrayList<JCheckBox>();
        CmdiProfileReader cmdiProfileReader = CmdiProfileReader.getSingleInstance();
        for (CmdiProfileReader.CmdiProfile currentCmdiProfile : cmdiProfileReader.cmdiProfileArray) {
            String templateId = "clarin:" + currentCmdiProfile.getXsdHref();
            JCheckBox clarinProfileCheckBox = new JCheckBox();
            clarinProfileCheckBox.setText(currentCmdiProfile.name);
            clarinProfileCheckBox.setName(currentCmdiProfile.name);
            clarinProfileCheckBox.setActionCommand(templateId);
            clarinProfileCheckBox.setSelected(selectedTemplates.contains(templateId));
            clarinProfileCheckBox.setToolTipText(currentCmdiProfile.description);
            clarinProfileCheckBox.addActionListener(TemplateDialogue.templateSelectionListener);
            clarinProfileCheckBox.addActionListener(new DownloadSchemaActionListener(clarinProfileCheckBox, cmdiProfileReader, currentCmdiProfile.getXsdHref()));
            checkBoxArray.add(clarinProfileCheckBox);
        }
        for (String currentSepectedProfile : selectedTemplates) {
            if (!currentSepectedProfile.startsWith("custom:")) continue;
            String customUrlString = currentSepectedProfile.substring("custom:".length());
            String customName = currentSepectedProfile.replaceAll("[/.]xsd$", "");
            if (customName.contains("/")) {
                customName = customName.substring(customName.lastIndexOf("/") + 1);
            }
            JCheckBox clarinProfileCheckBox = new JCheckBox();
            clarinProfileCheckBox.setText(customName);
            clarinProfileCheckBox.setName(customName);
            clarinProfileCheckBox.setActionCommand(currentSepectedProfile);
            clarinProfileCheckBox.setSelected(true);
            clarinProfileCheckBox.setToolTipText("custom profile, uncheck to remove");
            clarinProfileCheckBox.addActionListener(TemplateDialogue.templateSelectionListener);
            clarinProfileCheckBox.addActionListener(new DownloadSchemaActionListener(clarinProfileCheckBox, cmdiProfileReader, customUrlString));
            checkBoxArray.add(clarinProfileCheckBox);
        }
        TemplateDialogue.addSorted(this.clarinPanel, checkBoxArray);
    }

    private static class DownloadSchemaActionListener
    implements ActionListener {
        private CmdiProfileReader reader;
        private String url;
        private JCheckBox checkBox;

        public DownloadSchemaActionListener(JCheckBox clarinProfileCheckBox, CmdiProfileReader reader, String url) {
            this.reader = reader;
            this.url = url;
            this.checkBox = clarinProfileCheckBox;
        }

        public void actionPerformed(ActionEvent e) {
            new Thread(){

                public void run() {
                    if (DownloadSchemaActionListener.this.checkBox.isSelected()) {
                        DownloadSchemaActionListener.this.reader.storeProfileInCache(DownloadSchemaActionListener.this.url, 0);
                    }
                }
            }.start();
        }
    }
}

