/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeCellRenderer;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.ui.ArbilTreeRenderer;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.data.KinTreeNode;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.KinDragTransferHandler;
import nl.mpi.kinnate.ui.KinTree;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class EgoSelectionPanel
extends JPanel
implements ActionListener {
    private KinTree egoTree;
    private KinTree requiredTree;
    private KinTree impliedTree;
    private KinTree transientTree;
    JPanel labelPanel3;
    JScrollPane metadataNodeScrolPane;
    JScrollPane transientNodeScrolPane;
    private MessageDialogHandler dialogHandler;
    private EntityCollection entityCollection;
    private ArbilDataNodeLoader dataNodeLoader;

    public EgoSelectionPanel(KinDiagramPanel kinDiagramPanel, GraphPanel graphPanel, MessageDialogHandler dialogHandler, EntityCollection entityCollection, ArbilDataNodeLoader dataNodeLoader) {
        this.dialogHandler = dialogHandler;
        this.entityCollection = entityCollection;
        this.dataNodeLoader = dataNodeLoader;
        JPanel transientNodePanel = new JPanel(new BorderLayout());
        transientNodePanel.setBorder(BorderFactory.createTitledBorder("Transient Entities"));
        JButton convertTransientButton = new JButton("Convert to Database Diagram");
        convertTransientButton.setActionCommand("convert");
        convertTransientButton.addActionListener(this);
        convertTransientButton.setEnabled(false);
        transientNodePanel.add((Component)convertTransientButton, "First");
        this.transientTree = new KinTree(kinDiagramPanel, graphPanel);
        this.transientTree.setBackground(transientNodePanel.getBackground());
        transientNodePanel.add((Component)((Object)this.transientTree), "Center");
        this.transientNodeScrolPane = new JScrollPane(transientNodePanel);
        JPanel metadataNodePanel = new JPanel(new BorderLayout());
        this.egoTree = new KinTree(kinDiagramPanel, graphPanel);
        this.egoTree.setCellRenderer((TreeCellRenderer)new ArbilTreeRenderer());
        this.requiredTree = new KinTree(kinDiagramPanel, graphPanel);
        this.requiredTree.setCellRenderer((TreeCellRenderer)new ArbilTreeRenderer());
        this.impliedTree = new KinTree(kinDiagramPanel, graphPanel);
        this.impliedTree.setCellRenderer((TreeCellRenderer)new ArbilTreeRenderer());
        this.setLayout(new BorderLayout());
        JPanel treePanel2 = new JPanel(new BorderLayout());
        this.metadataNodeScrolPane = new JScrollPane(metadataNodePanel);
        JPanel labelPanel1 = new JPanel(new BorderLayout());
        JPanel labelPanel2 = new JPanel(new BorderLayout());
        this.labelPanel3 = new JPanel(new BorderLayout());
        labelPanel1.setBorder(BorderFactory.createTitledBorder("Ego"));
        labelPanel2.setBorder(BorderFactory.createTitledBorder("Required"));
        this.labelPanel3.setBorder(BorderFactory.createTitledBorder("Implied"));
        labelPanel1.add((Component)((Object)this.egoTree), "Center");
        labelPanel2.add((Component)((Object)this.requiredTree), "Center");
        this.labelPanel3.add((Component)((Object)this.impliedTree), "Center");
        this.egoTree.setBackground(labelPanel1.getBackground());
        this.requiredTree.setBackground(labelPanel1.getBackground());
        this.impliedTree.setBackground(labelPanel1.getBackground());
        metadataNodePanel.add((Component)labelPanel1, "First");
        metadataNodePanel.add((Component)treePanel2, "Center");
        treePanel2.add((Component)labelPanel2, "First");
        treePanel2.add((Component)this.labelPanel3, "Center");
        this.add((Component)this.metadataNodeScrolPane, "Center");
    }

    public void setTransferHandler(KinDragTransferHandler dragTransferHandler) {
        for (KinTree currentTree : new KinTree[]{this.egoTree, this.requiredTree, this.impliedTree, this.transientTree}) {
            currentTree.setTransferHandler(dragTransferHandler);
            currentTree.setDragEnabled(true);
        }
    }

    public void setTreeNodes(GraphPanel graphPanel) {
        HashSet<UniqueIdentifier> egoIdentifiers = graphPanel.dataStoreSvg.egoEntities;
        HashSet<UniqueIdentifier> requiredEntityIdentifiers = graphPanel.dataStoreSvg.requiredEntities;
        EntityData[] allEntities = graphPanel.dataStoreSvg.graphData != null ? graphPanel.dataStoreSvg.graphData.getDataNodes() : new EntityData[]{};
        IndexerParameters indexerParameters = graphPanel.getIndexParameters();
        this.remove(this.transientNodeScrolPane);
        this.add((Component)this.metadataNodeScrolPane, "Center");
        this.revalidate();
        ArrayList<KinTreeNode> egoNodeArray = new ArrayList<KinTreeNode>();
        ArrayList<KinTreeNode> requiredNodeArray = new ArrayList<KinTreeNode>();
        ArrayList<KinTreeNode> remainingNodeArray = new ArrayList<KinTreeNode>();
        for (EntityData entityData : allEntities) {
            if (!entityData.isVisible) continue;
            KinTreeNode kinTreeNode = new KinTreeNode(entityData, indexerParameters, this.dialogHandler, this.entityCollection, this.dataNodeLoader);
            if (entityData.isEgo || egoIdentifiers.contains(entityData.getUniqueIdentifier())) {
                egoNodeArray.add(kinTreeNode);
                continue;
            }
            if (requiredEntityIdentifiers.contains(entityData.getUniqueIdentifier())) {
                requiredNodeArray.add(kinTreeNode);
                continue;
            }
            remainingNodeArray.add(kinTreeNode);
        }
        this.egoTree.rootNodeChildren = egoNodeArray.toArray(new ArbilNode[0]);
        this.egoTree.requestResort();
        this.requiredTree.rootNodeChildren = requiredNodeArray.toArray(new ArbilNode[0]);
        this.requiredTree.requestResort();
        this.impliedTree.rootNodeChildren = remainingNodeArray.toArray(new ArbilNode[0]);
        this.impliedTree.requestResort();
        this.transientTree.rootNodeChildren = new ArbilNode[0];
        this.transientTree.requestResort();
    }

    public void setTransientNodes(EntityData[] allEntities) {
        this.remove(this.metadataNodeScrolPane);
        this.add((Component)this.transientNodeScrolPane, "Center");
        this.revalidate();
        ArrayList<KinTreeNode> transientNodeArray = new ArrayList<KinTreeNode>();
        for (EntityData entityData : allEntities) {
            KinTreeNode kinTreeNode = new KinTreeNode(entityData, null, this.dialogHandler, this.entityCollection, this.dataNodeLoader);
            transientNodeArray.add(kinTreeNode);
        }
        this.transientTree.rootNodeChildren = transientNodeArray.toArray(new ArbilNode[0]);
        this.transientTree.requestResort();
        this.egoTree.rootNodeChildren = new ArbilNode[0];
        this.egoTree.requestResort();
        this.requiredTree.rootNodeChildren = new ArbilNode[0];
        this.requiredTree.requestResort();
        this.impliedTree.rootNodeChildren = new ArbilNode[0];
        this.impliedTree.requestResort();
    }

    public void actionPerformed(ActionEvent e) {
        if ("convert".equals(e.getActionCommand())) {
            throw new UnsupportedOperationException("Ticket #1114 Button to convert freeform diagram to metadata diagram");
        }
    }
}

