/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdi.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import nl.mpi.imdi.api.IMDIDom;
import nl.mpi.imdi.api.IMDIEdit;
import nl.mpi.imdi.api.IMDIElement;
import nl.mpi.imdi.api.IMDILink;
import nl.mpi.imdi.api.KeyValuePairs;
import nl.mpi.imdi.api.WSNodeType;
import nl.mpi.util.OurURL;
import org.w3c.dom.Document;

public class TestDom {
    private static IMDIEdit api = new IMDIDom();
    private static Document dom = null;
    private static OurURL baseURL = null;
    private static File outFile = new File("outfile.imdi");
    private static OurURL inURL = null;

    public static String[] tokenize(String what) {
        StringTokenizer st = new StringTokenizer(what, ",", true);
        boolean prevWasDelim = true;
        Vector<String> result = new Vector<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.equals(",")) {
                if (prevWasDelim) {
                    result.add("");
                }
                prevWasDelim = true;
                continue;
            }
            result.add(token);
            prevWasDelim = false;
        }
        String[] resultArray = result.toArray(new String[0]);
        for (int i = 0; i < resultArray.length; ++i) {
            if (resultArray[i].length() != 0) continue;
            resultArray[i] = null;
        }
        return resultArray;
    }

    private static int getType(String what) {
        if (what == null) {
            System.out.println("No type class argument given");
            return -1;
        }
        try {
            return Integer.parseInt(what);
        }
        catch (NumberFormatException nfe) {
            int i = WSNodeType.typeForName(what);
            if (i > 0) {
                return i;
            }
            System.out.println("Name does not specify a known type class: " + what);
            System.out.println("Valid names are: ");
            for (i = 1; i < WSNodeType.typeNumbers.length; ++i) {
                System.out.println("  " + WSNodeType.nameForType(WSNodeType.typeNumbers[i]));
            }
            return -1;
        }
    }

    private static void checkOkay(String what, boolean okay) {
        if (okay) {
            System.out.println(what + ": okay");
        } else {
            System.out.println(what + ": error: " + api.getMessage());
        }
    }

    private static void printLink(IMDILink il) {
        System.out.println("IMDILink[" + il.getSpec() + "," + il.getDomId() + "," + il.getAttributeName() + "] = '" + il.getValue() + "'");
        int type = il.getNodeType();
        System.out.println("  Class=" + WSNodeType.nameForType(type) + " Type=" + il.getType() + " Format=" + il.getFormat() + " Language=" + il.getLanguageId() + " Name=" + il.getLinkName());
        System.out.println("  URID=" + il.getURID() + " LinkDef=" + il.getLinkDefinition() + " -URL-> " + il.getRawURL());
    }

    public static void linkHandler(String cmd, String args) {
        if (args == null) {
            System.out.println("Arguments required for link command: " + cmd);
            return;
        }
        if (cmd.equals("getall")) {
            int type = TestDom.getType(args);
            if (type < 0) {
                return;
            }
            IMDILink[] links = api.getIMDILinks(dom, baseURL, type);
            TestDom.checkOkay("Get all IMDI links of type " + WSNodeType.nameForType(type), links != null);
            if (links == null) {
                return;
            }
            if (links.length == 0) {
                System.out.println("Found no links.");
            } else {
                System.out.println("Found " + links.length + " links:");
                for (int i = 0; i < links.length; ++i) {
                    System.out.print("Link " + (i + 1) + ": ");
                    TestDom.printLink(links[i]);
                }
                System.out.println();
            }
            return;
        }
        if (cmd.equals("getbyid")) {
            IMDILink link = api.getIMDILink(dom, baseURL, args);
            TestDom.checkOkay("Get IMDI link with domId " + args, link != null);
            if (link != null) {
                TestDom.printLink(link);
            }
            return;
        }
        if (cmd.equals("get")) {
            IMDILink link = api.getIMDILink(dom, baseURL, args);
            TestDom.checkOkay("Get IMDI link with " + (args.startsWith("i") ? "domId " : "spec ") + args, link != null);
            if (link != null) {
                TestDom.printLink(link);
            }
            return;
        }
        if (cmd.equals("remove")) {
            IMDIElement target = null;
            target = args.indexOf(46) != -1 || !args.startsWith("i") ? new IMDIElement(args) : new IMDIElement(null, args);
            TestDom.checkOkay("Delete IMDI link " + target, api.removeIMDILink(dom, target));
            return;
        }
        String[] tokens = TestDom.tokenize(args);
        if (cmd.equals("create")) {
            int type = -1;
            String spec = null;
            if (tokens.length < 3) {
                System.out.println("Required arguments: url, name, type class, plus spec if class is info file");
                return;
            }
            type = TestDom.getType(tokens[2]);
            if (tokens.length > 3) {
                spec = tokens[3];
            }
            String urlToLink = tokens[0];
            String linkName = tokens[1];
            IMDILink link = api.createIMDILink(dom, baseURL, urlToLink, linkName, type, spec);
            TestDom.checkOkay("Create IMDI link of type " + WSNodeType.nameForType(type), link != null);
            if (link != null) {
                TestDom.printLink(link);
            }
        } else if (cmd.equals("change")) {
            if (tokens.length < 9) {
                System.out.println("Arguments: domid, url, urid, type class, name, language, value, format, type");
                System.out.println("Some fields can be empty, depending on the type class");
                for (int i = 0; i < tokens.length; ++i) {
                    System.out.println("[" + tokens[i] + "]");
                }
                return;
            }
            int type = TestDom.getType(tokens[3]);
            IMDILink link = new IMDILink(null, tokens[0], type, null);
            if (tokens[1] != null && tokens[1].length() > 0) {
                try {
                    link.setURL(new OurURL(baseURL, tokens[1]));
                    System.out.println("new OurURL: " + baseURL + ", " + tokens[1] + " -> " + link.getRawURL());
                }
                catch (MalformedURLException mue) {
                    System.out.println("Invalid URL ignored: " + mue);
                }
            }
            if (tokens[2] != null && tokens[2].length() > 0) {
                link.setURID(tokens[2]);
            }
            if (tokens[4] != null && tokens[4].length() > 0) {
                link.setLinkName(tokens[4]);
            }
            if (tokens[5] != null && tokens[5].length() > 0) {
                link.setLanguageId(tokens[5]);
            }
            if (tokens[6] != null && tokens[6].length() > 0) {
                link.setValue(tokens[6]);
            }
            if (tokens[7] != null && tokens[7].length() > 0) {
                link.setFormat(tokens[7]);
            }
            if (tokens[8] != null && tokens[8].length() > 0) {
                link.setType(tokens[8]);
            }
            System.out.println("Change IMDI link:");
            TestDom.printLink(link);
            TestDom.checkOkay("Change IMDI link of type " + WSNodeType.nameForType(type), api.changeIMDILink(dom, baseURL, link));
        } else {
            System.out.println("Unknown link command ignored: " + cmd);
        }
    }

    private static void printElement(IMDIElement ie) {
        System.out.println("IMDIElement[" + ie.getSpec() + "," + ie.getDomId() + "," + ie.getAttributeName() + "] = '" + ie.getValue() + "'");
    }

    public static void elementHandler(String cmd, String args) {
        if (args == null) {
            System.out.println("Arguments required for element command: " + cmd);
            return;
        }
        if (cmd.equals("get")) {
            IMDIElement ie = api.getIMDIElement(dom, args);
            TestDom.checkOkay("Read IMDI element " + args, ie != null);
            if (ie != null) {
                TestDom.printElement(ie);
            }
            return;
        }
        if (cmd.equals("addempty")) {
            IMDIElement ie = api.addIMDIElement(dom, args);
            TestDom.checkOkay("Create IMDI element: " + args, ie != null);
            if (ie != null) {
                TestDom.printElement(ie);
            }
            return;
        }
        if (cmd.equals("remove")) {
            IMDIElement target = null;
            target = args.indexOf(46) != -1 || !args.startsWith("i") ? new IMDIElement(args) : new IMDIElement("-none-", args);
            TestDom.checkOkay("Delete IMDI element " + target, api.removeIMDIElement(dom, target));
            return;
        }
        String[] tokens = TestDom.tokenize(args);
        if (tokens.length < 2) {
            System.out.println("Not enough arguments for command: " + cmd);
            return;
        }
        if (cmd.equals("setbyid")) {
            String domId = tokens[0];
            String value = tokens[1];
            IMDIElement target = new IMDIElement(null, domId);
            target.setValue(value);
            IMDIElement ie = api.setIMDIElement(dom, target);
            TestDom.checkOkay("Set IMDI element: " + args, ie != null);
            if (ie != null) {
                TestDom.printElement(ie);
            }
        } else if (cmd.equals("setbyspec")) {
            String spec = tokens[0];
            String value = tokens[1];
            TestDom.checkOkay("Set IMDI value: " + spec + "=" + value, api.setIMDIValue(dom, spec, value));
        } else {
            System.out.println("Unknown element command ignored: " + cmd);
        }
    }

    public static void keyHandler(String cmd, String args) {
        if (args == null) {
            System.out.println("Arguments required for key command: " + cmd);
            return;
        }
        String[] tokens = TestDom.tokenize(args);
        if (cmd.equals("get")) {
            Hashtable kv = new Hashtable(1);
            KeyValuePairs.getKeyValuePair(dom, args, api, kv);
            TestDom.checkOkay("Read key value pair " + args, true);
            System.out.println("Found " + (kv.size() > 0 ? "a" : "no") + " key value pair");
            Enumeration items = kv.keys();
            while (items.hasMoreElements()) {
                String key = (String)items.nextElement();
                System.out.println("  " + key + " => " + (String)kv.get(key));
            }
            return;
        }
        if (cmd.equals("list")) {
            Hashtable kv = api.getKeyValuePairs(dom, args);
            TestDom.checkOkay("Read key value pairs " + args, true);
            System.out.println("Found " + kv.size() + " key value pair" + (kv.size() == 1 ? "" : "s"));
            Enumeration items = kv.keys();
            while (items.hasMoreElements()) {
                String key = (String)items.nextElement();
                System.out.println("  " + key + " => " + (String)kv.get(key));
            }
            return;
        }
        if (cmd.equals("set")) {
            if (tokens.length < 3) {
                System.out.println("Not enough arguments for command: " + cmd);
                return;
            }
            boolean okay = api.setKeyValuePair(dom, tokens[0], tokens[1], tokens[2]);
            TestDom.checkOkay("Set or create key value pair at: " + tokens[0] + " key: " + tokens[1] + " value: " + tokens[2], okay);
            return;
        }
        if (cmd.equals("remove")) {
            if (tokens.length < 2) {
                System.out.println("Not enough arguments for command: " + cmd);
                return;
            }
            boolean okay = api.setKeyValuePair(dom, tokens[0], tokens[1], null);
            TestDom.checkOkay("Remove key value pair at: " + tokens[0] + " key: " + tokens[1], okay);
            return;
        }
        System.out.println("Unknown key command ignored: " + cmd);
    }

    public static void command(String cmd) {
        String a = cmd;
        String b = null;
        int split = a.indexOf(61);
        if (split != -1) {
            b = a.substring(split + 1);
            if ((a = a.substring(0, split)).startsWith("save")) {
                outFile = new File(b);
            } else if (a.startsWith("load") || a.startsWith("validate")) {
                try {
                    inURL = new OurURL(b);
                }
                catch (MalformedURLException mue) {
                    System.out.println("Invalid input file URL: " + mue);
                }
            }
        }
        if (a.startsWith("#")) {
            System.out.println(cmd);
            return;
        }
        if (a.trim().length() == 0) {
            System.out.println("# -------------");
            return;
        }
        baseURL = inURL;
        if (a.equals("newsession")) {
            dom = api.createIMDIDOM(1);
            TestDom.checkOkay("Load template for session", dom != null);
        } else if (a.equals("newcorpus")) {
            dom = api.createIMDIDOM(2);
            TestDom.checkOkay("Load template for corpus", dom != null);
        } else if (a.equals("newcatalogue")) {
            dom = api.createIMDIDOM(8);
            TestDom.checkOkay("Load template for catalogue", dom != null);
        } else if (a.equals("loadfile")) {
            dom = api.loadIMDIDocument(inURL, false);
            TestDom.checkOkay("Load " + inURL, dom != null);
        } else if (a.equals("loadvalidate")) {
            dom = api.loadIMDIDocument(inURL, true);
            TestDom.checkOkay("Load and validate " + inURL, dom != null);
        } else if (a.equals("savefile")) {
            TestDom.checkOkay("Save to " + outFile + ", keeping domIds", api.writeDOM(dom, outFile, false));
        } else if (a.equals("saveclean")) {
            TestDom.checkOkay("Save to " + outFile + ", removing domIds", api.writeDOM(dom, outFile, true));
        } else if (a.equals("transform")) {
            try {
                String[] tokens;
                OurURL styleURL = new OurURL("file:transformer.xsl");
                OurURL victimURL = new OurURL("file:transformed.imdi");
                if (b != null && (tokens = TestDom.tokenize(b)).length == 2) {
                    victimURL = new OurURL(tokens[0]);
                    styleURL = new OurURL(tokens[1]);
                }
                TestDom.checkOkay("Transforming (internal function!) " + victimURL + " with XSL " + styleURL, ((IMDIDom)api).applyStyleSheet(victimURL, styleURL));
            }
            catch (MalformedURLException mue) {
                System.out.println("Could not transform - invalid URL: " + mue);
            }
            catch (NullPointerException npe) {
                System.out.println("Could not transform - empty URL");
            }
        } else if (a.equals("testsession")) {
            boolean result = api.isIMDIFileType(dom, 1);
            System.out.println("Loaded DOM is " + (result ? "a" : "NO") + " session");
        } else if (a.equals("testcorpus")) {
            boolean result = api.isIMDIFileType(dom, 2);
            System.out.println("Loaded DOM is " + (result ? "a" : "NO") + " corpus");
        } else if (a.equals("testcatalogue")) {
            boolean result = api.isIMDIFileType(dom, 8);
            System.out.println("Loaded DOM is " + (result ? "a" : "NO") + " catalogue");
        } else if (a.equals("validate")) {
            TestDom.checkOkay("Validate " + inURL, api.isValidIMDIFile(inURL));
        } else if (a.startsWith("link")) {
            TestDom.linkHandler(a.substring(4), b);
        } else if (a.startsWith("element")) {
            TestDom.elementHandler(a.substring(7), b);
        } else if (a.startsWith("key")) {
            TestDom.keyHandler(a.substring(3), b);
        } else if (a.indexOf("help") != -1) {
            System.out.println("The 'help' argument must be the first argument");
        } else {
            System.out.println("Unknown command ignored: " + a);
        }
    }

    public static void main(String[] args) {
        try {
            inURL = new OurURL("file:infile.imdi");
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        if (args.length == 0 || args.length > 0 && (args[0].indexOf(63) != -1 || args[0].indexOf("help") != -1)) {
            System.out.println("XML IMDI processing command line and batch interface:");
            System.out.println("Either give option 'batch' and send commands to stdin");
            System.out.println("or give (1 or more) commands as command line options.");
            System.out.println("See mpi.imdi.api.TestDom javadoc for command details.");
            return;
        }
        if (args.length == 1 && args[0].equals("batch")) {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                try {
                    while (true) {
                        String cmd;
                        if ((cmd = br.readLine()) == null) {
                            System.out.println("End of input stream reached");
                            br.close();
                            return;
                        }
                        TestDom.command(cmd);
                    }
                }
                catch (IOException ioe) {
                    System.out.println("Input stream read error: " + ioe);
                    continue;
                }
                break;
            }
        }
        for (int i = 0; i < args.length; ++i) {
            TestDom.command(args[i]);
        }
    }
}

