/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps.trust;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertChainChecker {
    private static KeyStore trustStore = CertChainChecker.getCacertsKeyStore();
    private static CertPathValidator certValidator = CertChainChecker.initCertValidator();
    private static CertificateFactory certFactory = CertChainChecker.initCertFactory();
    private static PKIXBuilderParameters pkixParameters = CertChainChecker.initPKIXParameters();

    public static void validate(X509Certificate[] x509CertificateArray) throws CertPathValidatorException, CertificateException {
        CertChainChecker.validate(x509CertificateArray, null);
    }

    public static void validate(X509Certificate[] x509CertificateArray, Date date) throws CertPathValidatorException, CertificateException {
        pkixParameters.setDate(date);
        try {
            CertPath certPath = CertChainChecker.getCertPath(x509CertificateArray);
            certValidator.validate(certPath, pkixParameters);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw certPathValidatorException;
        }
        catch (Exception exception) {
            throw new CertificateException("Error processing certificate chain: " + exception.getMessage());
        }
    }

    public static X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray;
        Vector<X509Certificate> vector = new Vector<X509Certificate>();
        try {
            x509CertificateArray = trustStore.aliases();
            while (x509CertificateArray.hasMoreElements()) {
                vector.add((X509Certificate)trustStore.getCertificate(x509CertificateArray.nextElement()));
            }
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
        x509CertificateArray = new X509Certificate[vector.size()];
        vector.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    private static CertPath getCertPath(X509Certificate[] x509CertificateArray) throws CertPathValidatorException {
        X500Principal x500Principal;
        X509Certificate[] x509CertificateArray2 = x509CertificateArray;
        int n = x509CertificateArray.length - 1;
        X509Certificate x509Certificate = x509CertificateArray[n];
        X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
        if (x500Principal2.equals(x500Principal = x509Certificate.getSubjectX500Principal())) {
            x509CertificateArray2 = new X509Certificate[n];
            System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 0, n);
        }
        try {
            return certFactory.generateCertPath(Arrays.asList(x509CertificateArray2));
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException(certificateException.getMessage());
        }
    }

    private static CertPathValidator initCertValidator() throws RuntimeException {
        if (Security.getProvider("BC") == null) {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot add BouncyCastle security provider");
            }
        }
        try {
            return CertPathValidator.getInstance("PKIX", "BC");
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot initialize CertPathValidator: " + exception.getMessage());
        }
    }

    private static CertificateFactory initCertFactory() throws RuntimeException {
        if (Security.getProvider("BC") == null) {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot add BouncyCastle security provider");
            }
        }
        try {
            return CertificateFactory.getInstance("X.509", "BC");
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot initialize CertificateFactory: " + exception.getMessage());
        }
    }

    private static PKIXBuilderParameters initPKIXParameters() throws RuntimeException {
        try {
            PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            pKIXBuilderParameters.setRevocationEnabled(false);
            pKIXBuilderParameters.setMaxPathLength(-1);
            return pKIXBuilderParameters;
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot initialize PKIXParameters: " + exception.getMessage());
        }
    }

    private static KeyStore getCacertsKeyStore() throws RuntimeException {
        Object object;
        String string = null;
        File file = null;
        FileInputStream fileInputStream = null;
        final HashMap hashMap = new HashMap();
        String string2 = File.separator;
        KeyStore keyStore = null;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    hashMap.put("trustStore", System.getProperty("javax.net.ssl.trustStore"));
                    hashMap.put("javaHome", System.getProperty("java.home"));
                    hashMap.put("trustStoreType", System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()));
                    hashMap.put("trustStoreProvider", System.getProperty("javax.net.ssl.trustStoreProvider", ""));
                    hashMap.put("trustStorePasswd", System.getProperty("javax.net.ssl.trustStorePassword", ""));
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException("Cannot determine defaults for truststore");
        }
        string = (String)hashMap.get("trustStore");
        if (!"NONE".equals(string)) {
            if (string != null) {
                file = new File(string);
                fileInputStream = CertChainChecker.getFileInputStream(file);
            } else {
                object = (String)hashMap.get("javaHome");
                file = new File((String)object + string2 + "lib" + string2 + "security" + string2 + "jssecacerts");
                fileInputStream = CertChainChecker.getFileInputStream(file);
                if (fileInputStream == null) {
                    file = new File((String)object + string2 + "lib" + string2 + "security" + string2 + "cacerts");
                    fileInputStream = CertChainChecker.getFileInputStream(file);
                }
            }
            string = fileInputStream != null ? file.getPath() : "No File Available, using empty keystore.";
        }
        String string3 = (String)hashMap.get("trustStoreType");
        String string4 = (String)hashMap.get("trustStoreProvider");
        try {
            if (string3.length() != 0) {
                keyStore = string4.length() == 0 ? KeyStore.getInstance(string3) : KeyStore.getInstance(string3, string4);
                object = null;
                String string5 = (String)hashMap.get("trustStorePasswd");
                if (string5.length() != 0) {
                    object = string5.toCharArray();
                }
                keyStore.load(fileInputStream, (char[])object);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot load cacerts store: " + exception.getMessage());
        }
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot close cacerts store: " + exception.getMessage());
        }
        return keyStore;
    }

    private static FileInputStream getFileInputStream(final File file) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() {
                    try {
                        if (file.exists()) {
                            return new FileInputStream(file);
                        }
                        return null;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return null;
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }
}

