/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.item.AtomType;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.item.ItemSeq;
import org.basex.query.item.Type;
import org.basex.query.item.Value;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;

public abstract class Seq
extends Value {
    protected final long size;

    protected Seq(long s) {
        this(s, AtomType.SEQ);
    }

    protected Seq(long s, Type t) {
        super(t);
        this.size = s;
    }

    public static Value get(Item[] v, int s) {
        return s == 0 ? Empty.SEQ : (s == 1 ? v[0] : new ItemSeq(v, s));
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        throw Err.XPSEQ.thrw(ii, this);
    }

    @Override
    public final Item test(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.ebv(ctx, ii);
    }

    @Override
    public final int hash(InputInfo ii) throws QueryException {
        int h = 1;
        long v = Math.min(this.size, 5L);
        while (--v >= 0L) {
            h = 31 * h + this.itemAt(v).hash(ii);
        }
        return h;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        int i = 0;
        while ((long)i < this.size) {
            sb.append(String.valueOf(i != 0 ? ", " : "") + this.itemAt(i));
            if (sb.length() > 32 && (long)(i + 1) != this.size) {
                sb.append(", ...");
                break;
            }
            ++i;
        }
        return sb.append(")").toString();
    }
}

