/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.entityindexer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JProgressBar;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityService;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.entityindexer.ProcessAbortException;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.kintypestrings.KinTypeStringConverter;
import nl.mpi.kinnate.kintypestrings.ParserHighlight;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.ui.KinTypeStringProvider;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryParser
implements EntityService {
    HashMap<UniqueIdentifier, EntityData> loadedGraphNodes;
    EntityCollection entityCollection;
    public boolean abortProcess = false;
    public static int foundOrder;

    public QueryParser(EntityData[] svgEntities, EntityCollection entityCollection) {
        this.entityCollection = entityCollection;
        this.loadedGraphNodes = new HashMap();
        if (svgEntities != null) {
            for (EntityData svgStoredEntity : svgEntities) {
                this.loadedGraphNodes.put(svgStoredEntity.getUniqueIdentifier(), svgStoredEntity);
            }
        }
        for (EntityData graphDataNode : this.loadedGraphNodes.values()) {
            for (EntityRelation nodeRelation : graphDataNode.getRelatedNodesToBeLoaded()) {
                EntityData alterNode = this.loadedGraphNodes.get(nodeRelation.alterUniqueIdentifier);
                if (alterNode == null) continue;
                nodeRelation.setAlterNode(alterNode);
            }
        }
    }

    @Deprecated
    public void primeWithEntities(EntityData[] preLoadedEntities) {
        for (EntityData currentEntity : preLoadedEntities) {
            if (this.loadedGraphNodes.containsKey(currentEntity.getUniqueIdentifier())) continue;
            this.loadedGraphNodes.put(currentEntity.getUniqueIdentifier(), currentEntity);
        }
    }

    @Override
    public void requestAbortProcess() {
        this.abortProcess = true;
    }

    @Override
    public void clearAbortRequest() {
        this.abortProcess = false;
    }

    @Override
    public EntityData[] processKinTypeStrings(ArrayList<KinTypeStringProvider> kinTypeStringProviders, IndexerParameters indexParameters, DataStoreSvg dataStoreSvg, JProgressBar progressBar) throws EntityServiceException, ProcessAbortException {
        foundOrder = 0;
        if (indexParameters.valuesChanged) {
            indexParameters.valuesChanged = false;
            this.loadedGraphNodes = new HashMap();
        }
        KinTypeStringConverter kinTypeStringConverter = new KinTypeStringConverter(dataStoreSvg);
        for (EntityData graphDataNode : this.loadedGraphNodes.values()) {
            graphDataNode.clearVisibility();
            graphDataNode.clearTempLabels();
        }
        int totalProgressRequired = dataStoreSvg.requiredEntities.size();
        for (KinTypeStringProvider kinTypeStringProvider : kinTypeStringProviders) {
            totalProgressRequired += kinTypeStringProvider.getTotalLength();
        }
        progressBar.setMaximum(totalProgressRequired);
        progressBar.setMinimum(0);
        progressBar.setValue(0);
        progressBar.setIndeterminate(totalProgressRequired < 3);
        for (KinTypeStringProvider kinTypeStringProvider : kinTypeStringProviders) {
            int lineCounter = -1;
            String[] kinTypeStrings = kinTypeStringProvider.getCurrentStrings();
            ParserHighlight[] parserHighlightArray = new ParserHighlight[kinTypeStrings.length];
            for (String inputString : kinTypeStrings) {
                parserHighlightArray[++lineCounter] = new ParserHighlight();
                ArrayList<KinTypeStringConverter.KinTypeElement> kinTypeElementArray = kinTypeStringConverter.getKinTypeElements(inputString, parserHighlightArray[lineCounter]);
                for (KinTypeStringConverter.KinTypeElement kinTypeElement : kinTypeElementArray) {
                    if (kinTypeElement.queryTerms == null) continue;
                    for (UniqueIdentifier currentFoundId : this.entityCollection.getEntityIdByTerm(kinTypeElement)) {
                        EntityData queryNode;
                        if (this.abortProcess) {
                            throw new ProcessAbortException();
                        }
                        if (this.loadedGraphNodes.containsKey(currentFoundId)) {
                            queryNode = this.loadedGraphNodes.get(currentFoundId);
                        } else {
                            queryNode = this.entityCollection.getEntity(currentFoundId, indexParameters);
                            this.loadedGraphNodes.put(queryNode.getUniqueIdentifier(), queryNode);
                        }
                        queryNode.isVisible = true;
                        kinTypeElement.entityData.add(queryNode);
                        if (!kinTypeElement.kinType.isEgoType()) continue;
                        queryNode.isEgo = true;
                        new KinTypeStringConverter(dataStoreSvg).setEgoKinTypeString(queryNode);
                    }
                }
                if (kinTypeElementArray.size() > 0 && kinTypeElementArray.get((int)0).queryTerms == null) {
                    KinTypeStringConverter.KinTypeElement firstKinType = kinTypeElementArray.get(0);
                    if (firstKinType.kinType.isEgoType()) {
                        for (UniqueIdentifier currentEgoId : dataStoreSvg.egoEntities) {
                            EntityData egoNode;
                            if (this.abortProcess) {
                                throw new ProcessAbortException();
                            }
                            if (this.loadedGraphNodes.containsKey(currentEgoId)) {
                                egoNode = this.loadedGraphNodes.get(currentEgoId);
                            } else {
                                egoNode = this.entityCollection.getEntity(currentEgoId, indexParameters);
                                this.loadedGraphNodes.put(egoNode.getUniqueIdentifier(), egoNode);
                            }
                            egoNode.isEgo = true;
                            egoNode.isVisible = true;
                            if (!firstKinType.kinType.matchesEgonessAndSymbol(egoNode, null)) continue;
                            firstKinType.entityData.add(egoNode);
                        }
                    }
                }
                for (KinTypeStringConverter.KinTypeElement kinTypeElement : kinTypeElementArray) {
                    if (this.abortProcess) {
                        throw new ProcessAbortException();
                    }
                    for (EntityData kinTypeEntityData : kinTypeElement.entityData) {
                        for (EntityRelation entityRelationToLoad : kinTypeEntityData.getRelatedNodesToBeLoaded()) {
                            EntityData relatedNode;
                            if (this.abortProcess) {
                                throw new ProcessAbortException();
                            }
                            if (this.loadedGraphNodes.containsKey(entityRelationToLoad.alterUniqueIdentifier)) {
                                relatedNode = this.loadedGraphNodes.get(entityRelationToLoad.alterUniqueIdentifier);
                            } else {
                                relatedNode = this.entityCollection.getEntity(entityRelationToLoad.alterUniqueIdentifier, indexParameters);
                                this.loadedGraphNodes.put(relatedNode.getUniqueIdentifier(), relatedNode);
                            }
                            entityRelationToLoad.setAlterNode(relatedNode);
                        }
                        for (EntityRelation entityRelation : kinTypeEntityData.getAllRelations()) {
                            if (kinTypeElement.nextType == null || !kinTypeElement.nextType.kinType.matchesRelation(entityRelation, null)) continue;
                            kinTypeElement.nextType.entityData.add(entityRelation.getAlterNode());
                            entityRelation.getAlterNode().isVisible = true;
                        }
                    }
                }
                progressBar.setValue(progressBar.getValue() + 1);
            }
            kinTypeStringProvider.highlightKinTypeStrings(parserHighlightArray, kinTypeStrings);
        }
        Iterator<UniqueIdentifier> iterator = dataStoreSvg.requiredEntities.iterator();
        while (iterator.hasNext()) {
            EntityData requiredNode;
            if (this.abortProcess) {
                throw new ProcessAbortException();
            }
            UniqueIdentifier currentEgoId = iterator.next();
            if (this.loadedGraphNodes.containsKey(currentEgoId)) {
                requiredNode = this.loadedGraphNodes.get(currentEgoId);
            } else {
                requiredNode = this.entityCollection.getEntity(currentEgoId, indexParameters);
                this.loadedGraphNodes.put(requiredNode.getUniqueIdentifier(), requiredNode);
            }
            requiredNode.isVisible = true;
            progressBar.setValue(progressBar.getValue() + 1);
        }
        for (EntityData graphDataNode : this.loadedGraphNodes.values()) {
            for (EntityRelation nodeRelation : graphDataNode.getRelatedNodesToBeLoaded()) {
                EntityData alterNode = this.loadedGraphNodes.get(nodeRelation.alterUniqueIdentifier);
                if (alterNode == null) continue;
                nodeRelation.setAlterNode(alterNode);
            }
        }
        return this.loadedGraphNodes.values().toArray(new EntityData[0]);
    }
}

