/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.export;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.KinTermSavePanel;
import nl.mpi.kinnate.export.PedigreePackageExport;

public class ExportToR {
    private SessionStorage sessionStorage;
    private MessageDialogHandler dialogHandler;
    private BugCatcher bugCatcher;

    public ExportToR(SessionStorage sessionStorage, MessageDialogHandler dialogHandler, BugCatcher bugCatcher) {
        this.sessionStorage = sessionStorage;
        this.dialogHandler = dialogHandler;
        this.bugCatcher = bugCatcher;
    }

    public void doExport(Component mainFrame, KinTermSavePanel savePanel) {
        JFileChooser fc = new JFileChooser();
        String lastSavedFileString = this.sessionStorage.loadString("kinoath.ExportToR");
        if (lastSavedFileString != null) {
            fc.setSelectedFile(new File(lastSavedFileString));
        }
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".csv");
            }

            public String getDescription() {
                return "Data Frame (CSV)";
            }
        });
        int returnVal = fc.showSaveDialog(mainFrame);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            PedigreePackageExport packageExport = new PedigreePackageExport();
            this.sessionStorage.saveString("kinoath.ExportToR", file.getPath());
            try {
                FileWriter fileWriter = new FileWriter(file, false);
                fileWriter.write(packageExport.createCsvContents(savePanel.getGraphEntities()));
                fileWriter.close();
            }
            catch (IOException exception) {
                this.dialogHandler.addMessageDialogToQueue("Error, could not save file", "Export");
                this.bugCatcher.logError((Exception)exception);
            }
        }
    }
}

