/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.XsdChecker;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.gedcomimport.CsvImporter;
import nl.mpi.kinnate.gedcomimport.EntityImporter;
import nl.mpi.kinnate.gedcomimport.GedcomImporter;
import nl.mpi.kinnate.gedcomimport.GenericImporter;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.entityprofiles.ProfileRecord;
import nl.mpi.kinnate.ui.menu.DocumentNewMenu;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class GedcomImportPanel
extends JPanel {
    private EntityCollection entityCollection;
    private AbstractDiagramManager abstractDiagramManager;
    private JTextArea importTextArea;
    private JProgressBar progressBar;
    private JCheckBox overwriteOnImport;
    private JCheckBox validateImportedXml;
    private JButton startButton;
    private JPanel endPagePanel;
    private SessionStorage sessionStorage;
    private ArbilWindowManager dialogHandler;
    private ArbilDataNodeLoader dataNodeLoader;
    private ArbilTreeHelper treeHelper;
    private Component parentPanel;

    public GedcomImportPanel(AbstractDiagramManager abstractDiagramManager, EntityCollection entityCollection, SessionStorage sessionStorage, ArbilWindowManager dialogHandler, ArbilDataNodeLoader dataNodeLoader, ArbilTreeHelper treeHelper) {
        this.setPreferredSize(new Dimension(500, 500));
        this.abstractDiagramManager = abstractDiagramManager;
        this.entityCollection = entityCollection;
        this.sessionStorage = sessionStorage;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
        this.treeHelper = treeHelper;
    }

    protected JPanel getCreatedNodesPane(final GenericImporter gedcomImporter) {
        JPanel createdNodesPanel = new JPanel();
        createdNodesPanel.setLayout(new BoxLayout(createdNodesPanel, 3));
        if (gedcomImporter.getCreatedNodeIds().isEmpty()) {
            createdNodesPanel.add(new JLabel("No data was imported, nothing to show in the graph."));
        } else {
            final ArrayList<JCheckBox> checkBoxArray = new ArrayList<JCheckBox>();
            for (String typeString : gedcomImporter.getCreatedNodeIds().keySet()) {
                JCheckBox currentCheckBox = new JCheckBox(typeString + " ( x " + gedcomImporter.getCreatedNodeIds().get(typeString).size() + ")", true);
                currentCheckBox.setActionCommand(typeString);
                checkBoxArray.add(currentCheckBox);
                createdNodesPanel.add(currentCheckBox);
            }
            JButton showButton = new JButton("Show selected types in graph");
            showButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    final KinDiagramPanel egoSelectionTestPanel = new KinDiagramPanel(DocumentNewMenu.DocumentType.Simple, GedcomImportPanel.this.sessionStorage, GedcomImportPanel.this.dialogHandler, GedcomImportPanel.this.dataNodeLoader, GedcomImportPanel.this.treeHelper, GedcomImportPanel.this.entityCollection);
                    egoSelectionTestPanel.setName("Imported Entities");
                    GedcomImportPanel.this.abstractDiagramManager.createDiagramContainer(egoSelectionTestPanel);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            HashSet selectedIds = new HashSet();
                            for (JCheckBox currentCheckBox : checkBoxArray) {
                                if (!currentCheckBox.isSelected()) continue;
                                selectedIds.addAll(gedcomImporter.getCreatedNodeIds().get(currentCheckBox.getActionCommand()));
                            }
                            egoSelectionTestPanel.addNodeCollection(selectedIds.toArray(new UniqueIdentifier[0]), "Imported Entities");
                            egoSelectionTestPanel.loadAllTrees();
                        }
                    });
                }
            });
            createdNodesPanel.add(showButton);
        }
        return createdNodesPanel;
    }

    public void startImport(File importFile) {
        this.startImport(importFile, null, importFile.getName());
    }

    public void startImport(String importUriString) {
        File cachedFile = this.sessionStorage.updateCache(importUriString, 30, true);
        this.startImport(cachedFile, null, importUriString);
    }

    public void startImportJar(String importFileString) {
        this.startImport(null, importFileString, importFileString);
    }

    private void startImport(final File importFile, final String importFileString, String importLabel) {
        if (importFile != null && !importFile.exists()) {
            this.add(new JLabel("File not found"));
        } else {
            this.importTextArea = new JTextArea();
            JScrollPane importScrollPane = new JScrollPane(this.importTextArea);
            this.setLayout(new BorderLayout());
            this.add((Component)importScrollPane, "Center");
            String titleString = importFile != null ? "Import: " + importFile.getName() : "Import: " + importFileString.substring(importFileString.lastIndexOf("/") + 1);
            this.setName(titleString);
            this.parentPanel = this.abstractDiagramManager.createDiagramContainer(this);
            this.progressBar = new JProgressBar(0, 100);
            this.endPagePanel = new JPanel(new BorderLayout());
            this.endPagePanel.add((Component)this.progressBar, "First");
            this.add((Component)this.endPagePanel, "Last");
            this.progressBar.setVisible(true);
            JPanel topPanel = new JPanel();
            final JComboBox<ProfileRecord> profileSelectBox = new JComboBox<ProfileRecord>(new DataStoreSvg().selectedProfiles);
            topPanel.add(profileSelectBox);
            this.overwriteOnImport = new JCheckBox("Overwrite Existing");
            this.overwriteOnImport.setEnabled(false);
            this.startButton = new JButton("Start");
            topPanel.add(this.overwriteOnImport);
            this.validateImportedXml = new JCheckBox("Validate Xml");
            topPanel.add(this.validateImportedXml);
            topPanel.add(this.startButton);
            JPanel topOuterPanel = new JPanel(new BorderLayout());
            topOuterPanel.add((Component)new JLabel(importLabel, 0), "First");
            topOuterPanel.add((Component)topPanel, "Center");
            this.add((Component)topOuterPanel, "First");
            this.startButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GedcomImportPanel.this.startButton.setEnabled(false);
                    GedcomImportPanel.this.overwriteOnImport.setEnabled(false);
                    GedcomImportPanel.this.validateImportedXml.setEnabled(false);
                    final String profileId = ((ProfileRecord)profileSelectBox.getSelectedItem()).profileId;
                    new Thread(){

                        public void run() {
                            try {
                                boolean overwriteExisting = GedcomImportPanel.this.overwriteOnImport.isSelected();
                                EntityImporter genericImporter = new GedcomImporter(GedcomImportPanel.this.progressBar, GedcomImportPanel.this.importTextArea, overwriteExisting, GedcomImportPanel.this.sessionStorage);
                                if (importFileString != null) {
                                    if (!genericImporter.canImport(importFileString)) {
                                        genericImporter = new CsvImporter(GedcomImportPanel.this.progressBar, GedcomImportPanel.this.importTextArea, overwriteExisting, GedcomImportPanel.this.sessionStorage);
                                    }
                                } else if (!genericImporter.canImport(importFile.toString())) {
                                    genericImporter = new CsvImporter(GedcomImportPanel.this.progressBar, GedcomImportPanel.this.importTextArea, overwriteExisting, GedcomImportPanel.this.sessionStorage);
                                }
                                GedcomImportPanel.this.importTextArea.append("Importing the kinship data (step 1/4)\n");
                                GedcomImportPanel.this.importTextArea.setCaretPosition(GedcomImportPanel.this.importTextArea.getText().length());
                                URI[] treeNodesArray = importFileString != null ? genericImporter.importFile(importFileString, profileId) : genericImporter.importFile(importFile, profileId);
                                boolean checkFilesAfterImport = GedcomImportPanel.this.validateImportedXml.isSelected();
                                if (treeNodesArray != null && checkFilesAfterImport) {
                                    int maxXsdErrorToShow = 3;
                                    GedcomImportPanel.this.importTextArea.append("Checking XML of imported data  (step 3/4)\n");
                                    GedcomImportPanel.this.importTextArea.setCaretPosition(GedcomImportPanel.this.importTextArea.getText().length());
                                    GedcomImportPanel.this.progressBar.setValue(0);
                                    GedcomImportPanel.this.progressBar.setMaximum(treeNodesArray.length + 1);
                                    for (URI currentNodeUri : treeNodesArray) {
                                        XsdChecker xsdChecker;
                                        GedcomImportPanel.this.progressBar.setValue(GedcomImportPanel.this.progressBar.getValue() + 1);
                                        if (maxXsdErrorToShow <= 0 || (xsdChecker = new XsdChecker()).simpleCheck(new File(currentNodeUri)) == null) continue;
                                        GedcomImportPanel.this.abstractDiagramManager.createDiagramSubPanel("XSD Error on Import", (Component)xsdChecker, GedcomImportPanel.this.parentPanel);
                                        xsdChecker.checkXML(GedcomImportPanel.this.dataNodeLoader.getArbilDataNode(null, currentNodeUri));
                                        xsdChecker.setDividerLocation(0.5);
                                        if (--maxXsdErrorToShow > 0) continue;
                                        GedcomImportPanel.this.importTextArea.append("maximum xsd errors shown, no more files will be tested\n");
                                    }
                                } else {
                                    GedcomImportPanel.this.importTextArea.append("Skipping check XML of imported data  (step 3/4)\n");
                                }
                                GedcomImportPanel.this.progressBar.setIndeterminate(true);
                                GedcomImportPanel.this.importTextArea.append("Starting update of entity database (step 4/4)\n");
                                GedcomImportPanel.this.importTextArea.setCaretPosition(GedcomImportPanel.this.importTextArea.getText().length());
                                GedcomImportPanel.this.entityCollection.updateDatabase(treeNodesArray, GedcomImportPanel.this.progressBar);
                                GedcomImportPanel.this.importTextArea.append("Import complete\n");
                                GedcomImportPanel.this.importTextArea.setCaretPosition(GedcomImportPanel.this.importTextArea.getText().length());
                                GedcomImportPanel.this.progressBar.setIndeterminate(false);
                                GedcomImportPanel.this.progressBar.setVisible(false);
                                GedcomImportPanel.this.endPagePanel.add((Component)GedcomImportPanel.this.getCreatedNodesPane(genericImporter), "Center");
                                GedcomImportPanel.this.revalidate();
                            }
                            catch (IOException exception) {
                                GedcomImportPanel.this.importTextArea.append("Import Failed: " + exception.getMessage() + "\n");
                            }
                            catch (ImportException exception) {
                                GedcomImportPanel.this.importTextArea.append("Import Failed:" + exception.getMessage() + "\n");
                            }
                        }
                    }.start();
                }
            });
        }
    }
}

